/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.collect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.container.MessageCarouselContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.h5.H5InvoiceListService;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.OpenCloseCallBackUrlUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.fpzs.FpzsAttachService;
import org.apache.commons.collections4.MapUtils;

public class InvoiceListMobilePlugin
extends AbstractMobFormPlugin
implements ClickListener,
ItemClickListener,
RowClickEventListener,
PullRefreshListener,
EntryGridBindDataListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(InvoiceListMobilePlugin.class);
    private final String[] buttons = new String[]{"inv_list_btn", "inv_pic_btn", "attach_list_btn", "attach_pic_btn", "back"};
    public static final String TABAP = "tabap";
    public static final String INVOICE_TAB = "invoice_collect";
    public static final String ATTACH_TAB = "attachment_collect";
    public static final String COVER_TAB = "cover_collect";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ENTRYENTITY1 = "entryentity1";

    public void registerListener(EventObject e) {
        this.addClickListeners(this.buttons);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
        CardEntry cardEntry1 = (CardEntry)this.getView().getControl(ENTRYENTITY1);
        cardEntry1.addRowClickListener((RowClickEventListener)this);
        CardEntry cardEntry2 = (CardEntry)this.getView().getControl("cover_entryentity");
        cardEntry2.addRowClickListener((RowClickEventListener)this);
        MessageCarouselContainer carouselFigure = (MessageCarouselContainer)this.getView().getControl("inv_pic_range");
        carouselFigure.addItemClickListener((ItemClickListener)this);
        MessageCarouselContainer carouselFigure1 = (MessageCarouselContainer)this.getView().getControl("attach_pic_range");
        carouselFigure1.addItemClickListener((ItemClickListener)this);
        ProgressBar pb = (ProgressBar)this.getControl("probarupdateclass");
        if (pb != null) {
            pb.addProgressListener((ProgresssListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        e.getRows().stream().forEach(row -> {
            int index = row.getRowIndex();
            DynamicObject dynamicObject = row.getDataEntity();
            H5InvoiceListService h5InvoiceListSevice = new H5InvoiceListService((AbstractFormPlugin)this, ENTRYENTITY, "");
            String invoiceInfoStr = dynamicObject.getString("invoice_info");
            JSONObject invoiceInfoJson = JSONObject.parseObject((String)invoiceInfoStr);
            Map invoice = invoiceInfoJson.getInnerMap();
            h5InvoiceListSevice.setTag(invoice, index);
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("\u67e5\u770b\u5355\u636e\u53d1\u7968\u5217\u8868\u5165\u53c2\uff1a{}", (Object)customParams);
        JSONObject viewCustomParam = FpzsMainService.cacheViewCustomParam((AbstractFormPlugin)this);
        this.fillEntryEntity((Map<String, Object>)viewCustomParam);
        this.fillAttachEntryEntity((Map<String, Object>)viewCustomParam);
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_pic_btn"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"attach_pic_btn"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_pic_range"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"attach_pic_range"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
        String closedCallBackUrl = viewCustomParam.getString("closedCallBackUrl");
        if (StringUtils.isNotEmpty((CharSequence)closedCallBackUrl)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"back_flex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"back_flex"});
        }
    }

    public void afterBindData(EventObject e) {
        try {
            this.fillCover();
        }
        catch (IOException ioException) {
            LOGGER.error("in\u6d41md5\u5931\u8d25\uff1a", (Object)e);
        }
    }

    private void fillCover() throws IOException {
        this.clearListData("cover_entryentity");
        this.getView().setVisible(Boolean.FALSE, new String[]{COVER_TAB});
        Map viewCustomParam = FpzsMainService.getViewCustomParam((AbstractFormPlugin)this);
        String billId = (String)viewCustomParam.get("billId");
        ExpenseRelationService expenseRelationService = new ExpenseRelationService();
        JSONArray coverArray = expenseRelationService.queryCover(billId);
        LOGGER.info("\u67e5\u8be2\u8fd4\u56de\u5c01\u9762\u6570\u636e{}", (Object)coverArray);
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        if (!CollectionUtils.isEmpty((Collection)coverArray)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{COVER_TAB});
            this.getModel().beginInit();
            for (int i = 0; i < coverArray.size(); ++i) {
                JSONObject attach = coverArray.getJSONObject(i);
                String snapshotUrl = attach.getString("snapshotUrl");
                String createTime = attach.getString("createTime");
                String coverNo = attach.getString("coverNo");
                String coverId = attach.getString("coverId");
                String localUrl = attach.getString("localUrl");
                int row = this.getModel().createNewEntryRow("cover_entryentity");
                this.getModel().setValue("cover_time", (Object)createTime, row);
                this.getModel().setValue("coverno", (Object)coverNo, row);
                this.getModel().setValue("coverid", (Object)coverId, row);
                this.getModel().setValue("cover_image", (Object)this.getAttachmentPreviewUrl(snapshotUrl, baseUrl), row);
            }
            this.getModel().endInit();
            this.getView().updateView("cover_entryentity");
        }
    }

    private void clearListData(String var1) {
        this.getModel().deleteEntryData(var1);
    }

    private void fillAttachEntryEntity(Map<String, Object> customParams) {
        boolean queryAll;
        this.clearListData(ENTRYENTITY1);
        List serialNos = (List)customParams.get("serialNos");
        String billId = (String)customParams.get("billId");
        String entityId = (String)customParams.get("entityId");
        AttachQueryService attachQueryService = new AttachQueryService();
        HashSet<Long> existsIdSet = new HashSet<Long>(16);
        List<Object> resultList = new ArrayList(16);
        ArrayList<String> urlList = new ArrayList<String>(8);
        boolean bl = queryAll = CollectionUtils.isEmpty((Collection)serialNos) || !CollectionUtils.isEmpty((Collection)serialNos) && serialNos.size() > 1;
        if (StringUtils.isNotEmpty((CharSequence)billId)) {
            JSONArray array = attachQueryService.queryFpzsAttach(billId, entityId, null, true);
            for (int i = 0; i < array.size(); ++i) {
                boolean includeSerialNo;
                JSONObject attach2 = array.getJSONObject(i);
                Long id = attach2.getLong("attachId");
                String serialNo = attach2.getString("serialNo");
                String attachUrl = attachQueryService.getAttachUrl(attach2.getString("attachType"), attach2.getString("snapshotUrl"), attach2.getString("attachIcon"), attach2.getString("attachUrl"));
                if (StringUtils.isEmpty((CharSequence)attachUrl)) {
                    attachUrl = AttachConstant.getAttachIconUrl((String)attach2.getString("attachType"));
                }
                boolean bl2 = includeSerialNo = queryAll || StringUtils.isBlank((CharSequence)serialNo) || !CollectionUtils.isEmpty((Collection)serialNos) && serialNos.contains(serialNo);
                if (!existsIdSet.add(id) || !includeSerialNo) continue;
                LinkedHashMap temMap = Maps.newLinkedHashMap();
                temMap.put("id", attach2.getLong("attachId"));
                temMap.put("attach_name", attach2.getString("attachName"));
                temMap.put("remark", attach2.getString("remark"));
                temMap.put("attach_url", UrlServiceUtils.getFileFullUrl((String)attachUrl));
                temMap.put("create_time", attach2.getString("createTime"));
                urlList.add(attachUrl);
                resultList.add(temMap);
            }
        } else if (!CollectionUtils.isEmpty((Collection)serialNos)) {
            String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
            QFilter qFilters1 = new QFilter("relation_id", "in", (Object)serialNos);
            qFilters1.and(new QFilter("relation_type", "=", (Object)"3"));
            DynamicObjectCollection attachRelationList = attachQueryService.findByFilter(qFilters1);
            List ids = attachRelationList.stream().map(c -> c.getLong("attach_id")).distinct().collect(Collectors.toList());
            QFilter qFilters = new QFilter("id", "in", ids);
            qFilters.and(new QFilter("attach_url", "is not null", null));
            DynamicObjectCollection attachList = attachQueryService.queryByFilter(qFilters, null, 500);
            resultList = attachList.stream().map(attach -> {
                LinkedHashMap temMap = Maps.newLinkedHashMap();
                Long id = attach.getLong("id");
                String attachUrl = attachQueryService.getAttachUrl(attach);
                existsIdSet.add(id);
                temMap.put("id", attach.get("id"));
                temMap.put("attach_name", attach.getString("attach_name"));
                temMap.put("remark", attach.getString("remark"));
                temMap.put("attach_url", this.getAttachmentPreviewUrl(attachUrl, baseUrl));
                temMap.put("create_time", DateUtils.format((Date)attach.getDate("create_time"), (String)"yyyy-MM-dd HH:mm:ss"));
                urlList.add(FpzsAttachService.getPreviewIconUrl(attach));
                return temMap;
            }).collect(Collectors.toList());
        }
        this.getModel().beginInit();
        resultList.stream().forEach(map -> {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY1);
            map.entrySet().stream().forEach(modelEntry -> this.getModel().setValue((String)modelEntry.getKey() + "2", modelEntry.getValue(), row));
        });
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY1);
        Label labelap = (Label)this.getView().getControl("labelap11");
        labelap.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20\u9644\u4ef6", (String)"InvoiceListMobilePlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), resultList.size()));
        this.showAttachFlex(urlList);
    }

    private void showAttachFlex(List<String> urlList) {
        if (CollectionUtils.isEmpty(urlList)) {
            return;
        }
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        if (urlList.size() == 1) {
            this.showAttachFlex2(urlList.get(0), baseUrl);
            return;
        }
        MessageCarouselContainer mcc = (MessageCarouselContainer)this.getControl("attach_pic_range");
        LinkedList<String> snapshotUrls = new LinkedList<String>();
        LinkedList<String> labels = new LinkedList<String>();
        for (int i = 0; i < urlList.size(); ++i) {
            String iconImage = UrlServiceUtils.getFileFullUrl((String)urlList.get(i));
            snapshotUrls.add(iconImage);
            labels.add(String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u9644\u4ef6\uff0c\u5f53\u524d\uff08%2$s/%3$s\uff09", (String)"InvoiceListMobilePlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), urlList.size(), i + 1, urlList.size()));
        }
        String[] urls = new String[snapshotUrls.size()];
        snapshotUrls.toArray(urls);
        String[] texts = new String[labels.size()];
        labels.toArray(texts);
        ArrayList data = new ArrayList(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            HashMap controlsMap = new HashMap(2);
            HashMap<String, String> propsMap = new HashMap<String, String>(1);
            propsMap.put("text", texts[i]);
            controlsMap.put("labelap3", propsMap);
            propsMap = new HashMap(1);
            propsMap.put("imageKey", urls[i]);
            controlsMap.put("imageap1", propsMap);
            data.add(controlsMap);
        }
        mcc.setData(data);
        this.getPageCache().put("attachData", SerializationUtils.toJsonString(data));
    }

    private void showInvoiceFlex(JSONArray jsonArray) {
        MessageCarouselContainer mcc = (MessageCarouselContainer)this.getControl("inv_pic_range");
        LinkedList<String> snapshotUrls = new LinkedList<String>();
        LinkedList<String> labels = new LinkedList<String>();
        JSONArray jsonArray1 = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject invoice = jsonArray.getJSONObject(i);
            if (StringUtils.isBlank((CharSequence)invoice.getString("snapshotUrl"))) continue;
            jsonArray1.add((Object)invoice);
        }
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        if (jsonArray1.size() == 1) {
            this.showInvoiceFlex2(jsonArray1, baseUrl);
            return;
        }
        for (int i = 0; i < jsonArray1.size(); ++i) {
            JSONObject invoice = jsonArray1.getJSONObject(i);
            snapshotUrls.add(this.getServerPictureUrl(invoice.getString("snapshotUrl"), baseUrl));
            labels.add(String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u53d1\u7968\uff0c\u5f53\u524d\uff08%2$s/%3$s\uff09", (String)"InvoiceListMobilePlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray1.size(), i + 1, jsonArray1.size()));
        }
        String[] urls = new String[snapshotUrls.size()];
        snapshotUrls.toArray(urls);
        String[] texts = new String[labels.size()];
        labels.toArray(texts);
        ArrayList data = new ArrayList(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            HashMap controlsMap = new HashMap(2);
            HashMap<String, String> propsMap = new HashMap<String, String>(1);
            propsMap.put("imageKey", urls[i]);
            controlsMap.put("imageap", propsMap);
            propsMap = new HashMap(1);
            propsMap.put("text", texts[i]);
            controlsMap.put("labelap", propsMap);
            data.add(controlsMap);
        }
        mcc.setData(data);
        this.getPageCache().put("invData", SerializationUtils.toJsonString(data));
    }

    private void showAttachFlex2(String attachmentUrl, String baseUrl) {
        Label labelap = (Label)this.getView().getControl("labelap5");
        labelap.setText(ResManager.loadKDString((String)"\u51711\u5f20\u9644\u4ef6\uff0c\u5f53\u524d\uff081/1\uff09", (String)"InvoiceListMobilePlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("attach_picture", (Object)this.getAttachmentPreviewUrl(attachmentUrl, baseUrl));
    }

    private void showInvoiceFlex2(JSONArray jsonArray, String baseUrl) {
        JSONObject invoice = jsonArray.getJSONObject(0);
        Label labelap = (Label)this.getView().getControl("labelap4");
        labelap.setText(ResManager.loadKDString((String)"\u51711\u5f20\u53d1\u7968\uff0c\u5f53\u524d\uff081/1\uff09", (String)"InvoiceListMobilePlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("inv_picture", (Object)this.getServerPictureUrl(invoice.getString("snapshotUrl"), baseUrl));
    }

    public String getAttachmentPreviewUrl(String attachUrl, String baseUrl) {
        return UrlServiceUtils.getDownloadUrl((String)attachUrl, (String)baseUrl);
    }

    public String getServerPictureUrl(String attachUrl, String baseUrl) {
        if (attachUrl.contains("http")) {
            return attachUrl;
        }
        return UrlServiceUtils.getDownloadUrl((String)attachUrl, (String)baseUrl);
    }

    private void fillEntryEntity(Map<String, Object> customParams) {
        this.clearListData(ENTRYENTITY);
        List serialNos = (List)customParams.get("serialNos");
        String billId = (String)customParams.get("billId");
        String entityId = (String)customParams.get("entityId");
        if (CollectionUtils.isEmpty((Collection)serialNos) && StringUtils.isEmpty((CharSequence)billId)) {
            billId = "-999999999999999";
        }
        QFilter expenseFilter = null;
        QFilter entityidFilter = null;
        QFilter serialFilters = null;
        if (StringUtils.isNotEmpty((CharSequence)billId)) {
            expenseFilter = new QFilter("expense_id", "=", (Object)billId);
        }
        if (StringUtils.isNotEmpty((CharSequence)entityId)) {
            entityidFilter = new QFilter("entityid", "=", (Object)entityId);
        }
        if (!CollectionUtils.isEmpty((Collection)serialNos)) {
            serialFilters = new QFilter("serial_no", "in", (Object)serialNos);
        }
        if (expenseFilter != null && serialFilters == null) {
            DynamicObjectCollection serialCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{entityidFilter, serialFilters, expenseFilter});
            if (!CollectionUtils.isEmpty((Collection)serialCollection)) {
                List serialList = serialCollection.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
                serialFilters = new QFilter("serial_no", "in", serialList);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u5b58\u5728", (String)"InvoiceListMobilePlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        H5InvoiceListService h5InvoiceListService = new H5InvoiceListService((AbstractFormPlugin)this, ENTRYENTITY, "");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(serialFilters);
        h5InvoiceListService.queryData(filters, null);
        if (!CollectionUtils.isEmpty((Collection)serialNos)) {
            h5InvoiceListService.orderListByFields(serialNos, "serial_no");
        }
        h5InvoiceListService.fillEntryEntity();
        List invoiceList = h5InvoiceListService.getInvoiceData();
        ArrayList<String> normalSerialNos = new ArrayList<String>(invoiceList.size());
        BigDecimal sumTotalAmount = BigDecimal.ZERO;
        HashSet<Long> currencyIds = new HashSet<Long>(invoiceList.size());
        for (Map result : invoiceList) {
            if (CollectionUtils.isEmpty((Map)result)) continue;
            normalSerialNos.add(String.valueOf(result.get("serial_no")));
            BigDecimal totalAmount = (BigDecimal)result.get("total_amount");
            sumTotalAmount = sumTotalAmount.add(totalAmount);
            Object invoiceType = result.get("invoice_type");
            long currencyId = CurrencyUtils.FpzsMainService_100_id;
            if ((InputInvoiceTypeEnum.containCurrencyId((Long)BigDecimalUtil.transDecimal(invoiceType).longValue()) || invoiceType != null && InputInvoiceTypeEnum.containCurrencyIdByAwsType((String)invoiceType.toString())) && (currencyId = BigDecimalUtil.transDecimal(result.get("currencyid")).longValue()) == 0L) {
                currencyId = CurrencyUtils.FpzsMainService_100_id;
            }
            currencyIds.add(currencyId);
        }
        Label labelap = (Label)this.getView().getControl("labelap1");
        labelap.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20\u53d1\u7968\uff0c\u5408\u8ba1", (String)"InvoiceListMobilePlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceList.size()));
        this.getModel().setValue("sum_amount1", (Object)sumTotalAmount);
        this.showSummary(currencyIds, invoiceList.size());
        this.getView().getPageCache().put("invoiceListSize", String.valueOf(invoiceList.size()));
        String currencyIdStr = currencyIds.stream().map(Object::toString).collect(Collectors.joining(","));
        this.getView().getPageCache().put("currencyIds", currencyIdStr);
        JSONArray invoiceArray = VerifyUtil.verifyBySerialNos(new HashMap(), normalSerialNos, (boolean)true);
        if (!invoiceArray.isEmpty()) {
            this.showInvoiceFlex(invoiceArray);
        }
    }

    private void showSummary(Set<Long> currencyIds, int invoiceListSize) {
        Label labelap = (Label)this.getView().getControl("labelap1");
        if (currencyIds.size() > 1) {
            labelap.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20\u53d1\u7968", (String)"InvoiceListMobilePlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceListSize));
            this.getView().setVisible(Boolean.FALSE, new String[]{"sum_amount1", "labelap2"});
        } else if (currencyIds.size() == 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"sum_amount1"});
            Long totalCurrencyId = currencyIds.iterator().next();
            this.getModel().setValue("total_currencyid", (Object)totalCurrencyId);
            if (!CurrencyUtils.FpzsMainService_100_id.equals(totalCurrencyId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap2"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap2"});
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String invPicture = (String)this.getModel().getValue("inv_picture");
        String attachPicture = (String)this.getModel().getValue("attach_picture");
        switch (key) {
            case "inv_list_btn": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inv_list_btn"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"sum_amount1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap2"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inv_pic_btn"});
                if (StringUtils.isNotBlank((CharSequence)invPicture)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"inv_pic_range"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inv_pic_range"});
                break;
            }
            case "inv_pic_btn": {
                String currencyIdStr;
                this.getView().setVisible(Boolean.FALSE, new String[]{"inv_pic_btn"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inv_pic_range"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inv_list_btn"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"sum_amount1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap2"});
                String sizeStr = this.getView().getPageCache().get("invoiceListSize");
                int invoiceListSize = 0;
                if (StringUtils.isNotEmpty((CharSequence)sizeStr)) {
                    try {
                        invoiceListSize = Integer.parseInt(sizeStr);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.info("\u53d1\u7968\u6570\u91cf\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e);
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)(currencyIdStr = this.getView().getPageCache().get("currencyIds")))) break;
                String[] split = currencyIdStr.split(",");
                HashSet<Long> currencyIds = new HashSet<Long>(split.length);
                for (String idStr : split) {
                    long id = BigDecimalUtil.transDecimal((Object)idStr).longValue();
                    if (id == 0L) {
                        id = CurrencyUtils.FpzsMainService_100_id;
                    }
                    currencyIds.add(id);
                }
                this.showSummary(currencyIds, invoiceListSize);
                break;
            }
            case "attach_list_btn": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"attach_list_btn"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap11"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"attach_pic_btn"});
                if (StringUtils.isNotBlank((CharSequence)attachPicture)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"attach_pic_range"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"attach_pic_range"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
                break;
            }
            case "attach_pic_btn": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"attach_pic_btn"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attach_pic_range"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"attach_list_btn"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap7"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap11"});
                break;
            }
            case "back": {
                Map viewCustomParam = FpzsMainService.getViewCustomParam((AbstractFormPlugin)this);
                String closedCallBackUrl = (String)viewCustomParam.get("closedCallBackUrl");
                if (StringUtils.isNotEmpty((CharSequence)closedCallBackUrl) || "2".equals(viewCustomParam.get("openType"))) {
                    OpenCloseCallBackUrlUtils.openCloseCallBackUrl((AbstractFormPlugin)this, (String)"custom_open_url", (Map)viewCustomParam);
                    break;
                }
                this.getView().close();
                break;
            }
            default: {
                this.getView().close();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        int index = (Integer)evt.getParamsMap().get("rowKey");
        String imageAp = (String)evt.getParamsMap().get("fieldId");
        String data = null;
        if (StringUtils.equals((CharSequence)"imageap", (CharSequence)imageAp)) {
            data = this.getPageCache().get("invData");
        } else if (StringUtils.equals((CharSequence)"imageap1", (CharSequence)imageAp)) {
            data = this.getPageCache().get("attachData");
        }
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        List msgList = (List)SerializationUtils.fromJsonString((String)data, List.class);
        Map dataMap = (Map)msgList.get(index);
        Map propMap = (Map)dataMap.get("imageap");
        if (StringUtils.equals((CharSequence)"imageap1", (CharSequence)imageAp)) {
            propMap = (Map)dataMap.get("imageap1");
        }
        if (MapUtils.isEmpty((Map)propMap) || propMap.get("imageKey") == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "previewImage");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("current", MapUtils.getString((Map)propMap, (Object)"imageKey"));
        args.put("urls", new String[]{MapUtils.getString((Map)propMap, (Object)"imageKey")});
        map.put("args", args);
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        String tabId = tab.getCurrentTab();
        Map viewCustomParam = FpzsMainService.getViewCustomParam((AbstractFormPlugin)this);
        if (StringUtils.equals((CharSequence)INVOICE_TAB, (CharSequence)tabId)) {
            this.fillEntryEntity(viewCustomParam);
        } else if (StringUtils.equals((CharSequence)ATTACH_TAB, (CharSequence)tabId)) {
            this.fillAttachEntryEntity(viewCustomParam);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry clickCardEntry = (CardEntry)evt.getSource();
        int currentRow = evt.getRow();
        String entyrKey = clickCardEntry.getEntryKey();
        HashMap<String, Object> value = new HashMap<String, Object>(2);
        value.put("row", currentRow);
        boolean allowEdit = false;
        value.put("allowEdit", allowEdit);
        value.put("allowDel", allowEdit);
        if (StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)entyrKey) && StringUtils.isBlank((CharSequence)CacheHelper.get((String)("entryentityRowClick" + RequestContext.get().getUserId())))) {
            CacheHelper.put((String)("entryentityRowClick" + RequestContext.get().getUserId()), (String)"1", (int)3);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, currentRow);
            if (dynamicObject == null) {
                return;
            }
            value.put("mainIds", dynamicObject.getString("id"));
            value.put("relationType", "3");
            value.put("allowEditAttach", allowEdit);
            value.put("addAttach", allowEdit);
            FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_inv_update");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "inv_"));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
            H5PluginService.setCommonParam(value, (Map)this.getView().getFormShowParameter().getCustomParams());
            showParameter.setCustomParams(value);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)ENTRYENTITY1, (CharSequence)entyrKey) && StringUtils.isBlank((CharSequence)CacheHelper.get((String)("entryentity1RowClick" + RequestContext.get().getUserId())))) {
            CacheHelper.put((String)("entryentity1RowClick" + RequestContext.get().getUserId()), (String)"1", (int)3);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY1, currentRow);
            if (dynamicObject == null) {
                return;
            }
            value.put("id", dynamicObject.getLong("id2"));
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_attach_detail");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "abcd"));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
            H5PluginService.setCommonParam(value, (Map)this.getView().getFormShowParameter().getCustomParams());
            showParameter.setCustomParams(value);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)"cover_entryentity", (CharSequence)entyrKey)) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("cover_entryentity", currentRow);
            if (dynamicObject == null) {
                return;
            }
            HashMap<String, Object> coverMap = new HashMap<String, Object>(2);
            coverMap.put("coverId", dynamicObject.get("coverid"));
            coverMap.put("coverNo", dynamicObject.get("coverno"));
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_cover_detail");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "abcd"));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            FpzsAnonymousUserService.addEventCode(coverMap, (String)this.getView().getPageId());
            H5PluginService.setCommonParam(coverMap, (Map)this.getView().getFormShowParameter().getCustomParams());
            showParameter.setCustomParams(coverMap);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void onProgress(ProgressEvent evt) {
        InvoiceClassService.getInstance().refreshListRow((AbstractFormPlugin)this, "invoice_class", "invoice_class_show", "id");
    }
}

