/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ExpenseStatusEnum;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.MetadataUtil;

public class MobileFileBagTipPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"submit", "rescan"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fileBagNo = customParams.get("fileBagNo");
        Label desc = (Label)this.getView().getControl("desc");
        if (fileBagNo == null) {
            desc.setText(ResManager.loadKDString((String)"\u626b\u63cf\u5931\u8d25", (String)"ScanFileBagOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            desc.setText(ResManager.loadKDString((String)"\u626b\u63cf\u6210\u529f", (String)"ScanFileBagOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            Label result = (Label)this.getView().getControl("result");
            result.setText(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4fe1\u606f\u4e3a\uff1a %1$s", (String)"ScanFileBagOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), String.valueOf(fileBagNo).length() > 50 ? String.valueOf(fileBagNo).substring(0, 50) : fileBagNo));
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("submit".equals(key)) {
            this.saveExpenseFileBag();
        } else if ("rescan".equals(key)) {
            this.getView().returnDataToParent((Object)"rescan");
            this.getView().close();
        }
    }

    private void saveExpenseFileBag() {
        DynamicObject billInfo;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fileBagNo = customParams.get("fileBagNo");
        Object billId = customParams.get("billId");
        Object billType = customParams.get("billType");
        if (billId == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5355\u636e%1$s", (String)"ExpenseManageListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), ""));
            return;
        }
        DynamicObject[] billInfos = BusinessDataServiceHelper.load((String)"rim_expense", (String)MetadataUtil.getFields((String)"rim_expense"), (QFilter[])new QFilter[]{new QFilter("expense_id", "=", billId), new QFilter("expense_type", "=", billType)});
        if (billInfos.length == 0) {
            billInfo = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
            billInfo.set("status", (Object)ExpenseStatusEnum.NOT_REIMBURSED.getCode());
        } else {
            billInfo = billInfos[0];
        }
        billInfo.set("create_time", (Object)new Date());
        billInfo.set("update_time", (Object)new Date());
        billInfo.set("expense_num", customParams.get("billNo"));
        billInfo.set("expense_id", billId);
        billInfo.set("expense_type", billType);
        billInfo.set("resource", customParams.get("resource"));
        billInfo.set("entityid", customParams.get("entityId"));
        billInfo.set("view_page", customParams.get("viewPage"));
        billInfo.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        billInfo.set("creator_name", (Object)RequestContext.get().getUserName());
        billInfo.set("orgid", customParams.get("org_id"));
        billInfo.set("file_bag_no", String.valueOf(fileBagNo).length() > 50 ? String.valueOf(fileBagNo).substring(0, 50) : fileBagNo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billInfo});
        InvoiceLog.insertExpenseLog((String)"fileBagScan", (String)(billId + ""), (String)(customParams.get("billNo") + ""), (String)new JSONObject(customParams).toJSONString());
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }
}

