/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.progress;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.RimProgressConstant;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.process.RimProgressTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class RimProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(RimProcessPlugin.class);
    private static final String CTRL_PRO_KEY = "rim_progressbarap";
    private static final String START_TIME = "start_time";
    public static final String FINISH_FLAG = "finishFlag";
    public static final String TITLE = "title";
    public static final String SUM_TIP = "sum_tip";
    public static final String CURRENT_PROGRESS = "current_progress";
    public static final String VIEW_LOG = "view_log";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"Thead-RimProcessPlugin", (int)6);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(CTRL_PRO_KEY);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{VIEW_LOG});
    }

    public void afterBindData(EventObject e) {
        Label label;
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!this.checkParam(customParams)) {
            LOGGER.info("customParams", (Object)customParams.toString());
            throw new MsgException("0001", ResManager.loadKDString((String)"\u5fc5\u4f20\u5b57\u6bb5\u7f3a\u5931", (String)"RimProcessPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        IPageCache pageCache = this.getView().getPageCache();
        String batchNoListStr = (String)customParams.get("batchNolist");
        LOGGER.info("RimProcessPlugin\uff0cbatchNolist--" + batchNoListStr);
        pageCache.put("batchNolist", batchNoListStr);
        String entityName = (String)customParams.get("entityName");
        String statusFieldName = (String)customParams.get("statusFieldName");
        String queryFields = (String)customParams.get("queryFields");
        String handlingStatusListStr = (String)customParams.get("handlingStatusList");
        String filterFieldName = (String)customParams.get("filterFieldName");
        String title = (String)customParams.get(TITLE);
        ProgressBar bar = (ProgressBar)this.getControl(CTRL_PRO_KEY);
        Date now = new Date();
        pageCache.put(START_TIME, DateUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss"));
        Date date = RimProcessPlugin.calculateNextEndDate(LocalDateTime.now());
        pageCache.put("lastTime", DateUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        JSONArray jsonArray = JSON.parseArray((String)batchNoListStr);
        QFilter filter = new QFilter(filterFieldName, "in", (Object)jsonArray);
        DynamicObjectCollection countReuslt = QueryServiceHelper.query((String)entityName, (String)"total_num, success_num", (QFilter[])new QFilter[]{filter});
        int totalNum = 0;
        for (DynamicObject dynamicObject : countReuslt) {
            totalNum += dynamicObject.getInt("total_num");
        }
        String sumTip = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4efd\u53d1\u7968\u52fe\u9009\u4e2d...", (String)"RimProcessPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), totalNum);
        if (StringUtils.isNotBlank((String)sumTip)) {
            label = (Label)this.getControl(SUM_TIP);
            label.setText(sumTip);
        }
        if (StringUtils.isNotBlank((String)title)) {
            label = (Label)this.getControl(TITLE);
            label.setText(title);
        }
        int progress = 0;
        Label currentProgressControl = (Label)this.getControl(CURRENT_PROGRESS);
        currentProgressControl.setText(String.valueOf(progress) + "%");
        bar.setPercent(progress);
        bar.start();
        pageCache.put("batchNolist", batchNoListStr);
        pageCache.put("entityName", entityName);
        pageCache.put("statusFieldName", statusFieldName);
        pageCache.put("queryFields", queryFields);
        pageCache.put("handlingStatusList", handlingStatusListStr);
        pageCache.put("filterFieldName", filterFieldName);
        String rimProgressTaskTime = ImcConfigUtil.getValue((String)"rim_deduction", (String)"rim_progress_task_time");
        Long runTime = 600000L;
        try {
            runTime = Long.valueOf(rimProgressTaskTime);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.info("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
        }
        RimProgressTask rimProgressTask = new RimProgressTask(RequestContext.get(), this.getView().getPageId(), runTime);
        threadPool.execute((Runnable)rimProgressTask);
    }

    private boolean checkParam(Map<String, Object> customParams) {
        if (MapUtils.isEmpty(customParams)) {
            return false;
        }
        for (String fieldName : RimProgressConstant.mustHaveParam) {
            if (customParams.containsKey(fieldName) && !Objects.isNull(customParams.get(fieldName))) continue;
            return false;
        }
        return true;
    }

    public void onProgress(ProgressEvent evt) {
        ProgressBar bar = (ProgressBar)this.getControl(CTRL_PRO_KEY);
        int progress = this.getProgress();
        LOGGER.info("progress" + progress);
        if (progress >= 100) {
            Label label = (Label)this.getControl(SUM_TIP);
            IPageCache pageCache = this.getView().getPageCache();
            String totalNum = pageCache.get("totalNum");
            String successNum = pageCache.get("successNum");
            String failNum = pageCache.get("failNum");
            label.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u4efd\u53d1\u7968\u52fe\u9009\u7ed3\u675f\uff0c\u52fe\u9009\u6210\u529f%2$s\u4efd\uff0c\u52fe\u9009\u5931\u8d25%3$s\u4efd", (String)"RimProcessPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), totalNum, successNum, failNum));
            evt.setProgress(100);
            bar.stop();
            this.removeCache();
        } else {
            evt.setProgress(progress);
        }
        Label currentProgressControl = (Label)this.getControl(CURRENT_PROGRESS);
        currentProgressControl.setText(String.valueOf(progress) + "%");
    }

    private void removeCache() {
        this.getView().getPageCache().remove("lastTime");
        this.getView().getPageCache().remove(START_TIME);
        this.getView().getPageCache().remove(FINISH_FLAG);
        this.getView().getPageCache().remove("entityName");
        this.getView().getPageCache().remove("statusFieldName");
        this.getView().getPageCache().remove("queryFields");
        this.getView().getPageCache().remove("handlingStatusList");
        this.getView().getPageCache().remove("filterFieldName");
    }

    private int getProgress() {
        String finishFlag = this.getView().getPageCache().get(FINISH_FLAG);
        if ("1".equals(finishFlag)) {
            return 100;
        }
        String startTime = this.getView().getPageCache().get(START_TIME);
        if (StringUtils.isBlank((String)startTime)) {
            return 100;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startDate = LocalDateTime.parse(startTime, formatter);
        Date nowDate = new Date();
        IPageCache pageCache = this.getView().getPageCache();
        String lastTime = pageCache.get("lastTime");
        if (StringUtils.isNotBlank((String)lastTime)) {
            Date lastDate = DateUtils.stringToDate((String)lastTime, (String)"yyyy-MM-dd HH:mm:ss");
            if (nowDate.compareTo(lastDate) <= 0) {
                nowDate = lastDate;
            } else {
                pageCache.put("lastTime", DateUtils.format((Date)nowDate, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        LocalDateTime now = LocalDateTime.parse(DateUtils.format((Date)nowDate, (String)"yyyy-MM-dd HH:mm:ss"), formatter);
        return this.calculateProgress(startDate, now);
    }

    public int calculateProgress(LocalDateTime startDate, LocalDateTime endDate) {
        Duration duration = Duration.between(startDate, endDate);
        long twoMinutesInSeconds = 240L;
        long elapsedSeconds = duration.getSeconds();
        if (elapsedSeconds >= twoMinutesInSeconds) {
            return 90;
        }
        double progressPercent = (double)elapsedSeconds / (double)twoMinutesInSeconds;
        return (int)(progressPercent * 90.0);
    }

    public static Date calculateNextEndDate(LocalDateTime endDate) {
        long twoMinutesInSeconds = 240L;
        double timePerProgressUnit = (double)twoMinutesInSeconds / 90.0;
        long secondsToAdd = (long)timePerProgressUnit;
        endDate = endDate.plusSeconds(secondsToAdd);
        return RimProcessPlugin.convertToLocalDate(endDate);
    }

    public static Date convertToLocalDate(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public void stopRimTaskByBatchNo(String batchNoListStrAdd) {
        JSONArray jsonArrayAdd;
        if (StringUtils.isNotBlank((String)batchNoListStrAdd) && CollectionUtils.isNotEmpty((Collection)(jsonArrayAdd = JSONArray.parseArray((String)batchNoListStrAdd)))) {
            String batchNo = jsonArrayAdd.getString(0);
            String stopFlag = CacheHelper.get((String)("progressStopFlag" + batchNo));
            if (StringUtils.isBlank((String)CacheHelper.get((String)("progressStopFlag" + batchNo)))) {
                CacheHelper.put((String)("progressStopFlag" + batchNo), (String)"1", (int)60);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String batchNoListStr = this.getView().getPageCache().get("batchNolist");
        this.stopRimTaskByBatchNo(batchNoListStr);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String batchNoListStr = this.getView().getPageCache().get("batchNolist");
        this.stopRimTaskByBatchNo(batchNoListStr);
        if (StringUtils.equals((String)VIEW_LOG, (String)control.getKey())) {
            this.showlogPage(control.getKey());
        }
    }

    private void showlogPage(String itemKey) {
        String batchNoListStr = this.getView().getPageCache().get("batchNolist");
        this.getView().getPageCache().remove("batchNolist");
        if (StringUtils.isNotBlank((String)batchNoListStr)) {
            JSONArray jsonArray = JSON.parseArray((String)batchNoListStr);
            JSONObject resultObject = new JSONObject();
            resultObject.put("viewLog", (Object)"1");
            resultObject.put("itemKey", (Object)itemKey);
            resultObject.put("batchNolist", (Object)jsonArray);
            this.getView().returnDataToParent((Object)resultObject);
            this.removeCache();
        }
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().getPageCache().put("stopFlag", "1");
    }
}

