/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import org.apache.commons.compress.utils.Lists;

public class ModifyDeductionFlagPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"submit"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"deduction_type"});
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        if (parentCustomParams != null) {
            JSONObject param = (JSONObject)parentCustomParams.get("param");
            Long invoiceType = param.getLong("invoiceType");
            this.getModel().setValue("invoice_type", (Object)invoiceType);
            if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"deduction_type"});
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("submit".equals(control.getKey())) {
            ArrayList cannotModifyList = Lists.newArrayList();
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            if (parentCustomParams != null) {
                JSONObject param = (JSONObject)parentCustomParams.get("param");
                JSONArray primaryKeyValues = param.getJSONArray("ids");
                Long invoiceType = param.getLong("invoiceType");
                DynamicObject[] mainObject = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields((String)"rim_invoice"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                DynamicObject[] detailObject = null;
                HashMap<String, DynamicObject> detailMap = new HashMap<String, DynamicObject>(mainObject.length);
                if (mainObject.length > 0) {
                    List serialNos = Arrays.stream(mainObject).map(m -> m.getString("serial_no")).collect(Collectors.toList());
                    for (DynamicObject obj : detailObject = BusinessDataServiceHelper.load((String)InputInvoiceTypeEnum.getEntity((Long)invoiceType), (String)MetadataUtil.getFields((String)InputInvoiceTypeEnum.getEntity((Long)invoiceType)), (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialNos)})) {
                        detailMap.put(obj.getString("serial_no"), obj);
                    }
                }
                String deductionFlag = (String)this.getModel().getValue("deduction_flag");
                String deductionType = (String)this.getModel().getValue("deduction_type");
                this.modifyDeductionFlag(invoiceType, deductionFlag, deductionType, mainObject, detailMap, cannotModifyList);
                if (cannotModifyList.size() > 0) {
                    this.getView().returnDataToParent((Object)cannotModifyList);
                } else {
                    this.getView().returnDataToParent((Object)"success");
                }
                this.getView().close();
            }
        }
    }

    private void modifyDeductionFlag(Long invoiceType, String deductionFlag, String deductionType, DynamicObject[] mainObject, Map<String, DynamicObject> detailMap, List<String> cannotModifyList) {
        ArrayList<DynamicObject> detailObjectList = new ArrayList<DynamicObject>(mainObject.length);
        ArrayList<DynamicObject> modifyLogList = new ArrayList<DynamicObject>(mainObject.length);
        for (DynamicObject main : mainObject) {
            String fpyDeductionFlag = main.getString("deduction_flag");
            boolean canModify = this.checkCanModify(main);
            if (!canModify) {
                String invoiceCodeNo = StringUtils.isNotEmpty((String)main.getString("invoice_code")) ? main.getString("invoice_code") + "_" + main.getString("invoice_no") : main.getString("invoice_no");
                cannotModifyList.add(invoiceCodeNo);
                continue;
            }
            DynamicObject detail = detailMap.get(main.getString("serial_no"));
            if (!deductionFlag.equals(main.getString("deduction_flag"))) {
                InvoiceSaveService.setExtInfo((DynamicObject)main, (String)InvoiceSaveConstant.EXT_MODIFY_DEDUCTION_FLAG, (String)deductionFlag);
            }
            main.set("deduction_flag", (Object)deductionFlag);
            detail.set("deduction_flag", (Object)deductionFlag);
            if (InputInvoiceTypeEnum.canDeduction((Long)invoiceType).booleanValue()) {
                if ("1".equals(deductionFlag)) {
                    main.set("effective_tax_amount", (Object)main.getBigDecimal("total_tax_amount"));
                    main.set("authenticate_flag", (Object)"0");
                    detail.set("effective_tax_amount", (Object)main.getBigDecimal("total_tax_amount"));
                    detail.set("authenticate_flag", (Object)"0");
                }
            } else if (InputInvoiceTypeEnum.canTransportDeduction((Long)invoiceType).booleanValue()) {
                if ("1".equals(deductionFlag)) {
                    BigDecimal effectiveTaxAmount = DeductionUtils.recalculateEffectiveTaxAmount((DynamicObject)main, (DynamicObject)detail);
                    if (effectiveTaxAmount != null) {
                        main.set("effective_tax_amount", (Object)effectiveTaxAmount);
                        detail.set("effective_tax_amount", (Object)effectiveTaxAmount);
                    }
                } else {
                    main.set("effective_tax_amount", (Object)BigDecimal.ZERO);
                    detail.set("effective_tax_amount", (Object)BigDecimal.ZERO);
                }
                if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                    if ("1".equals(deductionType)) {
                        main.set("authenticate_flag", (Object)"0");
                        detail.set("authenticate_flag", (Object)"0");
                        main.set("transport_deduction", (Object)"");
                        detail.set("transport_deduction", (Object)"");
                    } else {
                        main.set("transport_deduction", (Object)"0");
                        detail.set("transport_deduction", (Object)"0");
                        main.set("authenticate_flag", (Object)"");
                        detail.set("authenticate_flag", (Object)"");
                    }
                } else {
                    main.set("transport_deduction", (Object)"0");
                    detail.set("transport_deduction", (Object)"0");
                }
            }
            detailObjectList.add(detail);
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_df_log");
            logObj.set("expense_id", (Object)RequestContext.get().getCurrUserId());
            logObj.set("expense_num", (Object)RequestContext.get().getUserName());
            logObj.set("create_time", (Object)new Date());
            logObj.set("fpy_deduction_flag", (Object)fpyDeductionFlag);
            logObj.set("expense_deduction_flag", (Object)deductionFlag);
            logObj.set("fail_reason", (Object)"");
            logObj.set("serial_no", (Object)main.getString("serial_no"));
            modifyLogList.add(logObj);
        }
        SaveServiceHelper.update((DynamicObject[])mainObject);
        if (detailObjectList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])detailObjectList.toArray(new DynamicObject[0]));
        }
        if (modifyLogList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])modifyLogList.toArray(new DynamicObject[0]));
        }
    }

    private boolean checkCanModify(DynamicObject main) {
        String authenticateFlag = main.getString("authenticate_flag");
        String transportDeduction = main.getString("transport_deduction");
        String invoiceStatus = main.getString("invoice_status");
        if (StringUtils.isEmpty((String)authenticateFlag) && StringUtils.isEmpty((String)transportDeduction) && (StringUtils.isEmpty((String)invoiceStatus) || "0".equals(invoiceStatus) || "7".equals(invoiceStatus))) {
            return true;
        }
        return !(!"0".equals(authenticateFlag) && !"0".equals(transportDeduction) || !StringUtils.isEmpty((String)invoiceStatus) && !"0".equals(invoiceStatus) && !"7".equals(invoiceStatus));
    }
}

