/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.input.InputInvoiceDataService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ChangeOrgOperateService
extends InvoiceOperateService {
    private static Log logger = LogFactory.getLog(ChangeOrgOperateService.class);

    public ChangeOrgOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            HasPermOrgResult hasPermOrgResult;
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"ChangeOrgOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)false);
            lsp.setCustomParam("orgFuncId", (Object)"10");
            if ("change_taxorg".equals(this.type) && TenantUtils.useNewTaxOrg().booleanValue()) {
                lsp.setCustomParam("orgFuncId", (Object)"40");
            }
            if (!(hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.plugin.getView(), (String)"rim_invoice", (String)"47150e89000000ac")).hasAllOrgPerm()) {
                lsp.setCustomParam("range", (Object)hasPermOrgResult.getHasPermOrgs());
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            lsp.setCloseCallBack(closeCallBack);
            this.plugin.getView().showForm((FormShowParameter)lsp);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection orgList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            List list;
            Long orgId = (Long)orgList.get(0).getPrimaryKeyValue();
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"ChangeOrgOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            String userId = RequestContext.get().getUserId();
            DynamicObject[] objList = BusinessDataServiceHelper.load((Object[])selectCollection.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
            HashMap typeSerialMap = new HashMap(8);
            InputInvoiceDataService inputInvoiceDataService = new InputInvoiceDataService();
            HashMap<String, String> serialDeduction = new HashMap<String, String>(8);
            HashMap<String, String> serialDeductionAmount = new HashMap<String, String>(8);
            for (DynamicObject obj : objList) {
                Long invoiceType;
                if ("change_org".equals(this.type)) {
                    inputInvoiceDataService.createParam(obj);
                    obj.set("org", (Object)orgId);
                    invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("invoice_type"));
                    if (InputInvoiceTypeEnum.canDeduction((Long)invoiceType).booleanValue() || InputInvoiceTypeEnum.canTransportDeduction((Long)invoiceType).booleanValue()) {
                        String deductionFlag = obj.getString("deduction_flag");
                        String extInfo = obj.getString("ext_info");
                        String buyerTaxNo = obj.getString("buyer_tax_no");
                        Pair targetTaxNoPair = DeductionConstant.getTargetTaxNo((String)buyerTaxNo, (Long)orgId);
                        boolean smallScaleTaxpayer = TenantUtils.isSmallScaleTaxpayer((String)((String)targetTaxNoPair.getRight()));
                        logger.info("\u662f\u5426\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff1a{}", (Object)smallScaleTaxpayer);
                        if (smallScaleTaxpayer) {
                            if ("1".equals(deductionFlag)) {
                                InvoiceSaveService.setExtInfo((DynamicObject)obj, (String)InvoiceSaveConstant.EXT_ORIGINAL_DEDUCTION_FLAG, (String)"1");
                                InvoiceSaveService.setExtInfo((DynamicObject)obj, (String)InvoiceSaveConstant.EXT_ORIGINAL_DEDUCTION_TAX_AMOUNT, (String)obj.getString("effective_tax_amount"));
                            }
                            logger.info("\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e0d\u53ef\u62b5\u6263");
                            obj.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                            obj.set("effective_tax_amount", (Object)BigDecimal.ZERO);
                        } else {
                            try {
                                JSONObject extInfoObj = JSON.parseObject((String)extInfo);
                                String originalDeductionFlag = extInfoObj.getString(InvoiceSaveConstant.EXT_ORIGINAL_DEDUCTION_FLAG);
                                if ("1".equals(originalDeductionFlag) && "0".equals(deductionFlag)) {
                                    obj.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"1");
                                    obj.set("effective_tax_amount", (Object)BigDecimalUtil.transDecimal((Object)extInfoObj.getString(InvoiceSaveConstant.EXT_ORIGINAL_DEDUCTION_TAX_AMOUNT)));
                                }
                                InvoiceSaveService.setExtInfo((DynamicObject)obj, (String)InvoiceSaveConstant.EXT_ORIGINAL_DEDUCTION_FLAG, null);
                                InvoiceSaveService.setExtInfo((DynamicObject)obj, (String)InvoiceSaveConstant.EXT_ORIGINAL_DEDUCTION_TAX_AMOUNT, null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    serialDeduction.put(obj.getString("serial_no"), obj.getString("deduction_flag"));
                    serialDeductionAmount.put(obj.getString("serial_no"), obj.getString("effective_tax_amount"));
                    inputInvoiceDataService.createParam(obj);
                } else {
                    obj.set("tax_org", (Object)orgId);
                }
                obj.set("modifytime", (Object)new Date());
                obj.set("modifier", (Object)userId);
                invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("invoice_type"));
                String entity = InputInvoiceTypeEnum.getEntity((Long)invoiceType);
                list = (ArrayList<String>)typeSerialMap.get(entity);
                if (list == null) {
                    list = new ArrayList<String>(8);
                }
                list.add(obj.getString("serial_no"));
                typeSerialMap.put(entity, list);
            }
            try (TXHandle h = TX.required();){
                try {
                    ArrayList serialList = new ArrayList(selectCollection.size());
                    for (Map.Entry entry : typeSerialMap.entrySet()) {
                        DynamicObject[] invoiceList;
                        QFilter filter = new QFilter("serial_no", "in", entry.getValue());
                        list = QueryServiceHelper.queryPrimaryKeys((String)((String)entry.getKey()), (QFilter[])new QFilter[]{filter}, null, (int)((List)entry.getValue()).size());
                        for (DynamicObject obj : invoiceList = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((String)entry.getKey())))) {
                            if ("change_org".equals(this.type)) {
                                obj.set("org", (Object)orgId);
                                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("invoice_type"));
                                if (InputInvoiceTypeEnum.canDeduction((Long)invoiceType).booleanValue() || InputInvoiceTypeEnum.canTransportDeduction((Long)invoiceType).booleanValue()) {
                                    obj.set("deduction_flag", serialDeduction.get(obj.getString("serial_no")));
                                    obj.set("effective_tax_amount", (Object)BigDecimalUtil.transDecimal(serialDeductionAmount.get(obj.getString("serial_no"))));
                                }
                            } else {
                                obj.set("tax_org", (Object)orgId);
                            }
                            obj.set("modifytime", (Object)new Date());
                            obj.set("modifier", (Object)userId);
                        }
                        serialList.addAll((Collection)entry.getValue());
                        SaveServiceHelper.save((DynamicObject[])invoiceList);
                    }
                    if ("change_org".equals(this.type)) {
                        InvoiceLog.insert((String)"changeorg", serialList, (String)"");
                    } else {
                        InvoiceLog.insert((String)"changtaxorg", serialList, (String)"");
                    }
                    SaveServiceHelper.save((DynamicObject[])objList);
                    inputInvoiceDataService.saveParam();
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            BillList billlist = (BillList)this.plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
        }
    }
}

