/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class CheckOperateService
extends InvoiceOperateService {
    public CheckOperateService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DeleteOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object[] invoiceIds = selectCollection.getPrimaryKeyValues();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields((String)"rim_invoice"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceIds)});
        if (invoices == null) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"CheckOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List<DynamicObject> collect = Arrays.stream(invoices).filter(f -> InputInvoiceTypeEnum.needCheck((Long)f.getDynamicObject("invoice_type").getLong("id"))).filter(f -> !"1".equals(f.getString("check_status"))).collect(Collectors.toList());
        if (collect.size() == 0) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u67e5\u9a8c\u53d1\u7968", (String)"CheckOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        JSONArray result = this.getDealResult(collect);
        if (result.size() < invoiceIds.length) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u4e3a\u60a8\u8fc7\u6ee4\u65e0\u9700\u67e5\u9a8c\u7684\u53d1\u7968", (String)"CheckOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
        HashMap<String, JSONArray> customParams = new HashMap<String, JSONArray>(1);
        customParams.put("personTicketInvoices", result);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_personticket_check");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
        showParameter.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm(showParameter);
    }

    private JSONArray getDealResult(List<DynamicObject> collect) {
        String recognitionImplStr = RimConfigUtils.getConfig((String)"rim_recog_check", (String)"rimpl");
        boolean isAwsRecognition = StringUtils.isEmpty((String)recognitionImplStr) || "kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService".equals(recognitionImplStr);
        boolean isConvertPlace = "1".equals(RimConfigUtils.getConfig((String)"rim_recog_check", (String)"convertplace"));
        JSONArray result = new JSONArray();
        for (DynamicObject obj : collect) {
            CheckResult checkResult;
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("org_id"));
            if (orgId == 0L) {
                orgId = RequestContext.get().getOrgId();
            }
            Map invoice = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)obj);
            InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)((Long)invoice.get("invoice_type")));
            JSONObject convert = convertService.convert(invoice);
            String entityId = InputInvoiceTypeEnum.getEntity((Long)((Long)invoice.get("invoice_type")));
            DynamicObject subObj = null;
            try {
                subObj = QueryServiceHelper.queryOne((String)entityId, (String)"check_code", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", invoice.get("serial_no"))});
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (subObj != null) {
                convert.put("checkCode", (Object)subObj.getString("check_code"));
            }
            CheckParam invoiceCheckPart = ConvertFieldUtil.getInvoiceCheckPart((JSONObject)convert);
            String taxNo = convert.getString("buyerTaxNo");
            if (StringUtils.isEmpty((String)taxNo)) {
                taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            }
            if ((checkResult = SimplyCheckService.checkInvoice((CheckParam)invoiceCheckPart, (Long)orgId, (String)taxNo)) != null && "0000".equals(checkResult.getErrcode())) {
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                JSONObject invoiceJson = JSON.parseObject((String)invoiceCheckStr);
                invoiceJson.put("checkStatus", (Object)"1");
                try {
                    InvoiceSaveService invoiceSaveService;
                    if (isAwsRecognition && isConvertPlace) {
                        InvoiceCollectService collectService = new InvoiceCollectService();
                        collectService.convertPlace(invoiceJson);
                    }
                    if ((invoiceSaveService = InvoiceSaveService.newInstance((String)invoiceJson.getString("invoiceType"))) == null) continue;
                    boolean isCollectOwner = SysParamUtil.getSysParamByOrgId((Long)orgId, (String)"is_collectowner");
                    if (isCollectOwner) {
                        boolean isHit = SysParamUtil.isHitValue((long)orgId, (String)"collectowner_config", (String)"3");
                        if (!isHit) {
                            invoiceJson.put("needUserRelation", (Object)"0");
                        } else {
                            InvoiceSaveService.notSetUserRelationIfExist((JSONObject)invoiceJson);
                        }
                    } else {
                        invoiceJson.put("needUserRelation", (Object)"0");
                    }
                    invoiceSaveService.save(invoiceJson);
                    result.add((Object)invoiceJson);
                }
                catch (MsgException e) {
                    convert.put("checkStatus", (Object)"2");
                    convert.put("errcode", (Object)e.getErrorCode());
                    convert.put("description", (Object)e.getErrorMsg());
                    result.add((Object)convert);
                }
                continue;
            }
            convert.put("checkStatus", (Object)"2");
            if (checkResult != null) {
                convert.put("errcode", (Object)checkResult.getErrcode());
                convert.put("description", (Object)checkResult.getDescription());
            }
            result.add((Object)convert);
        }
        return result;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList billlist = (BillList)this.plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }
}

