/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class DeductionLoginOperateService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(DeductionLoginOperateService.class);
    private static String[] INOUTS = new String[]{"1", "2", "4", "5"};

    public DeductionLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
        this.currentOrgId = currentOrgId;
        this.showResult = this::showResult;
    }

    public DeductionLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        this.plugin = plugin;
        this.type = type;
        this.currentOrgId = currentOrgId;
        this.showResult = consumer;
    }

    @Override
    public void operate() {
        String cache = this.plugin.getPageCache().get("deduct_tax_no");
        String title = this.plugin.getPageCache().get("deduct_title");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject cacheJson = JSONObject.parseObject((String)cache);
        if (ObjectUtils.isEmpty((Object)cacheJson)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> list = new ArrayList<String>(cacheJson.size());
        LOGGER.info("\u767b\u5f55\u68c0\u6d4b\u7a0e\u53f7:{}", (Object)cacheJson.keySet());
        for (Map.Entry entry : cacheJson.entrySet()) {
            String taxNo = (String)entry.getKey();
            JSONObject configObj = cacheJson.getJSONObject(taxNo);
            JSONArray invoices = configObj.getJSONArray("invoices");
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                list.add(taxNo);
                this.setCacheTip(taxNo, invoices, ErrorType.TAXNO_NULL.getName());
                continue;
            }
            String dkType = this.getNewDkType(taxNo, configObj);
            LOGGER.info("{}\u6536\u7968\u901a\u9053:{}", (Object)taxNo, (Object)dkType);
            if (StringUtils.isBlank((CharSequence)dkType)) {
                list.add(taxNo);
                this.setCacheTip(taxNo, invoices, ErrorType.DKTYPE_NULL.getName());
                continue;
            }
            if (this.beforeLoginDoOperation(dkType, taxNo, configObj)) {
                list.add(taxNo);
                continue;
            }
            String deductibleMode = configObj.getString("deductibleMode");
            if ("2".equals(deductibleMode) || "-2".equals(deductibleMode)) {
                if (!"5".equals(dkType) && !"4".equals(dkType)) {
                    list.add(taxNo);
                    this.setCacheTip(taxNo, invoices, ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u65b0\u7535\u5b50\u5e73\u53f0\u548c\u4e50\u4f01\u901a\u9053\u8fdb\u884c\u9000\u7a0e\u64cd\u4f5c", (String)"DeductOperateService_76", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if ("5".equals(dkType) && "-2".equals(deductibleMode)) {
                    list.add(taxNo);
                    this.setCacheTip(taxNo, invoices, ResManager.loadKDString((String)"\u5f53\u524d\u4e50\u4f01\u901a\u9053\u4e0d\u652f\u6301\u9000\u7a0e\u64a4\u9500\u64cd\u4f5c", (String)"DeductOperateService_75", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (Boolean.TRUE.equals(configObj.getBoolean("noLogin"))) {
                this.afterLoginDoOperation(dkType, taxNo, configObj, null);
                list.add(taxNo);
                continue;
            }
            if ("4".equals(dkType)) {
                boolean isBreak;
                boolean syncDown = DeductionLoginOperateService.isSyncDown(taxNo);
                configObj.put("rpa_select_syn", (Object)(syncDown ? "1" : "0"));
                if (!syncDown) {
                    configObj.put("notDateSplit", (Object)"1");
                }
                if (!(isBreak = this.loginEleClient(cacheJson, list, taxNo, configObj, dkType))) continue;
                return;
            }
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
            list.add(taxNo);
        }
        for (String tt : list) {
            cacheJson.remove((Object)tt);
        }
        if (cacheJson.isEmpty()) {
            this.showResult.accept(title);
        }
    }

    public void setCacheTip(String taxNo, JSONArray invoices, String messageParam) {
        JSONObject resultParam = ResultContant.createSuccessJSONObject();
        StringBuilder message = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice = invoices.getJSONObject(i);
                String invoiceCode = invoice.getString("invoiceCode");
                String invoiceNo = invoice.getString("invoiceNo");
                message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u7a0e\u53f7%2$s\uff0c%3$s", (String)"DeductionLoginOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo), taxNo, messageParam)).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        resultParam.put("message", (Object)message.toString());
        resultParam.put("successNum", (Object)0);
        resultParam.put("failNum", (Object)(CollectionUtils.isNotEmpty((Collection)invoices) ? invoices.size() : 0));
        this.setOperationResult2Cache(resultParam);
    }

    private String getNewDkType(String taxNo, JSONObject configObj) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (!"deduct_login_down_invoice".equals(this.type)) {
            return dkType;
        }
        if (ObjectUtils.isEmpty((Object)taxNo) || ObjectUtils.isEmpty((Object)dkType) || ObjectUtils.isEmpty((Object)configObj)) {
            return dkType;
        }
        if ("5".equals(dkType)) {
            return dkType;
        }
        JSONArray batchNoList = configObj.getJSONArray("data");
        boolean isCheckDkType = true;
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)batchNoList)) {
            for (int i = 0; i < batchNoList.size(); ++i) {
                JSONObject logConfig = batchNoList.getJSONObject(i);
                if (Arrays.asList(INOUTS).contains(logConfig.getString("inout"))) continue;
                isCheckDkType = false;
                break;
            }
        }
        return isCheckDkType ? InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType) : dkType;
    }

    public boolean loginEleClient(JSONObject cacheJson, List<String> list, String taxNo, JSONObject configObj, String dkType) {
        NewEtaxDeductService service = new NewEtaxDeductService(Long.valueOf(0L));
        JSONObject loginResult = service.login(taxNo);
        JSONObject data = loginResult.getJSONObject("data");
        if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
            if (service.needOpenLoginPage(data)) {
                data.put("taxNo", (Object)taxNo);
                service.showLoginPage(data, this.plugin, this.type);
                this.plugin.getPageCache().put("loginTaxNo", taxNo);
                for (String tt : list) {
                    cacheJson.remove((Object)tt);
                }
                this.plugin.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
                return true;
            }
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
            list.add(taxNo);
        } else {
            if (loginResult == null) {
                loginResult = new JSONObject();
                loginResult.put("errcode", (Object)ErrorType.ALl_E_LOGIN_FAIL.getCode());
                loginResult.put("description", (Object)ErrorType.ALl_E_LOGIN_FAIL.getName());
            }
            list.add(taxNo);
            JSONObject resultParam = ResultContant.createSuccessJSONObject();
            StringBuilder resultMessage = new StringBuilder();
            JSONArray invoices = configObj.getJSONArray("invoices");
            boolean hasInvoice = CollectionUtils.isNotEmpty((Collection)invoices);
            if (hasInvoice) {
                for (int i = 0; i < invoices.size(); ++i) {
                    JSONObject invoice = invoices.getJSONObject(i);
                    String invoiceCode = invoice.getString("invoiceCode");
                    String invoiceNo = invoice.getString("invoiceNo");
                    resultMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u7a0e\u53f7%2$s\uff0c%3$s", (String)"DeductionLoginOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo), taxNo, loginResult.getString("description"))).append(ViewUtil.LINE_SEPARATOR);
                }
            } else {
                resultMessage.append(loginResult.getString("description"));
            }
            resultParam.put("message", (Object)resultMessage.toString());
            resultParam.put("successNum", (Object)0);
            resultParam.put("failNum", (Object)(hasInvoice ? invoices.size() : 0));
            this.setOperationResult2Cache(resultParam);
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String taxNo = this.plugin.getPageCache().get("loginTaxNo");
        String cache = this.plugin.getPageCache().get("deduct_tax_no");
        String title = this.plugin.getPageCache().get("deduct_title");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject json = JSONObject.parseObject((String)cache);
        if (ObjectUtils.isEmpty((Object)json)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String dkType = "4";
        JSONObject configObj = json.getJSONObject(taxNo);
        if (StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
        } else {
            this.afterLoginDoOperation(dkType, taxNo, configObj, ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"DeductionLoginOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        json.remove((Object)taxNo);
        if (json.isEmpty()) {
            this.showResult.accept(title);
        } else {
            this.plugin.getPageCache().put("deduct_tax_no", json.toJSONString());
            this.operate();
        }
    }

    protected void setOperationResult2Cache(JSONObject operationRtn) {
        if (operationRtn == null) {
            return;
        }
        JSONArray batchNoArr = operationRtn.getJSONArray("batchNoList");
        IPageCache pageCache = this.plugin.getPageCache();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)batchNoArr)) {
            String batchNoStr = pageCache.get("batchNolist");
            LOGGER.info("RimProcessPlugin\uff0ccache-batchNolist: {}, new-batchNoArr {}" + batchNoStr, (Object)batchNoArr.toString());
            JSONArray newBatchArr = new JSONArray();
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)batchNoStr)) {
                newBatchArr = JSONArray.parseArray((String)batchNoStr);
            }
            newBatchArr.addAll((Collection)batchNoArr);
            pageCache.put("batchNolist", newBatchArr.toJSONString());
            pageCache.put("entityName", "rim_select_log");
            pageCache.put("statusFieldName", "handle_status");
            pageCache.put("queryFields", "handle_status,id");
            JSONArray handlingStatusArr = new JSONArray();
            handlingStatusArr.add((Object)"0");
            handlingStatusArr.add((Object)"3");
            pageCache.put("handlingStatusList", handlingStatusArr.toJSONString());
            pageCache.put("filterFieldName", "batch_no");
        }
        String resultCache = pageCache.get("operation_result");
        JSONObject resultInfo = null;
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        if (resultCache != null) {
            resultInfo = JSONObject.parseObject((String)resultCache);
            successNum += resultInfo.getIntValue("successNum");
            failNum += resultInfo.getIntValue("failNum");
            String msg = resultInfo.getString("message");
            if (msg != null) {
                message.append(msg);
            }
        } else {
            resultInfo = ResultContant.createSuccessJSONObject();
        }
        if (!ResultContant.isSuccess((JSONObject)operationRtn).booleanValue()) {
            resultInfo.put("errcode", operationRtn.get((Object)"errcode"));
        }
        successNum += operationRtn.getInteger("successNum").intValue();
        failNum += operationRtn.getInteger("failNum").intValue();
        if (null != operationRtn.get((Object)"message")) {
            message.append(operationRtn.get((Object)"message"));
        }
        resultInfo.put("successNum", (Object)successNum);
        resultInfo.put("failNum", (Object)failNum);
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            resultInfo.put("message", (Object)message.toString());
        }
        pageCache.put("operation_result", resultInfo.toJSONString());
    }

    public boolean beforeLoginDoOperation(String dkType, String taxNo, JSONObject configObj) {
        return false;
    }

    private void showResult(String title) {
        DeductionUtils.showResult((AbstractFormPlugin)this.plugin);
    }
}

