/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.deduction.ReadyDeductSelectSerive;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class DeductionReadySelectCancelService
extends InvoiceOperateService {
    public DeductionReadySelectCancelService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        if (!DeductionReadySelectCancelService.checkPermission(this.type)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u64a4\u9500\u9884\u52fe\u9009\u6743\u9650\uff0c\u8bf7\u914d\u7f6e\u53d1\u7968\u4e3b\u8868\u7684\u64a4\u9500\u9884\u52fe\u9009\u6743\u9650", (String)"DeductionReadySelectService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"ClassInvoiceService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object[] invoiceIds = selectCollection.getPrimaryKeyValues();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields((String)"rim_invoice"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceIds)});
        if (invoices == null) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u7968", (String)"DelPersonInvoiceOpenService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        StringBuilder desc = new StringBuilder();
        for (DynamicObject invoice : invoices) {
            this.buildDesc(desc, invoice);
        }
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            this.plugin.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(desc.toString());
            this.plugin.getView().showOperationResult(operationResult);
            return;
        }
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        String queryType = customParams.get("querytype") + "";
        ReadyDeductSelectSerive selectSerive = new ReadyDeductSelectSerive();
        String batchNo = UUID.getBatchNo((String)"READY");
        for (DynamicObject main : invoices) {
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)main.get("invoice_type"));
            if ("undeduction".equals(queryType) || "deduction".equals(queryType) || "drawback".equals(queryType)) {
                JSONObject example = new JSONObject();
                example.put("serial_no", (Object)main.getString("serial_no"));
                example.put("invoice_type", (Object)invoiceType);
                if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
                    example.put("invoice_code", (Object)main.getString("invoice_code"));
                }
                example.put("invoice_no", (Object)main.getString("invoice_no"));
                example.put("effective_tax_amount", main.get("effective_tax_amount"));
                example.put("tax_period", (Object)DateUtils.format((Date)main.getDate("tax_period"), (String)"yyyyMM"));
                example.put("authenticate_flag", (Object)"0");
                JSONArray taxDeductInvoiceArray = new JSONArray();
                taxDeductInvoiceArray.add((Object)example);
                selectSerive.readyDeductSelect(taxDeductInvoiceArray, "0", main.getDate("tax_period"), batchNo);
                continue;
            }
            ArrayList transportDeductSerialNos = Lists.newArrayList();
            transportDeductSerialNos.add(main.getString("serial_no"));
            selectSerive.readyDeductTransport((List)transportDeductSerialNos, "0", main.getDate("tax_period"), batchNo);
        }
        this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u9884\u52fe\u9009\u6210\u529f", (String)"ReadyDudectSelectPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        BillList billlist = (BillList)this.plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }

    private void buildDesc(StringBuilder desc, DynamicObject invoice) {
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        String queryType = customParams.get("querytype") + "";
        String invoiceCode = invoice.getString("invoice_code");
        String invoiceNo = invoice.getString("invoice_no");
        String invoiceInfo = StringUtils.isEmpty((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + "-" + invoiceNo;
        StringBuilder subDescStr = new StringBuilder();
        if ("undeduction".equals(queryType) || "deduction".equals(queryType) || "drawback".equals(queryType)) {
            String authenticateFlag = invoice.getString("authenticate_flag");
            if (!"4".equals(authenticateFlag)) {
                subDescStr.append(ResManager.loadKDString((String)"\u53ea\u80fd\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u672a\u52fe\u9009\u201d\u6216\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968\uff0c\u6216\u64a4\u9500\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968", (String)"DeductionReadySelectService_1", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
        } else {
            String transportDeduction = invoice.getString("transport_deduction");
            if (!"2".equals(transportDeduction)) {
                subDescStr.append(ResManager.loadKDString((String)"\u53ea\u80fd\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u672a\u52fe\u9009\u201d\u6216\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968\uff0c\u6216\u64a4\u9500\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968", (String)"DeductionReadySelectService_1", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)subDescStr.toString())) {
            desc.append(invoiceInfo).append(":").append((CharSequence)subDescStr);
        }
    }
}

