/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DeductionReadySelectService
extends InvoiceOperateService {
    public DeductionReadySelectService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        if (!DeductionReadySelectService.checkPermission(this.type)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9884\u52fe\u9009\u6743\u9650\uff0c\u8bf7\u914d\u7f6e\u53d1\u7968\u4e3b\u8868\u7684\u63d0\u4ea4\u9884\u52fe\u9009\u6743\u9650", (String)"DeductionReadySelectService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"ClassInvoiceService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object[] invoiceIds = selectCollection.getPrimaryKeyValues();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id, invoice_code, invoice_no, invoice_type, authenticate_flag, transport_deduction, buyer_tax_no, invoice_status, org_id, invoice_amount, invoice_risk_level", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceIds)});
        if (invoices == null) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u7968", (String)"DelPersonInvoiceOpenService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        StringBuilder desc = new StringBuilder();
        for (DynamicObject invoice : invoices) {
            this.buildDesc(desc, invoice);
        }
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            this.plugin.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(desc.toString());
            this.plugin.getView().showOperationResult(operationResult);
            return;
        }
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        customParams.put("invoiceIds", invoiceIds);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("rim_batch_ready_select");
        showParameter.setParentPageId(this.plugin.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
        showParameter.setCustomParam("param", (Object)customParams);
        showParameter.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm(showParameter);
    }

    private void buildDesc(StringBuilder desc, DynamicObject invoice) {
        String taxNo;
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        String queryType = customParams.get("querytype") + "";
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("invoice_type"));
        String invoiceCode = invoice.getString("invoice_code");
        String invoiceNo = invoice.getString("invoice_no");
        String invoiceInfo = StringUtils.isEmpty((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + "-" + invoiceNo;
        StringBuilder subDescStr = new StringBuilder();
        if ("undeduction".equals(queryType) || "deduction".equals(queryType) || "drawback".equals(queryType)) {
            String authenticateFlag = invoice.getString("authenticate_flag");
            if ("1".equals(authenticateFlag) || "2".equals(authenticateFlag) || "3".equals(authenticateFlag) || "5".equals(authenticateFlag)) {
                subDescStr.append(ResManager.loadKDString((String)"\u53ea\u80fd\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u672a\u52fe\u9009\u201d\u6216\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968\uff0c\u6216\u64a4\u9500\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968", (String)"DeductionReadySelectService_1", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
        } else {
            String transportDeduction = invoice.getString("transport_deduction");
            if ("1".equals(transportDeduction)) {
                subDescStr.append(ResManager.loadKDString((String)"\u53ea\u80fd\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u672a\u52fe\u9009\u201d\u6216\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968\uff0c\u6216\u64a4\u9500\u9884\u52fe\u9009\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u9884\u52fe\u9009\u201d\u7684\u53d1\u7968", (String)"DeductionReadySelectService_1", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            String invoiceRiskLevel;
            String invoiceStatus;
            BigDecimal invoiceAmount = BigDecimalUtil.transDecimal((Object)invoice.get("invoice_amount"));
            if (BigDecimal.ZERO.compareTo(invoiceAmount) > 0) {
                subDescStr.append(ResManager.loadKDString((String)"\u5f00\u7968\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968", (String)"DeductionReadySelectService_2", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
            if (StringUtils.isNotEmpty((CharSequence)(invoiceStatus = invoice.getString("invoice_status"))) && !"0".equals(invoiceStatus) && !"7".equals(invoiceStatus)) {
                subDescStr.append(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52fe\u9009\u53d1\u7968\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u548c\u201c\u90e8\u5206\u7ea2\u51b2\u201d\u7684\u53d1\u7968\uff0c\u8bf7\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968", (String)"DeductionReadySelectService_3", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
            if (StringUtils.isNotEmpty((CharSequence)(invoiceRiskLevel = invoice.getString("invoice_risk_level"))) && "3".equals(invoiceRiskLevel)) {
                subDescStr.append(ResManager.loadKDString((String)"\u8bf7\u52ff\u52fe\u9009\u5f02\u5e38\u51ed\u8bc1\uff0c\u82e5\u72b6\u6001\u6709\u8bef\u8bf7\u4e0b\u8f7d\u66f4\u65b0", (String)"DeductionReadySelectService_4", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        if (StringUtils.isEmpty((CharSequence)(taxNo = invoice.getString("buyer_tax_no")))) {
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("org_id"));
            if (orgId == 0L) {
                orgId = RequestContext.get().getOrgId();
            }
            taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
        }
        if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
            subDescStr.append(ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e0d\u652f\u6301\u62b5\u6263\u7c7b\u52fe\u9009\uff0c\u53ef\u6839\u636e\u4f01\u4e1a\u5728\u7a0e\u5c40\u7684\u4fe1\u606f\uff0c\u5728\u661f\u701a\u53d1\u7968\u4e91\u4f01\u4e1a\u57fa\u7840\u8d44\u6599\u4fee\u6539", (String)"DeductionReadySelectService_5", (String)"imc-rim-formplugin", (Object[])new Object[0])).append(ViewUtil.LINE_SEPARATOR);
        }
        if (StringUtils.isNotEmpty((CharSequence)subDescStr.toString())) {
            desc.append(invoiceInfo).append(":").append((CharSequence)subDescStr);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (ResManager.loadKDString((String)"\u63d0\u4ea4\u9884\u52fe\u9009\u6210\u529f", (String)"ReadyDudectSelectPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(returnData + "")) {
            this.plugin.getView().showSuccessNotification(returnData + "");
        } else {
            this.plugin.getView().showTipNotification(returnData + "");
        }
        BillList billlist = (BillList)this.plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }
}

