/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;

public class InvoiceOperateService {
    private static Log logger = LogFactory.getLog(InvoiceOperateService.class);
    public static final String OPERATE_TYPE_EXPENSE = "add_expense";
    public static final String OPERATE_TYPE_VOUCH = "add_vouch";
    public static final String OPERATE_TYPE_EXPORT = "export";
    public static final String OPERATE_TYPE_EXPORT_HEAD = "export_head";
    public static final String OPERATE_TYPE_SELECT = "deduction_select";
    public static final String OPERATE_TYPE_UNSELECT = "deduction_unselect";
    public static final String OPERATE_TYPE_TAX_SELECT = "deduction_tax";
    public static final String OPERATE_TYPE_TAX_UNSELECT = "undeduction_tax";
    public static final String OPERATE_TYPE_INVOICE_SIGN = "invoice_sign";
    public static final String OPERATE_TYPE_GENERATE_VOUCHER = "generatevoucher";
    public static final String OPERATE_TYPE_DELETE = "delete_invoice";
    public static final String OPERATE_TYPE_CHANGE_ROG = "change_org";
    public static final String OPERATE_TYPE_CHANGE_TAXROG = "change_taxorg";
    public static final String OPERATE_TYPE_DOWNLOAD = "download_invoice";
    public static final String OPERATE_TYPE_DOWNLOAD_XML = "download_xml";
    public static final String OPERATE_TYPE_DOWNLOAD_INV_ATTACH = "download_inv_attach";
    public static final String OPERATE_IMPORT_ITEM = "item_import";
    public static final String OPERATE_DOWNLOAD_TEMPLATE = "download_template";
    public static final String OPERATE_IMPORT_INVOICE = "import_invoice";
    public static final String OPERATE_IMPORT_RESULT = "import_result";
    public static final String OPERATE_TYPE_INVOICE_UNSIGN = "invoice_unsign";
    public static final String OPERATE_TYPE_INVOICE_DETAIL = "invoice_detail";
    public static final String OPERATE_TYPE_INVOICE_TAG = "invoice_tag";
    public static final String OPERATE_TYPE_DOWN_TAX_FILE = "down_tax_file";
    public static final String OPERATE_TYPE_AGRIC_HANDLE = "agric_handle";
    public static final String OPERATE_TYPE_MODIFY_DEDUCTION_FLAG = "modify_deduction_flag";
    public static final String OPERATE_TYPE_EXPORT_CONFIG = "export_config";
    public static final String OPERATE_TYPE_DEDUCT_LOGIN = "deduct_login";
    public static final String OPERATE_TYPE_DEDUCT_LOGIN_SELECT = "deduct_login_select";
    public static final String OPERATE_TYPE_DEDUCT_LOGIN_BATCH_DEDUCT = "deduct_login_batch_deduct";
    public static final String OPERATE_TYPE_DEDUCT_LOGIN_DOWN_INVOICE = "deduct_login_down_invoice";
    public static final String OPERATE_TYPE_DEDUCT_LOGIN_READY_SELECT = "deduct_login_ready_select";
    public static final String OPERATE_TYPE_DEDUCT_LOGIN_GET_ASYNC_RESULT = "deduct_login_get_async_result";
    public static final String OPERATE_TYPE_DOWN_REAPPLY_LOGIN = "down_reapply_login";
    public static final String OPERATE_TYPE_SELECT_REAPPLY_LOGIN = "select_reapply_login";
    public static final String OPERATE_TYPE_EXCEL_SELECT = "excel_select";
    public static final String OPERATE_TYPE_EXCEL_SELECT_DOWN = "excel_select_upload";
    public static final String OPERATE_TYPE_EXCEL_SELECT_RESULT = "excel_select_result";
    public static final String OPERATE_TYPE_READY_SELECT = "deduction_ready_select";
    public static final String OPERATE_TYPE_READY_SELECT_CANCEL = "deduction_ready_select_cancel";
    public static final String OPERATE_TYPE_COLLECT_INVOICE = "collect_invoice";
    public static final String OPERATE_TYPE_RELAY_INVOICE = "relay_invoice";
    public static final String OPERATE_TYPE_DEL_PERSON_INVOICE = "delete_person_invoice";
    public static final String OPERATE_TYPE_UPDATE_VOUCH = "update_vouch";
    public static final String OPERATE_TYPE_CLASS_INVOICE = "class_invoice";
    public static final String OPERATE_TYPE_INVOICE_CHECK = "invoice_check";
    public static final String OPERATE_TYPE_RECORDED_COMMIT = "recorded_commit";
    public static final String OPERATE_TYPE_RECORDED_UPDATE = "recorded_update";
    public static final String OPERATE_TYPE_RECORDED_REVOKE = "recorded_revoke";
    public static final String RECORDED_ETAX_CALLBACK = "recorded_etax_callback";
    public static final String OPERATE_TYPE_RECORDED_PURPOSE = "maintain_recorded_purpose";
    public static final String OPERATE_TYPE_RECORDED_TIME = "maintain_recorded_time";
    public static final String RIM_PROGRESS_WINDOW = "rim_progress_window";
    protected AbstractFormPlugin plugin;
    protected String type;
    protected Long currentOrgId;
    protected Consumer<String> showResult;

    protected static final List<String> OPERATE_LIST_TICKETPOOL() {
        ArrayList<String> list = new ArrayList<String>(16);
        list.add(OPERATE_TYPE_DELETE);
        list.add(OPERATE_TYPE_EXPENSE);
        list.add(OPERATE_TYPE_VOUCH);
        list.add(OPERATE_TYPE_UPDATE_VOUCH);
        list.add(OPERATE_TYPE_EXPORT);
        list.add(OPERATE_TYPE_CHANGE_ROG);
        list.add(OPERATE_TYPE_CHANGE_TAXROG);
        list.add(OPERATE_TYPE_DOWNLOAD);
        list.add(OPERATE_TYPE_DOWN_TAX_FILE);
        list.add(OPERATE_DOWNLOAD_TEMPLATE);
        list.add(OPERATE_IMPORT_RESULT);
        list.add(OPERATE_TYPE_INVOICE_SIGN);
        list.add(OPERATE_TYPE_INVOICE_UNSIGN);
        list.add(OPERATE_TYPE_INVOICE_DETAIL);
        list.add(OPERATE_TYPE_INVOICE_TAG);
        return list;
    }

    protected static final List<String> OPERATE_LIST_PERSON_TICKET() {
        ArrayList<String> list = new ArrayList<String>(8);
        list.add(OPERATE_TYPE_COLLECT_INVOICE);
        list.add(OPERATE_TYPE_CLASS_INVOICE);
        list.add(OPERATE_TYPE_RELAY_INVOICE);
        list.add(OPERATE_TYPE_INVOICE_DETAIL);
        list.add(OPERATE_TYPE_INVOICE_CHECK);
        list.add(OPERATE_TYPE_DEL_PERSON_INVOICE);
        return list;
    }

    protected static final List<String> OPERATE_LIST_DEDUCTION() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add(OPERATE_TYPE_READY_SELECT);
        list.add(OPERATE_TYPE_SELECT);
        list.add(OPERATE_TYPE_UNSELECT);
        list.add(OPERATE_TYPE_EXPORT);
        list.add(OPERATE_TYPE_EXCEL_SELECT);
        return list;
    }

    protected static final List<String> OPERATE_LIST_TAXDEDUCTION() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add(OPERATE_TYPE_READY_SELECT);
        list.add(OPERATE_TYPE_TAX_SELECT);
        list.add(OPERATE_TYPE_TAX_UNSELECT);
        list.add(OPERATE_TYPE_GENERATE_VOUCHER);
        list.add(OPERATE_TYPE_EXPORT);
        return list;
    }

    protected static final List<String> OPERATE_LIST_ARGIC_HANDLE() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add(OPERATE_TYPE_AGRIC_HANDLE);
        list.add(OPERATE_TYPE_EXPORT);
        return list;
    }

    protected static final List<String> OPERATE_LIST_CURRENT_PERIOD() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(OPERATE_TYPE_GENERATE_VOUCHER);
        list.add(OPERATE_TYPE_EXPORT);
        return list;
    }

    protected static final List<String> OPERATE_LIST_DEFAULT() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(OPERATE_TYPE_EXPORT);
        return list;
    }

    public void operate() {
    }

    public void operate(ListSelectedRow listSelectedRow) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
    }

    public void afterUpload(UploadEvent evt) {
    }

    public static void addToolItems(String queryType, String invoiceType, Toolbar toolbar) {
        long start = System.currentTimeMillis();
        List<String> items = InvoiceOperateService.getToolItems(queryType, invoiceType);
        if (items != null) {
            List<Map<String, Object>> itemConfigList = InvoiceOperateService.getToolItemsConfig(queryType, invoiceType);
            items = InvoiceOperateService.sortTollItems(items, itemConfigList);
            Map<String, BarItemAp> itemApMap = InvoiceOperateService.createBarItemAp(queryType, invoiceType, items);
            ArrayList<Map> list = new ArrayList<Map>(items.size());
            HashSet<String> set = new HashSet<String>();
            for (String item : items) {
                BarItemAp ap;
                String group = InvoiceOperateService.getItemGroup(item);
                if (group == null || !set.add(group) || (ap = itemApMap.get(group)) == null) continue;
                list.add(ap.createControl());
            }
            toolbar.addControls(list);
        }
        logger.info("addToolItems:" + (System.currentTimeMillis() - start));
    }

    private static Map<String, BarItemAp> createBarItemAp(String queryType, String invoiceType, List<String> items) {
        HashMap<String, BarItemAp> result = new HashMap<String, BarItemAp>(items.size());
        ArrayList<BarItemAp> list = new ArrayList<BarItemAp>(items.size());
        BarItemAp importItemAp = null;
        BarItemAp orgItemAp = null;
        BarItemAp signItemAp = null;
        int singBtnSize = 0;
        for (String item : items) {
            DropdownItem downItem;
            BarItemAp exportItemAp;
            if (OPERATE_TYPE_EXPORT.equals(item)) {
                exportItemAp = InvoiceOperateService.createExportBarItemAp(queryType, invoiceType);
                if (exportItemAp == null) continue;
                list.add(exportItemAp);
                continue;
            }
            if (OPERATE_TYPE_READY_SELECT.equals(item)) {
                BarItemAp readySelectBarItemAp = InvoiceOperateService.createReadySelectBarItemAp();
                list.add(readySelectBarItemAp);
                continue;
            }
            if (OPERATE_TYPE_EXCEL_SELECT.equals(item)) {
                exportItemAp = InvoiceOperateService.createExcelSelectBarItemAp(queryType, invoiceType);
                list.add(exportItemAp);
                continue;
            }
            if (OPERATE_TYPE_EXCEL_SELECT_DOWN.equals(item) || OPERATE_TYPE_EXCEL_SELECT_RESULT.equals(item)) {
                if (importItemAp == null) {
                    importItemAp = InvoiceOperateService.createBarItemAp(item, null, new LocaleString(InvoiceOperateService.getItemName(item)));
                }
                downItem = new DropdownItem(item, InvoiceOperateService.getItemName(item), " ", " ", " ");
                downItem.setIsSwitch(true);
                importItemAp.getDropdownItems().add(downItem);
                continue;
            }
            if (OPERATE_TYPE_DOWNLOAD.equals(item)) {
                BarItemAp downItemAp = InvoiceOperateService.createDownInvoiceFileBarItemAp(queryType, invoiceType);
                list.add(downItemAp);
                continue;
            }
            if (!InvoiceOperateService.checkPermission(item) || OPERATE_TYPE_INVOICE_DETAIL.equals(item) && !"0".equals(invoiceType) && !Arrays.asList(InputInvoiceTypeEnum.getDetialType()).contains(InputInvoiceTypeEnum.getInvoiceType((String)invoiceType))) continue;
            if (OPERATE_TYPE_CHANGE_ROG.equals(item) || OPERATE_TYPE_CHANGE_TAXROG.equals(item)) {
                if (orgItemAp == null) {
                    orgItemAp = new BarItemAp();
                    orgItemAp.setKey(InvoiceOperateService.getItemGroup(item));
                    orgItemAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u62a4\u7ec4\u7ec7\u4fe1\u606f", (String)"InvoiceOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                downItem = new DropdownItem(item, InvoiceOperateService.getItemName(item), " ", " ", " ");
                downItem.setIsSwitch(true);
                orgItemAp.getDropdownItems().add(downItem);
                continue;
            }
            if (OPERATE_DOWNLOAD_TEMPLATE.equals(item) || OPERATE_IMPORT_RESULT.equals(item)) {
                if (importItemAp == null) {
                    importItemAp = InvoiceOperateService.createBarItemAp(OPERATE_IMPORT_ITEM, OPERATE_IMPORT_INVOICE, new LocaleString(InvoiceOperateService.getItemName(OPERATE_IMPORT_INVOICE)));
                    importItemAp.setUploadable(true);
                }
                downItem = new DropdownItem(item, InvoiceOperateService.getItemName(item), " ", " ", " ");
                downItem.setIsSwitch(true);
                importItemAp.getDropdownItems().add(downItem);
                continue;
            }
            if (OPERATE_TYPE_INVOICE_SIGN.equals(item) || OPERATE_TYPE_INVOICE_UNSIGN.equals(item)) {
                ++singBtnSize;
                if (signItemAp == null) {
                    signItemAp = InvoiceOperateService.createBarItemAp(item, null, new LocaleString(InvoiceOperateService.getItemName(item)));
                }
                if (singBtnSize <= 1) continue;
                signItemAp.setOperationKey(OPERATE_TYPE_INVOICE_SIGN);
                downItem = new DropdownItem(OPERATE_TYPE_INVOICE_UNSIGN, InvoiceOperateService.getItemName(OPERATE_TYPE_INVOICE_UNSIGN), " ", " ", " ");
                downItem.setIsSwitch(true);
                signItemAp.getDropdownItems().add(downItem);
                continue;
            }
            if (OPERATE_TYPE_GENERATE_VOUCHER.equals(item)) {
                list.add(InvoiceOperateService.createVouchItem());
                continue;
            }
            list.add(InvoiceOperateService.createBarItemAp(item, InvoiceOperateService.getOperationKey(item), new LocaleString(InvoiceOperateService.getItemName(item))));
        }
        if (importItemAp != null) {
            list.add(importItemAp);
        }
        if (orgItemAp != null) {
            list.add(orgItemAp);
        }
        if (signItemAp != null) {
            list.add(signItemAp);
        }
        for (BarItemAp ap : list) {
            result.put(ap.getKey(), ap);
        }
        return result;
    }

    private static BarItemAp createReadySelectBarItemAp() {
        BarItemAp exportItemAp = new BarItemAp();
        exportItemAp.setKey(OPERATE_TYPE_READY_SELECT);
        exportItemAp.setOperationStyle(Integer.valueOf(1));
        exportItemAp.setName(new LocaleString(InvoiceOperateService.getItemName(OPERATE_TYPE_READY_SELECT)));
        DropdownItem cancelItem = new DropdownItem(OPERATE_TYPE_READY_SELECT_CANCEL, InvoiceOperateService.getItemName(OPERATE_TYPE_READY_SELECT_CANCEL), " ", " ", " ");
        cancelItem.setIsSwitch(true);
        exportItemAp.getDropdownItems().add(cancelItem);
        return exportItemAp;
    }

    private static List<String> sortTollItems(List<String> items, List<Map<String, Object>> configItemList) {
        if (configItemList == null || configItemList.isEmpty()) {
            return items;
        }
        ArrayList<String> newitems = new ArrayList<String>(items.size());
        ArrayList<String> hideItmes = new ArrayList<String>(items.size());
        for (Map<String, Object> entry : configItemList) {
            String itemKey = (String)entry.get("itemkey");
            if (Boolean.TRUE.equals(entry.get("show"))) {
                newitems.add(itemKey);
                continue;
            }
            hideItmes.add(itemKey);
        }
        for (String item : items) {
            if (newitems.contains(item) || hideItmes.contains(item)) continue;
            newitems.add(item);
        }
        return newitems;
    }

    public static List<String> getToolItems(String queryType, String invoiceType) {
        return InvoiceOperateService.getToolItemsDefault(queryType, invoiceType);
    }

    private static List<Map<String, Object>> getToolItemsConfig(String queryType, String invoiceType) {
        QFilter filter1 = new QFilter("configtype", "=", (Object)"1");
        QFilter filter2 = new QFilter("billstatus", "=", (Object)"B");
        QFilter filter3 = new QFilter("querytype", "=", (Object)queryType);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_query_config", (String)"entryentity.itemkey as itemkey,entryentity.itemname as itemname,entryentity.show as show,entryentity.seq as seq", (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"entryentity.seq");
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>(collect.size());
        for (DynamicObject obj : collect) {
            String itemkey = obj.getString("itemkey");
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)itemkey)) continue;
            String itemname = obj.getString("itemname");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemname)) {
                itemname = InvoiceOperateService.getItemName(itemkey);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemname)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("itemname", itemname);
            map.put("itemkey", itemkey);
            map.put("seq", obj.getInt("seq"));
            map.put("show", obj.getBoolean("show"));
            resultMap.add(map);
        }
        return resultMap;
    }

    private static List<String> getToolItemsDefault(String queryType, String invoiceType) {
        List<String> items = null;
        if ("ticket_pool".equals(queryType)) {
            items = InvoiceOperateService.OPERATE_LIST_TICKETPOOL();
            Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
            if (InputInvoiceTypeEnum.canTransportDeduction((Long)type).booleanValue() || InputInvoiceTypeEnum.canDeduction((Long)type).booleanValue() || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(type)) {
                items.add(OPERATE_TYPE_MODIFY_DEDUCTION_FLAG);
            }
        } else if ("person_ticket".equals(queryType)) {
            items = InvoiceOperateService.OPERATE_LIST_PERSON_TICKET();
        } else if ("deduction".equals(queryType) || "undeduction".equals(queryType) || "drawback".equals(queryType) || "readyselect_deduction".equals(queryType) || "readyselect_undeduction".equals(queryType)) {
            items = InvoiceOperateService.OPERATE_LIST_DEDUCTION();
            if ("drawback".equals(queryType) || String.valueOf(InputInvoiceTypeEnum.WITHHOLDING.getCode()).equals(invoiceType)) {
                items.remove(OPERATE_TYPE_EXCEL_SELECT);
            }
            if ("readyselect_deduction".equals(queryType) || "readyselect_undeduction".equals(queryType) || "drawback".equals(queryType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType))) {
                items.remove(OPERATE_TYPE_READY_SELECT);
            }
        } else if ("taxdeduction".equals(queryType) || "readyselect_taxdeduction".equals(queryType)) {
            items = InvoiceOperateService.OPERATE_LIST_TAXDEDUCTION();
            if ("readyselect_taxdeduction".equals(queryType)) {
                items.remove(OPERATE_TYPE_READY_SELECT);
            }
        } else {
            items = "current_period".equals(queryType) ? InvoiceOperateService.OPERATE_LIST_CURRENT_PERIOD() : ("agric_handle_selfproduced".equals(queryType) || "agric_handle_smallscale_special".equals(queryType) ? InvoiceOperateService.OPERATE_LIST_ARGIC_HANDLE() : ("recorded".equals(queryType) ? InvoiceOperateService.OPERATE_LIST_TAX_RECORDED() : InvoiceOperateService.OPERATE_LIST_DEFAULT()));
        }
        items.add("refresh");
        items.add("close");
        return items;
    }

    private static List<String> OPERATE_LIST_TAX_RECORDED() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add(OPERATE_TYPE_RECORDED_COMMIT);
        list.add(OPERATE_TYPE_RECORDED_UPDATE);
        list.add(OPERATE_TYPE_RECORDED_REVOKE);
        list.add(OPERATE_TYPE_RECORDED_PURPOSE);
        list.add(OPERATE_TYPE_RECORDED_TIME);
        return list;
    }

    private static BarItemAp createBarItemAp(String item, String operationKey, LocaleString itemName) {
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey(item);
        barItemAp.setName(itemName);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)operationKey)) {
            barItemAp.setOperationKey(operationKey);
        }
        return barItemAp;
    }

    private static BarItemAp createExportBarItemAp(String queryType, String invoiceType) {
        RequestContext request;
        int checkPerm;
        String typeEntity = InputInvoiceTypeEnum.getEntity((Long)BigDecimalUtil.transDecimal((Object)invoiceType).longValue());
        Boolean hasItem = Boolean.FALSE;
        if ("rim_inv_ordinary".equals(typeEntity) || "rim_inv_special".equals(typeEntity) || "rim_inv_toll".equals(typeEntity) || "rim_inv_electric".equals(typeEntity)) {
            hasItem = Boolean.TRUE;
        }
        if ((checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong((request = RequestContext.get()).getUserId()), (Long)request.getOrgId(), (String)"rim", (String)"rim_invoice", (String)"4730fc9f000004ae")) > 0) {
            DropdownItem downItem;
            BarItemAp exportItemAp = new BarItemAp();
            exportItemAp.setKey(OPERATE_TYPE_EXPORT);
            exportItemAp.setOperationKey(OPERATE_TYPE_EXPORT);
            exportItemAp.setName(new LocaleString(InvoiceOperateService.getItemName(OPERATE_TYPE_EXPORT)));
            if (hasItem.booleanValue()) {
                downItem = new DropdownItem(OPERATE_TYPE_EXPORT_HEAD, InvoiceOperateService.getItemName(OPERATE_TYPE_EXPORT_HEAD), " ", OPERATE_TYPE_EXPORT_HEAD, " ");
                downItem.setIsSwitch(true);
                exportItemAp.getDropdownItems().add(downItem);
            }
            downItem = new DropdownItem(OPERATE_TYPE_EXPORT_CONFIG, InvoiceOperateService.getItemName(OPERATE_TYPE_EXPORT_CONFIG), " ", " ", " ");
            downItem.setIsSwitch(true);
            exportItemAp.getDropdownItems().add(downItem);
            return exportItemAp;
        }
        checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(request.getUserId()), (Long)request.getOrgId(), (String)"rim", (String)"rim_invoice", (String)"29ROM/MNM/2K");
        if (checkPerm > 0) {
            String operkey = OPERATE_TYPE_EXPORT;
            if (hasItem.booleanValue()) {
                operkey = OPERATE_TYPE_EXPORT_HEAD;
            }
            BarItemAp exportItemAp = new BarItemAp();
            exportItemAp.setKey(operkey);
            exportItemAp.setOperationKey(operkey);
            exportItemAp.setName(new LocaleString(InvoiceOperateService.getItemName(operkey)));
            DropdownItem downItem = new DropdownItem(OPERATE_TYPE_EXPORT_CONFIG, InvoiceOperateService.getItemName(OPERATE_TYPE_EXPORT_CONFIG), " ", " ", " ");
            downItem.setIsSwitch(true);
            exportItemAp.getDropdownItems().add(downItem);
            return exportItemAp;
        }
        return null;
    }

    private static BarItemAp createExcelSelectBarItemAp(String queryType, String invoiceType) {
        BarItemAp exportItemAp = new BarItemAp();
        exportItemAp.setKey(OPERATE_TYPE_EXCEL_SELECT);
        exportItemAp.setOperationStyle(Integer.valueOf(1));
        exportItemAp.setName(new LocaleString(InvoiceOperateService.getItemName(OPERATE_TYPE_EXCEL_SELECT)));
        exportItemAp.setUploadable(true);
        DropdownItem downItem = new DropdownItem(OPERATE_TYPE_EXCEL_SELECT_DOWN, InvoiceOperateService.getItemName(OPERATE_TYPE_EXCEL_SELECT_DOWN), " ", " ", " ");
        downItem.setIsSwitch(true);
        exportItemAp.getDropdownItems().add(downItem);
        DropdownItem downItem2 = new DropdownItem(OPERATE_TYPE_EXCEL_SELECT_RESULT, InvoiceOperateService.getItemName(OPERATE_TYPE_EXCEL_SELECT_RESULT), " ", " ", " ");
        downItem2.setIsSwitch(true);
        exportItemAp.getDropdownItems().add(downItem2);
        return exportItemAp;
    }

    private static BarItemAp createDownInvoiceFileBarItemAp(String queryType, String invoiceType) {
        BarItemAp exportItemAp = new BarItemAp();
        exportItemAp.setKey(OPERATE_TYPE_DOWNLOAD);
        exportItemAp.setOperationStyle(Integer.valueOf(1));
        exportItemAp.setOperationKey(OPERATE_TYPE_DOWNLOAD);
        exportItemAp.setName(new LocaleString(InvoiceOperateService.getItemName(OPERATE_TYPE_DOWNLOAD)));
        DropdownItem downItem = new DropdownItem(OPERATE_TYPE_DOWNLOAD_XML, InvoiceOperateService.getItemName(OPERATE_TYPE_DOWNLOAD_XML), " ", OPERATE_TYPE_DOWNLOAD_XML, " ");
        downItem.setIsSwitch(true);
        exportItemAp.getDropdownItems().add(downItem);
        DropdownItem downItem2 = new DropdownItem(OPERATE_TYPE_DOWNLOAD_INV_ATTACH, InvoiceOperateService.getItemName(OPERATE_TYPE_DOWNLOAD_INV_ATTACH), " ", " ", " ");
        downItem2.setIsSwitch(true);
        exportItemAp.getDropdownItems().add(downItem2);
        return exportItemAp;
    }

    private static BarItemAp createVouchItem() {
        BarItemAp orgItemAp = new BarItemAp();
        orgItemAp.setKey(OPERATE_TYPE_GENERATE_VOUCHER);
        orgItemAp.setName(new LocaleString(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"InvoiceOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        orgItemAp.setOperationKey(OPERATE_TYPE_GENERATE_VOUCHER);
        DropdownItem downItem = new DropdownItem("previewvoucher", ResManager.loadKDString((String)"\u9884\u89c8\u51ed\u8bc1", (String)"InvoiceOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), " ", "previewvoucher", " ");
        downItem.setIsSwitch(true);
        orgItemAp.getDropdownItems().add(downItem);
        downItem = new DropdownItem("tracevoucher", ResManager.loadKDString((String)"\u8054\u67e5\u51ed\u8bc1", (String)"InvoiceOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), " ", "tracevoucher", " ");
        downItem.setIsSwitch(true);
        orgItemAp.getDropdownItems().add(downItem);
        downItem = new DropdownItem("deletevoucher", ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"InvoiceOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), " ", "deletevoucher", " ");
        downItem.setIsSwitch(true);
        orgItemAp.getDropdownItems().add(downItem);
        return orgItemAp;
    }

    public static String getItemName(String item) {
        switch (item) {
            case "add_expense": {
                return ResManager.loadKDString((String)"\u7ef4\u62a4\u62a5\u9500\u72b6\u6001", (String)"InvoiceOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "add_vouch": {
                return ResManager.loadKDString((String)"\u7ef4\u62a4\u5165\u8d26\u4fe1\u606f", (String)"InvoiceOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "export": {
                return ResManager.loadKDString((String)"\u5bfc\u51fa\u53d1\u7968", (String)"InvoiceOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "export_head": {
                return ResManager.loadKDString((String)"\u4e0d\u542b\u660e\u7ec6\u5bfc\u51fa", (String)"InvoiceOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "invoice_sign": {
                return ResManager.loadKDString((String)"\u53d1\u7968\u7b7e\u6536", (String)"InvoiceOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "invoice_unsign": {
                return ResManager.loadKDString((String)"\u53d1\u7968\u53cd\u7b7e\u6536", (String)"InvoiceOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "delete_invoice": {
                return ResManager.loadKDString((String)"\u5220\u9664", (String)"InvoiceOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "change_org": {
                return ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"InvoiceOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "change_taxorg": {
                return ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"InvoiceOperateService_15", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "generatevoucher": {
                return ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"InvoiceOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "deduction_select": {
                return ResManager.loadKDString((String)"\u53d1\u7968\u52fe\u9009", (String)"InvoiceOperateService_16", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "deduction_unselect": {
                return ResManager.loadKDString((String)"\u64a4\u9500\u52fe\u9009", (String)"InvoiceOperateService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "deduction_tax": {
                return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u7a0e\u989d\u62b5\u6263", (String)"InvoiceOperateService_18", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "undeduction_tax": {
                return ResManager.loadKDString((String)"\u64a4\u9500\u65c5\u5ba2\u8fd0\u8f93\u7a0e\u989d\u62b5\u6263", (String)"InvoiceOperateService_19", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "download_invoice": {
                return ResManager.loadKDString((String)"\u5bfc\u51fa\u53d1\u7968\u6587\u4ef6", (String)"InvoiceOperateService_20", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "download_xml": {
                return ResManager.loadKDString((String)"\u5bfc\u51fa\u7a0e\u5c40\u6570\u7535\u7968\u6e90\u6587\u4ef6", (String)"InvoiceOperateService_28", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "download_inv_attach": {
                return ResManager.loadKDString((String)"\u5bfc\u51fa\u53d1\u7968\u53ca\u5173\u8054\u9644\u4ef6\u6587\u4ef6", (String)"InvoiceOperateService_42", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "download_template": {
                return ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f\u4e0b\u8f7d", (String)"InvoiceOperateService_21", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "import_invoice": {
                return ResManager.loadKDString((String)"\u5f15\u5165\u53d1\u7968", (String)"InvoiceOperateService_22", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "import_result": {
                return ResManager.loadKDString((String)"\u67e5\u770b\u5f15\u5165\u7ed3\u679c", (String)"InvoiceOperateService_23", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "export_config": {
                return ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bfc\u51fa\u6a21\u677f", (String)"InvoiceOperateService_24", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "invoice_detail": {
                return ResManager.loadKDString((String)"\u67e5\u770b\u53d1\u7968\u660e\u7ec6", (String)"InvoiceOperateService_25", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "invoice_tag": {
                return ResManager.loadKDString((String)"\u7ef4\u62a4\u6807\u6ce8", (String)"InvoiceOperateService_26", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "excel_select": {
                return ResManager.loadKDString((String)"\u5f15\u5165\u6e05\u5355\u52fe\u9009", (String)"InvoiceOperateService_27", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "excel_select_upload": {
                return ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f\u4e0b\u8f7d", (String)"InvoiceOperateService_21", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "excel_select_result": {
                return ResManager.loadKDString((String)"\u67e5\u770b\u5f15\u5165\u7ed3\u679c", (String)"InvoiceOperateService_23", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "collect_invoice": {
                return ResManager.loadKDString((String)"\u53d1\u7968\u91c7\u96c6", (String)"InvoiceOperateService_30", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "relay_invoice": {
                return ResManager.loadKDString((String)"\u53d1\u7968\u6307\u6d3e", (String)"InvoiceOperateService_31", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "invoice_check": {
                return ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u9a8c", (String)"InvoiceOperateService_33", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "recorded_commit": {
                return ResManager.loadKDString((String)"\u63d0\u4ea4\u5165\u8d26", (String)"InvoiceOperateService_36", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "recorded_update": {
                return ResManager.loadKDString((String)"\u5165\u8d26\u66f4\u65b0", (String)"InvoiceOperateService_40", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "recorded_revoke": {
                return ResManager.loadKDString((String)"\u64a4\u9500\u5165\u8d26", (String)"InvoiceOperateService_37", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "maintain_recorded_purpose": {
                return ResManager.loadKDString((String)"\u7ef4\u62a4\u5165\u8d26\u7528\u9014", (String)"InvoiceOperateService_38", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "maintain_recorded_time": {
                return ResManager.loadKDString((String)"\u7ef4\u62a4\u5165\u8d26\u65f6\u95f4", (String)"InvoiceOperateService_39", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "delete_person_invoice": {
                return ResManager.loadKDString((String)"\u5220\u9664", (String)"InvoiceOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "update_vouch": {
                return ResManager.loadKDString((String)"\u66f4\u65b0\u51ed\u8bc1\u4fe1\u606f", (String)"InvoiceOperateService_41", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "class_invoice": {
                return ResManager.loadKDString((String)"\u7ef4\u62a4\u6807\u7b7e", (String)"InvoiceOperateService_32", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "refresh": {
                return ResManager.loadKDString((String)"\u5237\u65b0", (String)"InvoiceOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "close": {
                return ResManager.loadKDString((String)"\u9000\u51fa", (String)"InvoiceOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "down_tax_file": {
                return ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u5c40\u6e90\u6587\u4ef6", (String)"InvoiceOperateService_34", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "agric_handle": {
                return ResManager.loadKDString((String)"\u4e0a\u4f20\u786e\u8ba4", (String)"InvoiceOperateService_35", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "modify_deduction_flag": {
                return ResManager.loadKDString((String)"\u4fee\u6539\u662f\u5426\u53ef\u62b5\u6263", (String)"InvoiceOperateService_43", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "deduction_ready_select": {
                return ResManager.loadKDString((String)"\u9884\u52fe\u9009", (String)"InvoiceOperateService_44", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            case "deduction_ready_select_cancel": {
                return ResManager.loadKDString((String)"\u64a4\u9500\u9884\u52fe\u9009", (String)"InvoiceOperateService_45", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private static String getItemGroup(String item) {
        if (OPERATE_TYPE_CHANGE_ROG.equals(item) || OPERATE_TYPE_CHANGE_TAXROG.equals(item)) {
            return "item_org";
        }
        if (OPERATE_DOWNLOAD_TEMPLATE.equals(item) || OPERATE_IMPORT_RESULT.equals(item)) {
            return OPERATE_IMPORT_ITEM;
        }
        return item;
    }

    private static String getOperationKey(String item) {
        switch (item) {
            case "refresh": {
                return "refresh";
            }
            case "close": {
                return "close";
            }
        }
        return "";
    }

    public boolean checkPermission() {
        return InvoiceOperateService.checkPermission(this.type);
    }

    public static boolean checkPermission(String type) {
        RequestContext request = RequestContext.get();
        String permItem = null;
        if (OPERATE_TYPE_EXPENSE.equals(type)) {
            permItem = "1VXP2FHHEP00";
        } else if (OPERATE_TYPE_DELETE.equals(type)) {
            permItem = "4715e1f1000000ac";
        } else if (OPERATE_TYPE_VOUCH.equals(type)) {
            permItem = "1VXP5307OTUT";
        } else if (OPERATE_TYPE_INVOICE_SIGN.equals(type)) {
            permItem = "1VXP9=N6T3O6";
        } else if (OPERATE_TYPE_INVOICE_UNSIGN.equals(type)) {
            permItem = "2633TNGWR5RK";
        } else if (OPERATE_TYPE_EXPORT.equals(type)) {
            permItem = "4730fc9f000004ae";
        } else if (OPERATE_TYPE_EXPORT_HEAD.equals(type)) {
            permItem = "4730fc9f000004ae,29ROM/MNM/2K";
        } else if (OPERATE_TYPE_CHANGE_TAXROG.equals(type) || OPERATE_TYPE_CHANGE_ROG.equals(type)) {
            permItem = "1VXP/DD9OOIH";
        } else if (OPERATE_DOWNLOAD_TEMPLATE.equals(type) || OPERATE_IMPORT_RESULT.equals(type)) {
            permItem = "251PPI92VIL5";
        } else if (OPERATE_TYPE_DOWNLOAD.equals(type)) {
            permItem = "23+Y3P5F6LEE";
        } else if (OPERATE_TYPE_DOWNLOAD_XML.equals(type)) {
            permItem = "4XIC9/G1M+EX";
        } else if (OPERATE_TYPE_DOWNLOAD_INV_ATTACH.equals(type)) {
            permItem = "4XIC=U3/INF=";
        } else if (OPERATE_TYPE_SELECT.equals(type)) {
            permItem = "23/JY+G53AJ7";
        } else if (OPERATE_TYPE_GENERATE_VOUCHER.equals(type)) {
            permItem = "/LRTO/JV2TYZ";
        } else if (OPERATE_TYPE_UNSELECT.equals(type)) {
            permItem = "23/K1GA7A6R+";
        } else if (OPERATE_TYPE_TAX_SELECT.equals(type)) {
            permItem = "1JF99PN24IWY";
        } else if (OPERATE_TYPE_RECORDED_COMMIT.equals(type)) {
            permItem = "4=GX4UAPWE=I";
        } else if (OPERATE_TYPE_RECORDED_UPDATE.equals(type)) {
            permItem = "4D4IQNPGQ6XP";
        } else if (OPERATE_TYPE_RECORDED_REVOKE.equals(type)) {
            permItem = "4=GX84IW7SXY";
        } else if (OPERATE_TYPE_TAX_UNSELECT.equals(type)) {
            permItem = "23/K8T1S32++";
        } else if (OPERATE_TYPE_EXCEL_SELECT.equals(type) || OPERATE_TYPE_EXCEL_SELECT_DOWN.equals(type) || OPERATE_TYPE_EXCEL_SELECT_RESULT.equals(type)) {
            permItem = "3A9CRV=AEPBN";
        } else if (OPERATE_TYPE_DOWN_TAX_FILE.equals(type)) {
            permItem = "48EKVCB5B1WR";
        } else if (OPERATE_TYPE_AGRIC_HANDLE.equals(type)) {
            permItem = "49YMZ5ZV1DE4";
        } else if (OPERATE_TYPE_UPDATE_VOUCH.equals(type)) {
            permItem = "4T7SBWHC4U2E";
        } else if (OPERATE_TYPE_CLASS_INVOICE.equals(type)) {
            permItem = "4XHZEMD6GM0=";
        } else if (OPERATE_TYPE_RELAY_INVOICE.equals(type)) {
            permItem = "4XHZN0MRD2RI";
        } else if (OPERATE_TYPE_INVOICE_DETAIL.equals(type)) {
            permItem = "4XI+2KABPSE7";
        } else if (OPERATE_TYPE_INVOICE_TAG.equals(type)) {
            permItem = "4XI+65QZEGGD";
        } else if (OPERATE_TYPE_MODIFY_DEDUCTION_FLAG.equals(type)) {
            permItem = "5+TZXBF5CCH4";
        } else if (OPERATE_TYPE_READY_SELECT.equals(type)) {
            permItem = "50Z1/KVT6ROE";
        } else if (OPERATE_TYPE_READY_SELECT_CANCEL.equals(type)) {
            permItem = "23/6B4TR10C8";
        }
        if (permItem != null) {
            if (permItem.indexOf(44) > 0) {
                String[] pers;
                for (String per : pers = permItem.split(",")) {
                    int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(request.getUserId()), (Long)request.getOrgId(), (String)"rim", (String)"rim_invoice", (String)per);
                    if (checkPerm <= 0) continue;
                    return true;
                }
                return false;
            }
            int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(request.getUserId()), (Long)request.getOrgId(), (String)"rim", (String)"rim_invoice", (String)permItem);
            return checkPerm > 0;
        }
        return true;
    }

    public void afterLoginDoOperation(String dkType, String taxNo, JSONObject configObj, String failMsg) {
    }

    public static List<Long> getF7InvoiceTypes(String queryType, String invoiceType) {
        Long invoicetypeLong;
        ArrayList invoiceTypes = Lists.newArrayList();
        Long l = invoicetypeLong = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoiceType) ? Long.valueOf(invoiceType + "") : null;
        if (invoicetypeLong != null && invoicetypeLong > 0L) {
            invoiceTypes.add(invoicetypeLong);
            return invoiceTypes;
        }
        if ("recorded".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getTaxRecordedTypes()));
        } else if ("deduction".equals(queryType) || "undeduction".equals(queryType) || "readyselect_deduction".equals(queryType) || "readyselect_undeduction".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getVatDeductionTypes()));
            invoiceTypes.add(InputInvoiceTypeEnum.ORDINARY_PAPER.getCode());
            invoiceTypes.add(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
            invoiceTypes.add(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode());
        } else if ("drawback".equals(queryType) || "drawback_period".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getVatDrawbackTypes()));
        } else if ("taxdeduction".equals(queryType) || "readyselect_taxdeduction".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getTransportTypes()));
        } else if ("current_period".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getDeductionAllTypes()));
        } else if ("agric_handle_selfproduced".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getSelfproducedAgricType()));
        } else if ("agric_handle_smallscale_special".equals(queryType)) {
            invoiceTypes.addAll(Arrays.asList(InputInvoiceTypeEnum.getSmallScaleSpecialType()));
        }
        return invoiceTypes;
    }

    public static boolean isSyncDown(String taxNo) {
        Map downSyncMap = ImcConfigUtil.getValue((String)"rim_etax_select_syn");
        if (ObjectUtils.isEmpty((Object)downSyncMap) || ObjectUtils.isEmpty((Object)taxNo)) {
            return false;
        }
        String allAsync = (String)downSyncMap.get("all_taxno");
        String taxNoAsync = (String)downSyncMap.get(taxNo);
        String batchTaxNos = (String)downSyncMap.get("taxnos");
        return StringUtils.contains((CharSequence)batchTaxNos, (CharSequence)taxNo) || "1".equals(allAsync) || "1".equals(taxNoAsync);
    }
}

