/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.model.SelectLog;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.query.operate.DeductionLoginOperateService;

public class BatchDeductLoginOperateService
extends DeductionLoginOperateService {
    private static Log LOGGER = LogFactory.getLog(BatchDeductLoginOperateService.class);

    public BatchDeductLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        super(type, currentOrgId, plugin);
    }

    public BatchDeductLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        super(type, currentOrgId, plugin, consumer);
    }

    @Override
    public void afterLoginDoOperation(String dkType, String taxNo, JSONObject configObj, String failMsg) {
        LOGGER.info("\u6279\u91cf\u751f\u6210\u7edf\u8ba1\u8868:{}-\u7a0e\u5c40\u901a\u9053{}", (Object)taxNo, (Object)dkType);
        try (DLock dLock = LockUtils.createDLockByMd5((String)("batch_deduct_" + taxNo), (String)"batch_deduct_lock");){
            if (dLock.tryLock()) {
                String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
                JSONObject statisticData = new JSONObject();
                Long orgId = configObj.getLong("taxpayer_org");
                if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
                    this.insertLog(batchNo, taxNo, orgId, failMsg, statisticData);
                    return;
                }
                if ("3".equals(dkType) || "5".equals(dkType)) {
                    failMsg = ResManager.loadKDString((String)"\u822a\u4fe1\u63a5\u53e3\u662f\u5f02\u6b65\u64cd\u4f5c,\u65e0\u6cd5\u6279\u91cf\u64cd\u4f5c", (String)"BatchDeductLoginOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    this.insertLog(batchNo, taxNo, orgId, failMsg, statisticData);
                    return;
                }
                DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)orgId);
                JSONObject param = new JSONObject();
                param.put("taxNo", (Object)taxNo);
                param.put("batchNo", (Object)batchNo);
                String taxPeriod = "";
                JSONObject statisticTable = deductService.getStatisticTable(param);
                String createTjbbStatus = "";
                if (!ResultContant.isSuccess((JSONObject)statisticTable).booleanValue()) {
                    failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"BatchDeductLoginOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), statisticTable.getString("description"));
                    this.insertLog(batchNo, taxNo, orgId, failMsg, statisticData);
                    return;
                }
                statisticData = statisticTable.getJSONObject("data");
                createTjbbStatus = statisticData.getString("createTjbbStatus");
                taxPeriod = statisticData.getString("taxPeriod");
                if (StatisticsStatusEnum.UN_CREATE.getCode().equals(createTjbbStatus)) {
                    param.put("requestId", (Object)UUID.randomUUID());
                    statisticTable = deductService.createStatisticTable(param);
                    if (ResultContant.isSuccess((JSONObject)statisticTable).booleanValue()) {
                        statisticData = statisticTable.getJSONObject("data");
                        createTjbbStatus = statisticData.getString("createTjbbStatus");
                        taxPeriod = statisticData.getString("taxPeriod");
                    } else {
                        failMsg = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"BatchDeductLoginOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), statisticTable.getString("description"));
                        this.insertLog(batchNo, taxNo, orgId, failMsg, statisticData);
                        return;
                    }
                }
                if (StatisticsStatusEnum.CREATED_CONFIRM.getCode().equals(createTjbbStatus)) {
                    param.put("requestId", (Object)UUID.randomUUID());
                    String confirmSecret = configObj.getString("confirm_secret");
                    param.put("password", (Object)confirmSecret);
                    param.put("confirmSecret", (Object)confirmSecret);
                    statisticTable = deductService.confirmStatisticTable(param);
                    if (ResultContant.isSuccess((JSONObject)statisticTable).booleanValue()) {
                        statisticData.put("createTjbbStatus", (Object)StatisticsStatusEnum.CONFIRMED.getCode());
                        statisticData.put("updateTime", (Object)new Date());
                        if (StringUtils.isEmpty((CharSequence)taxPeriod)) {
                            taxPeriod = DeductionConstant.getSkssq((String)taxNo);
                        }
                        Date operateTime = statisticData.getDate("operateTime");
                        DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
                        deductInvoiceOperateService.updateAuthenticateFlag("2", taxNo, DateUtils.stringToDate((String)taxPeriod, (String)"yyyyMM"), operateTime, new String[]{"1", "2"});
                    } else {
                        failMsg = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u7b7e\u540d\u5931\u8d25:%1$s", (String)"BatchDeductLoginOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), statisticTable.getString("description"));
                    }
                } else {
                    failMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7edf\u8ba1\u8868\u72b6\u6001\u662f[%1$s]\uff0c\u4e0d\u80fd\u786e\u8ba4\u7b7e\u540d", (String)"BatchDeductLoginOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]), StatisticsStatusEnum.getNameByCode((String)createTjbbStatus));
                }
                this.insertLog(batchNo, taxNo, orgId, failMsg, statisticData);
            } else {
                LOGGER.info("\u6279\u91cf\u751f\u6210\u7edf\u8ba1\u8868:{}\u6b63\u5728\u5904\u7406\u4e2d", (Object)taxNo);
            }
        }
    }

    private void insertLog(String batchNo, String taxNo, Long orgId, String failMsg, JSONObject statisticData) {
        String skssq = statisticData.getString("taxPeriod");
        String status = statisticData.getString("createTjbbStatus");
        LOGGER.info("\u6279\u91cf\u62b5\u6263\u7ed3\u679c{}-{}-[{}]", new Object[]{taxNo, StringUtils.isEmpty((CharSequence)failMsg) ? "\u6210\u529f" : failMsg, status});
        SelectLog selectLog = new SelectLog();
        selectLog.setBatchNo(batchNo);
        selectLog.setDescription(failMsg);
        selectLog.setSelectType("6");
        selectLog.setOperateType("9");
        selectLog.setSelectOperaType("1");
        selectLog.setOrgId(orgId);
        selectLog.setTaxNo(taxNo);
        boolean success = StringUtils.isEmpty((CharSequence)failMsg) && StatisticsStatusEnum.CONFIRMED.getCode().equals(status);
        selectLog.setHandleStatus(success ? "1" : "2");
        selectLog.setSelectType("6");
        selectLog.setStatisticsStatus(status);
        selectLog.setResultJson(statisticData);
        Date taxPeriod = null;
        if (StringUtils.isNotEmpty((CharSequence)skssq)) {
            taxPeriod = DateUtils.stringToDate((String)skssq, (String)"yyyyMM");
            selectLog.setTaxPeriod(taxPeriod);
        }
        SelectAccountService.insertSelectLog((SelectLog)selectLog);
    }
}

