/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.query.operate.impl.ReapplyDownLoginOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReapplySelectLoginOperateService
extends ReapplyDownLoginOperateService {
    private static Log LOGGER = LogFactory.getLog(ReapplySelectLoginOperateService.class);

    public ReapplySelectLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        super(type, currentOrgId, plugin);
    }

    public ReapplySelectLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        super(type, currentOrgId, plugin, consumer);
    }

    @Override
    public void reapply(String taxNo, JSONArray selectLogArr) {
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)selectLogArr)) {
            LOGGER.info("\u540c\u6b65\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a");
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u540c\u6b65\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a", (String)"ReapplySelectLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), selectLogArr, 0);
            return;
        }
        Set batchNOSet = selectLogArr.toJavaList(JSONObject.class).stream().map(t -> t.getString("batch_no")).collect(Collectors.toSet());
        QFilter filter = new QFilter("batch_no", "in", batchNOSet);
        QFilter sselectResultfilter = new QFilter("select_result", "not in", (Object)"1");
        DynamicObjectCollection selectAccountList = QueryServiceHelper.query((String)"rim_select_account", (String)"id,batch_no,serial_no,invoice_type,deduction_purpose,handle_status,select_result,select_time,pre_authenticate_flag,not_deductible_type,electronic_no", (QFilter[])new QFilter[]{filter, sselectResultfilter}, (String)"create_time asc");
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)selectAccountList)) {
            LOGGER.info("\u53f0\u8d26\u4fe1\u606f\u4e3a\u7a7a");
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u53f0\u8d26\u4fe1\u606f\u4e3a\u7a7a", (String)"ReapplySelectLoginOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), selectLogArr, 0);
            return;
        }
        Map<String, List<DynamicObject>> accountGroupMap = selectAccountList.stream().filter(s -> !kd.bos.orm.util.StringUtils.isEmpty((Object)s.getString("batch_no"))).collect(Collectors.groupingBy(s -> s.getString("batch_no")));
        for (int i = 0; i < selectLogArr.size(); ++i) {
            JSONObject selectLog = selectLogArr.getJSONObject(i);
            String batchNo = selectLog.getString("batch_no");
            String selectType = selectLog.getString("select_type");
            String operateType = selectLog.getString("operate_type");
            if (!accountGroupMap.containsKey(batchNo)) {
                JSONArray selectLogArrNew = new JSONArray(1);
                selectLogArrNew.add((Object)selectLog);
                this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u53f7\u4e0d\u5b58\u5728\u975e\u6210\u529f\u72b6\u6001\u7684\u53f0\u8d26\u6570\u636e", (String)"ReapplySelectLoginOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), selectLogArrNew, 0);
                continue;
            }
            this.startReapplyAccount(selectLog, accountGroupMap.get(batchNo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReapplyAccount(JSONObject selectLog, List<DynamicObject> dynamicObjects) {
        block21: {
            if (selectLog == null || kd.bos.orm.util.CollectionUtils.isEmpty(dynamicObjects)) {
                LOGGER.info("\u64cd\u4f5c\u65e5\u5fd7\u6216\u53f0\u8d26\u4fe1\u606f\u4e3a\u7a7a");
                this.setCacheTip("", ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7\u6216\u53f0\u8d26\u4fe1\u606f\u4e3a\u7a7a", (String)"ReapplySelectLoginOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), null, 0);
                return;
            }
            String batchNo = selectLog.getString("batch_no");
            String key = "rim.ReapplySelectLoginOperateService-" + batchNo;
            try (DLock lock = DLock.create((String)key, (String)"ReapplySelectLoginOperateService.lock");){
                if (!lock.tryLock()) break block21;
                try {
                    String taxNo = selectLog.getString("tax_no");
                    String selectType = selectLog.getString("select_type");
                    String operateType = selectLog.getString("operate_type");
                    String billType = selectLog.getString("bill_type");
                    JSONArray jsonArray = new JSONArray(1);
                    jsonArray.add((Object)selectLog);
                    if (InvoiceDownHelper.ALLOW_REAPPLY_SELECT_TYPE_GX.contains(selectType)) {
                        this.reapplySelect(selectLog, dynamicObjects);
                    } else if ("7".equals(selectType)) {
                        this.reapplyRecorded(selectLog, dynamicObjects);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u5931\u8d25:" + batchNo, (Throwable)e);
                    JSONArray selectLogArrNew = new JSONArray(1);
                    selectLogArrNew.add((Object)selectLog);
                    this.setCacheTip("", e.getMessage(), selectLogArrNew, 0);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private void reapplySelect(JSONObject selectLog, List<DynamicObject> dynamicObjects) {
        String taxNo = selectLog.getString("tax_no");
        String deductibleMode = selectLog.getString("operate_type");
        Pair pair = DeductionConstant.getDeductionPurpose((String)deductibleMode);
        String authenticateFlagParam = (String)pair.getLeft();
        String deductionPurposeParam = (String)pair.getRight();
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)selectLog.get((Object)"org"));
        String billType = selectLog.getString("bill_type");
        JSONArray jsonArray = new JSONArray(1);
        jsonArray.add((Object)selectLog);
        Map<String, DynamicObject> accountMap = dynamicObjects.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("serial_no"))).collect(Collectors.toMap(t -> t.getString("serial_no"), element -> element, (oldValue, newValue) -> oldValue));
        QFilter serialNoFilter = new QFilter("serial_no", "in", accountMap.keySet());
        QFilter taxNoFilter = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level", (QFilter[])new QFilter[]{serialNoFilter, taxNoFilter}, (String)"id desc");
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)invoiceCollection)) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u6839\u636e\u53f0\u8d26\u4fe1\u606f\u7684\u6d41\u6c34\u53f7\u65e0\u6cd5\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u4fe1\u606f", (String)"ReapplySelectLoginOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        JSONArray invoices = new JSONArray();
        DynamicObjectCollection successCollection = new DynamicObjectCollection();
        for (DynamicObject object : invoiceCollection) {
            String remark;
            String outputType;
            String authenticateFlag = object.getString("authenticate_flag");
            String isVoucher = object.getString("isvoucher");
            if ("1".equals(authenticateFlagParam) && !StringUtils.isEmpty((CharSequence)authenticateFlag) && !"0".equals(authenticateFlag) && !"4".equals(authenticateFlag) || "0".equals(authenticateFlagParam) && (!"1".equals(authenticateFlag) || "1".equals(isVoucher)) || "2".equals(deductibleMode) && (StringUtils.isNotEmpty((CharSequence)(outputType = object.getString("output_type"))) || StringUtils.isNotEmpty((CharSequence)(remark = object.getString("remark"))) && remark.contains("\u4ee3\u529e\u9000\u7a0e"))) continue;
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("invoice_type"));
            String invoiceStatus = object.getString("invoice_status");
            if ("1".equals(authenticateFlagParam) && !InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) && !"0".equals(invoiceStatus) && !"7".equals(invoiceStatus)) continue;
            String invoiceRiskLevel = object.getString("invoice_risk_level");
            if ("1".equals(authenticateFlagParam) && ("2".equals(invoiceRiskLevel) || "3".equals(invoiceRiskLevel) || "\u7591\u70b9\u53d1\u7968".equals(invoiceRiskLevel) || "\u5f02\u5e38\u51ed\u8bc1".equals(invoiceRiskLevel)) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) && object.getDate("invoice_date") == null) continue;
            if ("1".equals(authenticateFlagParam)) {
                String totalTaxAmount = object.getString("total_tax_amount");
                if (new BigDecimal(totalTaxAmount).compareTo(BigDecimal.ZERO) < 0) continue;
                DynamicObject account = accountMap.get(object.getString("serial_no"));
                if (StringUtils.isNotBlank((CharSequence)account.getString("not_deductible_type"))) {
                    object.set("not_deductible_type", (Object)account.getString("not_deductible_type"));
                }
                String notDeductibleType = object.getString("not_deductible_type");
                if ("2".equals(deductionPurposeParam) && (StringUtils.isEmpty((CharSequence)notDeductibleType) || "0".equals(notDeductibleType))) continue;
            }
            invoices.add((Object)DeductionConstant.createSelectJson((DynamicObject)object, (String)deductionPurposeParam));
        }
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)invoices)) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u52fe\u9009\u4fe1\u606f\u4e0d\u6ee1\u8db3\u91cd\u8bd5\u8981\u6c42\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u52fe\u9009\u9875\u9762\u53d1\u8d77\u8bf7\u6c42\uff0c\u83b7\u53d6\u5168\u9762\u7684\u63d0\u793a\u4fe1\u606f", (String)"ReapplySelectLoginOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        JSONObject param = new JSONObject();
        param.put("billType", (Object)billType);
        param.put("deductibleMode", (Object)deductibleMode);
        param.put("taxNo", (Object)taxNo);
        param.put("invoices", (Object)invoices);
        String taskNo = UUID.randomUUID();
        param.put("taskNo", (Object)taskNo);
        param.put("orgId", (Object)orgId);
        param.put("selectOperationType", (Object)"1");
        param.put("rpa_select_syn", (Object)(DeductSelectService.isSyncDown((String)taxNo) ? "1" : "0"));
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductSelectService invoiceDeductService = DeductServiceFactory.newInstanceForDeductSelect((String)dkType);
        JSONObject result = invoiceDeductService.batchSelectInvoices(param);
        if (result == null) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u8c03\u7528\u52fe\u9009\u5f02\u5e38", (String)"ReapplySelectLoginOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        int successNum = result.getIntValue("successNum");
        if (successNum > 0) {
            this.setCacheTip(taxNo, "", null, 1);
        } else {
            String description = result.getString("description");
            if (StringUtils.isNotBlank((CharSequence)result.getString("message"))) {
                description = result.getString("message");
            }
            this.setCacheTip(taxNo, description, jsonArray, 0);
        }
    }

    private void reapplyRecorded(JSONObject selectLog, List<DynamicObject> dynamicObjects) {
        QFilter taxNoFilter;
        String taxNo = selectLog.getString("tax_no");
        String operateType = selectLog.getString("operate_type");
        String billType = selectLog.getString("bill_type");
        JSONArray jsonArray = new JSONArray(1);
        jsonArray.add((Object)selectLog);
        String dktype = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle((String)dktype);
        if (deductService == null) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c", (String)"TaxRecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        Map<String, DynamicObject> accountMap = dynamicObjects.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("serial_no"))).collect(Collectors.toMap(t -> t.getString("serial_no"), element -> element, (oldValue, newValue) -> oldValue));
        QFilter serialNoFilter = new QFilter("serial_no", "in", accountMap.keySet());
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date", (QFilter[])new QFilter[]{serialNoFilter, taxNoFilter = new QFilter("buyer_tax_no", "=", (Object)taxNo)}, (String)"id desc");
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)invoiceCollection)) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u6839\u636e\u53f0\u8d26\u4fe1\u606f\u7684\u6d41\u6c34\u53f7\u65e0\u6cd5\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u4fe1\u606f", (String)"ReapplySelectLoginOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        String recordedopereateType = "";
        if ("02".equals(operateType)) {
            recordedopereateType = "recorded_commit";
        } else if ("03".equals(operateType)) {
            recordedopereateType = "recorded_update";
        } else if ("06".equals(operateType)) {
            recordedopereateType = "recorded_revoke";
        } else {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u975e\u5165\u5e10\u64cd\u4f5c", (String)"ReapplySelectLoginOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        DynamicObjectCollection successCollection = new DynamicObjectCollection();
        for (DynamicObject object : invoiceCollection) {
            DynamicObject account = accountMap.get(object.getString("serial_no"));
            Date selectTime = account.getDate("select_time");
            object.set("tax_recorded_time", (Object)selectTime);
            object.set("tax_recorded_period", (Object)selectTime);
            String deductionPurpose = account.getString("deduction_purpose");
            object.set("tax_recorded_purpose", (Object)deductionPurpose);
            String recordedStatus = object.getString("tax_recorded_status");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("invoice_type"));
            if (invoiceType == null || invoiceType <= 0L || "recorded_commit".equals(recordedopereateType) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)recordedStatus) && !"01".equals(recordedStatus) || "recorded_update".equals(recordedopereateType) && !"02".equals(recordedStatus) && !"03".equals(recordedStatus) && !"06".equals(recordedStatus) || "recorded_revoke".equals(recordedopereateType) && !"02".equals(recordedStatus) && !"03".equals(recordedStatus)) continue;
            successCollection.add((Object)object);
        }
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)successCollection)) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u5165\u8d26\u72b6\u6001\u4e0d\u6ee1\u8db3\u91cd\u8bd5\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u5931\u8d25\u53f0\u8d26\u5bf9\u5e94\u7684\u7a0e\u5c40\u5165\u8d26\u72b6\u6001", (String)"ReapplySelectLoginOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        JSONObject recordedParam = RecordedConstant.createRecordedParamNew((DynamicObjectCollection)successCollection, (String)recordedopereateType, (String)billType, null);
        if (recordedParam == null) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u7ec4\u88c5\u5165\u8d26\u6570\u636e\u5931\u8d25", (String)"ReapplySelectLoginOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        JSONObject configObj = recordedParam.getJSONObject(taxNo);
        JSONArray invoices = configObj.getJSONArray("invoices");
        ArrayList<JSONObject> invoiceSuccessList = new ArrayList<JSONObject>(1);
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject jsonObject = invoices.getJSONObject(i);
            JSONObject checkResult = deductService.checkRecordedInvoiceParam(jsonObject, recordedopereateType);
            if (!ResultContant.isSuccess((JSONObject)checkResult).booleanValue()) continue;
            invoiceSuccessList.add(jsonObject);
        }
        if (CollectionUtils.isEmpty(invoiceSuccessList)) {
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u5165\u8d26\u4fe1\u606f\u5fc5\u586b\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u5165\u8d26\u9875\u9762\u53d1\u8d77\u8bf7\u6c42\uff0c\u83b7\u53d6\u5168\u9762\u7684\u63d0\u793a\u4fe1\u606f", (String)"ReapplySelectLoginOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
            return;
        }
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("operateType", (Object)recordedopereateType);
        if ("5".equals(dktype)) {
            param.put("dktype", (Object)"5");
            param.put("invoiceSuccessList", invoiceSuccessList);
            this.invokeRecordSplitNew(param, jsonArray);
        } else if ("4".equals(dktype)) {
            Map<String, List<JSONObject>> taxRecordedPurposeMap = invoiceSuccessList.stream().collect(Collectors.groupingBy(t -> t.getString("nextEntryMarkStatus")));
            for (Map.Entry<String, List<JSONObject>> etaxEntry : taxRecordedPurposeMap.entrySet()) {
                JSONObject paramNewEtax = new JSONObject();
                paramNewEtax.putAll((Map)param);
                paramNewEtax.put("dktype", (Object)"4");
                paramNewEtax.put("invoiceSuccessList", etaxEntry.getValue());
                paramNewEtax.put("nextEntryMarkStatus", (Object)etaxEntry.getKey());
                this.invokeRecordSplitNew(paramNewEtax, jsonArray);
            }
        }
    }

    public void invokeRecordSplitNew(JSONObject param, JSONArray jsonArray) {
        String taxNo = param.getString("taxNo");
        String operateType = param.getString("operateType");
        String dktype = DeductionConstant.getDkType((String)taxNo);
        RecordedConstant recordedConstant = new RecordedConstant();
        DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle((String)dktype);
        List invoiceList = (List)param.get((Object)"invoiceSuccessList");
        if (invoiceList.size() > deductService.maxSizeRecorded) {
            List lists = ListUtils.splitList((List)invoiceList, (int)deductService.maxSizeRecorded);
            for (List list : lists) {
                JSONObject paramSplit = new JSONObject();
                paramSplit.putAll((Map)param);
                paramSplit.put("invoices", (Object)list);
                JSONObject result = deductService.recordedCommit(paramSplit);
                if (result == null) {
                    result = new JSONObject();
                    result.put("errcode", (Object)"2002");
                    result.put("description", (Object)ErrorType.PARAM_ERROR.getName());
                }
                if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                    paramSplit.put("result", (Object)result);
                    recordedConstant.dealInvoiceSuccess(paramSplit, operateType);
                    this.setCacheTip(taxNo, "", null, 1);
                    continue;
                }
                this.setCacheTip(taxNo, result.getString("description"), jsonArray, 0);
            }
        } else {
            param.put("invoices", (Object)invoiceList);
            JSONObject result = deductService.recordedCommit(param);
            if (result == null) {
                result = new JSONObject();
                result.put("errcode", (Object)"2002");
                result.put("description", (Object)ErrorType.PARAM_ERROR.getName());
            }
            if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                param.put("result", (Object)result);
                recordedConstant.dealInvoiceSuccess(param, operateType);
                this.setCacheTip(taxNo, "", null, 1);
            } else {
                this.setCacheTip(taxNo, result.getString("description"), jsonArray, 0);
            }
        }
    }
}

