/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.recorded;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TaxRecordedOperateService
extends InvoiceOperateService {
    private static Log logger = LogFactory.getLog(TaxRecordedOperateService.class);
    public static final String OPERATE_TYPE = "operatetype";
    public static final String INVOICES = "invoices";
    private static final int DEFAULT_SIZE = 500;

    public TaxRecordedOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            FormShowParameter showParameter;
            String str;
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"RecordedOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            Map parentCustomParams = listPlugin.getView().getFormShowParameter().getCustomParams();
            Object queryType = parentCustomParams.get("querytype");
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date", (QFilter[])new QFilter[]{filte}, (String)"id desc");
            int count = invoiceCollection.size();
            StringBuilder message = new StringBuilder();
            JSONArray invoices = new JSONArray();
            for (DynamicObject object : invoiceCollection) {
                String msg;
                String serialNo;
                String recordedStatus = object.getString("tax_recorded_status");
                String recordedPurpose = object.getString("tax_recorded_purpose");
                Date recordedTime = object.getDate("tax_recorded_time");
                String invoiceCode = object.getString("invoice_code");
                String invoiceNo = object.getString("invoice_no");
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("invoice_type"));
                if (invoiceType == null || invoiceType <= 0L) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)(serialNo = object.getString("serial_no")))) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedOperateService_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("recorded_commit".equals(this.type) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)recordedStatus) && !"01".equals(recordedStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u5165\u8d26\u72b6\u6001\u4e0d\u7b49\u4e8e\u672a\u5165\u8d26\uff0c\u8bf7\u9009\u62e9\u672a\u5165\u8d26\u6570\u636e", (String)"RecordedOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("recorded_update".equals(this.type) && !"02".equals(recordedStatus) && !"03".equals(recordedStatus) && !"06".equals(recordedStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u4e0d\u662f\u5df2\u5165\u8d26\u6216\u5165\u8d26\u64a4\u9500\u7684\u53d1\u7968", (String)"RecordedOperateService_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("recorded_revoke".equals(this.type) && !"02".equals(recordedStatus) && !"03".equals(recordedStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u5165\u8d26\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5165\u8d26(\u4f01\u4e1a\u6240\u5f97\u7a0e\u7a0e\u524d\u6263\u9664) \u6216 \u5df2\u5165\u8d26(\u4f01\u4e1a\u6240\u5f97\u7a0e\u4e0d\u6263\u9664)", (String)"RecordedOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (("maintain_recorded_time".equals(this.type) || "maintain_recorded_purpose".equals(this.type)) && ("11".equals(recordedStatus) || "02".equals(recordedStatus) || "03".equals(recordedStatus) || "06".equals(recordedStatus))) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5165\u8d26\u5904\u7406\u4e2d\u3001\u5df2\u5165\u8d26\u6216\u5df2\u64a4\u9500\u5165\u8d26\uff0c\u4e0d\u80fd\u6279\u91cf\u4fee\u6539\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u6216\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (!kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)message.toString())) continue;
                invoices.add((Object)object);
            }
            String recordedName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5165\u8d26", (String)"RecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            if ("recorded_update".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u5165\u8d26\u66f4\u65b0", (String)"RecordedOperateService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if ("recorded_revoke".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u64a4\u9500\u5165\u8d26", (String)"RecordedOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if ("maintain_recorded_purpose".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u7528\u9014", (String)"RecordedOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if ("maintain_recorded_time".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)(str = message.toString()))) {
                ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)recordedName, (String)message.toString(), (int)0, (int)count);
                return;
            }
            this.plugin.getPageCache().put("deduct_title", recordedName);
            this.plugin.getPageCache().put("operateType", this.type);
            if ("recorded_commit".equals(this.type) || "recorded_update".equals(this.type)) {
                showParameter = new FormShowParameter();
                parentCustomParams.put(INVOICES, invoices);
                parentCustomParams.put("operateType", this.type);
                showParameter.setCustomParams(parentCustomParams);
                showParameter.setFormId("rim_tax_recorded_commit");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
                if ("recorded_update".equals(this.type)) {
                    showParameter.setCaption(ResManager.loadKDString((String)"\u5165\u8d26\u66f4\u65b0\u6c47\u603b", (String)"RecordedOperateService_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                showParameter.setCloseCallBack(closeCallBack);
                this.plugin.getView().showForm(showParameter);
            }
            if ("recorded_revoke".equals(this.type)) {
                this.plugin.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u64a4\u9500\u5165\u8d26\uff1f", (String)"RecordedOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(this.type), null);
            }
            if ("maintain_recorded_time".equals(this.type) || "maintain_recorded_purpose".equals(this.type)) {
                showParameter = new FormShowParameter();
                parentCustomParams.put(INVOICES, invoices);
                String updateType = "update_time";
                String title = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                if ("maintain_recorded_purpose".equals(this.type)) {
                    updateType = "update_purpose";
                    title = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u7528\u9014", (String)"RecordedOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                parentCustomParams.put("update_type", updateType);
                parentCustomParams.put("deduct_title", title);
                showParameter.setCustomParams(parentCustomParams);
                showParameter.setFormId("rim_recorded_update");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCaption(title);
                this.plugin.getView().showForm(showParameter);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (kd.imc.rim.common.utils.StringUtils.equals((CharSequence)this.type, (CharSequence)actionId)) {
            JSONObject returnData;
            Object data;
            Object recordedParam;
            if (("recorded_commit".equals(this.type) || "recorded_update".equals(this.type)) && (recordedParam = closedCallBackEvent.getReturnData()) != null) {
                this.plugin.getPageCache().put("recorded_taxno", recordedParam.toString());
                String recordedName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5165\u8d26", (String)"RecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                if ("recorded_update".equals(this.type)) {
                    recordedName = ResManager.loadKDString((String)"\u5165\u8d26\u66f4\u65b0", (String)"RecordedOperateService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                if ("recorded_revoke".equals(this.type)) {
                    recordedName = ResManager.loadKDString((String)"\u64a4\u9500\u5165\u8d26", (String)"RecordedOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                this.plugin.getPageCache().put("recorded_title", recordedName);
                this.invokeRecorded();
            }
            if (("maintain_recorded_time".equals(this.type) || "maintain_recorded_purpose".equals(this.type)) && (data = closedCallBackEvent.getReturnData()) != null && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)(returnData = (JSONObject)data).get((Object)"message").toString())) {
                if ("0000".equals(returnData.get((Object)"code"))) {
                    this.plugin.getView().showSuccessNotification(returnData.get((Object)"message").toString(), Integer.valueOf(2000));
                    this.plugin.getView().invokeOperation("refresh");
                } else {
                    this.plugin.getView().showTipNotification(returnData.get((Object)"message").toString(), Integer.valueOf(2000));
                }
            }
        }
        if ("recorded_etax_callback".equals(actionId)) {
            String taxNo = this.plugin.getPageCache().get("recorded_login_taxno");
            String cache = this.plugin.getPageCache().get("recorded_taxno");
            String title = this.plugin.getPageCache().get("recorded_title");
            if (StringUtils.isEmpty((CharSequence)cache)) {
                return;
            }
            JSONObject cacheObject = JSONObject.parseObject((String)cache);
            if (ObjectUtils.isEmpty((Object)cacheObject)) {
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)taxNo)) {
                JSONObject configObj = cacheObject.getJSONObject(taxNo);
                if (!ObjectUtils.isEmpty((Object)configObj)) {
                    this.invokeRecordSplitNew(configObj);
                }
                cacheObject.remove((Object)taxNo);
            }
            if (cacheObject.isEmpty()) {
                DeductionUtils.showResultRecorded((AbstractFormPlugin)this.plugin);
            } else {
                this.plugin.getPageCache().put("deduct_tax_no", cacheObject.toJSONString());
                this.invokeRecorded();
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("recorded_revoke".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date", (QFilter[])new QFilter[]{filte}, (String)"id desc");
            if (CollectionUtils.isEmpty((Collection)invoiceCollection)) {
                logger.info("\u64a4\u9500\u52fe\u9009\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u4e0d\u505a\u53d8\u52a8");
                return;
            }
            JSONObject recordedParam = RecordedConstant.createRecordedParamNew((DynamicObjectCollection)invoiceCollection, (String)this.type, (String)"1", null);
            if (recordedParam != null) {
                this.plugin.getPageCache().put("recorded_taxno", recordedParam.toString());
                String recordedName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5165\u8d26", (String)"RecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                if ("recorded_update".equals(this.type)) {
                    recordedName = ResManager.loadKDString((String)"\u5165\u8d26\u66f4\u65b0", (String)"RecordedOperateService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                if ("recorded_revoke".equals(this.type)) {
                    recordedName = ResManager.loadKDString((String)"\u64a4\u9500\u5165\u8d26", (String)"RecordedOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                this.plugin.getPageCache().put("recorded_title", recordedName);
                this.invokeRecorded();
            }
        }
    }

    public void invokeRecorded() {
        JSONObject cacheJson;
        String cache = this.plugin.getPageCache().get("recorded_taxno");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)(cacheJson = JSONObject.parseObject((String)cache)))) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> list = new ArrayList<String>(cacheJson.size());
        logger.info("\u767b\u5f55\u68c0\u6d4b\u7a0e\u53f7:{}", (Object)cacheJson.keySet());
        logger.info("\u9875\u9762\u5165\u8d26-\u6700\u521d\u59cb\u53c2\u6570\uff1a\u64cd\u4f5c\u7c7b\u578b{}, \u7a0e\u53f7\u5206\u6279\u7684\u5165\u53c2{}", (Object)this.type, (Object)cache);
        for (Map.Entry entry : cacheJson.entrySet()) {
            String taxNo = (String)entry.getKey();
            JSONObject configObj = cacheJson.getJSONObject(taxNo);
            JSONArray invoices = configObj.getJSONArray(INVOICES);
            if (CollectionUtils.isEmpty((Collection)invoices)) {
                list.add(taxNo);
                this.setCacheTip(taxNo, invoices, ErrorType.PARAM_ERROR.getName());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                list.add(taxNo);
                this.setCacheTip(taxNo, invoices, ErrorType.TAXNO_NULL.getName());
                continue;
            }
            String dktype = DeductionConstant.getDkType((String)taxNo);
            DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle((String)dktype);
            if (deductService == null) {
                list.add(taxNo);
                this.setCacheTip(taxNo, invoices, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c", (String)"TaxRecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            ArrayList<JSONObject> invoiceSuccessList = new ArrayList<JSONObject>(1);
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject jsonObject = invoices.getJSONObject(i);
                JSONObject checkResult = deductService.checkRecordedInvoiceParam(jsonObject, this.type);
                if (!ResultContant.isSuccess((JSONObject)checkResult).booleanValue()) {
                    JSONArray objects = new JSONArray();
                    checkResult.put("invoiceNo", (Object)jsonObject.getString("invoiceNo"));
                    checkResult.put("invoiceCode", (Object)jsonObject.getString("invoiceCode"));
                    objects.add((Object)checkResult);
                    this.setCacheTip(taxNo, objects, checkResult.getString("description"));
                    continue;
                }
                invoiceSuccessList.add(jsonObject);
            }
            if (CollectionUtils.isEmpty(invoiceSuccessList)) {
                list.add(taxNo);
                continue;
            }
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            param.put("operateType", (Object)this.type);
            if ("5".equals(dktype)) {
                param.put("dktype", (Object)"5");
                param.put("invoiceSuccessList", invoiceSuccessList);
                this.invokeRecordSplitNew(param);
                list.add(taxNo);
                continue;
            }
            if (!"4".equals(dktype)) continue;
            Map<String, List<JSONObject>> taxRecordedPurposeMap = invoiceSuccessList.stream().collect(Collectors.groupingBy(t -> t.getString("nextEntryMarkStatus")));
            for (Map.Entry<String, List<JSONObject>> etaxEntry : taxRecordedPurposeMap.entrySet()) {
                JSONObject paramNewEtax = new JSONObject();
                paramNewEtax.putAll((Map)param);
                paramNewEtax.put("dktype", (Object)"4");
                paramNewEtax.put("invoiceSuccessList", etaxEntry.getValue());
                paramNewEtax.put("nextEntryMarkStatus", (Object)etaxEntry.getKey());
                boolean isBreak = this.loginEleClient(cacheJson, list, taxNo, paramNewEtax);
                if (isBreak) {
                    return;
                }
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)paramNewEtax.get((Object)"loginFail"))) {
                    list.add(taxNo);
                    JSONObject loginFail = paramNewEtax.getJSONObject("loginFail");
                    this.setCacheTip(taxNo, invoices, loginFail.getString("description"));
                    continue;
                }
                this.invokeRecordSplitNew(paramNewEtax);
                list.add(taxNo);
            }
        }
        for (String tt : list) {
            cacheJson.remove((Object)tt);
        }
        if (cacheJson.isEmpty()) {
            DeductionUtils.showResultRecorded((AbstractFormPlugin)this.plugin);
        }
    }

    public void invokeRecordSplitNew(JSONObject param) {
        String taxNo = param.getString("taxNo");
        String opereateType = param.getString("operateType");
        String dktype = DeductionConstant.getDkType((String)taxNo);
        RecordedConstant recordedConstant = new RecordedConstant();
        DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle((String)dktype);
        List invoiceList = (List)param.get((Object)"invoiceSuccessList");
        if (invoiceList.size() > deductService.maxSizeRecorded) {
            List lists = ListUtils.splitList((List)invoiceList, (int)deductService.maxSizeRecorded);
            for (List list : lists) {
                JSONObject paramSplit = new JSONObject();
                paramSplit.putAll((Map)param);
                paramSplit.put(INVOICES, (Object)list);
                JSONObject result = deductService.recordedCommit(paramSplit);
                if (result == null) {
                    result = new JSONObject();
                    result.put("errcode", (Object)"2002");
                    result.put("description", (Object)ErrorType.PARAM_ERROR.getName());
                }
                if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                    paramSplit.put("result", (Object)result);
                    recordedConstant.dealInvoiceSuccess(paramSplit, opereateType);
                    this.setCacheSuccess(list.size());
                    continue;
                }
                this.setCacheTip(taxNo, JSONArray.parseArray((String)JSONObject.toJSONString((Object)list)), result.getString("description"));
            }
        } else {
            param.put(INVOICES, (Object)invoiceList);
            JSONObject result = deductService.recordedCommit(param);
            if (result == null) {
                result = new JSONObject();
                result.put("errcode", (Object)"2002");
                result.put("description", (Object)ErrorType.PARAM_ERROR.getName());
            }
            if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                param.put("result", (Object)result);
                recordedConstant.dealInvoiceSuccess(param, opereateType);
                this.setCacheSuccess(invoiceList.size());
            } else {
                this.setCacheTip(taxNo, JSONArray.parseArray((String)JSONObject.toJSONString((Object)invoiceList)), result.getString("description"));
            }
        }
    }

    private void setCacheSuccess(int successNum) {
        JSONObject resultParam = ResultContant.createSuccessJSONObject();
        resultParam.put("successNum", (Object)successNum);
        resultParam.put("failNum", (Object)0);
        this.setOperationResult2Cache(resultParam);
    }

    private void setCacheTip(String taxNo, JSONArray invoices, String messageParam) {
        JSONObject resultParam = new JSONObject();
        resultParam.put("errcode", (Object)ErrorType.PARAM_ERROR.getCode());
        StringBuilder message = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice = invoices.getJSONObject(i);
                String invoiceCode = invoice.getString("invoiceCode");
                String invoiceNo = invoice.getString("invoiceNo");
                message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u7a0e\u53f7%2$s\uff0c%3$s", (String)"DeductionLoginOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo), taxNo, messageParam)).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        resultParam.put("message", (Object)message.toString());
        resultParam.put("successNum", (Object)0);
        resultParam.put("failNum", (Object)(CollectionUtils.isNotEmpty((Collection)invoices) ? invoices.size() : 0));
        this.setOperationResult2Cache(resultParam);
    }

    protected void setOperationResult2Cache(JSONObject operationRtn) {
        if (operationRtn == null) {
            return;
        }
        String resultCache = this.plugin.getPageCache().get("operation_result");
        JSONObject resultInfo = null;
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        if (resultCache != null) {
            resultInfo = JSONObject.parseObject((String)resultCache);
            successNum += resultInfo.getIntValue("successNum");
            failNum += resultInfo.getIntValue("failNum");
            String msg = resultInfo.getString("message");
            if (msg != null) {
                message.append(msg);
            }
        } else {
            resultInfo = ResultContant.createSuccessJSONObject();
        }
        if (!ResultContant.isSuccess((JSONObject)operationRtn).booleanValue()) {
            String messageTip;
            String errcode = operationRtn.getString("errcode");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errcode)) {
                resultInfo.put("errcode", (Object)errcode);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(messageTip = operationRtn.getString("message")))) {
                message.append(messageTip);
            }
        }
        resultInfo.put("successNum", (Object)(successNum += operationRtn.getInteger("successNum").intValue()));
        resultInfo.put("failNum", (Object)(failNum += operationRtn.getInteger("failNum").intValue()));
        resultInfo.put("message", (Object)message.toString());
        this.plugin.getPageCache().put("operation_result", resultInfo.toJSONString());
    }

    private boolean loginEleClient(JSONObject cacheJson, List<String> list, String taxNo, JSONObject configObj) {
        NewEtaxDeductService service = new NewEtaxDeductService(Long.valueOf(0L));
        JSONObject loginResult = service.login(taxNo);
        if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
            JSONObject data = loginResult.getJSONObject("data");
            if (service.needOpenLoginPage(data)) {
                data.put("taxNo", (Object)taxNo);
                service.showLoginPage(data, this.plugin, "recorded_etax_callback");
                this.plugin.getPageCache().put("recorded_login_taxno", taxNo);
                for (String tt : list) {
                    cacheJson.remove((Object)tt);
                }
                cacheJson.put(taxNo, (Object)configObj);
                this.plugin.getPageCache().put("recorded_taxno", cacheJson.toJSONString());
                return true;
            }
            logger.info("\u5df2\u767b\u5f55\uff1a{}", (Object)loginResult);
        } else {
            if (loginResult == null) {
                loginResult = new JSONObject();
                loginResult.put("errcode", (Object)ErrorType.ALl_E_LOGIN_FAIL.getCode());
                loginResult.put("description", (Object)ErrorType.ALl_E_LOGIN_FAIL.getName());
            }
            logger.info("\u83b7\u53d6\u767b\u5f55\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)loginResult);
            configObj.put("loginFail", (Object)loginResult);
        }
        return false;
    }

    public Pair<Integer, Integer> invokeRecordSplit(DeductService deductService, List<JSONObject> invoiceList, JSONObject param, int fail, int success, StringBuilder message, List<JSONObject> resultList) {
        String api = param.getString("api");
        if (invoiceList.size() > deductService.maxSizeRecorded) {
            List lists = ListUtils.splitList(invoiceList, (int)deductService.maxSizeRecorded);
            for (List list : lists) {
                JSONObject paramSplit = new JSONObject();
                paramSplit.putAll((Map)param);
                paramSplit.put(INVOICES, (Object)list);
                JSONObject result = deductService.recordedCommit(paramSplit);
                if (result == null) continue;
                if (!"0000".equals(result.getString("errcode"))) {
                    fail += list.size();
                    if ("1".equals(api)) {
                        paramSplit.put("result", (Object)result);
                        resultList.add(paramSplit);
                        continue;
                    }
                    String description = result.getString("description");
                    for (JSONObject jsonObject : list) {
                        this.getFaliMsg(message, jsonObject, description);
                    }
                    continue;
                }
                success += list.size();
                paramSplit.put("result", (Object)result);
                resultList.add(paramSplit);
            }
        } else {
            param.put(INVOICES, invoiceList);
            JSONObject result = deductService.recordedCommit(param);
            if (result != null) {
                if (!"0000".equals(result.getString("errcode"))) {
                    fail += invoiceList.size();
                    if ("1".equals(api)) {
                        param.put("result", (Object)result);
                        resultList.add(param);
                        return Pair.of((Object)success, (Object)fail);
                    }
                    String description = result.getString("description");
                    for (JSONObject jsonObject : invoiceList) {
                        this.getFaliMsg(message, jsonObject, description);
                    }
                    logger.info("fail size: {}", (Object)fail);
                    return Pair.of((Object)success, (Object)fail);
                }
                success += invoiceList.size();
                param.put("result", (Object)result);
                resultList.add(param);
            }
        }
        logger.info("fail size: {}", (Object)fail);
        logger.info("success size: {}", (Object)success);
        return Pair.of((Object)success, (Object)fail);
    }

    private void getFaliMsg(StringBuilder message, JSONObject jsonObject, String msgStr) {
        String invoiceCode = jsonObject.getString("invoiceCode");
        String invoiceNo = jsonObject.getString("invoiceNo");
        String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
        String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s %2$s", (String)"TaxRecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup, msgStr);
        message.append(msg);
        message.append(ViewUtil.LINE_SEPARATOR);
    }
}

