/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.verify;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class FpzsConfigPlugin
extends AbstractFormPlugin {
    private static final String EXPENSE_TYPE_ENTITY = "rim_expense_type";
    private static final String FPZS_CONFIG_ENTRY = "rim_fpzs_config_entry";
    private static final String FPZS_CONFIG_ORG = "rim_fpzs_config_org";
    private static final String FPZS_CONFIG_ENTITY = "rim_fpzs_config";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (!"save_config".equals(key) && "add_bill_type".equals(key)) {
            this.showBillTypeBase();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("save".equals(key)) {
            this.saveBillConfig(args);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (EXPENSE_TYPE_ENTITY.equals(actionId)) {
            this.addNewBillType(closedCallBackEvent.getReturnData());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        List<String> tagConfigKeys = this.getTagConfigKeys();
        if (tagConfigKeys.contains(propName)) {
            Map permMap = FpzsConstant.createPermMap();
            String permItem = (String)permMap.get(propName);
            this.showOrHideTab(propName, permItem);
        }
    }

    public void loadData(LoadDataEventArgs e) {
        Object pkValue = e.getPkId();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object pkValue = this.getModel().getDataEntity(true).getPkValue();
        Map permMap = FpzsConstant.createPermMap();
        if (pkValue == null || 0L == (Long)pkValue) {
            List<String> tabConfigKeys = this.getTagConfigKeys();
            for (String tabConfigKey : tabConfigKeys) {
                String permItem = (String)permMap.get(tabConfigKey);
                this.showOrHideTab(tabConfigKey, permItem);
            }
            String number = UUID.getBatchNumber();
            this.getModel().setValue("schema_number", (Object)"FPYZS".concat(number));
            return;
        }
        String schemaNumber = (String)this.getModel().getValue("schema_number");
        if ("FPYZS_DEFAULT".equalsIgnoreCase(schemaNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
        DynamicObject configObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)FPZS_CONFIG_ENTITY);
        String pcConfigStr = configObj.getString("pc_config_tag");
        String mobConfigStr = configObj.getString("mobile_config_tag");
        if (StringUtils.isNotEmpty((CharSequence)pcConfigStr)) {
            JSONObject pcConfig = JSONObject.parseObject((String)pcConfigStr);
            this.setUserConfig(pcConfig, this.createDefaultPcConfig());
        }
        if (StringUtils.isNotEmpty((CharSequence)mobConfigStr)) {
            JSONObject mobConfig = JSONObject.parseObject((String)mobConfigStr);
            this.setUserConfig(mobConfig, this.createDefaultMobConfig());
        }
    }

    public void afterCreateNewData(EventObject e) {
        e.getSource();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void saveBillConfig(BeforeDoOperationEventArgs args) {
        JSONObject userPcConfig = this.getUserConfig(this.createDefaultPcConfig());
        JSONObject userMobConfig = this.getUserConfig(this.createDefaultMobConfig());
        String suitableBillType = (String)this.getModel().getValue("suitable_bill_types");
        DynamicObjectCollection currentBillTypes = this.getModel().getEntryEntity(FPZS_CONFIG_ENTRY);
        if ("0".equals(suitableBillType) && (currentBillTypes == null || currentBillTypes.size() == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5355\u636e\u7c7b\u578b\u65f6\uff0c\u9002\u7528\u7684\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsConfigPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Boolean scope = (Boolean)this.getModel().getValue("scope");
        DynamicObjectCollection orgs = this.getModel().getEntryEntity(FPZS_CONFIG_ORG);
        if (!scope.booleanValue() && CollectionUtils.isEmpty((Collection)orgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u7ec4\u7ec7\u65f6\uff0c\u9002\u7528\u7684\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsConfigPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Object schemaNumber = this.getModel().getValue("schema_number");
        String repeatTip = this.getRepeatedBillType();
        if (StringUtils.isNotEmpty((CharSequence)repeatTip)) {
            this.getView().showTipNotification(repeatTip);
            args.setCancel(true);
            return;
        }
        if ("1".equals(suitableBillType)) {
            this.getModel().deleteEntryData(FPZS_CONFIG_ENTRY);
        }
        userPcConfig.put("cv", (Object)1);
        this.getModel().setValue("pc_config_tag", (Object)userPcConfig.toJSONString());
        this.getModel().setValue("mobile_config_tag", (Object)userMobConfig.toJSONString());
    }

    private String getRepeatedBillType() {
        Object tip = null;
        return null;
    }

    private void showOrHideTab(String key, String permItem) {
        String configValue = (String)this.getModel().getValue(key);
        if ("0".equals(configValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{key.concat("_tab")});
        } else if ("1".equals(configValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{key.concat("_tab")});
        } else if ("2".equals(configValue)) {
            RequestContext request = RequestContext.get();
            String entityId = "";
            entityId = key.startsWith("pc") ? "rim_fpzs_main" : "rim_mobile_index";
            int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(request.getUserId()), (Long)request.getOrgId(), (String)"rim", (String)entityId, (String)permItem);
            if (checkPerm <= 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{key.concat("_tab")});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{key.concat("_tab")});
            }
        }
    }

    private void setUserConfig(JSONObject userConfig, Map<String, String> defaultConfig) {
        List<String> tagConfigs = this.getTagConfigKeys();
        String key = null;
        Map permMap = FpzsConstant.createPermMap();
        for (Map.Entry<String, String> entry : defaultConfig.entrySet()) {
            key = entry.getKey();
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            String userConfigValue = userConfig.getString(key);
            if (StringUtils.isEmpty((CharSequence)userConfigValue)) {
                userConfigValue = entry.getValue();
            }
            this.getModel().setValue(key, (Object)userConfigValue);
            if (!tagConfigs.contains(key)) continue;
            String permItem = (String)permMap.get(key);
            this.showOrHideTab(key, permItem);
        }
    }

    private JSONObject getUserConfig(Map<String, String> defaultConfig) {
        if (defaultConfig == null || defaultConfig.size() == 0) {
            return new JSONObject();
        }
        JSONObject userConfig = new JSONObject();
        for (Map.Entry<String, String> pcEntry : defaultConfig.entrySet()) {
            String key = pcEntry.getKey();
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            String value = pcEntry.getValue();
            String userValue = (String)this.getModel().getValue(key);
            if (!StringUtils.isEmpty((CharSequence)userValue)) {
                value = userValue;
            }
            userConfig.put(key, (Object)value);
        }
        return userConfig;
    }

    private void addNewBillType(Object returnData) {
        String billNumber;
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        DynamicObjectCollection billEntities = this.getModel().getEntryEntity(FPZS_CONFIG_ENTRY);
        HashSet<String> selectedBillNumber = new HashSet<String>(8);
        if (billEntities != null && billEntities.size() > 0) {
            billNumber = null;
            for (DynamicObject billTypeObj : billEntities) {
                if (billTypeObj == null || !StringUtils.isNotEmpty((CharSequence)(billNumber = billTypeObj.getString("bill_number")))) continue;
                selectedBillNumber.add(billNumber);
            }
        }
        billNumber = null;
        for (ListSelectedRow selectedRow : selectedRows) {
            if (selectedRow == null) continue;
            billNumber = selectedRow.getNumber();
            if (!selectedBillNumber.add(billNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u91cd\u590d\uff0c\u5df2\u81ea\u52a8\u5254\u9664\u91cd\u590d\u7684\u5355\u636e\u7f16\u7801", (String)"FpzsConfigPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            int index = this.getModel().createNewEntryRow(FPZS_CONFIG_ENTRY);
            this.getModel().setValue("bill_number", (Object)selectedRow.getNumber(), index);
            this.getModel().setValue("bill_name", (Object)selectedRow.getName(), index);
        }
    }

    private void showBillTypeBase() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)EXPENSE_TYPE_ENTITY, (boolean)true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setHasRight(true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EXPENSE_TYPE_ENTITY);
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<String> getTagConfigKeys() {
        List<String> tabConfigKeys = Arrays.asList("pc_invoice", "pc_oversea", "pc_contract", "pc_attach", "mobile_invoice", "mobile_oversea", "mobile_contract", "mobile_attach");
        return tabConfigKeys;
    }

    private Map<String, String> createDefaultPcConfig() {
        HashMap<String, String> defaultPcConfig = new HashMap<String, String>(27);
        defaultPcConfig.put("pc_invoice", "2");
        defaultPcConfig.put("pc_oversea", "2");
        defaultPcConfig.put("pc_contract", "2");
        defaultPcConfig.put("pc_attach", "2");
        defaultPcConfig.put("operate_upload", "2");
        defaultPcConfig.put("operate_qrcode", "2");
        defaultPcConfig.put("operate_enter", "2");
        defaultPcConfig.put("operate_scanner", "2");
        defaultPcConfig.put("operate_san_gun", "2");
        defaultPcConfig.put("operate_company_invoice", "2");
        defaultPcConfig.put("operate_person_invoice", "2");
        defaultPcConfig.put("operate_excel_import", "2");
        defaultPcConfig.put("pc_oversea_file_upload", "2");
        defaultPcConfig.put("pc_oversea_phone_upload", "2");
        defaultPcConfig.put("pc_oversea_scanner", "2");
        defaultPcConfig.put("pc_oversea_company", "2");
        defaultPcConfig.put("pc_oversea_person", "2");
        defaultPcConfig.put("pc_oversea_enter", "2");
        defaultPcConfig.put("pc_contract_file_upload", "2");
        defaultPcConfig.put("pc_contract_phone_upload", "2");
        defaultPcConfig.put("pc_contract_scanner", "2");
        defaultPcConfig.put("pc_contract_company", "2");
        defaultPcConfig.put("pc_contract_person", "2");
        defaultPcConfig.put("operate_attach_qrcode", "2");
        defaultPcConfig.put("operate_attach_upload", "2");
        defaultPcConfig.put("operate_attach_scanner", "2");
        defaultPcConfig.put("pc_attach_company", "2");
        defaultPcConfig.put("pc_attach_person", "2");
        defaultPcConfig.put("operate_attach_person", "2");
        return defaultPcConfig;
    }

    private Map<String, String> createDefaultMobConfig() {
        HashMap<String, String> defaultMobConfig = new HashMap<String, String>(13);
        defaultMobConfig.put("mobile_invoice", "2");
        defaultMobConfig.put("mobile_oversea", "2");
        defaultMobConfig.put("mobile_attach", "2");
        defaultMobConfig.put("mobile_contract", "2");
        defaultMobConfig.put("mob_invoice_camera", "2");
        defaultMobConfig.put("mob_invoice_scan_qrcode", "2");
        defaultMobConfig.put("mob_invoice_hand_add", "2");
        defaultMobConfig.put("mob_invoice_message", "2");
        defaultMobConfig.put("mob_invoice_email", "2");
        defaultMobConfig.put("mob_invoice_wxcard", "2");
        defaultMobConfig.put("mob_invoice_pocket", "2");
        defaultMobConfig.put("mob_oversea_camera", "2");
        defaultMobConfig.put("mob_oversea_pocket", "2");
        defaultMobConfig.put("mob_attach_camera", "2");
        defaultMobConfig.put("mob_attach_pocket", "2");
        defaultMobConfig.put("mobile_filebag_scan", "2");
        return defaultMobConfig;
    }
}

