/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.expense;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.expense.service.InvoiceImageNotifyService;
import org.apache.commons.compress.utils.Lists;

public class InvoiceImageNotifyUnlockTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InvoiceImageNotifyUnlockTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u8c03\u5ea6\u6267\u884c\u901a\u77e5\u5f71\u50cfunlock\u6570\u636e...");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date thirtyDaysAgo = calendar.getTime();
        QFilter filterStart = new QFilter("createdate", ">=", (Object)thirtyDaysAgo);
        QFilter filterEnd = new QFilter("createdate", "<=", (Object)new Date());
        List list = QueryServiceHelper.queryPrimaryKeys((String)"rim_image_notify_log", (QFilter[])new QFilter[]{filterStart, filterEnd}, (String)"id", (int)10000);
        if (list.size() > 0) {
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"rim_image_notify_log").getDynamicObjectType());
            ArrayList targetList = Lists.newArrayList();
            if (load.length > 0) {
                for (DynamicObject notify : load) {
                    List unlockDetail;
                    DynamicObjectCollection detailLogColl = notify.getDynamicObjectCollection("rim_notify_log_detail");
                    if (CollectionUtils.isEmpty((Collection)detailLogColl) || (unlockDetail = detailLogColl.stream().filter(f -> "unlock".equals(f.getString("error_info"))).collect(Collectors.toList())).size() <= 0) continue;
                    targetList.add(notify);
                }
                List params = targetList.stream().map(v -> v.getString("json")).collect(Collectors.toList());
                InvoiceImageNotifyService.imageNotify(params);
            }
            LOGGER.info("\u8c03\u5ea6\u6267\u884c\u901a\u77e5\u5f71\u50cfunlock\u6570\u636e...end");
        }
    }
}

