/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceTask;
import kd.imc.rim.common.utils.AllEleAuthUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.schedule.invoicedownload.service.InvoiceDownTaskHelper;

public class InputDownloadByRpaClientTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InputDownloadByRpaClientTask.class);
    private static final String CONFIG_KEY = "rpa_inoutput_down_size";
    private static int THREADPOOL_SIZE = RimConfigUtils.getPageSizeFromConfig((int)6, (String)"rim_sch", (String)"rpa_inoutput_down_pool_size");
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"InputDownloadByRpaClientTask", (int)THREADPOOL_SIZE);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u4e0b\u8f7dRPA\u8fdb\u9879\u53d1\u7968\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"InputDownloadByRpaClientTask", (String)"InputDownloadByRpaClientTask");){
            if (lock.tryLock()) {
                List<Long> downLogIds = InvoiceDownTaskHelper.getDownIds("invoice_full_down_rpa_cache");
                int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)900, (String)CONFIG_KEY);
                DynamicObject[] downLogDynamicObjects = InvoiceDownTaskHelper.getDownDynamicObject("rim_down_log", downLogIds, pageSize, "invoice_full_down_rpa_cache");
                this.downInvoice(requestContext, downLogDynamicObjects);
            } else {
                LOGGER.info("InputDownloadByRpaClientTask-Lock");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u4e0b\u8f7dRPA\u8fdb\u9879\u53d1\u7968\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void downInvoice(RequestContext requestContext, DynamicObject[] downLogDynamicObject) {
        if (ObjectUtils.isEmpty((Object[])downLogDynamicObject)) {
            return;
        }
        ArrayList<DynamicObject> downLogList = new ArrayList<DynamicObject>(Arrays.asList(downLogDynamicObject));
        Map<String, List<DynamicObject>> logGroupMap = downLogList.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
        ArrayList<String> taxNos = new ArrayList<String>(logGroupMap.keySet());
        List inputAccounts = AllEleAuthUtil.getInputAccounts(taxNos);
        Set<String> haveAccountTaxNos = inputAccounts.stream().map(s -> s.getString("taxNo")).collect(Collectors.toSet());
        this.handleNotAccount(haveAccountTaxNos, logGroupMap);
        if (CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        Map<String, List<JSONObject>> accountGroupMap = inputAccounts.stream().collect(Collectors.groupingBy(s -> s.getString("account") + s.getString("city")));
        int downMaxNum = InvoiceDownloadConstant.getPageSizeFromConfig((int)10, (String)"taxno_down_max_size");
        String isSinglethread = RimConfigUtils.getConfig((String)"rim_deduction", (String)"rpa_down_singlethread");
        CopyOnWriteArraySet<String> failTaxNos = new CopyOnWriteArraySet<String>();
        this.handleDown(requestContext, logGroupMap, accountGroupMap, downMaxNum, isSinglethread, failTaxNos);
        if (!failTaxNos.isEmpty()) {
            Iterator<String> iterator = logGroupMap.keySet().iterator();
            while (iterator.hasNext()) {
                String taxNo = iterator.next();
                if (failTaxNos.contains(taxNo)) continue;
                iterator.remove();
            }
            int downMaxNum2 = InvoiceDownloadConstant.getPageSizeFromConfig((int)2, (String)"taxno_down_max_size2");
            this.handleDown(requestContext, logGroupMap, accountGroupMap, downMaxNum2, isSinglethread, failTaxNos);
        }
    }

    private void handleDown(RequestContext requestContext, Map<String, List<DynamicObject>> logGroupMap, Map<String, List<JSONObject>> accountGroupMap, int downMaxNum, String isSinglethread, Set<String> failTaxNos) {
        ArrayList<Future> futureList = new ArrayList<Future>(8);
        Set<Map.Entry<String, List<JSONObject>>> entries = accountGroupMap.entrySet();
        int index = 0;
        ArrayList<String> taxNos = new ArrayList<String>(8);
        for (Map.Entry<String, List<JSONObject>> entry : entries) {
            String entryKey = entry.getKey();
            DLock dLock = LockUtils.createDLockByMd5((String)("rim.account-" + entryKey), (String)"rpa_account_lock");
            Throwable throwable = null;
            try {
                if (dLock.tryLock(2000L)) {
                    List rtnList;
                    List<JSONObject> accounts = entry.getValue();
                    ArrayList<DynamicObject> downLogs = new ArrayList<DynamicObject>(8);
                    taxNos.clear();
                    for (JSONObject account : accounts) {
                        String taxNo = account.getString("taxNo");
                        taxNos.add(taxNo);
                        List<DynamicObject> dynamicObjectList = logGroupMap.get(taxNo);
                        if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
                        downLogs.addAll(dynamicObjectList);
                    }
                    InvoiceDownServiceTask task = new InvoiceDownServiceTask(requestContext, downLogs, downMaxNum);
                    if ("1".equals(isSinglethread)) {
                        try {
                            String rtn = task.call();
                            if (!StringUtils.isNotEmpty((CharSequence)rtn)) continue;
                            this.addFailTaxNo(taxNos, failTaxNos);
                        }
                        catch (Exception rtn) {
                            // empty catch block
                        }
                        continue;
                    }
                    futureList.add(threadPool.submit((Callable)task));
                    if (CollectionUtils.isEmpty((Collection)(rtnList = CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)(++index))))) continue;
                    this.addFailTaxNo(taxNos, failTaxNos);
                    continue;
                }
                LOGGER.info("locked:" + entryKey);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dLock == null) continue;
                if (throwable != null) {
                    try {
                        dLock.close();
                    }
                    catch (Throwable rtn) {
                        throwable.addSuppressed(rtn);
                    }
                    continue;
                }
                dLock.close();
            }
        }
        List rtnList = CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)THREADPOOL_SIZE);
        if (!CollectionUtils.isEmpty((Collection)rtnList)) {
            this.addFailTaxNo(taxNos, failTaxNos);
        }
    }

    private void handleNotAccount(Set<String> haveAccountTaxNos, Map<String, List<DynamicObject>> logGroupMap) {
        if (haveAccountTaxNos == null || CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : logGroupMap.entrySet()) {
            String taxNo = entry.getKey();
            if (haveAccountTaxNos.contains(taxNo)) continue;
            InvoiceDownHelper.updateDescription(entry.getValue(), (String)String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"InputDownloadByRpaClientTask_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
        }
        Iterator<String> iterator = logGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            String taxNo = iterator.next();
            if (haveAccountTaxNos.contains(taxNo)) continue;
            iterator.remove();
        }
    }

    private void addFailTaxNo(List<String> resultList, Set<String> failTaxNos) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        for (String result : resultList) {
            this.addFailTaxNo(result, failTaxNos);
        }
    }

    private void addFailTaxNo(String result, Set<String> failTaxNos) {
        if (failTaxNos == null || StringUtils.isEmpty((CharSequence)result)) {
            return;
        }
        failTaxNos.add(result);
    }

    static {
        LOGGER.info("\u4e0b\u8f7drpa\u53d1\u7968\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60:{}", (Object)THREADPOOL_SIZE);
    }
}

