/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.impl.InputInvoiceDealService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.RimConfigUtils;

public class InputInvoiceDownDealTask
extends AbstractTask {
    private static int THREADPOOL_SIZE;
    private static ThreadPool inputThreadPool;
    private static final Log LOGGER;
    private static final String CONFIG_KEY = "deal_input_invoice_size";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int count;
        LOGGER.info("InputInvoiceDownDealTask\u5f00\u59cb... ");
        int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)1500, (String)CONFIG_KEY);
        for (int i = 0; i < 10 && (count = this.inputDeal(requestContext, pageSize)) >= 1; ++i) {
        }
        LOGGER.info("InputInvoiceDownDealTask\u7ed3\u675f... ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int inputDeal(RequestContext requestContext, int pageSize) {
        try (DLock lock = DLock.create((String)"rim.inputDeal", (String)"InputInvoiceDownDealTask.lock");){
            if (!lock.tryLock()) return 0;
            long start = System.currentTimeMillis();
            QFilter filter = new QFilter("sync_status", "=", (Object)"2");
            QFilter infilter = new QFilter("inout", "in", (Object)new String[]{"1", "7", "9"});
            List inputList = QueryServiceHelper.queryPrimaryKeys((String)"rim_down_input", (QFilter[])new QFilter[]{filter, infilter}, null, (int)pageSize);
            ArrayList<Future> futureList = new ArrayList<Future>(8);
            int index = 0;
            for (Object obj : inputList) {
                InputInvoiceDealService task = new InputInvoiceDealService(RequestContext.get(), obj);
                futureList.add(inputThreadPool.submit((Callable)task));
                CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)(++index));
            }
            CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)THREADPOOL_SIZE);
            LOGGER.info("\u5904\u7406{}\u5f20\u8fdb\u9879\u53d1\u7968,\u8017\u65f6:{}", (Object)(CollectionUtils.isEmpty((Collection)inputList) ? 0 : inputList.size()), (Object)(System.currentTimeMillis() - start));
            int n = inputList.size();
            return n;
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u8fdb\u9879\u53d1\u7968\u9519\u8bef", (Throwable)e);
        }
        return 0;
    }

    static {
        LOGGER = LogFactory.getLog(InputInvoiceDownDealTask.class);
        THREADPOOL_SIZE = RimConfigUtils.getPageSizeFromConfig((int)5, (String)"rim_sch", (String)"inputdeal_pool_size");
        inputThreadPool = ThreadPools.newFixedThreadPool((String)"InputInvoiceDownDealTask_input", (int)THREADPOOL_SIZE);
        LOGGER.info("\u5904\u7406\u8fdb\u9879\u53d1\u7968\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60:{}", (Object)THREADPOOL_SIZE);
    }
}

