/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.LqIncrementDownResultDealTask;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.schedule.invoicedownload.service.InvoiceDownTaskHelper;

public class LqIncrementInvoiceDownTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(LqIncrementInvoiceDownTask.class);
    private static final String CONFIG_KEY = "lq_increment_down_size";
    private static int THREADPOOL_SIZE = RimConfigUtils.getPageSizeFromConfig((int)3, (String)"rim_sch", (String)"lq_increment_pool_size");
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"LqIncrementInvoiceDownTask", (int)THREADPOOL_SIZE);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u4e0b\u8f7d\u4e50\u4f01\u589e\u91cf\u53d1\u7968\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)CONFIG_KEY);
        try (DLock lock = DLock.create((String)"LqIncrementInvoiceDownTask", (String)"LqIncrementInvoiceDownTaskLock");){
            if (lock.tryLock()) {
                List<Long> idList = InvoiceDownTaskHelper.getDownIds("invoice_increment_down_cache");
                Object[] dynamicObjects = InvoiceDownTaskHelper.getDownDynamicObject("rim_down_init", idList, pageSize, "invoice_increment_down_cache");
                if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
                    return;
                }
                HashMap noTypeMap = Maps.newHashMap();
                HashMap inoutMap = Maps.newHashMap();
                for (Object obj : dynamicObjects) {
                    DynamicObjectCollection userOrgCollect = obj.getDynamicObjectCollection("userorg");
                    List invoiceTypes = CommonUtils.getMultiValues((String)obj.getString("invoice_type"));
                    List outputDownloadList = CommonUtils.getMultiValues((String)obj.getString("output_download"));
                    for (DynamicObject userOrg : userOrgCollect) {
                        Long taxpayerOrg = userOrg.getLong("taxpayer_org.id");
                        String taxNo = userOrg.getString("taxpayer_tax_no");
                        String dkType = DeductionConstant.getDkType((String)taxNo);
                        if (!"5".equals(dkType = InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType))) continue;
                        noTypeMap.put(userOrg.getString("taxpayer_tax_no") + "-" + taxpayerOrg, invoiceTypes);
                        inoutMap.put(userOrg.getString("taxpayer_tax_no"), outputDownloadList);
                    }
                }
                if (noTypeMap.isEmpty()) {
                    return;
                }
                ArrayList<Future> futureList = new ArrayList<Future>(8);
                int index = 0;
                for (Map.Entry entry : noTypeMap.entrySet()) {
                    String taxNoOrg = (String)entry.getKey();
                    LqIncrementDownResultDealTask lqIncrementDownResultDealTask = new LqIncrementDownResultDealTask(requestContext, taxNoOrg, (List)entry.getValue(), (Map)inoutMap);
                    futureList.add(threadPool.submit((Callable)lqIncrementDownResultDealTask));
                    CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)(++index));
                }
                CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)THREADPOOL_SIZE);
            }
        }
    }

    static {
        LOGGER.info("\u4e0b\u8f7d\u4e50\u4f01\u589e\u91cf\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60:{}", (Object)THREADPOOL_SIZE);
    }
}

