/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Sets;

public class RetryInvoiceDealTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RetryInvoiceDealTask.class);
    private static final Integer MAX_DOWN_INPUT = 30;
    private static final Integer MAX_RETRY_DEAL_DATE = 5;
    private static final Integer MAX_SELECT_ACCOUNT_DEAL_DATE = 60;
    private static final Integer MAX_DOWN_LOG_DEAL_DATE = 120;
    private static final Integer MAX_DELETE_COUNT = 50000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u5904\u7406\u5931\u8d25\u91cd\u8bd5\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        try (DLock lock = DLock.create((String)"RetryDealInvoiceLookTask", (String)"RetryDealInvoiceLookTask");){
            if (lock.tryLock()) {
                int result;
                int result1;
                int i;
                this.retryDealInvoice();
                this.retryDownInvoice();
                this.deleteOverdueSelectAccount();
                this.updateOverdueDownLog();
                this.deleteOverdueInvoiceLog();
                for (i = 0; i < 50 && (result1 = this.deleteOverdueInvoiceAccount()) != 0; ++i) {
                }
                for (i = 0; i < 50 && (result = this.updateDownAccountOrg()) != 0; ++i) {
                }
                for (i = 0; i < 50 && (result = this.deleteOverdueInvoiceTpl()) != 0; ++i) {
                }
                this.againApply();
            } else {
                LOGGER.info("RetryDealInvoiceLookTask-Lock");
            }
        }
    }

    private void retryDealInvoice() {
        try {
            Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - MAX_RETRY_DEAL_DATE)));
            QFilter dateFilter = new QFilter("createtime", ">=", (Object)maxDate);
            QFilter statusFilter = new QFilter("sync_status", "=", (Object)"0");
            Object[] dynamicObjects = BusinessDataServiceHelper.load((String)"rim_down_input", (String)"sync_status,handle_num,modifytime", (QFilter[])new QFilter[]{dateFilter, statusFilter});
            if (!ObjectUtils.isEmpty((Object[])dynamicObjects)) {
                for (Object dynamicObject : dynamicObjects) {
                    dynamicObject.set("sync_status", (Object)"2");
                    dynamicObject.set("handle_num", (Object)0);
                    dynamicObject.set("modifytime", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u7f6e\u5931\u8d25\u7684\u53d1\u7968\u72b6\u6001\u62a5\u9519", (Throwable)e);
        }
    }

    private void retryDownInvoice() {
        try {
            QFilter stepFilter;
            QFilter inoutFilter;
            QFilter statusFilter;
            int maxDateInt;
            Date maxDate;
            QFilter dateFilter;
            Object[] dynamicObjects;
            String retryFlag = RimConfigUtils.getConfig((String)"rim_deduction", (String)"retry_down_invoice");
            String allDkType = RimConfigUtils.getConfig((String)"rim_deduction", (String)"retry_down_all_dktype");
            if ("1".equals(retryFlag) && !ObjectUtils.isEmpty((Object[])(dynamicObjects = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"gov_status,modifytime,tax_no", (QFilter[])new QFilter[]{dateFilter = new QFilter("apply_date", ">=", (Object)(maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - (maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)5, (String)"retry_down_invoice_days"))))))), statusFilter = new QFilter("gov_status", "in", (Object)new String[]{"1", "8"}), inoutFilter = new QFilter("inout", "in", (Object)new String[]{"1", "2"}), stepFilter = new QFilter("apply_step", "=", (Object)1)})))) {
                ArrayList<Object> updateObjs = new ArrayList<Object>(dynamicObjects.length);
                for (Object dynamicObject : dynamicObjects) {
                    String taxno;
                    String dkType;
                    if (!"1".equals(allDkType) && !"2".equals(dkType = DeductionConstant.getDkType((String)(taxno = dynamicObject.getString("tax_no"))))) continue;
                    dynamicObject.set("gov_status", (Object)"6");
                    dynamicObject.set("modifytime", (Object)new Date());
                    updateObjs.add(dynamicObject);
                }
                if (CollectionUtils.isEmpty(updateObjs)) {
                    return;
                }
                SaveServiceHelper.save((DynamicObject[])updateObjs.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u7f6e\u4e0b\u8f7d\u72b6\u6001\u62a5\u9519", (Throwable)e);
        }
    }

    private void againApply() {
        block3: {
            try {
                String retryFlag = RimConfigUtils.getConfig((String)"rim_deduction", (String)"hl_again_apply");
                if (!"1".equals(retryFlag)) break block3;
                QFilter qFilter = new QFilter("gov_status", "=", (Object)"7");
                qFilter.and("sync_type", "=", (Object)"3");
                qFilter.and("download_errcode", "=", (Object)"7");
                qFilter.and("inout", "in", (Object)new String[]{"1", "2"});
                int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)30, (String)"again_apply_days");
                Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
                QFilter dateFilter = new QFilter("createtime", ">=", (Object)maxDate);
                int queryCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)2000, (String)"again_apply_query_count");
                int applyCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)"again_apply_count");
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"rim_down_log", (String)"id,tax_no", (QFilter[])new QFilter[]{qFilter, dateFilter}, null, (int)queryCount);
                if (CollectionUtils.isEmpty((Collection)dynamicObjects)) break block3;
                Collections.shuffle(dynamicObjects);
                int index = 0;
                String taxNo = "";
                long id = 0L;
                InputOutInvoiceApplyService inputOutInvoiceApplyService = null;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    id = dynamicObject.getLong("id");
                    taxNo = dynamicObject.getString("tax_no");
                    inputOutInvoiceApplyService = InvoiceDownServiceFactory.newInstanceForApply((String)taxNo);
                    inputOutInvoiceApplyService.againApply(Long.valueOf(id));
                    if (++index < applyCount) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u91cd\u65b0\u7533\u8bf7\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private int deleteOverdueInvoiceTpl() {
        try {
            int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DOWN_INPUT, (String)"max_down_input");
            int maxDeleteCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DELETE_COUNT, (String)"max_delete_count");
            Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
            QFilter dateFilter = new QFilter("modifytime", "<", (Object)maxDate);
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_down_input", (QFilter[])new QFilter[]{dateFilter}, null, (int)maxDeleteCount);
            if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
                DBUtils.deleteByIds((String)"rim_down_input", (List)primaryKeys);
                return 1;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u966450\u5929\u524d\u7684\u4e34\u65f6\u6570\u636e\u62a5\u9519", (Throwable)e);
        }
        return 0;
    }

    private int deleteOverdueInvoiceAccount() {
        try {
            String retryFlag = RimConfigUtils.getConfig((String)"rim_deduction", (String)"not_delete_down_account");
            if (!"1".equals(retryFlag)) {
                int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DOWN_INPUT, (String)"max_delete_down_account");
                int maxDeleteCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DELETE_COUNT, (String)"max_delete_count");
                Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
                QFilter dateFilter = new QFilter("createtime", "<", (Object)maxDate);
                List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_down_account", (QFilter[])new QFilter[]{dateFilter}, null, (int)maxDeleteCount);
                if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
                    DBUtils.deleteByIds((String)"rim_down_account", (List)primaryKeys);
                    return 1;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u966490\u5929\u524d\u7684\u4e34\u65f6\u6570\u636e\u62a5\u9519", (Throwable)e);
        }
        return 0;
    }

    private void deleteOverdueInvoiceLog() {
        try {
            String retryFlag = RimConfigUtils.getConfig((String)"rim_deduction", (String)"not_delete_down_log");
            int maxDeleteCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DELETE_COUNT, (String)"max_delete_count");
            if (!"1".equals(retryFlag)) {
                int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DOWN_LOG_DEAL_DATE, (String)"max_delete_down_log");
                Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
                QFilter dateFilter = new QFilter("createtime", "<", (Object)maxDate);
                List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_down_log", (QFilter[])new QFilter[]{dateFilter}, null, (int)maxDeleteCount);
                if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
                    DBUtils.deleteByIds((String)"rim_down_log", (List)primaryKeys);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u9664\u4e00\u5e74\u524d\u7684\u4e0b\u8f7d\u65e5\u5fd7\u6570\u636e\u62a5\u9519", (Throwable)e);
        }
    }

    private void deleteOverdueSelectAccount() {
        try {
            int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_SELECT_ACCOUNT_DEAL_DATE, (String)"max_select_account");
            int maxDeleteCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DELETE_COUNT, (String)"max_delete_count");
            Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
            QFilter dateFilter = new QFilter("create_time", "<", (Object)maxDate);
            QFilter statusFilter = new QFilter("handle_status", "!=", (Object)"3");
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_select_account", (QFilter[])new QFilter[]{statusFilter, dateFilter}, null, (int)maxDeleteCount);
            if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
                DBUtils.deleteByIds((String)"rim_select_account", (List)primaryKeys);
            }
            if (!CollectionUtils.isEmpty((Collection)(primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_select_log", (QFilter[])new QFilter[]{statusFilter, dateFilter}, null, (int)maxDeleteCount)))) {
                DBUtils.deleteByIds((String)"rim_select_log", (List)primaryKeys);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u966490\u5929\u524d\u7684\u52fe\u9009\u65e5\u5fd7\u62a5\u9519", (Throwable)e);
        }
    }

    private void updateOverdueDownLog() {
        try {
            int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)45, (String)"max_update_logs");
            int maxUpdateCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_DELETE_COUNT, (String)"max_update_logs_count");
            Date maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
            QFilter dateFilter = new QFilter("modifytime", "<", (Object)maxDate).and("gov_status", "in", (Object)new String[]{"2", "6"});
            Object[] logObjects = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"id,modifytime,gov_status", (QFilter[])dateFilter.toArray(), null, (int)maxUpdateCount);
            if (!ObjectUtils.isEmpty((Object[])logObjects)) {
                for (Object logObject : logObjects) {
                    logObject.set("modifytime", (Object)new Date());
                    logObject.set("gov_status", (Object)"5");
                }
                SaveServiceHelper.save((DynamicObject[])logObjects);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b060\u5929\u524d\u7684\u4e0b\u8f7d\u65e5\u5fd7\u62a5\u9519", (Throwable)e);
        }
    }

    private int updateDownAccountOrg() {
        String flag = RimConfigUtils.getConfig((String)"rim_deduction", (String)"update_downaccount_org");
        if (!"0".equals(flag)) {
            try {
                QFilter orgFilter = new QFilter("org", "=", (Object)0L).or("org", "is null", null);
                Object[] accountObjects = BusinessDataServiceHelper.load((String)"rim_down_account", (String)"id,batch_no,org,modifytime", (QFilter[])orgFilter.toArray(), (String)"modifytime desc", (int)10000);
                if (!ObjectUtils.isEmpty((Object[])accountObjects)) {
                    HashSet batchNos = Sets.newHashSet((Object[])new String[0]);
                    HashMap orgMap = Maps.newHashMap();
                    for (Object account : accountObjects) {
                        batchNos.add(account.getString("batch_no"));
                    }
                    QFilter qFilter = new QFilter("batch_no", "in", (Object)batchNos);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"rim_down_log", (String)"batch_no,org", (QFilter[])qFilter.toArray());
                    if (CollectionUtils.isEmpty((Collection)query)) {
                        return 1;
                    }
                    for (DynamicObject dynamicObject : query) {
                        orgMap.put(dynamicObject.getString("batch_no"), DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("org")));
                    }
                    for (Object account : accountObjects) {
                        String batchNo = account.getString("batch_no");
                        Long orgId = (Long)orgMap.get(batchNo);
                        if (orgId == null) continue;
                        account.set("org", (Object)orgId);
                        account.set("modifytime", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])accountObjects);
                    return 1;
                }
                QFilter qFilter = new QFilter("config_key", "=", (Object)"rim_deduction_update_downaccount_org").and("config_type", "=", (Object)"rim_deduction");
                Object[] configurations = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"fid,config_value", (QFilter[])qFilter.toArray());
                if (!ObjectUtils.isEmpty((Object[])configurations)) {
                    for (Object configuration : configurations) {
                        configuration.set("config_value", (Object)"0");
                    }
                    SaveServiceHelper.save((DynamicObject[])configurations);
                } else {
                    DynamicObject configuration2 = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
                    configuration2.set("config_type", (Object)"rim_deduction");
                    configuration2.set("config_key", (Object)"rim_deduction_update_downaccount_org");
                    configuration2.set("config_value", (Object)"0");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{configuration2});
                }
                CacheHelper.remove((String)"rim_deduction");
            }
            catch (Exception e) {
                LOGGER.error("\u521d\u59cb\u5316\u4e0b\u8f7d\u53f0\u8d26org\u62a5\u9519", (Throwable)e);
            }
        }
        return 0;
    }
}

