/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InvoiceApplyLogService;
import kd.imc.rim.common.invoice.download.InvoiceApplyServiceTask;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.schedule.invoicedownload.service.InvoiceDownTaskHelper;
import org.apache.commons.compress.utils.Lists;

public class SynchPermitTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SynchPermitTask.class);
    private static final String CONFIG_KEY = "inoutput_apply_size";
    private static int THREADPOOL_SIZE = RimConfigUtils.getPageSizeFromConfig((int)3, (String)"rim_sch", (String)"inoutput_apply_pool_size");
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"InputOutputApplyTask", (int)THREADPOOL_SIZE);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u4e0b\u8f7d\u8bb8\u53ef\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"FullInvoiceDownApplyLockTask", (String)"InvoiceDownApplyLockTask.lock");){
            if (lock.tryLock()) {
                int pageSize;
                List<Long> idList = InvoiceDownTaskHelper.getDownIds("invoice_down_init_cache");
                Object[] downloadSetting = InvoiceDownTaskHelper.getDownDynamicObject("rim_down_init", idList, pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)200, (String)CONFIG_KEY), "invoice_down_init_cache");
                if (!ObjectUtils.isEmpty((Object[])downloadSetting)) {
                    ArrayList taxNoList = Lists.newArrayList();
                    for (Object dynamicObject : downloadSetting) {
                        DynamicObjectCollection orgList = dynamicObject.getDynamicObjectCollection("userorg");
                        if (ObjectUtils.isEmpty((Object)orgList)) continue;
                        Date begin = null;
                        if (dynamicObject.getDate("end") == null) {
                            begin = dynamicObject.getDate("begin");
                        }
                        Long id = dynamicObject.getLong("id");
                        for (DynamicObject item : orgList) {
                            JSONObject taxJson = new JSONObject();
                            taxJson.put("configId", (Object)id);
                            taxJson.put("begin", (Object)begin);
                            taxJson.put("taxNo", item.get("taxpayer_tax_no"));
                            taxJson.put("orgId", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)item.get("taxpayer_org")));
                            taxNoList.add(taxJson);
                        }
                    }
                    this.dealApply(taxNoList);
                }
                InvoiceApplyLogService service = new InvoiceApplyLogService();
                service.executeApply();
            } else {
                LOGGER.info("InvoiceDownApplyLockTask-Lock");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u4e0b\u8f7d\u8bb8\u53ef\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void dealApply(List<JSONObject> taxNoList) {
        if (ObjectUtils.isEmpty(taxNoList)) {
            return;
        }
        ArrayList<Future> futureList = new ArrayList<Future>(8);
        int index = 0;
        for (JSONObject taxJson : taxNoList) {
            InvoiceApplyServiceTask task = new InvoiceApplyServiceTask(taxJson);
            futureList.add(threadPool.submit((Callable)task));
            CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)(++index));
        }
        CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)THREADPOOL_SIZE);
    }

    static {
        LOGGER.info("\u7533\u8bf7\u8fdb\u9500\u9879\u4e0b\u8f7d\u4efb\u52a1\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60:{}", (Object)THREADPOOL_SIZE);
    }
}

