/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.recorded;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.recorded.AutoRecordedService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;

public class AutoRecordedTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AutoRecordedTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u81ea\u52a8\u5165\u8d26\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        try (DLock lock = DLock.create((String)"AutoRecordedTask", (String)"AutoRecordedTask");){
            if (lock.tryLock()) {
                QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_auto_recorded_task", (String)"id", (QFilter[])qFilter.toArray());
                Object[] ids = collection.stream().map(s -> s.get("id")).toArray();
                Object[] configs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_auto_recorded_task"));
                if (!ObjectUtils.isEmpty((Object[])configs)) {
                    for (Object config : configs) {
                        this.doTask((DynamicObject)config);
                    }
                }
            } else {
                LOGGER.info("AutoRecordedTask-Lock");
            }
        }
    }

    public void doTask(DynamicObject config) {
        AutoRecordedService recordedService = new AutoRecordedService();
        DynamicObjectCollection userorg = config.getDynamicObjectCollection("userorg");
        if (CollectionUtils.isEmpty((Collection)userorg)) {
            String closeOrgAutoRecord = ImcConfigUtil.getValue((String)"rim_recorded", (String)"close_org_auto_record");
            if ("1".equals(closeOrgAutoRecord)) {
                LOGGER.info("\u81ea\u52a8\u5165\u5e10-\u5173\u95ed\u9ed8\u8ba4\u65b9\u6848");
                return;
            }
            QFilter groupFilter = new QFilter("servergroup", "=", (Object)"1");
            QFilter stateFilter = new QFilter("authstate", "=", (Object)"1");
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"id,orginfo.id as org_id,epinfo.name as name, epinfo.number as tax_no, authstate", (QFilter[])new QFilter[]{groupFilter, stateFilter});
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                LOGGER.info("\u4e0d\u5b58\u5728\u7ec4\u7ec7\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u5173\u8054\u6240\u6709\u7ec4\u7ec7");
                return;
            }
            Long createorg = config.getLong("createorg");
            HashSet<String> taxNoSet = new HashSet<String>();
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                Long orgId;
                DynamicObject org = (DynamicObject)dynamicObjectCollection.get(i);
                if (org == null || (orgId = Long.valueOf(org.getLong("org_id"))) == null || orgId <= 0L) continue;
                String name = org.getString("name");
                String taxNo = org.getString("tax_no");
                if (!StringUtils.isNotBlank((CharSequence)taxNo) || !taxNoSet.add(taxNo)) continue;
                if (createorg == null || createorg <= 0L) {
                    createorg = orgId;
                }
                DynamicObject item = userorg.addNew();
                item.set("seq", (Object)(i + 1));
                item.set("taxpayer_org", (Object)orgId);
                item.set("taxpayer_tax_no", (Object)taxNo);
                item.set("taxpayer_name", (Object)name);
            }
            config.set("createorg", (Object)createorg);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
        }
        if (CollectionUtils.isEmpty((Collection)userorg)) {
            LOGGER.info("\u4e0d\u5b58\u5728\u7ec4\u7ec7\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u5165\u5e10\uff0c\u914d\u7f6eid: {}", config.get("id"));
            return;
        }
        int queryInvoiceSize = RimConfigUtils.getPageSizeFromConfig((int)100, (String)"rim_recorded", (String)"auto_taxno_size");
        if (queryInvoiceSize < 0) {
            queryInvoiceSize = 100;
        }
        for (int i = 0; i < userorg.size(); ++i) {
            if (i >= queryInvoiceSize) {
                LOGGER.info("\u6267\u884c\u7684\u7a0e\u53f7\u4e0d\u8d85\u8fc7\uff0c\u6267\u884c\u7a0e\u53f7\u4e2a\u6570, {}, \u914d\u7f6eid: {}", (Object)queryInvoiceSize, config.get("id"));
                break;
            }
            DynamicObject orgObj = (DynamicObject)userorg.get(i);
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgObj.get("taxpayer_org"));
            recordedService.AutoRecorded(config, orgId, orgObj.getString("taxpayer_tax_no"));
        }
    }
}

