/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class RimPermissonTransferUpgradeUtil {
    private final Log logger = LogFactory.getLog(RimPermissonTransferUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermResult upgrade(List<Object[]> oldEntPerItem2NewMapList, StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermItemAuthUpgradeUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == oldEntPerItem2NewMapList || oldEntPerItem2NewMapList.isEmpty()) {
                this.logger.info("AppendPermItemAuthUpgradeUtil.upgrade, oldEntPerItem2NewMapList is empty.");
                PermResult permResult = PermResult.ok();
                return permResult;
            }
            for (int i = 0; i < oldEntPerItem2NewMapList.size(); ++i) {
                Object[] oldEntPerItem2NewMap = oldEntPerItem2NewMapList.get(i);
                if (null == oldEntPerItem2NewMap || Objects.equals(0, oldEntPerItem2NewMap.length)) {
                    this.logger.info("AppendPermItemAuthUpgradeUtil.upgrade, oldEntPerItem2NewMap is empty, i:{}", (Object)i);
                    continue;
                }
                Object oldEntNumObj = oldEntPerItem2NewMap[0];
                Object oldPermItemIdObj = oldEntPerItem2NewMap[1];
                Object newEntNumObj = oldEntPerItem2NewMap[2];
                Object newPermItemIdObj = oldEntPerItem2NewMap[3];
                if (Objects.isNull(newEntNumObj) || Objects.isNull(newPermItemIdObj)) {
                    this.logger.info("AppendPermItemAuthUpgradeUtil.upgrade, oldEntNumObj:{}, oldPermItemIdObj:{}, newEntNumObj:{}, newPermItemIdObj:{}, i:{}", new Object[]{oldEntNumObj, oldPermItemIdObj, newEntNumObj, newPermItemIdObj, i});
                    continue;
                }
                String newEntNum = (String)newEntNumObj;
                String newPermItemId = (String)newPermItemIdObj;
                if (StringUtils.isEmpty((String)newEntNum) || StringUtils.isEmpty((String)newPermItemId)) {
                    this.logger.info("AppendPermItemAuthUpgradeUtil.upgrade, newEntNum or newPermItemId is empty, oldEntNumObj:{}, oldPermItemIdObj:{}, newEntNum:{}, newPermItemId:{}, i:{}", new Object[]{oldEntNumObj, oldPermItemIdObj, newEntNum, newPermItemId, i});
                    continue;
                }
                Object threeStrategyEntryIdObj = Objects.equals(4, oldEntPerItem2NewMap.length) ? null : oldEntPerItem2NewMap[4];
                Object[] threeStrategyEntryIdArr = Objects.isNull(threeStrategyEntryIdObj) ? new Long[]{} : (Long[])threeStrategyEntryIdObj;
                String oldEntNum = Objects.isNull(oldEntNumObj) ? "" : (String)oldEntNumObj;
                String oldPermItemId = Objects.isNull(oldPermItemIdObj) ? "" : (String)oldPermItemIdObj;
                try (TXHandle h = TX.requiresNew();){
                    try {
                        if (threeStrategyEntryIdArr.length > 0 && StringUtils.isNotEmpty((String)newEntNum) && StringUtils.isNotEmpty((String)newPermItemId)) {
                            this.appendAdminSchemeDetail((Long[])threeStrategyEntryIdArr, newEntNum, newPermItemId);
                        }
                        if (!StringUtils.isNotEmpty((String)oldEntNum) || !StringUtils.isNotEmpty((String)oldPermItemId) || !StringUtils.isNotEmpty((String)newEntNum) || !StringUtils.isNotEmpty((String)newPermItemId)) continue;
                        ArrayList oldEntNumList = Lists.newArrayList((Object[])new String[]{oldEntNum});
                        Map oldEntNumAppIdMap = FormHelper.getAppIdByFormNum((List)oldEntNumList);
                        String oldAppId = (String)oldEntNumAppIdMap.get(oldEntNum);
                        ArrayList newEntNumList = Lists.newArrayList((Object[])new String[]{newEntNum});
                        Map newEntNumAppIdMap = FormHelper.getAppIdByFormNum((List)newEntNumList);
                        String newAppId = (String)newEntNumAppIdMap.get(newEntNum);
                        if (StringUtils.isNotEmpty((String)oldAppId) && StringUtils.isNotEmpty((String)newAppId) && !Objects.equals(oldAppId, newAppId)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u65e7\u8868\u5355\u4e0e\u65b0\u8868\u5355\u6240\u5c5e\u5e94\u7528\u4e0d\u4e00\u81f4\u3002", (String)"AppendPermItemAuthUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
                        }
                        this.copyPermForAdmingroupFunperm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        this.copyPermForUserPermDetail(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        this.copyPermForDisFunPerm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        this.copyPermForRolePermDetail(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        this.copyPermForBizRolePerm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        this.copyPermForBizRoleDisPerm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        continue;
                    }
                    catch (Exception e) {
                        String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u8ffd\u52a0\u6743\u9650\u9879\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0coldEntNum\uff1a%1$s\uff0coldPermItemId\uff1a%2$s\uff0cnewEntNum\uff1a%3$s\uff0cnewPermItemId\uff1a%4$s\uff0cthreeStrategyEntryIdArr\uff1a%5$s\uff0c%6$s", (String)"AppendPermItemAuthUpgradeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0]), oldEntNum, oldPermItemId, newEntNum, newPermItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage());
                        this.logger.error(errInfo, (Throwable)e);
                        h.markRollback();
                        pProcessInfo.append(errInfo);
                        this.addOperLog(errInfo);
                        throw e;
                    }
                }
            }
        }
        catch (Exception e) {
            PermResult permResult = PermResult.fail((String)e.getMessage());
            return permResult;
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            if (null != lock) {
                lock.unlock();
            }
        }
        return PermResult.ok();
    }

    private void appendAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String newEntNum, String ... newPermItemIds) {
        HashMap<String, String> appEntMap = new HashMap<String, String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fnumber, a.fbizappid");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" inner join t_meta_bizapp b on a.fbizappid = b.fid");
        HashSet cloudSet = Sets.newHashSet((Object[])new String[]{"0QLCSO6KKZC9", "83bfebc800000bac"});
        String cloudSetStr = String.join((CharSequence)"','", cloudSet);
        sb.append(" where b.fbizcloudid in ('").append(cloudSetStr).append("')");
        sb.append(" and a.fnumber = ? ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{newEntNum}, rs -> {
            while (rs.next()) {
                String fbizappid = rs.getString("fbizappid");
                String fnumber = rs.getString("fnumber");
                if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fnumber)) continue;
                appEntMap.put(fbizappid, fnumber);
            }
            return null;
        });
        if (appEntMap.isEmpty()) {
            return;
        }
        Set<String> exist = this.queryForAdminSchemeDetail(threeStrategyEntryIdArr, appEntMap, newPermItemIds);
        int size = threeStrategyEntryIdArr.length * appEntMap.size() * newPermItemIds.length - exist.size();
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int idx = 0;
        for (Long threeStrategyEntryId : threeStrategyEntryIdArr) {
            for (String newPermItemId : newPermItemIds) {
                for (Map.Entry appEnt : appEntMap.entrySet()) {
                    String appId = (String)appEnt.getKey();
                    String entNum = (String)appEnt.getValue();
                    String unique = threeStrategyEntryId + "_" + appId + "_" + entNum + "_" + newPermItemId;
                    if (exist.contains(unique)) continue;
                    paramList.add(new Object[]{threeStrategyEntryId, detailIds[idx], 0, appId, entNum, newPermItemId});
                    ++idx;
                }
            }
        }
        String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
        SqlUtil.syncInsert(paramList, (String)sql, (Integer)5000, (DBRoute)DBRoute.base, (boolean)true);
    }

    private Set<String> queryForAdminSchemeDetail(Long[] threeStrategyEntryIdArr, Map<String, String> appEntMap, String[] newPermItemIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail where 1=1 ", new Object[0]);
        sqlBuilder.appendIn(" and fentryid", (Object[])threeStrategyEntryIdArr);
        sqlBuilder.appendIn(" and fbizappid", (Object[])appEntMap.keySet().toArray(new String[0]));
        sqlBuilder.appendIn(" and fentitynum", (Object[])appEntMap.values().toArray(new String[0]));
        sqlBuilder.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, rs -> {
            HashSet<String> exist = new HashSet<String>(8);
            while (rs.next()) {
                exist.add(rs.getObject("fentryid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
            }
            return exist;
        });
    }

    private void copyPermForBizRoleDisPerm(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = this.queryForBizRoleDisPerm(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = this.existForBizRoleDisPerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        this.insertForBizRoleDisPerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private void insertForBizRoleDisPerm(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroledisperm", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(count * newPermItemIds.length);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + row.get("fbizappid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, row.get("fbizappid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        String insertSql = "INSERT INTO t_perm_bizroledisperm (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid) VALUES(?,?,?,?,?,?);";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
    }

    private int existForBizRoleDisPerm(Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, rs -> {
            while (rs.next()) {
                exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
            }
            return exist;
        });
        return count;
    }

    private DataSet queryForBizRoleDisPerm(String oldEntityTypeId, String oldPermItemId) {
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        String querySql = "select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm  where fentitytypeid = ? and fpermitemid = ? ";
        return DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForBizRoleDisPerm", (DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParam);
    }

    private void copyPermForBizRolePerm(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = this.queryForBizRolePerm(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = this.existForBizRolePerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        this.insertForBizRolePerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private void insertForBizRolePerm(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroleperm", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + row.get("fbizappid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, row.get("fbizappid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        String insertSql = "INSERT INTO t_perm_bizroleperm (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid) VALUES(?,?,?,?,?,?);";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
    }

    private int existForBizRolePerm(Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, rs -> {
            while (rs.next()) {
                exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
            }
            return exist;
        });
        return count;
    }

    private DataSet queryForBizRolePerm(String oldEntityTypeId, String oldPermItemId) {
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        String querySql = "select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm  where fentitytypeid = ? and fpermitemid = ? ";
        return DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParam);
    }

    private void copyPermForDisFunPerm(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = this.queryForDisFunPerm(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = this.existForDisFunPerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        this.insertForUserRoleDisFunPerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private void insertForUserRoleDisFunPerm(Set<String> exist, DataSet copy, int count, String newEntityTypeId, String ... newPermItemIds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_disfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : copy) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("forgid") + "_" + row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("fdimtype") + "_" + row.get("fisincludesuborg");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{ids[index++], row.get("fuserid"), row.get("forgid"), newPermItemId, newEntityTypeId, row.get("fentryid"), row.get("ffrom"), row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid"), row.get("fdimtype"), row.get("fisincludesuborg")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        String insertSql = "INSERT INTO t_perm_disfunperm (fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg) VALUES(?,?,?,?,?,?,?,?,?,?,?,?);";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
    }

    private DataSet queryForDisFunPerm(String oldEntityTypeId, String oldPermItemId) {
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        String querySql = "select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm  where fentitytypeid = ? and fpermitemid = ? ";
        return DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForDisFunPerm", (DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParam);
    }

    private int existForDisFunPerm(Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> orgIds = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            orgIds.add(row.get("forgid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,forgid,fbizappid,fentitytypeid,fpermitemid,fdimtype,fisincludesuborg from t_perm_disfunperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            existSql.appendIn(" and forgid ", orgIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, rs -> {
            while (rs.next()) {
                exist.add(rs.getObject("fuserid") + "_" + rs.getObject("forgid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesuborg"));
            }
            return exist;
        });
        return count;
    }

    private void copyPermForRolePermDetail(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = this.queryForRolePermDetail(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = this.existForRolePermDetail(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        this.insertForUserRolePermDetail(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private DataSet queryForRolePermDetail(String oldEntityTypeId, String oldPermItemId) {
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        String querySql = "select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial  where fentitytypeid = ? and fpermitemid = ? ";
        return DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForRolePermDetail", (DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParam);
    }

    private int existForRolePermDetail(Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        HashSet<Object> roleIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            bizAppIds.add(row.get("fbizappid"));
            roleIds.add(row.get("froleid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fbizappid,fentitytypeid,fpermitemid,froleid from t_perm_rolepermdetial", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(roleIds)) {
            existSql.appendIn(" and froleid", roleIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, rs -> {
            while (rs.next()) {
                exist.add(rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("froleid"));
            }
            return exist;
        });
        return count;
    }

    private void insertForUserRolePermDetail(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String ... newPermItemIds) {
        String[] entryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("froleid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), entryIds[index++], row.get("fseq"), row.get("fcontrolmode"), newPermItemId, row.get("finheritmode"), newEntityTypeId, row.get("fbizappid"), row.get("froleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        String insertSql = "INSERT INTO t_perm_rolepermdetial (fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid) VALUES(?,?,?,?,?,?,?,?,?);";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
    }

    private void copyPermForUserPermDetail(String oldEntNum, String newEntNum, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = this.queryForUserPermDetail(oldEntNum, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = this.existForUserPermDetail(exist, dataSet.copy(), newEntNum, newPermItemIds);
        this.insertForUserPermDetail(exist, dataSet, count, newEntNum, newPermItemIds);
    }

    private DataSet queryForUserPermDetail(String oldEntNum, String oldPermItemId) {
        Object[] queryParam = new Object[]{oldEntNum, oldPermItemId};
        String querySql = "select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail  where fentitytypeid = ? and fpermitemid = ? ";
        return DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForUserPermDetail", (DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParam);
    }

    private int existForUserPermDetail(Set<String> exist, DataSet dataSet, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        HashSet<Object> dimIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            bizAppIds.add(row.get("fbizappid"));
            dimIds.add(row.get("fdimid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,fbizappid,fentitytypeid,fpermitemid,fdimid,fdimtype,fisincludesub from t_perm_userpermdetail", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and  fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(dimIds)) {
            existSql.appendIn(" and fdimid ", dimIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, rs -> {
            while (rs.next()) {
                exist.add(rs.getObject("fuserid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesub"));
            }
            return exist;
        });
        return count;
    }

    private void insertForUserPermDetail(Set<String> exist, DataSet dataSet, int count, String newEntNum, String ... newPermItemIds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_userpermdetail", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("fbizappid") + "_" + newEntNum + "_" + newPermItemId + "_" + row.get("fdimid") + "_" + row.get("fdimtype") + "_" + row.get("fisincludesub");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), row.get("fuserid"), row.get("fdimtype"), row.get("fdimid"), row.get("fisincludesub"), String.valueOf(entryIds[index++]), row.get("fseq"), row.get("fcontrolmode"), newPermItemId, newEntNum, row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        String insertSql = "INSERT INTO t_perm_userpermdetail (fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
    }

    private void copyPermForAdmingroupFunperm(String oldEntNum, String newEntNum, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = this.queryForAdmingroupFunperm(oldEntNum, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = this.existForAdmingroupFunperm(exist, dataSet.copy(), newEntNum, newPermItemIds);
        this.insertForAdmingroupFunperm(exist, dataSet, count, newEntNum, newPermItemIds);
    }

    private DataSet queryForAdmingroupFunperm(String oldEntNum, String oldPermItemId) {
        Object[] queryParam = new Object[]{oldEntNum, oldPermItemId};
        String querySql = "select fid, fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm  where fentitynum = ? and fpermitemid = ? ";
        return DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForAdmingroupFunperm", (DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParam);
    }

    private int existForAdmingroupFunperm(Set<String> exist, DataSet dataSet, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> usrgrpIds = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            usrgrpIds.add(row.get("fusergroupid"));
            bizAppIds.add(row.get("fappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm", new Object[0]);
        existSql.append(" where fentitynum = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(usrgrpIds)) {
            existSql.appendIn(" and  fusergroupid ", usrgrpIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, rs -> {
            while (rs.next()) {
                exist.add(rs.getObject("fusergroupid") + "_" + rs.getObject("fappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
            }
            return exist;
        });
        return count;
    }

    private void insertForAdmingroupFunperm(Set<String> exist, DataSet dataSet, int count, String newEntNum, String ... newPermItemIds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_admingroupfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fusergroupid") + "_" + row.get("fappid") + "_" + newEntNum + "_" + newPermItemId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fusergroupid"), row.get("fappid"), newPermItemId, newEntNum};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        String insertSql = "INSERT INTO t_perm_admingroupfunperm (fid, fusergroupid, fappid, fpermitemid, fentitynum) VALUES(?,?,?,?,?);";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
    }

    private void addOperLog(String procInfo) {
        AppLogInfo appLogInfo = new AppLogInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOpName(ResManager.loadKDString((String)"\u3010\u8ffd\u52a0\u6743\u9650\u9879\u6388\u6743\u3011\u5347\u7ea7", (String)"AppendPermItemAuthUpgradeUtil_2", (String)"bos-permission-cache", (Object[])new Object[0]));
        appLogInfo.setOpDescription(procInfo);
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }
}

