/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.aws.ofd.util.model.VatInvoice;
import kd.imc.aws.ofd.util.model.VatInvoiceItem;
import kd.imc.rim.file.pdfanalysis.utils.ReUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.ReflectUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.ZeroTaxRateFlagEnum;
import kd.imc.rim.file.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoiceReadUtils {
    public static void setPatternMatchValue(Object invoice, String allText, String reg, String[] keys) {
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, reg, keys, false);
    }

    public static void setPatternMatchValue(Object invoice, String allText, String reg, String[] keys, boolean repeatFlag) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(allText);
        block0: while (matcher.find()) {
            int matchNum = matcher.groupCount();
            int valueNum = 0;
            for (String key : keys) {
                Object fieldValue;
                if (matcher.group(key) == null) continue;
                String value = matcher.group(key);
                Field field = ReflectUtil.getField(invoice.getClass(), (String)key);
                if (field == null || (fieldValue = ReflectUtil.getFieldValue((Object)invoice, (Field)field)) != null && (!repeatFlag || StrUtil.isEmpty((CharSequence)value))) continue;
                ReflectUtil.setFieldValue((Object)invoice, (Field)field, (Object)matcher.group(key));
                if (++valueNum == matchNum) continue block0;
            }
        }
    }

    public static void setInvoiceAmount(VatInvoice invoice, String allText) {
        String totalAmount = DigitalPdfConstants.ZERO_STR;
        String totalTax = DigitalPdfConstants.ZERO_STR;
        String totalAmountStr = ReUtil.get((String)"\u5408\u8ba1\u00a5(?<invoiceAmount>\\S*)", (CharSequence)allText.replace("\n", ""), (int)1);
        String[] totalAmountArr = totalAmountStr.split("\u00a5");
        if (totalAmountArr.length == 2) {
            totalAmount = totalAmountArr[0];
            totalTax = totalAmountArr[1];
        } else if (totalAmountArr.length == 4) {
            totalAmount = totalAmountArr[1];
            if (StringUtils.isNotEmpty((CharSequence)totalAmountArr[0])) {
                totalAmount = totalAmountArr[0] + totalAmount;
            }
            totalTax = totalAmountArr[3];
            if (StringUtils.isNotEmpty((CharSequence)totalAmountArr[2])) {
                totalTax = totalAmountArr[2] + totalTax;
            }
        } else if (totalAmountStr.endsWith("***")) {
            totalAmount = totalAmountStr.substring(0, totalAmountStr.length() - 3);
        }
        totalAmount = totalAmount.replace("***", "0");
        totalTax = totalTax.replace("***", "0");
        invoice.setInvoiceAmount(totalAmount);
        invoice.setTotalTaxAmount(totalTax);
    }

    public static List<TextCode> getItemHeadList(List<TextCode> xList) {
        ArrayList<TextCode> headList = new ArrayList<TextCode>(4);
        for (int i = 0; i < xList.size(); ++i) {
            TextCode pdfTextCode = xList.get(i);
            BigDecimal xLength = pdfTextCode.getWidth();
            String content = InvoiceReadUtils.replaceSpaceToEmpty(pdfTextCode.getContent());
            if (content != null && content.length() == 1 && i < xList.size() - 1) {
                TextCode nextTextCode = xList.get(++i);
                content = content + InvoiceReadUtils.replaceSpaceToEmpty(nextTextCode.getContent());
                xLength = xLength.add(nextTextCode.getWidth());
            }
            pdfTextCode.setWidth(xLength.add(pdfTextCode.getX()).add(new BigDecimal("4")));
            pdfTextCode.setContent(content);
            headList.add(pdfTextCode);
        }
        return headList;
    }

    public static VatInvoiceItem getItemByXList(List<TextCode> xList, List<TextCode> headList, boolean vatFlag) {
        VatInvoiceItem vatInvoiceItem = new VatInvoiceItem();
        block0: for (TextCode pdfTextCode : xList) {
            BigDecimal x = pdfTextCode.getX();
            for (int i = 0; i < headList.size(); ++i) {
                TextCode headPre = null;
                TextCode headNext = null;
                if (i > 0) {
                    headPre = headList.get(i - 1);
                }
                if (i < headList.size() - 1) {
                    headNext = headList.get(i + 1);
                }
                TextCode head = headList.get(i);
                if ((headPre != null || x.compareTo(head.getWidth()) >= 0) && (headPre == null || x.compareTo(headPre.getWidth().subtract(new BigDecimal("3"))) < 0) || headNext != null && x.add(pdfTextCode.getWidth()).compareTo(headNext.getX()) >= 0) continue;
                String headContent = head.getContent();
                String content = pdfTextCode.getContent();
                InvoiceReadUtils.setItemModel(vatInvoiceItem, headContent, content, vatFlag);
                continue block0;
            }
        }
        return vatInvoiceItem;
    }

    private static void setItemModel(VatInvoiceItem vatInvoiceItem, String headContent, String content, boolean vatFlag) {
        content = StrUtil.nullToEmpty((Object)content);
        if ("\u9879\u76ee\u540d\u79f0".equals(headContent) || vatFlag && headContent.contains("\u540d\u79f0")) {
            vatInvoiceItem.setGoodsName(StrUtil.nullToEmpty((Object)vatInvoiceItem.getGoodsName()) + content);
        } else if ("\u89c4\u683c\u578b\u53f7".equals(headContent) || headContent.contains("\u4ea7\u6743\u8bc1\u53f7") || headContent.contains("\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730")) {
            vatInvoiceItem.setSpecModel(StrUtil.nullToEmpty((Object)vatInvoiceItem.getSpecModel()) + content);
        } else if (headContent.contains("\u5355\u4f4d") || headContent.contains("\u5efa\u7b51\u9879\u76ee\u540d\u79f0")) {
            vatInvoiceItem.setUnit(StrUtil.nullToEmpty((Object)vatInvoiceItem.getUnit()) + content);
        } else if ("\u6570\u91cf".equals(headContent)) {
            vatInvoiceItem.setNum(content);
        } else if ("\u5355\u4ef7".equals(headContent)) {
            vatInvoiceItem.setUnitPrice(content);
        } else if (headContent.contains("\u7a0e\u7387")) {
            InvoiceReadUtils.setTaxRate(vatInvoiceItem, content);
        } else if ("\u91d1\u989d".equals(headContent)) {
            vatInvoiceItem.setDetailAmount(content);
        } else if ("\u7a0e\u989d".equals(headContent)) {
            if ("***".equals(content)) {
                content = "0";
            }
            vatInvoiceItem.setTaxAmount(content);
        }
    }

    private static void setTaxRate(VatInvoiceItem vatInvoiceItem, String taxRate) {
        ZeroTaxRateFlagEnum zeroTaxRateFlag = ZeroTaxRateFlagEnum.getZeroTaxRateFlagByMsg((String)taxRate);
        if (zeroTaxRateFlag != null) {
            vatInvoiceItem.setZeroTaxRateFlag(zeroTaxRateFlag.getValue());
            vatInvoiceItem.setTaxRate("0");
            return;
        }
        String taxRateNum = InvoiceReadUtils.getTaxRate(taxRate);
        if ("0".equals(taxRateNum)) {
            vatInvoiceItem.setZeroTaxRateFlag(ZeroTaxRateFlagEnum.ZERO_RATE.getValue());
        }
        vatInvoiceItem.setTaxRate(taxRateNum);
    }

    public static void setModelItemData(VatInvoice vatInvoice, List<VatInvoiceItem> itemList) {
        ArrayList<VatInvoiceItem> finalItemList = new ArrayList<VatInvoiceItem>();
        block0: for (int i = 0; i < itemList.size(); ++i) {
            VatInvoiceItem vatInvoiceItem = itemList.get(i);
            while (true) {
                if (i == itemList.size() - 1) {
                    String detailAmount = vatInvoiceItem.getDetailAmount();
                    if (detailAmount != null && detailAmount.contains("\u00a5")) continue block0;
                    finalItemList.add(vatInvoiceItem);
                    continue block0;
                }
                VatInvoiceItem vatInvoiceItemNext = itemList.get(i + 1);
                if (vatInvoiceItemNext.getTaxAmount() != null && vatInvoiceItem.getTaxAmount() != null) {
                    finalItemList.add(vatInvoiceItem);
                    continue block0;
                }
                if (vatInvoiceItemNext.getGoodsName() != null) {
                    vatInvoiceItem.setGoodsName(StringUtils.stripToEmpty((String)vatInvoiceItem.getGoodsName()) + vatInvoiceItemNext.getGoodsName());
                }
                if (vatInvoiceItemNext.getSpecModel() != null) {
                    vatInvoiceItem.setSpecModel(StringUtils.stripToEmpty((String)vatInvoiceItem.getSpecModel()) + vatInvoiceItemNext.getSpecModel());
                }
                if (vatInvoiceItemNext.getUnit() != null) {
                    vatInvoiceItem.setUnit(StringUtils.stripToEmpty((String)vatInvoiceItem.getUnit()) + vatInvoiceItemNext.getUnit());
                }
                if (vatInvoiceItemNext.getNum() != null) {
                    vatInvoiceItem.setNum(StringUtils.stripToEmpty((String)vatInvoiceItem.getNum()) + vatInvoiceItemNext.getNum());
                }
                if (vatInvoiceItemNext.getUnitPrice() != null) {
                    vatInvoiceItem.setUnitPrice(StringUtils.stripToEmpty((String)vatInvoiceItem.getUnitPrice()) + vatInvoiceItemNext.getUnitPrice());
                }
                if (vatInvoiceItemNext.getDetailAmount() != null) {
                    vatInvoiceItem.setDetailAmount(StringUtils.stripToEmpty((String)vatInvoiceItem.getDetailAmount()) + vatInvoiceItemNext.getDetailAmount());
                }
                if (vatInvoiceItemNext.getTaxRate() != null) {
                    vatInvoiceItem.setTaxRate(StringUtils.stripToEmpty((String)vatInvoiceItem.getTaxRate()) + vatInvoiceItemNext.getTaxRate());
                }
                ++i;
            }
        }
        vatInvoice.setItem(finalItemList);
    }

    public static String getLineText(List<TextCode> pdfTextCodeList, BigDecimal leftX, BigDecimal rightX, JSONObject param) {
        StringBuilder sb = new StringBuilder();
        BigDecimal startX = BigDecimal.ZERO;
        BigDecimal width = BigDecimal.ZERO;
        BigDecimal lastRightX = BigDecimal.ZERO;
        for (TextCode code : pdfTextCodeList) {
            BigDecimal x = code.getX();
            if (x.compareTo(leftX.add(new BigDecimal("3"))) <= 0 || rightX != null && x.compareTo(rightX) >= 0 || InvoiceReadUtils.checkMoreThanEnd(param, x) && x.subtract(lastRightX).abs().compareTo(new BigDecimal("20")) > 0) continue;
            if (startX.compareTo(BigDecimal.ZERO) == 0) {
                startX = x;
            }
            sb.append(code.getContent());
            width = width.add(code.getWidth());
            lastRightX = x.add(code.getWidth());
        }
        if (sb.length() > 0) {
            InvoiceReadUtils.setParamJsom(param, startX, startX.add(width));
        }
        return sb.toString();
    }

    private static boolean checkMoreThanEnd(JSONObject param, BigDecimal x) {
        if (param == null || param.getBigDecimal("endX") == null) {
            return false;
        }
        BigDecimal endX = param.getBigDecimal("endX");
        return x.compareTo(endX) > 0;
    }

    private static void setParamJsom(JSONObject param, BigDecimal x, BigDecimal currentEndX) {
        if (param != null) {
            if (!param.containsKey((Object)"startX")) {
                param.put("startX", (Object)x);
            }
            param.put("currentStartX", (Object)x);
            BigDecimal endX = param.getBigDecimal("endX");
            if (endX == null || currentEndX.compareTo(endX) > 0) {
                param.put("endX", (Object)currentEndX);
            }
        }
    }

    public static String replaceSpaceToEmpty(String str) {
        if (str != null) {
            str = str.replace(" ", "");
        }
        return str;
    }

    public static String getTaxRate(String taxRate) {
        if (taxRate != null && taxRate.contains("%")) {
            String taxRateStr = taxRate.replace("%", "");
            BigDecimal taxRateBig = new BigDecimal(taxRateStr).divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP).stripTrailingZeros();
            taxRate = taxRateBig.toPlainString();
        }
        return taxRate;
    }

    public static String formatDate(String str) {
        if (str == null) {
            return null;
        }
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = inputFormat.parse(str);
            return outputFormat.format(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean setPatternMatchValueTrain(Object invoice, String allText, String reg, String[] keys) {
        return InvoiceReadUtils.setPatternMatchValueTrain(invoice, allText, reg, keys, false);
    }

    public static boolean setPatternMatchValueTrain(Object invoice, String allText, String reg, String[] keys, boolean repeatFlag) {
        boolean isMatch = false;
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(allText);
        block0: while (matcher.find()) {
            int matchNum = matcher.groupCount();
            int valueNum = 0;
            for (String key : keys) {
                Object fieldValue;
                if (matcher.group(key) == null) continue;
                String value = matcher.group(key);
                Field field = ReflectUtil.getField(invoice.getClass(), (String)key);
                if (field == null || (fieldValue = ReflectUtil.getFieldValue((Object)invoice, (Field)field)) != null && (!repeatFlag || StrUtil.isEmpty((CharSequence)value))) continue;
                ReflectUtil.setFieldValue((Object)invoice, (Field)field, (Object)matcher.group(key));
                isMatch = true;
                if (++valueNum == matchNum) continue block0;
            }
        }
        return isMatch;
    }
}

