/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.imc.aws.ofd.constant.TrainEleTicketConstants;
import kd.imc.aws.ofd.util.analysis.IOfdRead;
import kd.imc.aws.ofd.util.analysis.InvoiceReadUtils;
import kd.imc.aws.ofd.util.analysis.OfdReadUtils;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.aws.ofd.util.model.TrainEleTicket;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class TrainEleTicketOfdRead
implements IOfdRead {
    public JSONObject readData(List<Element> svgList, InvoiceTypeEnum invoiceType) {
        Element pageEle = svgList.get(0);
        List<List<TextCode>> codeList = OfdReadUtils.getListByMap(pageEle);
        TrainEleTicket trainEleTicket = this.getTrainEleTickets(codeList, invoiceType);
        return OfdReadUtils.getReturnJson("4", null, null, trainEleTicket);
    }

    private TrainEleTicket getTrainEleTickets(List<List<TextCode>> contentList, InvoiceTypeEnum invoiceType) {
        TrainEleTicket trainEleTicket = new TrainEleTicket(invoiceType.getCode());
        int lineIndex = 1;
        for (List<TextCode> xList : contentList) {
            boolean isTure;
            StringBuilder lineContentBuilder = new StringBuilder();
            for (TextCode TextCode2 : xList) {
                String content = TextCode2.getContent();
                lineContentBuilder.append(content);
                if (content != null && ((content = content.replace("\uff1a", ":")).endsWith(":") || content.endsWith("\u00a5"))) continue;
                lineContentBuilder.append(" ");
            }
            String lineContent = lineContentBuilder.toString();
            if (!(lineIndex != 6 || lineContent.contains("\u91d1\u989d") || lineContent.contains("\u7a0e\u7387") || lineContent.contains("\u7a0e\u989d"))) {
                ++lineIndex;
            }
            if (lineIndex == 8 && !lineContent.contains("\u5df2\u9000\u91d1\u989d")) {
                ++lineIndex;
            }
            if (!(isTure = TrainEleTicketOfdRead.setDataWithLineStr(trainEleTicket, lineContent, lineIndex))) continue;
            ++lineIndex;
        }
        trainEleTicket.setTaxRate(InvoiceReadUtils.getTaxRate(trainEleTicket.getTaxRate()));
        return trainEleTicket;
    }

    private static boolean setDataWithLineStr(TrainEleTicket trainEleTicket, String lineStr, int lineIndex) {
        String[] lineStrArr = lineStr.split(" ");
        switch (lineIndex) {
            case 1: {
                return TrainEleTicketOfdRead.setDataByPattern(trainEleTicket, lineStr, "\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\S*)|\u5f00\u7968\u65e5\u671f:(?<issueDate>\\S*)", TrainEleTicketConstants.NUM_DATE_KEYS);
            }
            case 2: {
                if (lineStrArr.length != 5) break;
                trainEleTicket.setStationGetOn(lineStrArr[0]);
                trainEleTicket.setStationGetOff(lineStrArr[3]);
                trainEleTicket.setTrainNum(lineStrArr[2]);
                break;
            }
            case 3: {
                if (lineStrArr.length != 2) break;
                trainEleTicket.setPhonicsOfStationGetOn(lineStrArr[0]);
                trainEleTicket.setPhonicsOfStationGetOff(lineStrArr[1]);
                break;
            }
            case 4: {
                if (lineStrArr.length > 0) {
                    trainEleTicket.setInvoiceDate(InvoiceReadUtils.formatDate(lineStrArr[0]));
                }
                if (lineStrArr.length > 1) {
                    trainEleTicket.setTrainTime(lineStrArr[1].replace("\u5f00", ""));
                }
                if (lineStrArr.length > 2) {
                    String carriage = "";
                    String seatNo = "";
                    String seatInfo = lineStrArr[2];
                    if ("\u65e0\u5ea7".equals(seatInfo)) {
                        seatNo = "\u65e0\u5ea7";
                    } else {
                        String[] seatArr = seatInfo.split("\u8f66");
                        if (seatArr.length == 2) {
                            carriage = seatArr[0];
                            seatNo = seatArr[1].replace("\u53f7", "");
                        } else {
                            carriage = seatInfo;
                        }
                    }
                    trainEleTicket.setCarriage(carriage);
                    trainEleTicket.setSeatNo(seatNo);
                }
                if (lineStrArr.length <= 3) break;
                trainEleTicket.setSeat(lineStrArr[3]);
                break;
            }
            case 5: {
                TrainEleTicketOfdRead.setDataByPattern(trainEleTicket, lineStr, "(\u9000\u7968\u8d39|\u7968\u4ef7|\u6539\u7b7e\u8d39):\u00a5(?<totalAmount>\\S*)", TrainEleTicketConstants.TOTAL_AMOUNT_KEYS);
                if (!StringUtils.isEmpty((CharSequence)trainEleTicket.getSeat()) || lineStrArr.length <= 1) break;
                trainEleTicket.setSeat(lineStrArr[1]);
                break;
            }
            case 6: {
                return TrainEleTicketOfdRead.setDataByPattern(trainEleTicket, lineStr, "\u91d1\u989d:\u00a5(?<invoiceAmount>\\S*)|\u7a0e\u7387:(?<taxRate>\\S*)|\u7a0e\u989d:\u00a5(?<totalTaxAmount>\\S*)", TrainEleTicketConstants.AMOUNT_KEYS);
            }
            case 7: {
                if (lineStrArr.length != 2) break;
                trainEleTicket.setCustomerIdentityNum(lineStrArr[0]);
                trainEleTicket.setPassengerName(lineStrArr[1]);
                break;
            }
            case 8: {
                return TrainEleTicketOfdRead.setDataByPattern(trainEleTicket, lineStr, "\u5df2\u9000\u91d1\u989d:\u00a5(?<amountRefunded>\\S*)", TrainEleTicketConstants.REFUNDED_AMOUNT_KEYS);
            }
            case 9: {
                TrainEleTicketOfdRead.setDataByPattern(trainEleTicket, lineStr, "\u7535\u5b50\u5ba2\u7968\u53f7:(?<electronicTicketNum>\\S*)", TrainEleTicketConstants.ELECTRONIC_TICKET_NUM_KEYS);
                String typeOfBusiness = "\u552e";
                if (lineStrArr.length > 1 && ("\u5dee\u989d\u9000\u7968".equals(lineStrArr[1]) || "\u9000\u7968".equals(lineStrArr[1]))) {
                    typeOfBusiness = "\u9000";
                }
                trainEleTicket.setTypeOfBusiness(typeOfBusiness);
                break;
            }
            case 10: {
                return TrainEleTicketOfdRead.setDataByPattern(trainEleTicket, lineStr, "\u8d2d\u4e70\u65b9\u540d\u79f0:(?<buyerName>\\S*)|\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801:(?<buyerTaxNo>\\S*)", TrainEleTicketConstants.BUY_INFO_KEYS);
            }
        }
        return true;
    }

    private static boolean setDataByPattern(TrainEleTicket trainEleTicket, String lineStr, String reg, String[] keys) {
        boolean isMatch = false;
        boolean currentMatch = InvoiceReadUtils.setPatternMatchValueTrain(trainEleTicket, lineStr, reg, keys);
        if (currentMatch) {
            isMatch = true;
        }
        return isMatch;
    }
}

