/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.ofd;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.config.exception.ConvertException;
import kd.imc.aws.ofd.util.CompressHelper;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.aws.ofd.util.ofd.OfdReadUtil;
import kd.imc.aws.ofd.util.ofd.SVGConversionUtil;
import kd.imc.aws.ofd.util.ofd.SvgUtil;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.pdf.PdfUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DEROctetString;
import org.dom4j.Element;

public class OfdConvertUtil {
    private static Log LOGGER = LogFactory.getLog(OfdConvertUtil.class);

    public static byte[] convertToImage(byte[] fileBytes, float zoomScale, int imageType) {
        if (zoomScale > 3.0f) {
            throw new ConvertException(OfdErrorType.CONVERT_PNG_TOO_LARGE);
        }
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, false, -1);
        String svgStr = (String)svgMap.get("svgStr");
        float svgWidth = ((Float)svgMap.get("svgWidth")).floatValue();
        float svgHeight = ((Float)svgMap.get("svgHeight")).floatValue();
        byte[] svgBytes = svgStr.getBytes(StandardCharsets.UTF_8);
        return SVGConversionUtil.convertSvgBytes2Image((byte[])svgBytes, (float)(SvgUtil.getPxByMM(svgWidth) * zoomScale), (float)(SvgUtil.getPxByMM(svgHeight) * zoomScale), (int)imageType);
    }

    public static List<Object> convertToMultImage(byte[] fileBytes, float zoomScale, boolean strFlag, int imageType, int pageNo) {
        String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, pageNo);
        return SVGConversionUtil.convertSvgBytes2MulImage((String)svgStr, (float)zoomScale, (boolean)strFlag, (int)imageType);
    }

    public static byte[] convertToPdfNew(byte[] fileBytes, int pageNo) {
        try {
            Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, true, pageNo);
            String svgStr = (String)svgMap.get("svgStr");
            Map fontFamilyMap = (Map)svgMap.get("fontFamilyMap");
            return PdfUtils.convertToPdf((String)svgStr, (Map)fontFamilyMap);
        }
        catch (Exception e) {
            LOGGER.error("ofd\u8f6cpdf\u5931\u8d25", (Throwable)e);
            throw new ConvertException(OfdErrorType.CONVERT_PDF_ERROR, e.getMessage());
        }
    }

    public static List<byte[]> convertToPdfList(byte[] fileBytes, int pageNo) {
        try {
            Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, true, pageNo);
            String svgStr = (String)svgMap.get("svgStr");
            Map fontFamilyMap = (Map)svgMap.get("fontFamilyMap");
            return PdfUtils.convertToPdfList((String)svgStr, (Map)fontFamilyMap);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.CONVERT_PDF_ERROR.getDescription(), (Throwable)e);
            throw new ConvertException(OfdErrorType.CONVERT_PDF_ERROR, e.getMessage());
        }
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.ofdToSvgStr(fileBytes, false, -1).getBytes(StandardCharsets.UTF_8);
    }

    private static Map<String, Object> ofdToSvgMap(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map ofdFileMap = CompressHelper.decompress((byte[])fileBytes);
        return OfdConvertUtil.readOfdDataToSvg(ofdFileMap, pdfFlag, pageNo);
    }

    public static String ofdToSvgStr(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, pdfFlag, pageNo);
        return (String)svgMap.get("svgStr");
    }

    private static Map<String, Object> readOfdDataToSvg(Map<String, byte[]> ofdFileMap, boolean pdfFlag, int pageNo) {
        String annotationPath;
        byte[] annotationBytes;
        byte[] ofdMainByte = ofdFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        if (StringUtils.isEmpty((CharSequence)docRootPath)) {
            return null;
        }
        String signaturesPath = null;
        try {
            signaturesPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/Signatures");
        }
        catch (Exception e) {
            LOGGER.info("\u7b7e\u7ae0\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = ofdFileMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        if (documentEle == null) {
            return null;
        }
        Element commonDataEle = documentEle.element("CommonData");
        String documentResPath = commonDataEle.elementText("DocumentRes");
        String publicResPath = commonDataEle.elementText("PublicRes");
        if (StringUtils.isEmpty((CharSequence)documentResPath)) {
            documentResPath = publicResPath;
        }
        if (StringUtils.isEmpty((CharSequence)publicResPath)) {
            publicResPath = documentResPath;
        }
        HashMap<String, Object> fontFamilyMap = new HashMap<String, Object>();
        Map<String, Object> multiMediaMap = OfdConvertUtil.getMultiMediaMap(ofdFileMap, docRootDirPath + documentResPath, fontFamilyMap);
        OfdConvertUtil.getFontFamilyByPublicRes(ofdFileMap, docRootDirPath, publicResPath, fontFamilyMap);
        Element element = commonDataEle.element("PageArea");
        String firstPageArea = null;
        if (null != element) {
            firstPageArea = element.elementText("PhysicalBox");
        }
        float width = 210.0f;
        List tempEleList = commonDataEle.elements("TemplatePage");
        Map<String, Element> templateMap = OfdConvertUtil.getTempEleMap(tempEleList);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        Element annotationsEle = documentEle.element("Annotations");
        List annotationList = null;
        if (annotationsEle != null && (annotationBytes = ofdFileMap.get(annotationPath = docRootDirPath + annotationsEle.getText())) != null) {
            Element annotationEle = OfdReadUtil.getElementByByte(annotationBytes);
            annotationList = annotationEle.elements("Page");
        }
        float offsetY = 0.0f;
        StringBuilder contentBuffer = new StringBuilder();
        for (int i = 0; i < pageEleList.size(); ++i) {
            Element annotationEle;
            byte[] bytes;
            if (pageNo != -1 && pageNo != i) continue;
            Element pageEle = OfdReadUtil.getElementByPath(ofdFileMap, (Element)pageEleList.get(i), docRootDirPath);
            width = OfdConvertUtil.getPageEleWidth(pageEle, width);
            String tempId = OfdConvertUtil.getTempEleIdByPage(pageEle);
            Element tempElePath = templateMap.get(tempId);
            if (!tempEleList.isEmpty() && tempElePath == null) {
                tempElePath = (Element)tempEleList.get(i);
            }
            Element tempEle = null;
            if (tempElePath != null) {
                tempEle = OfdReadUtil.getElementByPath(ofdFileMap, tempElePath, docRootDirPath);
            }
            String signSvgString = null;
            if (i == 0 && !StringUtils.isEmpty((CharSequence)signaturesPath)) {
                signSvgString = OfdConvertUtil.getSignSvgString(ofdFileMap, signaturesPath, offsetY);
            }
            Map<String, Object> tempSvgMap = SvgUtil.getPageSvg(tempEle, firstPageArea, fontFamilyMap, null, multiMediaMap, offsetY, i, signSvgString);
            Map<String, Object> pageSvgMap = SvgUtil.getPageSvg(pageEle, firstPageArea, fontFamilyMap, tempSvgMap, multiMediaMap, offsetY, i, signSvgString);
            StringBuilder svgBuffer = (StringBuilder)pageSvgMap.get("svgBuffer");
            float offsetX = ((Float)pageSvgMap.get("offsetX")).floatValue();
            if (offsetX > width) {
                width = offsetX;
            }
            if (annotationList != null && annotationList.size() > i && null != (bytes = ofdFileMap.get(docRootDirPath + "Annots/" + ((Element)annotationList.get(i)).element("FileLoc").getText())) && bytes.length > 0 && (annotationEle = OfdReadUtil.getElementByPath(ofdFileMap, docRootDirPath + "Annots/" + ((Element)annotationList.get(i)).element("FileLoc").getText())) != null) {
                SvgUtil.appendAnnotation(annotationEle, fontFamilyMap, svgBuffer, multiMediaMap, offsetY);
            }
            svgBuffer.append("</svg>");
            if (!pdfFlag) {
                offsetY = ((Float)pageSvgMap.get("offsetY")).floatValue();
            }
            contentBuffer.append((CharSequence)svgBuffer);
        }
        StringBuilder pageBuffer = new StringBuilder("<svg ").append(" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ").append(" version=\"1.1\" ");
        pageBuffer.append("width=\"").append(width).append("mm\" height=\"").append(offsetY).append("mm\">");
        pageBuffer.append((CharSequence)contentBuffer);
        pageBuffer.append("</svg>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("svgStr", pageBuffer.toString());
        map.put("svgWidth", Float.valueOf(width));
        map.put("svgHeight", Float.valueOf(offsetY));
        map.put("fontFamilyMap", fontFamilyMap);
        return map;
    }

    private static float getPageEleWidth(Element pageEle, float width) {
        float areaWidth;
        String[] areaArr;
        Element element = pageEle.element("Area");
        String pageArea = null;
        if (null != element) {
            pageArea = element.elementText("PhysicalBox");
        }
        if (pageArea != null && (areaArr = pageArea.split(" ")).length == 4 && (areaWidth = Float.parseFloat(areaArr[2])) > width) {
            width = areaWidth;
        }
        return width;
    }

    private static Map<String, Element> getTempEleMap(List<Element> tempEleList) {
        HashMap<String, Element> templateMap = new HashMap<String, Element>(tempEleList.size());
        for (Element templateEle : tempEleList) {
            templateMap.put(templateEle.attributeValue("ID"), templateEle);
        }
        return templateMap;
    }

    private static String getTempEleIdByPage(Element pageEle) {
        String tempEleId = null;
        Element templateEle = pageEle.element("Template");
        if (templateEle != null) {
            tempEleId = templateEle.attributeValue("TemplateID");
        }
        return tempEleId;
    }

    private static Map<String, Object> getFontFamilyByPublicRes(Map<String, byte[]> ofdFileMap, String docRootDirPath, String publicResPath, Map<String, Object> fontFamilyMap) {
        byte[] fileBytes;
        if (fontFamilyMap == null) {
            fontFamilyMap = new HashMap<String, Object>();
        }
        if ((fileBytes = ofdFileMap.get(docRootDirPath + publicResPath)) == null || fileBytes.length == 0) {
            return fontFamilyMap;
        }
        Element publicResEle = OfdReadUtil.getElementByByte(fileBytes);
        Element drawParamsEle = publicResEle.element("DrawParams");
        OfdConvertUtil.setDrawEle(drawParamsEle, fontFamilyMap);
        Element fontsEle = publicResEle.element("Fonts");
        if (fontsEle != null) {
            String baseLoc = publicResEle.attributeValue("BaseLoc");
            baseLoc = !StringUtils.isEmpty((CharSequence)baseLoc) ? baseLoc + "/" : "";
            List fontEleList = fontsEle.elements("Font");
            for (Element fontEle : fontEleList) {
                String fontFamilyName = fontEle.attributeValue("FamilyName");
                if (StrUtil.isEmpty((CharSequence)fontFamilyName)) {
                    fontFamilyName = fontEle.attributeValue("FontName");
                }
                String fontFamilyNameLow = fontFamilyName.toLowerCase(Locale.ROOT);
                boolean ofdFonts = true;
                if (fontFamilyNameLow.contains("kaiti") && !fontFamilyNameLow.contains("bold")) {
                    fontFamilyName = "\u6977\u4f53, KaiTi, Kai, simkai";
                    ofdFonts = false;
                }
                if (fontFamilyNameLow.contains("simsun") && !fontFamilyNameLow.contains("bold")) {
                    fontFamilyName = "\u5b8b\u4f53, SimSun, simsun";
                    ofdFonts = false;
                }
                if (!StrUtil.isEmpty((CharSequence)fontFamilyName)) {
                    fontFamilyName = fontFamilyName.replace("\u6977\u4f53", "\u6977\u4f53, KaiTi, Kai, simkai");
                    fontFamilyName = fontFamilyName.replace("\u5b8b\u4f53", "\u5b8b\u4f53, SimSun, simsun");
                }
                String idStr = fontEle.attributeValue("ID");
                fontFamilyMap.put(idStr, fontFamilyName);
                if (!ofdFonts) continue;
                String fileName = fontEle.elementText("FontFile");
                String path = docRootDirPath + baseLoc + fileName;
                byte[] fontBytes = ofdFileMap.get(path);
                if (fontBytes == null) continue;
                fontFamilyMap.put(fontFamilyName, fontBytes);
                String[] fileNameArr = fileName.split("\\.");
                fontFamilyMap.put(fontFamilyName + "_name", fontFamilyName + "." + fileNameArr[fileNameArr.length - 1]);
            }
        }
        return fontFamilyMap;
    }

    private static void setDrawEle(Element drawParamsEle, Map<String, Object> map) {
        List drawEleList;
        if (drawParamsEle != null && (drawEleList = drawParamsEle.elements("DrawParam")) != null && !drawEleList.isEmpty()) {
            for (Element drawEle : drawEleList) {
                Element fillColorEle;
                if (drawEle == null) continue;
                String drawId = drawEle.attributeValue("ID");
                String lineWidth = drawEle.attributeValue("LineWidth");
                if (!StringUtils.isEmpty((CharSequence)lineWidth)) {
                    map.put("LINE_WIDTH_" + drawId, lineWidth);
                }
                if ((fillColorEle = drawEle.element("FillColor")) != null) {
                    OfdConvertUtil.setDrawParamsColor(drawEle, fillColorEle, map);
                    continue;
                }
                Element strokeColorEle = drawEle.element("StrokeColor");
                OfdConvertUtil.setDrawParamsColor(drawEle, strokeColorEle, map);
            }
        }
    }

    private static void setDrawParamsColor(Element drawEle, Element colorEle, Map<String, Object> map) {
        String fillColor;
        if (colorEle != null && !StrUtil.isEmpty((CharSequence)(fillColor = colorEle.attributeValue("Value")))) {
            String colorId = drawEle.attributeValue("ID");
            map.put("LINE_COLOR_" + colorId, fillColor);
        }
    }

    private static Map<String, Object> getMultiMediaMap(Map<String, byte[]> ofdFileMap, String documentResPath, Map<String, Object> fontFamilyMap) {
        HashMap<String, Object> multiMediaMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)documentResPath) && !documentResPath.endsWith("null")) {
            byte[] docResByte = ofdFileMap.get(documentResPath);
            Element docResEle = OfdReadUtil.getElementByByte(docResByte);
            String baseLoc = "";
            List multiMediasEles = new ArrayList(8);
            if (docResEle != null) {
                baseLoc = docResEle.attributeValue("BaseLoc");
                multiMediasEles = docResEle.elements("MultiMedias");
            }
            if (!StringUtils.isEmpty((CharSequence)baseLoc)) {
                baseLoc = baseLoc + "/";
            }
            if (baseLoc.startsWith("/")) {
                baseLoc = baseLoc.substring(1);
            }
            if (multiMediasEles != null && !multiMediasEles.isEmpty()) {
                for (Element multiMediasEle : multiMediasEles) {
                    List multiMediaList = multiMediasEle.elements("MultiMedia");
                    if (multiMediaList == null || multiMediaList.isEmpty()) continue;
                    String lastDirPath = OfdReadUtil.getLastDirPath(documentResPath).toString();
                    String documentResDirPath = baseLoc;
                    if (!baseLoc.startsWith(lastDirPath)) {
                        documentResDirPath = lastDirPath + baseLoc;
                    }
                    OfdConvertUtil.setMultiMediaMap(multiMediaMap, multiMediaList, documentResDirPath, ofdFileMap);
                }
            }
            if (docResEle != null) {
                Element compositeGraphicUnitsEle = docResEle.element("CompositeGraphicUnits");
                OfdConvertUtil.setCompositeGraphicUnitsEleToMultiMediaMap(multiMediaMap, compositeGraphicUnitsEle);
                Element drawParamsEle = docResEle.element("DrawParams");
                OfdConvertUtil.setDrawEle(drawParamsEle, fontFamilyMap);
            }
        }
        return multiMediaMap;
    }

    private static void setCompositeGraphicUnitsEleToMultiMediaMap(Map<String, Object> multiMediaMap, Element compositeGraphicUnitsEle) {
        if (compositeGraphicUnitsEle == null) {
            return;
        }
        List compositeGraphicUnitEles = compositeGraphicUnitsEle.elements("CompositeGraphicUnit");
        if (compositeGraphicUnitEles == null || compositeGraphicUnitEles.isEmpty()) {
            return;
        }
        for (Element compositeGraphicUnit : compositeGraphicUnitEles) {
            if (compositeGraphicUnit == null) continue;
            String id = "CompositeGraphicUnit_" + compositeGraphicUnit.attributeValue("ID");
            multiMediaMap.put(id, compositeGraphicUnit);
        }
    }

    private static void setMultiMediaMap(Map<String, Object> multiMediaMap, List<Element> multiMediaList, String documentResPath, Map<String, byte[]> ofdFileMap) {
        for (Element multiMediaEle : multiMediaList) {
            String fileName = multiMediaEle.elementText("MediaFile");
            if (fileName != null && fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (fileName != null && fileName.startsWith(documentResPath)) {
                fileName = fileName.replace(documentResPath, "");
            }
            String idStr = multiMediaEle.attributeValue("ID");
            multiMediaMap.put(idStr, fileName);
            multiMediaMap.put(idStr + "_BYTE", ofdFileMap.get(documentResPath + fileName));
        }
    }

    private static String getSignSvgString(Map<String, byte[]> ofdFileMap, String signaturesPath, float offsetY) {
        try {
            Element signaturesEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturesPath);
            if (signaturesEle == null) {
                return null;
            }
            String signPic = null;
            Element signaturePathEle = signaturesEle.element("Signature");
            String signaturePath = signaturePathEle.attributeValue("BaseLoc");
            Element signatureEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturePath = OfdReadUtil.getDirPath(signaturePath, signaturesPath));
            Element signedInfoEle = signatureEle.element("SignedInfo");
            Element stampAnnotEle = signedInfoEle.element("StampAnnot");
            if (stampAnnotEle != null) {
                String signBoundary = stampAnnotEle.attributeValue("Boundary");
                String signedValuePath = signatureEle.elementText("SignedValue");
                signedValuePath = OfdReadUtil.getDirPath(signedValuePath, signaturePath);
                byte[] signedValueByte = OfdReadUtil.getByteByPath(ofdFileMap, signedValuePath);
                signPic = OfdConvertUtil.getSignPic(signedValueByte, signBoundary, offsetY);
            }
            return signPic;
        }
        catch (Exception e) {
            throw new ConvertException(OfdErrorType.READ_SIGN_PIC_ERROR, e.getMessage());
        }
    }

    private static String getSignPic(byte[] signFileByte, String signBoundary, float offsetY) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
        if (!(asn1Sequence.getObjectAt(0) instanceof ASN1Sequence)) {
            return null;
        }
        ASN1Sequence asn1Sequence0 = (ASN1Sequence)asn1Sequence.getObjectAt(0);
        ASN1Sequence asnSealSequence = (ASN1Sequence)asn1Sequence0.getObjectAt(1);
        ASN1Sequence sealPicSeq = (ASN1Sequence)((ASN1Sequence)asnSealSequence.getObjectAt(0)).getObjectAt(3);
        String picType = sealPicSeq.getObjectAt(0).toString();
        byte[] picBytes = ((DEROctetString)sealPicSeq.getObjectAt(1)).getOctets();
        String contentStr = null;
        if ("ofd".equals(picType)) {
            contentStr = OfdConvertUtil.getSignOfdBuffer(picBytes, signBoundary);
        }
        if (contentStr == null) {
            picBytes = OfdConvertUtil.imageToPng(picBytes);
            contentStr = OfdConvertUtil.getSignPicBuffer(picBytes, signBoundary, offsetY);
        }
        return contentStr;
    }

    public static byte[] imageToPng(byte[] picBytes) throws IOException {
        BufferedImage input = ImageIO.read(new ByteArrayInputStream(picBytes));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)input, "PNG", outputStream);
            picBytes = outputStream.toByteArray();
        }
        return picBytes;
    }

    private static String getSignOfdBuffer(byte[] picBytes, String signBoundary) {
        Map signOfdMap;
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetX = Float.parseFloat(signBoundaryArr[0]);
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        float width = 0.0f;
        float height = 0.0f;
        if (signBoundaryArr.length == 4) {
            width = Float.parseFloat(signBoundaryArr[2]);
            height = Float.parseFloat(signBoundaryArr[3]);
        }
        if ((signOfdMap = CompressHelper.decompress((byte[])picBytes)) == null || signOfdMap.isEmpty()) {
            return null;
        }
        byte[] ofdMainByte = (byte[])signOfdMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = (byte[])signOfdMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String publicResPath = commonDataEle.elementText("PublicRes");
        Map<String, Object> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(signOfdMap, docRootDirPath, publicResPath, null);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        StringBuilder contentBuffer = new StringBuilder();
        for (int i = 0; i < pageEleList.size(); ++i) {
            Element pageEle = OfdReadUtil.getElementByPath(signOfdMap, (Element)pageEleList.get(i), docRootDirPath);
            Element areaEle = pageEle.element("Area");
            String physicalText = areaEle.elementText("PhysicalBox");
            float zoomX = 1.0f;
            float zoomY = 1.0f;
            if (!StrUtil.isEmpty((CharSequence)physicalText)) {
                String[] physicalArr = physicalText.split(" ");
                zoomX = width / Float.parseFloat(physicalArr[2]);
                zoomY = height / Float.parseFloat(physicalArr[3]);
            }
            Element contentEle = pageEle.element("Content");
            List layerEleList = contentEle.elements("Layer");
            for (Element layerEle : layerEleList) {
                List pathObjectEleList;
                List textEleList;
                Element pageBlockEle = layerEle.element("PageBlock");
                String drawParamId = layerEle.attributeValue("DrawParam");
                List blockTextEleList = null;
                List blockPathEleList = null;
                if (pageBlockEle != null) {
                    blockTextEleList = pageBlockEle.elements("TextObject");
                    blockPathEleList = pageBlockEle.elements("PathObject");
                }
                if ((textEleList = layerEle.elements("TextObject")) != null && !textEleList.isEmpty()) {
                    SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if (blockTextEleList != null && !blockTextEleList.isEmpty()) {
                    SvgUtil.getSvgTextByList(blockTextEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if ((pathObjectEleList = layerEle.elements("PathObject")) != null && !pathObjectEleList.isEmpty()) {
                    SvgUtil.getSvgLineByList(pathObjectEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if (blockPathEleList == null || blockPathEleList.isEmpty()) continue;
                SvgUtil.getSvgLineByList(blockPathEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
            }
        }
        return contentBuffer.toString();
    }

    private static String getSignPicBuffer(byte[] picBytes, String signBoundary, float offsetY) {
        if (picBytes == null) {
            return null;
        }
        picBytes = OfdConvertUtil.removeBlank(picBytes);
        String picBase64Str = Base64.getEncoder().encodeToString(picBytes);
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        StringBuilder contentBuffer = new StringBuilder();
        contentBuffer.append("<image x=\"").append(signBoundaryArr[0]).append("mm\" ");
        contentBuffer.append("y=\"").append(offsetY + pageOffsetY).append("mm\" ");
        contentBuffer.append("width=\"").append(signBoundaryArr[2]).append("mm\" ");
        contentBuffer.append("height=\"").append(signBoundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
        contentBuffer.append(picBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
        contentBuffer.append("\"/>");
        return contentBuffer.toString();
    }

    private static byte[] removeBlank(byte[] bytes) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
            int width = image.getWidth();
            int height = image.getHeight();
            BufferedImage newImage = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int rgb = image.getRGB(x, y);
                    if (OfdConvertUtil.isWhite(rgb)) {
                        newImage.setRGB(x, y, 0xFFFFFF);
                        continue;
                    }
                    newImage.setRGB(x, y, rgb);
                }
            }
            ImageIO.write((RenderedImage)newImage, "png", outputStream);
        }
        catch (IOException e) {
            return bytes;
        }
        return outputStream.size() > 0 ? outputStream.toByteArray() : bytes;
    }

    private static boolean isWhite(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return red == 255 && green == 255 && blue == 255;
    }
}

