/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.utils.XmlUtil;
import kd.imc.rim.file.pdfanalysis.utils.ZipExtractUtil;
import kd.imc.rim.file.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

public class PdfXbrlExtractUtil {
    private static Log log = LogFactory.getLog(PdfXbrlExtractUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject extractXbrl(byte[] fileBytes) {
        if (fileBytes == null) {
            return null;
        }
        try (PDDocument document = PDDocument.load((byte[])fileBytes);){
            JSONObject jSONObject = PdfXbrlExtractUtil.extractXbrl(document);
            return jSONObject;
        }
        catch (IOException e) {
            log.error("pdf\u89e3\u6790\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static JSONObject extractXbrl(PDDocument document) {
        if (document == null) {
            return null;
        }
        JSONObject xbrlInfo = PdfXbrlExtractUtil.extractOneXbrl(document);
        if (xbrlInfo == null || xbrlInfo.isEmpty()) {
            xbrlInfo = PdfXbrlExtractUtil.getCustomMetaData(document);
        }
        if (xbrlInfo == null || xbrlInfo.isEmpty()) {
            xbrlInfo = PdfXbrlExtractUtil.extractOneXml(document);
        }
        if (xbrlInfo == null || xbrlInfo.isEmpty()) {
            xbrlInfo = PdfXbrlExtractUtil.extractFromAttachment(document);
        }
        return xbrlInfo;
    }

    private static JSONObject getCustomMetaData(PDDocument document) {
        PDDocumentInformation documentInformation = document.getDocumentInformation();
        String hideXml = documentInformation.getCustomMetadataValue("hidexml");
        if (StringUtils.isEmpty((CharSequence)hideXml)) {
            return null;
        }
        byte[] decode = Base64.getDecoder().decode(hideXml);
        byte[] bytes = PdfXbrlExtractUtil.unGZip(decode);
        String xbrl = new String(bytes, StandardCharsets.UTF_8);
        if (StringUtils.isEmpty((CharSequence)xbrl)) {
            return null;
        }
        String fileName = "efi_issuer";
        String eInvoiceCodeNumber = PdfXbrlExtractUtil.getEInvoiceCodeNumber(xbrl);
        if (!StringUtils.isEmpty((CharSequence)eInvoiceCodeNumber)) {
            fileName = fileName + "_" + eInvoiceCodeNumber;
        }
        JSONObject xbrlInfo = new JSONObject();
        xbrlInfo.put("name", (Object)(fileName + ".xbrl"));
        xbrlInfo.put("message", (Object)xbrl);
        return xbrlInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unGZip(byte[] data) {
        byte[] b = null;
        ByteArrayInputStream bis = null;
        GZIPInputStream gzip = null;
        OutputStream baos = null;
        try {
            bis = new ByteArrayInputStream(data);
            gzip = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            int num = -1;
            baos = new ByteArrayOutputStream();
            while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                ((ByteArrayOutputStream)baos).write(buf, 0, num);
            }
            b = ((ByteArrayOutputStream)baos).toByteArray();
        }
        catch (Exception ex) {
            log.error("gzip\u89e3\u538b\u5931\u8d25", (Throwable)ex);
        }
        finally {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException iOException) {}
            }
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return b;
    }

    private static String getEInvoiceCodeNumber(String xbrl) {
        String invoiceCodeNumber = null;
        try {
            JSONObject jsonObject = XmlUtil.xml2Json((String)xbrl);
            JSONObject eInvoiceData = jsonObject.getJSONObject("EInvoiceData");
            JSONObject mainData = eInvoiceData.getJSONObject("Main");
            String invoiceCode = mainData.getString("EInvoiceCode");
            String invoiceNumber = mainData.getString("EInvoiceNumber");
            if (StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNumber)) {
                invoiceCodeNumber = invoiceCode + invoiceNumber;
            }
        }
        catch (Exception e) {
            log.error("xbrl\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return invoiceCodeNumber;
    }

    public static JSONArray extractFileBySuffix(PDDocument document, String suffix) {
        if (document == null) {
            return null;
        }
        JSONArray fileArray = new JSONArray();
        Map<String, byte[]> files = PdfXbrlExtractUtil.extractFiles(document);
        if (!files.isEmpty()) {
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                String fileName = file.getKey();
                byte[] message = file.getValue();
                if (fileName == null || message == null) continue;
                JSONObject fileInfo = new JSONObject();
                fileInfo.put("name", (Object)fileName);
                fileInfo.put("message", (Object)message);
                if (suffix != null && !"".equals(suffix)) {
                    if (!fileName.toLowerCase().endsWith(suffix.toLowerCase())) continue;
                    fileArray.add((Object)fileInfo);
                    continue;
                }
                fileArray.add((Object)fileInfo);
            }
        }
        return fileArray;
    }

    private static JSONObject extractOneXbrl(PDDocument document) {
        Map<String, byte[]> files = PdfXbrlExtractUtil.extractFiles(document);
        for (Map.Entry<String, byte[]> file : files.entrySet()) {
            String fileName = file.getKey();
            byte[] messageBytes = file.getValue();
            if (fileName.endsWith("hidexml.zip")) {
                Map<String, String> map = ZipExtractUtil.extractFileForXml(messageBytes);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    if (key == null || !key.toLowerCase().endsWith("xml")) continue;
                    return PdfXbrlExtractUtil.getXbrlJson(key, entry.getValue());
                }
            }
            if (!fileName.endsWith("xbrl")) continue;
            String message = new String(messageBytes, StandardCharsets.UTF_8);
            return PdfXbrlExtractUtil.getXbrlJson(fileName, message);
        }
        return null;
    }

    private static JSONObject extractFromAttachment(PDDocument document) {
        try {
            COSDictionary attachmentDict = (COSDictionary)document.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.getPDFName((String)"Attachment"));
            if (attachmentDict == null) {
                log.info("'Attachment' \u5b57\u5178\u672a\u627e\u5230\u3002");
                return null;
            }
            COSString attachmentData = (COSString)attachmentDict.getDictionaryObject(COSName.getPDFName((String)"AttachmentData"));
            if (attachmentData == null) {
                log.info("'AttachmentData' \u672a\u627e\u5230\u6216\u4e0d\u662f\u5b57\u7b26\u4e32\u3002");
                return null;
            }
            String xmlContent = new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)attachmentData.getString()));
            JSONObject jsonContent = XmlUtil.xml2Json((String)xmlContent);
            String voucher = jsonContent.getString("Voucher");
            byte[] voucherBytes = Base64.getDecoder().decode(voucher.getBytes("GBK"));
            String xml = new String(voucherBytes, "GBK");
            JSONObject dataJson = XmlUtil.xml2Json((String)xml);
            String fileName = "CTP_" + StrUtil.nullToEmpty((Object)dataJson.getString("AdmDivCode")) + StrUtil.nullToEmpty((Object)dataJson.getString("StYear")) + StrUtil.nullToEmpty((Object)dataJson.getString("VtCode")) + StrUtil.nullToEmpty((Object)dataJson.getString("VoucherNo")) + ".xml";
            return PdfXbrlExtractUtil.getXbrlJson(fileName, xml);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static JSONObject extractOneXml(PDDocument document) {
        Map<String, byte[]> files = PdfXbrlExtractUtil.extractFiles(document);
        for (Map.Entry<String, byte[]> file : files.entrySet()) {
            String fileName = file.getKey();
            byte[] messageBytes = file.getValue();
            if (!fileName.endsWith("xml")) continue;
            String message = new String(messageBytes, StandardCharsets.UTF_8);
            return PdfXbrlExtractUtil.getXbrlJson(fileName, message);
        }
        return null;
    }

    private static JSONObject getXbrlJson(String fileName, String message) {
        JSONObject xbrlInfo = new JSONObject();
        xbrlInfo.put("name", (Object)fileName);
        xbrlInfo.put("message", (Object)message);
        return xbrlInfo;
    }

    public static Map<String, byte[]> extractFiles(PDDocument document) {
        HashMap<String, Object> files = new HashMap<String, byte[]>();
        if (document == null) {
            return files;
        }
        try {
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree != null) {
                Iterator iterator;
                List kids;
                Map names = efTree.getNames();
                if (names != null) {
                    for (Map.Entry entry : names.entrySet()) {
                        PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)entry.getValue();
                        String filename = fileSpec.getFile();
                        if (filename == null) continue;
                        PDEmbeddedFile embeddedFile = PdfXbrlExtractUtil.getEmbeddedFile(fileSpec);
                        files.put(filename, embeddedFile.toByteArray());
                    }
                }
                if ((kids = efTree.getKids()) != null && (iterator = kids.iterator()).hasNext()) {
                    PDNameTreeNode node = (PDNameTreeNode)iterator.next();
                    names = node.getNames();
                    for (Map.Entry entry : names.entrySet()) {
                        PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)entry.getValue();
                        String filename = fileSpec.getFile();
                        if (filename == null) continue;
                        PDEmbeddedFile embeddedFile = PdfXbrlExtractUtil.getEmbeddedFile(fileSpec);
                        files.put(filename, embeddedFile.toByteArray());
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("pdf\u89e3\u6790\u5931\u8d25", (Throwable)e);
            files = new HashMap();
        }
        return files;
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }
}

