/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.utils.ReUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfUtils;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.IPdfRead;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfReadUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.SpecialCodeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoiceItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class DigitalPdfRead
implements IPdfRead {
    private static Log log = LogFactory.getLog(DigitalPdfRead.class);

    public JSONObject read(PDDocument document, InvoiceTypeEnum invoiceType) {
        try {
            int totalPageNum = document.getPages().getCount();
            VatInvoice invoice = new VatInvoice(invoiceType.getCode());
            ArrayList<VatInvoiceItem> initItemList = new ArrayList<VatInvoiceItem>();
            for (int i = 1; i <= totalPageNum; ++i) {
                List<List<PdfTextCode>> contentList = PdfReadUtil.getContentListByPageNum(document, i);
                this.setVatInvoice(invoice, contentList, i);
                this.setFirstItemList(contentList, initItemList);
            }
            DigitalPdfUtils.setModelItemData(invoice, initItemList);
            PDDocumentInformation info = document.getDocumentInformation();
            this.setValueFromPDDocumentInformation(invoice, info);
            return PdfReadUtil.getReturnJson("2", ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"DigitalPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), null, invoice);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6570\u7535pdf\u51fa\u9519", (Throwable)e);
            return PdfReadUtil.getReturnJson("2", ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"DigitalPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89e3\u6790\u6570\u7535pdf\u51fa\u9519", (String)"DigitalPdfRead_1", (String)"imc-rim-file", (Object[])new Object[0]), null);
        }
    }

    private void setValueFromPDDocumentInformation(VatInvoice invoice, PDDocumentInformation info) {
        Object obj;
        if (StringUtils.isEmpty((CharSequence)invoice.getInvoiceNo()) && (obj = this.getValueFromPDDocumentInformation(info, "InvoiceNumber")) != null) {
            invoice.setInvoiceNo(obj.toString());
        }
        if (StringUtils.isEmpty((CharSequence)invoice.getInvoiceDate()) && (obj = this.getValueFromPDDocumentInformation(info, "IssueTime")) != null) {
            invoice.setInvoiceDate(obj.toString());
        }
    }

    private Object getValueFromPDDocumentInformation(PDDocumentInformation info, String ... propertyKey) {
        if (info != null) {
            for (String pkey : propertyKey) {
                Object val = info.getPropertyStringValue(pkey);
                if (val == null) continue;
                return val;
            }
        }
        return null;
    }

    public JSONObject readArray(PDDocument document, InvoiceTypeEnum invoiceType) {
        ArrayList<VatInvoice> invoiceList = new ArrayList<VatInvoice>();
        try {
            int currentPageNo = 1;
            int totalPageNum = document.getPages().getCount();
            VatInvoice invoice = new VatInvoice(invoiceType.getCode());
            ArrayList<VatInvoiceItem> initItemList = new ArrayList<VatInvoiceItem>();
            for (int i = 1; i <= totalPageNum; ++i) {
                List<List<PdfTextCode>> contentList = PdfReadUtil.getContentListByPageNum(document, i);
                if (invoice.getRemark() == null) {
                    this.setVatInvoice(invoice, contentList, currentPageNo, totalPageNum);
                }
                this.setFirstItemList(contentList, initItemList);
                ++currentPageNo;
                if (invoice.getRemark() == null) continue;
                DigitalPdfUtils.setModelItemData(invoice, initItemList);
                invoiceList.add(invoice);
                invoice = new VatInvoice(invoice.getInvoiceType());
                initItemList.clear();
                currentPageNo = 1;
            }
            return PdfReadUtil.getReturnJson("2", ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"DigitalPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), null, invoiceList);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5168\u7535pdf\u51fa\u9519", (Throwable)e);
            return PdfReadUtil.getReturnJson("2", ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"DigitalPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89e3\u6790\u6570\u7535pdf\u51fa\u9519", (String)"DigitalPdfRead_1", (String)"imc-rim-file", (Object[])new Object[0]), null);
        }
    }

    public void setFirstItemList(List<List<PdfTextCode>> contentList, List<VatInvoiceItem> initItemList) {
        boolean detailFlag = false;
        List<PdfTextCode> headList = null;
        for (List<PdfTextCode> xList : contentList) {
            String everyFirstContent = DigitalPdfUtils.replaceSpaceToEmpty(xList.get(0).getContent());
            if (everyFirstContent.contains("\u9879\u76ee\u540d\u79f0")) {
                detailFlag = true;
                headList = DigitalPdfUtils.getItemHeadList(xList);
                continue;
            }
            if (!detailFlag) continue;
            if (this.isDetailEnd(xList, everyFirstContent)) break;
            initItemList.add(DigitalPdfUtils.getItemByXList(xList, headList, false));
        }
    }

    public boolean isDetailEnd(List<PdfTextCode> xList, String content) {
        if (content.equals("\u5c0f\u8ba1") || content.equals("\u5408\u8ba1")) {
            return true;
        }
        if ("\u5c0f".equals(content) || "\u5408".equals(content)) {
            PdfTextCode nextPdfTextCode = xList.get(1);
            String nextContent = DigitalPdfUtils.replaceSpaceToEmpty(nextPdfTextCode.getContent());
            return "\u8ba1".equals(nextContent);
        }
        return false;
    }

    public void setVatInvoice(VatInvoice invoice, List<List<PdfTextCode>> lastContentList, int totalPageNum) {
        this.setVatInvoice(invoice, lastContentList, 1, totalPageNum);
    }

    public void setVatInvoice(VatInvoice invoice, List<List<PdfTextCode>> lastContentList, int pageNo, int totalPageNum) {
        JSONObject dataJson = PdfReadUtil.getDataJsonByList(lastContentList);
        Map specialMap = (Map)dataJson.get((Object)"specialMap");
        String allText = dataJson.getString("allText");
        if (pageNo == 1) {
            PdfReadUtil.setSpecialInvoiceDate(invoice, allText);
            PdfReadUtil.setPatternMatchValue(invoice, allText, "(?:\u5f00\u7968\u53f7\u7801|\u53d1\u7968\u53f7\u7801):(?<invoiceNo>\\d{20})|\u5f00\u7968\u65e5\u671f:(?<invoiceDate>\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5)", DigitalPdfConstants.INVOICE_CODE_KEYS);
            PdfReadUtil.setInvoiceAmount(invoice, allText);
            PdfReadUtil.setPatternMatchValue(invoice, allText, "\u5f00\u7968\u4eba:(?<drawer>\\S*)", DigitalPdfConstants.DRAWER_KEYS);
            invoice.setInvoiceDate(DigitalPdfUtils.formatDate(invoice.getInvoiceDate()));
            this.setSpecialDataToInvoice(specialMap, invoice, lastContentList);
        }
        PdfReadUtil.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029\u00a5(?<totalAmount>\\S*)\\s", DigitalPdfConstants.AMOUNT_KEYS);
        if (invoice.getTotalAmount() == null || "0".equals(invoice.getTotalAmount())) {
            PdfReadUtil.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029(?<totalAmount>\\S*)", DigitalPdfConstants.AMOUNT_KEYS);
        }
        if (invoice.getTotalAmount() != null) {
            String totalAmount = invoice.getTotalAmount().replace(DigitalPdfConstants.EN_COMMA, "").replace(DigitalPdfConstants.EN_COLON, "").replace("\u00a5", "");
            invoice.setTotalAmount(totalAmount);
        }
        if (pageNo == totalPageNum) {
            DigitalPdfRead.setRemark(specialMap, invoice, lastContentList);
        }
        try {
            BigDecimal invoiceAmount;
            BigDecimal totalTaxAmount;
            BigDecimal totalAmount;
            if ((StringUtils.isEmpty((CharSequence)invoice.getTotalAmount()) || "0".equals(invoice.getTotalAmount())) && StringUtils.isNotEmpty((CharSequence)invoice.getTotalTaxAmount()) && StringUtils.isNotEmpty((CharSequence)invoice.getInvoiceAmount()) && BigDecimal.ZERO.compareTo(totalAmount = (totalTaxAmount = new BigDecimal(invoice.getTotalTaxAmount())).add(invoiceAmount = new BigDecimal(invoice.getInvoiceAmount()))) != 0) {
                invoice.setTotalAmount(totalAmount.toPlainString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setRemark(Map<String, PdfTextCode> specialMap, VatInvoice invoice, List<List<PdfTextCode>> contentList) {
        try {
            BigDecimal remarkTopY;
            PdfTextCode buyerInfoCode = specialMap.get(SpecialCodeEnum.BUYER_INFO.getCode());
            PdfTextCode totalAmountCode = specialMap.get(SpecialCodeEnum.TOTAL_AMOUNT.getCode());
            BigDecimal remarkLeftX = buyerInfoCode.getX().add(buyerInfoCode.getWidth());
            BigDecimal bigDecimal = remarkTopY = totalAmountCode != null ? totalAmountCode.getY() : null;
            if (remarkTopY == null) {
                PdfTextCode taxNoCode = specialMap.get(SpecialCodeEnum.BUYER_TAX_INFO_BOTTOM.getCode());
                BigDecimal bigDecimal2 = remarkTopY = taxNoCode != null ? taxNoCode.getY() : null;
            }
            if (remarkTopY == null) {
                return;
            }
            String remarkPre = invoice.getRemark();
            if (remarkPre == null) {
                remarkPre = "";
            }
            StringBuilder remarkBuilder = new StringBuilder(remarkPre);
            for (List<PdfTextCode> pdfTextCodeList : contentList) {
                String lineContent;
                PdfTextCode pdfTextCode = pdfTextCodeList.get(0);
                BigDecimal y = pdfTextCode.getY();
                if (y.compareTo(remarkTopY) <= 0 || StringUtils.isBlank((CharSequence)(lineContent = PdfReadUtil.getLineText(pdfTextCodeList, remarkLeftX, null, null)))) continue;
                if (lineContent.startsWith("\u5f00\u7968\u4eba")) break;
                remarkBuilder.append(lineContent);
            }
            invoice.setRemark(remarkBuilder.toString());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5907\u6ce8\u5931\u8d25", (Throwable)e);
        }
    }

    private void setSpecialDataToInvoice(Map<String, PdfTextCode> specialMap, VatInvoice invoice, List<List<PdfTextCode>> contentList) {
        try {
            PdfTextCode buyerInfoCode = specialMap.get(SpecialCodeEnum.BUYER_INFO.getCode());
            PdfTextCode salerInfoCode = specialMap.get(SpecialCodeEnum.SALER_INFO.getCode());
            PdfTextCode invoiceDateCode = specialMap.get(SpecialCodeEnum.INVOICE_DATE.getCode());
            PdfTextCode taxRateCode = specialMap.get(SpecialCodeEnum.TAX_RATE.getCode());
            BigDecimal buyerLeftX = buyerInfoCode.getX().add(buyerInfoCode.getWidth());
            BigDecimal buyerRightX = salerInfoCode.getX();
            BigDecimal buyerTopY = invoiceDateCode.getY();
            BigDecimal buyerBottomY = taxRateCode.getY();
            BigDecimal saleLeftX = salerInfoCode.getX().add(buyerInfoCode.getWidth());
            for (List<PdfTextCode> pdfTextCodeList : contentList) {
                PdfTextCode pdfTextCode = pdfTextCodeList.get(0);
                BigDecimal y = pdfTextCode.getY();
                if (y.compareTo(buyerTopY) <= 0 || y.compareTo(buyerBottomY) >= 0) continue;
                this.setInfoData(invoice, pdfTextCodeList, buyerLeftX, buyerRightX, true);
                this.setInfoData(invoice, pdfTextCodeList, saleLeftX, null, false);
            }
        }
        catch (Exception e) {
            log.info("\u89e3\u6790\u8d2d\u9500\u65b9\u4fe1\u606f\u5931\u8d25", (Object)e);
        }
    }

    private void setInfoData(VatInvoice invoice, List<PdfTextCode> pdfTextCodeList, BigDecimal leftX, BigDecimal rightX, boolean buyerFlag) {
        String lineContent = PdfReadUtil.getLineText(pdfTextCodeList, leftX, rightX, true, null);
        if (!StringUtils.isBlank((CharSequence)lineContent)) {
            String name = ReUtil.get((String)"\u540d\u79f0:(?<name>\\S*)", (CharSequence)lineContent, (int)1);
            String taxNo = ReUtil.get((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:(?<taxNo>\\S*)", (CharSequence)lineContent, (int)1);
            if (buyerFlag) {
                invoice.setBuyerName(name);
                invoice.setBuyerTaxNo(taxNo);
            } else {
                invoice.setSalerName(name);
                invoice.setSalerTaxNo(taxNo);
            }
        }
    }
}

