/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.constant.TrainEleTicketConstants;
import kd.imc.aws.ofd.util.model.TrainEleTicket;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfUtils;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.IPdfRead;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfReadUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import kd.imc.rim.file.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public class TrainEleTicketPdfRead
implements IPdfRead {
    private static Log log = LogFactory.getLog(TrainEleTicketPdfRead.class);

    public JSONObject read(PDDocument document, InvoiceTypeEnum invoiceType) {
        try {
            int totalPageNum = document.getPages().getCount();
            if (totalPageNum == 0) {
                return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"PDF\u5185\u5bb9\u4e3a\u7a7a", (String)"TrainEleTicketPdfRead_1", (String)"imc-rim-file", (Object[])new Object[0]), null);
            }
            List<List<PdfTextCode>> contentList = PdfReadUtil.getContentListByPageNum(document, 1);
            TrainEleTicket trainEleTicket = this.getTrainEleTicket(contentList, invoiceType);
            if (StringUtils.isEmpty((CharSequence)trainEleTicket.getInvoiceNo())) {
                return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (String)"TrainEleTicketPdfRead_2", (String)"imc-rim-file", (Object[])new Object[0]), null);
            }
            return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_3", (String)"imc-rim-file", (Object[])new Object[0]), null, trainEleTicket);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968pdf\u51fa\u9519", (Throwable)e);
            return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968\u51fa\u9519", (String)"TrainEleTicketPdfRead_4", (String)"imc-rim-file", (Object[])new Object[0]), null);
        }
    }

    public JSONObject readArray(PDDocument document, InvoiceTypeEnum invoiceType) {
        try {
            int totalPageNum = document.getPages().getCount();
            if (totalPageNum == 0) {
                return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"PDF\u5185\u5bb9\u4e3a\u7a7a", (String)"TrainEleTicketPdfRead_1", (String)"imc-rim-file", (Object[])new Object[0]), null);
            }
            List<List<PdfTextCode>> contentList = PdfReadUtil.getContentListByPageNum(document, 1);
            TrainEleTicket trainEleTicket = this.getTrainEleTicket(contentList, invoiceType);
            if (StringUtils.isEmpty((CharSequence)trainEleTicket.getInvoiceNo())) {
                return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u53d1\u7968\u53f7\u7801", (String)"TrainEleTicketPdfRead_5", (String)"imc-rim-file", (Object[])new Object[0]), null);
            }
            ArrayList<TrainEleTicket> list = new ArrayList<TrainEleTicket>(1);
            list.add(trainEleTicket);
            return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_3", (String)"imc-rim-file", (Object[])new Object[0]), null, list);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968pdf\u51fa\u9519", (Throwable)e);
            return PdfReadUtil.getReturnJson("4", ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968", (String)"TrainEleTicketPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89e3\u6790\u94c1\u8def\u7535\u5b50\u5ba2\u7968\u51fa\u9519", (String)"TrainEleTicketPdfRead_4", (String)"imc-rim-file", (Object[])new Object[0]), null);
        }
    }

    private TrainEleTicket getTrainEleTicket(List<List<PdfTextCode>> contentList, InvoiceTypeEnum invoiceType) {
        TrainEleTicket trainEleTicket = new TrainEleTicket(invoiceType.getCode());
        int lineIndex = 1;
        for (List<PdfTextCode> xList : contentList) {
            boolean isTure;
            StringBuilder lineContentBuilder = new StringBuilder();
            for (PdfTextCode pdfTextCode : xList) {
                String content = pdfTextCode.getContent();
                lineContentBuilder.append(content);
                if (content != null && ((content = content.replace("\uff1a", ":")).endsWith(":") || content.endsWith("\u00a5"))) continue;
                lineContentBuilder.append(" ");
            }
            String lineContent = lineContentBuilder.toString();
            if (!(lineIndex != 6 || lineContent.contains("\u91d1\u989d") || lineContent.contains("\u7a0e\u7387") || lineContent.contains("\u7a0e\u989d"))) {
                ++lineIndex;
            }
            if (lineIndex == 8 && !lineContent.contains("\u5df2\u9000\u91d1\u989d")) {
                ++lineIndex;
            }
            if (!(isTure = TrainEleTicketPdfRead.setDataWithLineStr(trainEleTicket, lineContent, lineIndex))) continue;
            ++lineIndex;
        }
        trainEleTicket.setTaxRate(DigitalPdfUtils.getTaxRate(trainEleTicket.getTaxRate()));
        Date date = TypeUtils.castToDate((Object)trainEleTicket.getIssueDate());
        String issueDate = DateUtil.formatDate("yyyy-MM-dd", date);
        trainEleTicket.setIssueDate(issueDate);
        return trainEleTicket;
    }

    private static boolean setDataWithLineStr(TrainEleTicket trainEleTicket, String lineStr, int lineIndex) {
        String[] lineStrArr = lineStr.split(" ");
        switch (lineIndex) {
            case 1: {
                return PdfReadUtil.setPatternMatchValue(trainEleTicket, lineStr, "\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\S*)|\u5f00\u7968\u65e5\u671f:(?<issueDate>\\S*)", TrainEleTicketConstants.NUM_DATE_KEYS);
            }
            case 2: {
                if (lineStrArr.length != 5) break;
                trainEleTicket.setStationGetOn(lineStrArr[0]);
                trainEleTicket.setStationGetOff(lineStrArr[3]);
                trainEleTicket.setTrainNum(lineStrArr[2]);
                break;
            }
            case 3: {
                if (lineStrArr.length != 2) break;
                trainEleTicket.setPhonicsOfStationGetOn(lineStrArr[0]);
                trainEleTicket.setPhonicsOfStationGetOff(lineStrArr[1]);
                break;
            }
            case 4: {
                if (lineStrArr.length > 0) {
                    trainEleTicket.setInvoiceDate(DigitalPdfUtils.formatDate(lineStrArr[0]));
                }
                if (lineStrArr.length > 1) {
                    trainEleTicket.setTrainTime(lineStrArr[1].replace("\u5f00", ""));
                }
                if (lineStrArr.length > 2) {
                    String carriage = "";
                    String seatNo = "";
                    String seatInfo = lineStrArr[2];
                    if ("\u65e0\u5ea7".equals(seatInfo)) {
                        seatNo = "\u65e0\u5ea7";
                    } else {
                        String[] seatArr = seatInfo.split("\u8f66");
                        if (seatArr.length == 2) {
                            carriage = seatArr[0];
                            seatNo = seatArr[1].replace("\u53f7", "");
                        } else {
                            carriage = seatInfo;
                        }
                    }
                    trainEleTicket.setCarriage(carriage);
                    trainEleTicket.setSeatNo(seatNo);
                }
                if (lineStrArr.length <= 3) break;
                trainEleTicket.setSeat(lineStrArr[3]);
                break;
            }
            case 5: {
                PdfReadUtil.setPatternMatchValue(trainEleTicket, lineStr, "(\u9000\u7968\u8d39|\u7968\u4ef7|\u6539\u7b7e\u8d39):\u00a5(?<totalAmount>\\S*)", TrainEleTicketConstants.TOTAL_AMOUNT_KEYS);
                if (!StringUtils.isEmpty((CharSequence)trainEleTicket.getSeat()) || lineStrArr.length <= 1) break;
                trainEleTicket.setSeat(lineStrArr[1]);
                break;
            }
            case 6: {
                return PdfReadUtil.setPatternMatchValue(trainEleTicket, lineStr, "\u91d1\u989d:\u00a5(?<invoiceAmount>\\S*)|\u7a0e\u7387:(?<taxRate>\\S*)|\u7a0e\u989d:\u00a5(?<totalTaxAmount>\\S*)", TrainEleTicketConstants.AMOUNT_KEYS);
            }
            case 7: {
                if (lineStrArr.length != 2) break;
                trainEleTicket.setCustomerIdentityNum(lineStrArr[0]);
                trainEleTicket.setPassengerName(lineStrArr[1]);
                break;
            }
            case 8: {
                return PdfReadUtil.setPatternMatchValue(trainEleTicket, lineStr, "\u5df2\u9000\u91d1\u989d:\u00a5(?<amountRefunded>\\S*)", TrainEleTicketConstants.REFUNDED_AMOUNT_KEYS);
            }
            case 9: {
                PdfReadUtil.setPatternMatchValue(trainEleTicket, lineStr, "\u7535\u5b50\u5ba2\u7968\u53f7:(?<electronicTicketNum>\\S*)", TrainEleTicketConstants.ELECTRONIC_TICKET_NUM_KEYS);
                String typeOfBusiness = "\u552e";
                if (lineStrArr.length > 1 && ("\u5dee\u989d\u9000\u7968".equals(lineStrArr[1]) || "\u9000\u7968".equals(lineStrArr[1]))) {
                    typeOfBusiness = "\u9000";
                }
                trainEleTicket.setTypeOfBusiness(typeOfBusiness);
                break;
            }
            case 10: {
                return PdfReadUtil.setPatternMatchValue(trainEleTicket, lineStr, "\u8d2d\u4e70\u65b9\u540d\u79f0:(?<buyerName>\\S*)|\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801:(?<buyerTaxNo>\\S*)", TrainEleTicketConstants.BUY_INFO_KEYS);
            }
        }
        return true;
    }
}

