/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.ofd;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.rim.file.utils.CompressHelper;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.ofd.OfdReadUtil;
import kd.imc.rim.file.utils.ofd.SVGConversionUtil;
import kd.imc.rim.file.utils.ofd.SvgUtil;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DEROctetString;
import org.dom4j.Element;

@Deprecated
public class OfdConvertUtil {
    private static final Log LOGGER = LogFactory.getLog(OfdConvertUtil.class);

    public static byte[] convertToImage(byte[] fileBytes, float zoomScale, int imageType, int pageNo) {
        long start = System.currentTimeMillis();
        if (zoomScale > 3.0f) {
            throw new KDException(new ErrorCode(OfdErrorType.CONVERT_PNG_TOO_LARGE.errcode, OfdErrorType.CONVERT_PNG_TOO_LARGE.getDescription()), new Object[0]);
        }
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, false, pageNo);
        String svgStr = (String)svgMap.get("svgStr");
        float svgWidth = ((Float)svgMap.get("svgWidth")).floatValue();
        float svgHeight = ((Float)svgMap.get("svgHeight")).floatValue();
        byte[] svgBytes = svgStr.getBytes(StandardCharsets.UTF_8);
        byte[] bb = SVGConversionUtil.convertSvgBytes2Image((byte[])svgBytes, (float)(SvgUtil.getPxByMM(svgWidth) * zoomScale), (float)(SvgUtil.getPxByMM(svgHeight) * zoomScale), (int)imageType);
        LOGGER.info("ofd\u8f6c\u56fe\u7247\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        return bb;
    }

    public static List<Object> convertToMultImage(byte[] fileBytes, float zoomScale, boolean strFlag, int imageType, int pageNo) {
        String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, pageNo);
        return SVGConversionUtil.convertSvgBytes2MulImage((String)svgStr, (float)zoomScale, (boolean)strFlag, (int)imageType);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        try {
            String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, -1);
            return SVGConversionUtil.convertSvgStr2Pdf((String)svgStr);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.CONVERT_PDF_ERROR + ":" + e.getMessage());
            throw new KDException(new ErrorCode(OfdErrorType.CONVERT_PDF_ERROR.errcode, OfdErrorType.CONVERT_PDF_ERROR.getDescription()), new Object[0]);
        }
    }

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        return null;
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.ofdToSvgStr(fileBytes, false, -1).getBytes(StandardCharsets.UTF_8);
    }

    private static Map<String, Object> ofdToSvgMap(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        long start = System.currentTimeMillis();
        Map ofdFileMap = CompressHelper.decompress((byte[])fileBytes);
        LOGGER.info("ofd\u8f6csvg\u8017\u65f61-{}", (Object)(System.currentTimeMillis() - start));
        Map<String, Object> map = OfdConvertUtil.readOfdDataToSvg(ofdFileMap, pdfFlag, pageNo);
        LOGGER.info("ofd\u8f6csvg\u8017\u65f62-{}", (Object)(System.currentTimeMillis() - start));
        return map;
    }

    private static String ofdToSvgStr(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, pdfFlag, pageNo);
        return (String)svgMap.get("svgStr");
    }

    private static Map<String, Object> readOfdDataToSvg(Map<String, byte[]> ofdFileMap, boolean pdfFlag, int pageNo) {
        String annotationPath;
        byte[] annotationBytes;
        String[] areaArr;
        float areaWidth;
        byte[] ofdMainByte = ofdFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath((byte[])ofdMainByte, (String)"DocBody/DocRoot");
        String signaturesPath = null;
        try {
            signaturesPath = OfdReadUtil.getTextByPath((byte[])ofdMainByte, (String)"DocBody/Signatures");
        }
        catch (Exception e) {
            LOGGER.info("\u7b7e\u7ae0\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        String docRootDirPath = OfdReadUtil.getLastDirPath((String)docRootPath).toString();
        byte[] documentByte = ofdFileMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte((byte[])documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String documentResPath = commonDataEle.elementText("DocumentRes");
        Map<String, Object> multiMediaMap = OfdConvertUtil.getMultiMediaMap(ofdFileMap, docRootDirPath + documentResPath);
        String publicResPath = commonDataEle.elementText("PublicRes");
        if (StringUtils.isEmpty((CharSequence)publicResPath)) {
            publicResPath = documentResPath;
        }
        Map<String, String> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(ofdFileMap.get(docRootDirPath + publicResPath));
        Element element = commonDataEle.element("PageArea");
        String firstPageArea = null;
        if (null != element) {
            firstPageArea = element.elementText("PhysicalBox");
        }
        float width = 210.0f;
        if (firstPageArea != null && (areaWidth = Float.parseFloat((areaArr = firstPageArea.split(" "))[2])) > 0.0f) {
            width = areaWidth;
        }
        List tempEleList = commonDataEle.elements("TemplatePage");
        Map<String, Element> templateMap = OfdConvertUtil.getTempEleMap(tempEleList);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        Element annotationsEle = documentEle.element("Annotations");
        List annotationList = null;
        if (annotationsEle != null && (annotationBytes = ofdFileMap.get(annotationPath = docRootDirPath + annotationsEle.getText())) != null) {
            Element annotationEle = OfdReadUtil.getElementByByte((byte[])annotationBytes);
            annotationList = annotationEle.elements("Page");
        }
        float offsetY = 0.0f;
        StringBuilder contentBuffer = new StringBuilder();
        for (int i = 0; i < pageEleList.size(); ++i) {
            Element annotationEle;
            if (pageNo != -1 && pageNo != i) continue;
            Element pageEle = OfdReadUtil.getElementByPath(ofdFileMap, (Element)((Element)pageEleList.get(i)), (String)docRootDirPath);
            String tempId = OfdConvertUtil.getTempEleIdByPage(pageEle);
            Element tempElePath = templateMap.get(tempId);
            if (!tempEleList.isEmpty() && tempElePath == null) {
                tempElePath = (Element)tempEleList.get(i);
            }
            Element tempEle = null;
            if (tempElePath != null) {
                tempEle = OfdReadUtil.getElementByPath(ofdFileMap, (Element)tempElePath, (String)docRootDirPath);
            }
            String signSvgString = null;
            if (i == 0 && !StringUtils.isEmpty((CharSequence)signaturesPath)) {
                signSvgString = OfdConvertUtil.getSignSvgString(ofdFileMap, signaturesPath, offsetY);
            }
            Map<String, Object> svgMap = SvgUtil.getPageSvg(tempEle, firstPageArea, fontFamilyMap, null, multiMediaMap, offsetY, i, signSvgString);
            StringBuilder svgBuffer = (StringBuilder)svgMap.get("svgBuffer");
            Map<String, Object> pageSvgMap = SvgUtil.getPageSvg(pageEle, firstPageArea, fontFamilyMap, svgBuffer, multiMediaMap, offsetY, i, signSvgString);
            if (svgMap.isEmpty()) {
                svgMap = pageSvgMap;
                svgBuffer = (StringBuilder)svgMap.get("svgBuffer");
                float offsetX = ((Float)svgMap.get("offsetX")).floatValue();
                if (offsetX > width) {
                    width = offsetX;
                }
            }
            if (annotationList != null && annotationList.size() > i && (annotationEle = OfdReadUtil.getElementByPath(ofdFileMap, (String)(docRootDirPath + "Annots/" + ((Element)annotationList.get(i)).element("FileLoc").getText()))) != null) {
                SvgUtil.appendAnnotation(annotationEle, fontFamilyMap, svgBuffer, multiMediaMap, offsetY);
            }
            svgBuffer.append("</svg>");
            if (!pdfFlag) {
                offsetY = ((Float)svgMap.get("offsetY")).floatValue();
            }
            contentBuffer.append((CharSequence)svgBuffer);
        }
        StringBuilder pageBuffer = new StringBuilder("<svg ").append(" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ").append(" version=\"1.1\" ");
        pageBuffer.append("width=\"").append(width).append("mm\" height=\"").append(offsetY).append("mm\">");
        pageBuffer.append((CharSequence)contentBuffer);
        pageBuffer.append("</svg>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("svgStr", pageBuffer.toString());
        map.put("svgWidth", Float.valueOf(width));
        map.put("svgHeight", Float.valueOf(offsetY));
        return map;
    }

    private static Map<String, Element> getTempEleMap(List<Element> tempEleList) {
        HashMap<String, Element> templateMap = new HashMap<String, Element>(tempEleList.size());
        for (Element templateEle : tempEleList) {
            templateMap.put(templateEle.attributeValue("ID"), templateEle);
        }
        return templateMap;
    }

    private static String getTempEleIdByPage(Element pageEle) {
        String tempEleId = null;
        Element templateEle = pageEle.element("Template");
        if (templateEle != null) {
            tempEleId = templateEle.attributeValue("TemplateID");
        }
        return tempEleId;
    }

    private static Map<String, String> getFontFamilyByPublicRes(byte[] fileBytes) {
        Element fontsEle;
        List drawEleList;
        HashMap<String, String> map = new HashMap<String, String>();
        if (fileBytes == null || fileBytes.length == 0) {
            return map;
        }
        Element publicResEle = OfdReadUtil.getElementByByte((byte[])fileBytes);
        Element drawParamsEle = publicResEle.element("DrawParams");
        if (drawParamsEle != null && (drawEleList = drawParamsEle.elements("DrawParam")) != null && !drawEleList.isEmpty()) {
            for (Element drawEle : drawEleList) {
                Element fillColorEle;
                if (drawEle == null) continue;
                String drawId = drawEle.attributeValue("ID");
                String lineWidth = drawEle.attributeValue("LineWidth");
                if (!StringUtils.isEmpty((CharSequence)lineWidth)) {
                    map.put("LINE_WIDTH_" + drawId, lineWidth);
                }
                if ((fillColorEle = drawEle.element("FillColor")) != null) {
                    OfdConvertUtil.setDrawParamsColor(drawEle, fillColorEle, map);
                    continue;
                }
                Element strokeColorEle = drawEle.element("StrokeColor");
                OfdConvertUtil.setDrawParamsColor(drawEle, strokeColorEle, map);
            }
        }
        if ((fontsEle = publicResEle.element("Fonts")) != null) {
            List fontEleList = fontsEle.elements("Font");
            for (Element fontEle : fontEleList) {
                String fontFamilyName = fontEle.attributeValue("FamilyName");
                if (StrUtil.isEmpty((CharSequence)fontFamilyName)) {
                    fontFamilyName = fontEle.attributeValue("FontName");
                }
                if ("kaiti".equals(fontFamilyName)) {
                    fontFamilyName = "\u6977\u4f53, KaiTi, Kai, simkai";
                }
                if (!StrUtil.isEmpty((CharSequence)fontFamilyName)) {
                    fontFamilyName = fontFamilyName.replace("\u6977\u4f53", "\u6977\u4f53, KaiTi, Kai, simkai");
                    fontFamilyName = fontFamilyName.replace("\u5b8b\u4f53", "\u5b8b\u4f53, SimSun, simsun");
                }
                map.put(fontEle.attributeValue("ID"), fontFamilyName);
            }
        }
        return map;
    }

    private static void setDrawParamsColor(Element drawEle, Element colorEle, Map<String, String> map) {
        String fillColor;
        if (colorEle != null && !StrUtil.isEmpty((CharSequence)(fillColor = colorEle.attributeValue("Value")))) {
            String colorId = drawEle.attributeValue("ID");
            map.put("LINE_COLOR_" + colorId, fillColor);
        }
    }

    private static Map<String, Object> getMultiMediaMap(Map<String, byte[]> ofdFileMap, String documentResPath) {
        Map<String, Object> multiMediaMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)documentResPath) && !documentResPath.endsWith("null")) {
            byte[] docResByte = ofdFileMap.get(documentResPath);
            Element docResEle = OfdReadUtil.getElementByByte((byte[])docResByte);
            String baseLoc = docResEle.attributeValue("BaseLoc");
            baseLoc = !StringUtils.isEmpty((CharSequence)baseLoc) ? baseLoc + "/" : "";
            Element multiMediasEle = docResEle.element("MultiMedias");
            List multiMediaList = multiMediasEle.elements("MultiMedia");
            if (multiMediaList != null && !multiMediaList.isEmpty()) {
                String documentResDirPath = OfdReadUtil.getLastDirPath((String)documentResPath).append(baseLoc).toString();
                multiMediaMap = OfdConvertUtil.getMultiMediaMap(multiMediaList, documentResDirPath, ofdFileMap);
            }
        }
        return multiMediaMap;
    }

    private static Map<String, Object> getMultiMediaMap(List<Element> multiMediaList, String documentResPath, Map<String, byte[]> ofdFileMap) {
        HashMap<String, Object> multiMediaMap = new HashMap<String, Object>(8);
        for (Element multiMediaEle : multiMediaList) {
            String fileName = multiMediaEle.elementText("MediaFile");
            String idStr = multiMediaEle.attributeValue("ID");
            multiMediaMap.put(idStr, fileName);
            multiMediaMap.put(idStr + "_BYTE", ofdFileMap.get(documentResPath + fileName));
        }
        return multiMediaMap;
    }

    private static String getSignSvgString(Map<String, byte[]> ofdFileMap, String signaturesPath, float offsetY) {
        try {
            Element signaturesEle = OfdReadUtil.getElementByPath(ofdFileMap, (String)signaturesPath);
            if (signaturesEle == null) {
                return null;
            }
            String signPic = null;
            Element signaturePathEle = signaturesEle.element("Signature");
            String signaturePath = signaturePathEle.attributeValue("BaseLoc");
            Element signatureEle = OfdReadUtil.getElementByPath(ofdFileMap, (String)(signaturePath = OfdReadUtil.getDirPath((String)signaturePath, (String)signaturesPath)));
            Element signedInfoEle = signatureEle.element("SignedInfo");
            Element stampAnnotEle = signedInfoEle.element("StampAnnot");
            if (stampAnnotEle != null) {
                String signBoundary = stampAnnotEle.attributeValue("Boundary");
                String signedValuePath = signatureEle.elementText("SignedValue");
                signedValuePath = OfdReadUtil.getDirPath((String)signedValuePath, (String)signaturePath);
                byte[] signedValueByte = OfdReadUtil.getByteByPath(ofdFileMap, (String)signedValuePath);
                signPic = OfdConvertUtil.getSignPic(signedValueByte, signBoundary, offsetY);
            }
            return signPic;
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.READ_SIGN_PIC_ERROR + ":" + e.getMessage());
            throw new KDException(new ErrorCode(OfdErrorType.READ_SIGN_PIC_ERROR.errcode, OfdErrorType.READ_SIGN_PIC_ERROR.getDescription()), new Object[0]);
        }
    }

    private static String getSignPic(byte[] signFileByte, String signBoundary, float offsetY) throws IOException {
        String contentStr;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
        ASN1Sequence asn1Sequence0 = (ASN1Sequence)asn1Sequence.getObjectAt(0);
        ASN1Sequence asnSealSequence = (ASN1Sequence)asn1Sequence0.getObjectAt(1);
        ASN1Sequence sealPicSeq = (ASN1Sequence)((ASN1Sequence)asnSealSequence.getObjectAt(0)).getObjectAt(3);
        String picType = sealPicSeq.getObjectAt(0).toString();
        byte[] picBytes = ((DEROctetString)sealPicSeq.getObjectAt(1)).getOctets();
        if ("ofd".equals(picType)) {
            contentStr = OfdConvertUtil.getSignOfdBuffer(picBytes, signBoundary);
        } else {
            picBytes = OfdConvertUtil.imageToPng(picBytes);
            contentStr = OfdConvertUtil.getSignPicBuffer(picBytes, signBoundary, offsetY);
        }
        return contentStr;
    }

    public static byte[] imageToPng(byte[] picBytes) throws IOException {
        BufferedImage input = ImageIO.read(new ByteArrayInputStream(picBytes));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)input, "PNG", outputStream);
            picBytes = outputStream.toByteArray();
        }
        return picBytes;
    }

    private static String getSignOfdBuffer(byte[] picBytes, String signBoundary) {
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetX = Float.parseFloat(signBoundaryArr[0]);
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        float width = 0.0f;
        float height = 0.0f;
        if (signBoundaryArr.length == 4) {
            width = Float.parseFloat(signBoundaryArr[2]);
            height = Float.parseFloat(signBoundaryArr[3]);
        }
        Map signOfdMap = CompressHelper.decompress((byte[])picBytes);
        byte[] ofdMainByte = (byte[])signOfdMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath((byte[])ofdMainByte, (String)"DocBody/DocRoot");
        String docRootDirPath = OfdReadUtil.getLastDirPath((String)docRootPath).toString();
        byte[] documentByte = (byte[])signOfdMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte((byte[])documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String publicResPath = commonDataEle.elementText("PublicRes");
        Map<String, String> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes((byte[])signOfdMap.get(docRootDirPath + publicResPath));
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        StringBuilder contentBuffer = new StringBuilder();
        for (int i = 0; i < pageEleList.size(); ++i) {
            Element pageEle = OfdReadUtil.getElementByPath((Map)signOfdMap, (Element)((Element)pageEleList.get(i)), (String)docRootDirPath);
            Element areaEle = pageEle.element("Area");
            String physicalText = areaEle.elementText("PhysicalBox");
            float zoomX = 1.0f;
            float zoomY = 1.0f;
            if (!StrUtil.isEmpty((CharSequence)physicalText)) {
                String[] physicalArr = physicalText.split(" ");
                zoomX = width / Float.parseFloat(physicalArr[2]);
                zoomY = height / Float.parseFloat(physicalArr[3]);
            }
            Element contentEle = pageEle.element("Content");
            List layerEleList = contentEle.elements("Layer");
            for (Element layerEle : layerEleList) {
                List pathObjectEleList;
                List textEleList;
                Element pageBlockEle = layerEle.element("PageBlock");
                String drawParamId = layerEle.attributeValue("DrawParam");
                List blockTextEleList = null;
                List blockPathEleList = null;
                if (pageBlockEle != null) {
                    blockTextEleList = pageBlockEle.elements("TextObject");
                    blockPathEleList = pageBlockEle.elements("PathObject");
                }
                if ((textEleList = layerEle.elements("TextObject")) != null && !textEleList.isEmpty()) {
                    SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if (blockTextEleList != null && !blockTextEleList.isEmpty()) {
                    SvgUtil.getSvgTextByList(blockTextEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if ((pathObjectEleList = layerEle.elements("PathObject")) != null && !pathObjectEleList.isEmpty()) {
                    SvgUtil.getSvgLineByList(pathObjectEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if (blockPathEleList == null || blockPathEleList.isEmpty()) continue;
                SvgUtil.getSvgLineByList(blockPathEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
            }
        }
        return contentBuffer.toString();
    }

    private static String getSignPicBuffer(byte[] picBytes, String signBoundary, float offsetY) {
        if (picBytes == null) {
            return null;
        }
        String picBase64Str = Base64.getEncoder().encodeToString(picBytes);
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        StringBuilder contentBuffer = new StringBuilder();
        contentBuffer.append("<image x=\"").append(signBoundaryArr[0]).append("mm\" ");
        contentBuffer.append("y=\"").append(offsetY + pageOffsetY).append("mm\" ");
        contentBuffer.append("width=\"").append(signBoundaryArr[2]).append("mm\" ");
        contentBuffer.append("height=\"").append(signBoundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
        contentBuffer.append(picBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
        contentBuffer.append("\"/>");
        return contentBuffer.toString();
    }
}

