/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.pdf;

import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import kd.imc.rim.file.model.RgbBean;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.pdf.PdfUtils;
import kd.imc.rim.file.utils.pdf.RgbUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class PdfWritePathUtils {
    public static void setPathValue(Element detailElement, PdfContentByte under, float fileHeight) {
        String strokeColor = detailElement.attributeValue("stroke");
        String fillColor = detailElement.attributeValue("fill");
        String dStr = detailElement.attributeValue("d");
        dStr = dStr.replaceAll("ZM", "Z M");
        String[] pathArr = dStr.split(" (?=[SMLQBAC])");
        String transform = detailElement.attributeValue("transform");
        under.saveState();
        boolean fillFlag = false;
        if (!StrUtil.isEmpty((CharSequence)fillColor) && !"none".equals(fillColor)) {
            fillFlag = true;
            PdfWritePathUtils.setFillColor(fillColor, under);
        } else {
            if (StrUtil.isEmpty((CharSequence)strokeColor)) {
                strokeColor = fillColor;
            }
            PdfWritePathUtils.setStrokeColor(detailElement, strokeColor, under);
        }
        PdfWritePathUtils.execTransForm(under, transform, fileHeight);
        PdfWritePathUtils.writePath(under, pathArr, fileHeight);
        if (fillFlag) {
            under.fill();
        }
        under.closePathStroke();
        under.restoreState();
    }

    private static void setFillColor(String fillColor, PdfContentByte under) {
        RgbBean colorArr = RgbUtils.hexToRGB((String)fillColor);
        Color baseColor = new Color(colorArr.getRed(), colorArr.getGreen(), colorArr.getBlue());
        under.setColorFill(baseColor);
    }

    private static void setStrokeColor(Element detailElement, String strokeColor, PdfContentByte under) {
        RgbBean colorArr = RgbUtils.hexToRGB((String)strokeColor);
        Color baseColor = new Color(colorArr.getRed(), colorArr.getGreen(), colorArr.getBlue());
        String stokeWidthStr = detailElement.attributeValue("stroke-width");
        float strokeWidth = 0.25f;
        if (!StringUtils.isEmpty((CharSequence)stokeWidthStr)) {
            strokeWidth = PdfUtils.getFloatPxByStr((String)stokeWidthStr);
        }
        under.setColorStroke(baseColor);
        under.setLineWidth(strokeWidth);
    }

    private static void execTransForm(PdfContentByte under, String transform, float fileHeight) {
        if (!StringUtils.isEmpty((CharSequence)transform)) {
            AffineTransform affineTransform = new AffineTransform();
            if (transform.contains("translate")) {
                String[] translateArr = transform.replace("translate(", "").replace(")", "").split(",");
                float translateX = PdfUtils.getNormalPxBySvgStrPx((String)translateArr[0]);
                float translateY = PdfUtils.getNormalPxBySvgStrPx((String)translateArr[1]);
                affineTransform.translate(translateX, -translateY);
                under.transform(affineTransform);
            } else if (transform.contains("matrix")) {
                String[] ctmStrArr = transform.replace("matrix(", "").replace(")", "").split(" ");
                float[] matrixArr = PdfUtils.ctmCalPoint((float)0.0f, (float)0.0f, (float)fileHeight, (String[])ctmStrArr);
                affineTransform.setTransform(matrixArr[0], matrixArr[2], matrixArr[1], matrixArr[3], matrixArr[4], matrixArr[5]);
                under.transform(affineTransform);
            }
        }
    }

    private static float[] writeQPath(PdfContentByte under, String[] pathSplitArr, float lastPointX, float lastPointY, float fileHeight) {
        float controlX = PdfWritePathUtils.getPointPx(pathSplitArr[1], fileHeight, false);
        float controlY = PdfWritePathUtils.getPointPx(pathSplitArr[2], fileHeight, true);
        float endX = PdfWritePathUtils.getPointPx(pathSplitArr[3], fileHeight, false);
        float endY = PdfWritePathUtils.getPointPx(pathSplitArr[4], fileHeight, true);
        under.curveTo(controlX, controlY, controlX, controlY, endX, endY);
        return new float[]{endX, endY};
    }

    private static void writePath(PdfContentByte under, String[] pathArr, float fileHeight) {
        float pointX = 0.0f;
        float pointY = 0.0f;
        block14: for (String pathStr : pathArr) {
            String[] pathSplitArr = pathStr.split(" ");
            switch (pathSplitArr[0]) {
                case "M": {
                    PdfWritePathUtils.writeLinePath(under, pathSplitArr, fileHeight, true);
                    pointX = PdfWritePathUtils.getPointPx(pathSplitArr[1], fileHeight, false);
                    pointY = PdfWritePathUtils.getPointPx(pathSplitArr[2], fileHeight, true);
                    continue block14;
                }
                case "C": {
                    PdfWritePathUtils.writeCurvePath(under, pathSplitArr, fileHeight);
                    continue block14;
                }
                case "L": {
                    PdfWritePathUtils.writeLinePath(under, pathSplitArr, fileHeight, false);
                    continue block14;
                }
                case "A": {
                    float[] pointArr = PdfWritePathUtils.writeAPath(under, pathSplitArr, pointX, pointY, fileHeight);
                    pointX = pointArr[0];
                    pointY = pointArr[1];
                    continue block14;
                }
                case "Q": {
                    float[] pointQArr = PdfWritePathUtils.writeQPath(under, pathSplitArr, pointX, pointY, fileHeight);
                    pointX = pointQArr[0];
                    pointY = pointQArr[1];
                    continue block14;
                }
            }
        }
    }

    private static void writeLinePath(PdfContentByte under, String[] pathSplitArr, float fileHeight, boolean startFlag) {
        float pathX = PdfWritePathUtils.getPointPx(pathSplitArr[1], fileHeight, false);
        float pathY = PdfWritePathUtils.getPointPx(pathSplitArr[2], fileHeight, true);
        if (startFlag) {
            under.moveTo(pathX, pathY);
        } else {
            under.lineTo(pathX, pathY);
        }
    }

    private static float[] writeAPath(PdfContentByte under, String[] pathSplitArr, float lastPointX, float lastPointY, float fileHeight) {
        under.moveTo(lastPointX, lastPointY);
        float rx = PdfUtils.getNormalPxBySvgStrPx((String)pathSplitArr[1]);
        float ry = PdfUtils.getNormalPxBySvgStrPx((String)pathSplitArr[2]);
        float x = PdfWritePathUtils.getPointPx(pathSplitArr[6], fileHeight, false);
        float y = PdfWritePathUtils.getPointPx(pathSplitArr[7], fileHeight, true);
        float x1 = lastPointX;
        float y1 = lastPointY;
        float x2 = x;
        float y2 = y;
        float extent = Float.parseFloat(pathSplitArr[3]);
        float startAng = 0.0f;
        if (x1 < x2 && y1 < y2) {
            startAng = 90.0f;
            x2 += rx;
            y1 -= ry;
        } else if (x1 < x2 && y1 > y2) {
            startAng = 0.0f;
            x1 -= rx;
            y2 -= ry;
        } else if (x1 > x2 && y1 < y2) {
            startAng = 180.0f;
            x1 += rx;
            y2 += ry;
        } else if (x1 > x2 && y1 > y2) {
            startAng = 270.0f;
            x2 -= rx;
            y1 += ry;
        }
        under.arc(x1, y1, x2, y2, startAng, extent);
        return new float[]{x, y};
    }

    private static void writeCurvePath(PdfContentByte under, String[] pointSplitArr, float fileHeight) {
        float pathCx1 = PdfWritePathUtils.getPointPx(pointSplitArr[1], fileHeight, false);
        float pathCy1 = PdfWritePathUtils.getPointPx(pointSplitArr[2], fileHeight, true);
        float pathCx2 = PdfWritePathUtils.getPointPx(pointSplitArr[3], fileHeight, false);
        float pathCy2 = PdfWritePathUtils.getPointPx(pointSplitArr[4], fileHeight, true);
        float pathCx3 = PdfWritePathUtils.getPointPx(pointSplitArr[5], fileHeight, false);
        float pathCy3 = PdfWritePathUtils.getPointPx(pointSplitArr[6], fileHeight, true);
        under.curveTo(pathCx1, pathCy1, pathCx2, pathCy2, pathCx3, pathCy3);
    }

    private static float getPointPx(String pointStr, float fileHeight, boolean yFlag) {
        float pointPx = PdfUtils.getNormalPxBySvgStrPx((String)pointStr);
        if (yFlag) {
            pointPx = fileHeight - pointPx;
        }
        return pointPx;
    }
}

