/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.formplugin.bill.matchbill.control.NegativeBillMatchControl;
import kd.imc.sim.schedule.AbstractJobTask;
import kd.imc.sim.schedule.bill.NegativeBillMatchTask;

public class BillMatchDetailListPlugin
extends AbstractListPlugin {
    private static final String TRACKUP = "trackup";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TRACKUP});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        String operateKey = oprate.getOperateKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if ("red".equals(operateKey)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_match_bill", (String)String.join((CharSequence)",", "orgid", "invoicetype", "billno"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(rows.getPrimaryKeyValues()).collect(Collectors.toSet())).toArray());
            new NegativeBillMatchControl().red((AbstractFormPlugin)this, args, bills);
        } else if ("match".equals(operateKey)) {
            HashSet<Long> orgIdSet = new HashSet<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                orgIdSet.add(row.getMainOrgId());
            }
            if (orgIdSet.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6570\u636e\u64cd\u4f5c", (String)"NegativeBillMatchListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "trackup": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                BillHelper.trackupOriginalBill((AbstractListPlugin)this, (String)"sim_original_bill", new HashSet<Object>(this.getOriginalBillPKs(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds())));
                break;
            }
            case "match": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                HashMap params = Maps.newHashMap();
                params.put("pks", this.getOriginalBillPKs(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds()));
                ViewUtil.openDialog((AbstractFormPlugin)this, (Map)params, (String)"sim_match_bill_process", (String)"sim_match_bill_process");
                break;
            }
            case "trackdown": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                List<Object> idList = this.getOriginalBillPKs(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds());
                HashSet successInvIds = new HashSet(idList.size());
                HashSet unSuccessInvIds = new HashSet(idList.size());
                HashSet redInfoIds = new HashSet(idList.size());
                HashSet redConfirmBillIds = new HashSet(idList.size());
                BillHelper.matchBillTrackDown(idList, successInvIds, unSuccessInvIds, redInfoIds, redConfirmBillIds);
                if (!CollectionUtils.isEmpty(unSuccessInvIds)) {
                    ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_invoice_wait", unSuccessInvIds);
                }
                if (!CollectionUtils.isEmpty(successInvIds)) {
                    ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_vatinvoice", successInvIds);
                }
                if (!CollectionUtils.isEmpty(redInfoIds)) {
                    ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_red_info", redInfoIds);
                }
                if (CollectionUtils.isEmpty(redConfirmBillIds)) break;
                ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_red_confirm_bill", redConfirmBillIds);
                break;
            }
            case "cancel_match": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "red": {
                List allErrorOrValidateInfo = afterDoOperationEventArgs.getOperationResult().getAllErrorOrValidateInfo();
                if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                    afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                    this.getView().showTipNotification(OperationConstant.getErrorMsg((OperationResult)afterDoOperationEventArgs.getOperationResult()));
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "sim_match_bill_process": {
                new NegativeBillMatchTask().dispatchTask(this, closedCallBackEvent.getReturnData(), ResManager.loadKDString((String)"\u5339\u914d\u84dd\u7968", (String)"NegativeBillMatchListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "dispatchTask": {
                AbstractJobTask.dispatchTaskCloseCallback(this, closedCallBackEvent.getReturnData());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        if ("red".equals(messageBoxClosedEvent.getCallBackId())) {
            new NegativeBillMatchControl().redConfirmCallBack((AbstractFormPlugin)this, messageBoxClosedEvent, ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues());
            this.getView().invokeOperation("refresh");
        }
    }

    private List<Object> getOriginalBillPKs(List<Object> matchBillIds) {
        DynamicObjectCollection relationList = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter(matchBillIds, (String)"tbillid").toArray());
        return relationList.stream().map(relation -> relation.get("sbillid")).distinct().collect(Collectors.toList());
    }
}

