/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.SynchronizationQuotaHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.SimCommonConstant;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.FiArFinArBillHelper;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.common.helper.SimCallBackHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.bill.originalbill.AbstractInvoiceOriginalBillWorkbenchPlugin;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginSelectInvoiceControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginPreviewIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.util.Dto.CheckResult;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class InvoiceOriginalBillPlugin
extends AbstractInvoiceOriginalBillWorkbenchPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(InvoiceOriginalBillPlugin.class);
    public static final String SIM_ORIGIN_SELECT = "sim_origin_select";
    private static final String SIM_ORIGIN_BILL_FILTER = "sim_origin_bill_filter";
    private static final String SIM_ORIGIN_BILL_SCHEME_FILTER = "sim_origin_bill_scheme_filter";

    public void filterContainerInit(FilterContainerInitArgs args) {
        Boolean preoriginal;
        String filter = this.getPageCache().get(SIM_ORIGIN_BILL_FILTER);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            return;
        }
        String billNos = (String)this.getView().getFormShowParameter().getCustomParam("billNos");
        if (StringUtils.isNotBlank((CharSequence)billNos)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                commonFilterColumn.setDefaultValue(null);
            }
            this.getPageCache().put(SIM_ORIGIN_BILL_FILTER, SIM_ORIGIN_BILL_FILTER);
        }
        if (StringUtils.isNotBlank((Object)(preoriginal = (Boolean)this.getView().getFormShowParameter().getCustomParam("preoriginal"))) && preoriginal.booleanValue()) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                commonFilterColumn.setDefaultValue(null);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String billNos = (String)this.getView().getFormShowParameter().getCustomParam("billNos");
        if (StringUtils.isNotBlank((CharSequence)billNos)) {
            try {
                String filter = this.getPageCache().get(SIM_ORIGIN_BILL_SCHEME_FILTER);
                if (StringUtils.isBlank((CharSequence)filter)) {
                    e.getQFilters().clear();
                    this.getPageCache().put(SIM_ORIGIN_BILL_SCHEME_FILTER, SIM_ORIGIN_BILL_SCHEME_FILTER);
                }
                e.getCustomQFilters().add(new QFilter("billno", "in", (Object)billNos.split(",")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"workout"});
        SynchronizationQuotaHelper.syncNowTaxQuotaNoByOrg();
        BotpHelper.dealHistoryData();
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "btn_import": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_IMPORT);
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"sim_original_bill_import", (String)"sim_original_bill_import");
                break;
            }
            case "btn_bill_withdraw": {
                this.billWithDraw(rows);
                break;
            }
            case "issuepush": {
                if (rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceOriginalBillPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), SimCommonConstant.SHOW_TIME);
                    return;
                }
                DynamicObject[] dynamicObjects = this.checkSpecialBill(rows.getPrimaryKeyValues(), "\u4e00\u952e\u5f00\u7968");
                CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_OPEN_INVOICE, (DynamicObject[])dynamicObjects);
                this.issuePush(dynamicObjects);
                break;
            }
            case "addrelateinvoice": {
                this.addRelateInvoice(rows);
                break;
            }
            case "cancelrelateinvoice": {
                this.cancelRelateInvoice(rows);
                break;
            }
            case "queryinvoices": {
                this.queryInvoices(rows);
                break;
            }
            case "bill_pratiques_part": {
                this.openPartWorkBench(((IListView)this.getView()).getSelectedRows());
                break;
            }
            case "bill_process": 
            case "bill_tempsave_preview": {
                DynamicObject[] bills = this.checkSpecialBill(rows.getPrimaryKeyValues(), "\u5355\u636e\u5904\u7406", "bill_tempsave_preview".equals(key));
                this.billProcess(bills, "bill_tempsave_preview".equals(key));
                break;
            }
            case "bill_process_preview": {
                DynamicObject[] previeBills = this.checkSpecialBill(rows.getPrimaryKeyValues(), "\u9884\u89c8\u5f00\u7968");
                this.checkBillPreviewSpecialCodeRemark(previeBills);
                break;
            }
            case "cancel_invoice": {
                this.cancelBillInvoice(rows);
                break;
            }
            case "closebill": {
                break;
            }
            case "billcopy": {
                DynamicObject[] oriBills;
                for (DynamicObject oriBill : oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "sim_original_bill_item", "billno"), (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray())) {
                    DynamicObjectCollection items = oriBill.getDynamicObjectCollection("sim_original_bill_item");
                    if (items.size() != 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u6ca1\u6709\u660e\u7ec6\u4e0d\u80fd\u590d\u5236", (String)"InvoiceOriginalBillPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), oriBill.getString("billno")));
                }
                break;
            }
            case "chongxiao": {
                DynamicObject[] oriBills;
                for (DynamicObject oriBill : oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"closestatus,billno", (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray())) {
                    if ("1".equals(oriBill.getString("closestatus"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u975e\u5173\u95ed\u72b6\u6001\u4e0d\u80fd\u624b\u5de5\u51b2\u9500\u4e0b\u63a8\u7684\u5e94\u6536\u5355", (String)"InvoiceOriginalBillPlugin_85", (String)"imc-sim-formplugin", (Object[])new Object[0]), oriBill.getString("billno")));
                }
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5c06\u9009\u4e2d\u7684%s\u6761\u5f00\u7968\u7533\u8bf7\u5355\u4e0b\u63a8\u7684\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u5417\uff1f", (String)"InvoiceOriginalBillPlugin_86", (String)"imc-sim-formplugin", (Object[])new Object[0]), oriBills.length), (String)"chongxiao");
            }
        }
    }

    private void checkBillTempSavePreview(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            if (bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0 && InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u6027\u8d28\u4e3a\u201c\u6b63\u6570\u201d\u3001\u53d1\u7968\u79cd\u7c7b\u4e3a\u201d\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09\u201d\u201c\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\u201d\u3001\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u7684\u5f00\u7968\u7533\u8bf7\u5355\u624d\u80fd\u8fdb\u884c\u53d1\u7968\u9884\u89c8\u3002", (String)"InvoiceOriginalBillPlugin_123", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void issuePush(DynamicObject[] dynamicObjects) {
        HashSet typeSet = Sets.newHashSet();
        if (!this.checkBill(dynamicObjects, typeSet)) {
            return;
        }
        CheckResult result = OriginalBillFormEditUtil.checkNormalRedReasonInfo((DynamicObject[])dynamicObjects, (Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE);
        ArrayList errMsgList = result.getErrMsgList();
        if (!errMsgList.isEmpty()) {
            String errMsg = String.join((CharSequence)"\r\n", errMsgList);
            ViewUtil.openConfirm((String)"normal_red_invoice", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ea2\u5b57\u666e\u7968\u6570\u636e\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u4fee\u6b63", (String)"InvoiceOriginalBillPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceOriginalBillPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceOriginalBillPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)errMsg);
            return;
        }
        ArrayList updateList = result.getUpdateList();
        if (!updateList.isEmpty()) {
            ImcSaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        BillHelper.checkIssuePushSpecialCodeRemark((AbstractFormPlugin)this, (DynamicObject[])dynamicObjects, (HashSet)typeSet);
    }

    public DynamicObject[] checkSpecialBill(Object[] billIds, String description) {
        return this.checkSpecialBill(billIds, description, false);
    }

    public DynamicObject[] checkSpecialBill(Object[] billIds, String description, boolean isTempSavePreview) {
        DynamicObject[] equipment;
        boolean isAllEle;
        int limitCount;
        boolean isIssueOperate;
        if (billIds == null || billIds.length == 0) {
            return new DynamicObject[0];
        }
        boolean bl = isIssueOperate = "\u9884\u89c8\u5f00\u7968".equals(description) || "\u4e00\u952e\u5f00\u7968".equals(description) || "\u5355\u636e\u5904\u7406".equals(description);
        if (isIssueOperate && billIds.length > (limitCount = BillHelper.getBillLimitCount())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6700\u591a\u63d0\u4ea4%s\u4e2a\u5355\u636e", (String)"InvoiceOriginalBillPlugin_76", (String)"imc-sim-formplugin", (Object[])new Object[0]), limitCount));
        }
        DynamicObject[] oriBills = OriginalBillHelper.queryOriginalbillsByIds((Object[])billIds);
        if (isIssueOperate) {
            this.checkBillItemLimitSize(oriBills);
        }
        if (oriBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5f00\u7968\u7533\u8bf7\u5355", (String)"InvoiceOriginalBillPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (isTempSavePreview) {
            this.checkBillTempSavePreview(oriBills);
        }
        OriginalBillPluginIssueControl.checkOnlyType((DynamicObject[])oriBills);
        for (DynamicObject oriBill : oriBills) {
            Object billSourceType = oriBill.get("billsourcetype");
            if (isIssueOperate) {
                this.checkRedConfirmInfo(oriBill, description);
            }
            OriginalBillPluginPreviewIssueControl.checkDescription(description, billSourceType);
        }
        boolean bl2 = isAllEle = InvoiceUtils.isAllEInvoice((Object)oriBills[0].getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)oriBills[0].getString("iselepaper"));
        if (isIssueOperate && !isAllEle && ((equipment = EquipmentUtil.getEquipmentByOrgId((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)oriBills[0].get("orgid")))) == null || equipment.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        return oriBills;
    }

    private void checkRedConfirmInfo(DynamicObject oriBill, String description) {
        if (RedConfirmHelper.isRedConfirmBill((DynamicObject)oriBill)) {
            if ("\u5355\u636e\u5904\u7406".equals(description)) {
                String infoCode = oriBill.getString("infocode");
                if (StringUtils.isNotBlank((CharSequence)infoCode)) {
                    RedConfirmHelper.checkOriginalBillRedConfirmInfo((DynamicObject)oriBill);
                    RedConfirmHelper.checkRedConfirmBillNoUsed((DynamicObject)oriBill);
                }
            } else {
                RedConfirmHelper.checkOriginalBillRedConfirmInfo((DynamicObject)oriBill);
                RedConfirmHelper.checkRedConfirmBillNoUsed((DynamicObject)oriBill);
            }
        }
    }

    private void closeBill(ListSelectedRowCollection rows) {
        Object[] primaryKeys = rows.getPrimaryKeyValues();
        if (primaryKeys.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5173\u95ed\u7684\u5355\u636e", (String)"InvoiceOriginalBillPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "invoicetype", "orgid", "billproperties", "billcomplete", "systemsource", "closestatus", "billno"), (QFilter[])new QFilter("id", "in", (Object)primaryKeys).toArray());
        HashSet<String> systemSourceSet = new HashSet<String>();
        List easSystems = CallbackHelperUtil.getEasSystemSource();
        for (DynamicObject originalBill : originalBills) {
            systemSourceSet.add(originalBill.getString("systemsource"));
        }
        PermissionHelper.checkOrgPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_CLOSEBILLS, (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBills[0].get("orgid")));
        if (easSystems.contains(systemSourceSet.iterator().next())) {
            ViewUtil.openConfirm((String)"closeEASBills", (String)ResManager.loadKDString((String)"\u5173\u95ed\u5f00\u7968\u7533\u8bf7\u5355\u540e\uff0c\u5c06\u91ca\u653e\u4e0a\u6e38\u5355\u636e\u7684\u53ef\u4e0b\u63a8\u91d1\u989d\uff0c\u60a8\u53ef\u4ee5\u4ece\u4e0a\u6e38\u4e1a\u52a1\u5355\u636e\u91cd\u65b0\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u8fdb\u884c\u91cd\u5f00\u3002", (String)"InvoiceOriginalBillPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceOriginalBillPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceOriginalBillPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            ViewUtil.openConfirm((String)"closeBills", (String)ResManager.loadKDString((String)"\u5173\u95ed\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u5c06\u91ca\u653e\u4e0a\u6e38\u5355\u636e\u7684\u5173\u8054\u4e0b\u63a8\u91d1\u989d\uff0c\u60a8\u9700\u8981\u4ece\u4e0a\u6e38\u5355\u636e\u4e0b\u63a8\u53d1\u7968\u4e91\u8fdb\u884c\u91cd\u5f00\uff1b\u4e0d\u80fd\u5728\u5f00\u7968\u7533\u8bf7\u5355\u4e0a\u7ee7\u7eed\u4e0b\u63a8\u91cd\u65b0\u5f00\u7968\u3002", (String)"InvoiceOriginalBillPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceOriginalBillPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceOriginalBillPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void cancelBillInvoice(ListSelectedRowCollection rows) {
        Object[] primaryKeyValues = rows.getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u5355\u636e\uff0c\u518d\u8fdb\u884c\u4f5c\u5e9f", (String)"InvoiceOriginalBillPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (primaryKeyValues.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u52fe\u9009\u4e00\u4e2a\u5355\u636e\u6570\u636e\u8fdb\u884c\u4f5c\u5e9f", (String)"InvoiceOriginalBillPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] dynamicObjects = this.checkSpecialBill(rows.getPrimaryKeyValues(), "\u4f5c\u5e9f\u53d1\u7968");
        CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_CANCEL_INVOICE, (DynamicObject[])dynamicObjects);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        Object[] pks = this.queryBillRelateInvoices(primaryKeyValues[0]);
        if (pks.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u5173\u8054\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        customParams.put("keys", pks);
        customParams.put("billId", primaryKeyValues[0]);
        customParams.put("ParentForm", "sim_original_bill");
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"iselepaper", (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
        if (AllEleAuthHelper.isElePaper((Object)invoices[0].getString("iselepaper"))) {
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceOriginalBillPlugin_97", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_inv_choose_abo_alle", (String)"msg_inv_abolish");
        } else {
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceOriginalBillPlugin_97", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_inv_choose_abolish", (String)"msg_inv_abolish");
        }
    }

    private Object[] queryBillRelateInvoices(Object primaryKeyValue) {
        DynamicObject[] invoiceArray;
        DynamicObject oriBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_original_bill");
        if ("C".equals(oriBill.getString("billsourcetype"))) {
            String invoiceCode = oriBill.getString("invoicecode");
            String invoiceNo = oriBill.getString("invoiceno");
            if (StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceNo)) {
                return new Object[0];
            }
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "iselepaper", "invoicecode", "invoiceno"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).toArray());
            this.checkInvalidInvoice(new DynamicObject[]{invoice});
            if (invoice == null) {
                return new Object[0];
            }
            String errmsg = FiArFinArBillHelper.isCanRedOrCancelNew((DynamicObject)invoice, (String)"");
            if (StringUtils.isNotBlank((CharSequence)errmsg)) {
                throw new KDBizException(errmsg);
            }
            return new Object[]{invoice.getPkValue()};
        }
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", primaryKeyValue).and("isdelete", "!=", (Object)"Y").toArray());
        if (array.length == 0) {
            return new Object[0];
        }
        ArrayList<Object> pks = new ArrayList<Object>();
        for (DynamicObject object : array) {
            pks.add(object.get("tbillid"));
        }
        Object orgPk = oriBill.getDynamicObject("orgid").getPkValue();
        ArrayList<Object> pkArray = new ArrayList<Object>();
        QFilter filter = new QFilter("id", "in", (Object)pks.toArray(new Object[0]));
        DynamicObject[] redInfo = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true), (QFilter[])filter.toArray());
        if (redInfo.length > 0) {
            DynamicObject[] invoices;
            ArrayList<Object> infoCodes = new ArrayList<Object>();
            for (DynamicObject object : redInfo) {
                infoCodes.add(object.get("infocode"));
            }
            QFilter invoiceFilter = new QFilter("infocode", "in", (Object)infoCodes.toArray(new Object[0])).and("orgid", "=", orgPk);
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "systemsource", "buyertype", "invoicecode", "invoiceno", "iselepaper"), (QFilter[])invoiceFilter.toArray())) {
                pkArray.add(invoice.getPkValue());
                String errmsg = FiArFinArBillHelper.isCanRedOrCancelNew((DynamicObject)invoice, (String)"");
                if (!StringUtils.isNotBlank((CharSequence)errmsg)) continue;
                throw new KDBizException(errmsg);
            }
            this.checkInvalidInvoice(invoices);
        }
        for (DynamicObject invoice : invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "systemsource", "buyertype", "invoicecode", "invoiceno", "iselepaper"), (QFilter[])new QFilter("id", "in", (Object)pks.toArray(new Object[0])).toArray())) {
            if (!StringUtils.isNotBlank((CharSequence)invoice.getString("invoicecode"))) continue;
            pkArray.add(invoice.getPkValue());
            String errmsg = FiArFinArBillHelper.isCanRedOrCancelNew((DynamicObject)invoice, (String)"");
            if (!StringUtils.isNotBlank((CharSequence)errmsg)) continue;
            throw new KDBizException(errmsg);
        }
        this.checkInvalidInvoice(invoiceArray);
        return pkArray.toArray(new Object[0]);
    }

    private void checkInvalidInvoice(DynamicObject[] invoiceArray) {
        String isElePaper = invoiceArray[0].getString("iselepaper");
        boolean elePaper = AllEleAuthHelper.isElePaper((Object)isElePaper);
        for (DynamicObject invoice : invoiceArray) {
            boolean invElePaper = AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"));
            if (elePaper == invElePaper) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u53d1\u7968\u540c\u65f6\u5305\u542b\u6570\u7535\u7eb8\u7968\u548c\u975e\u6570\u7535\u7eb8\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalBillPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean checkBill(DynamicObject[] dynamicObjects, HashSet<Object> typeSet) {
        HashMap<String, String> redConfirmBillNoMap = new HashMap<String, String>();
        for (DynamicObject bill : dynamicObjects) {
            if (InvoiceOriginalBillPlugin.operationOriginalBill(bill.getString("billstatus"), "issuepush")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7684\u5355\u636e\u5ba1\u6279\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u4e00\u952e\u5f00\u7968", (String)"InvoiceOriginalBillPlugin_78", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), InvoiceOriginalBillPlugin.getOriginalBillStatuNameByCode(bill.getString("billstatus"))), Integer.valueOf(2000));
                return false;
            }
            if (InvoiceOriginalBillPlugin.checkBlueInvoiceOriginalBill(bill)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%s)\u7684\u5355\u636e\u5305\u542b\u591a\u4e2a\u84dd\u7968\u4ee3\u7801\u548c\u84dd\u7968\u53f7\u7801,\u4e0d\u5141\u8bb8\u4e00\u952e\u5f00\u7968", (String)"InvoiceOriginalBillPlugin_35", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")), Integer.valueOf(2000));
                return false;
            }
            if ("2".equals(bill.getString("confirmstate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u975e\u201c\u5df2\u7533\u8bf7\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvoiceOriginalBillPlugin_36", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!"0".equals(bill.getString("validstate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u201c\u6b63\u5e38\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalBillPlugin_37", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("1".equals(bill.getString("closestatus"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u672a\u5173\u95ed\u201d\u7684\u5355\u636e\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalBillPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (RedConfirmHelper.isRedConfirmBill((DynamicObject)bill)) {
                RedConfirmHelper.checkOriginalBillRedConfirmInfo((DynamicObject)bill);
                String redConfirmBillNo = bill.getString("infocode");
                String billNo1 = bill.getString("billno");
                if (StringUtils.isNotBlank((CharSequence)redConfirmBillNo)) {
                    if (redConfirmBillNoMap.containsKey(redConfirmBillNo)) {
                        String billNo2 = (String)redConfirmBillNoMap.get(redConfirmBillNo);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u548c\u5355\u636e%2$s\u7ed1\u5b9a\u7684\u7ea2\u5b57\u786e\u5b9a\u5355\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalBillPlugin_79", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo1, billNo2));
                    }
                    redConfirmBillNoMap.put(redConfirmBillNo, billNo1);
                }
            }
            if (BillHelper.isRedInfo((DynamicObject)bill)) {
                typeSet.add("-1");
                this.getPageCache().put("select_bill_issyetype", "-1");
                continue;
            }
            typeSet.add("1");
            this.getPageCache().put("select_bill_issyetype", "1");
        }
        if (typeSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u76f8\u540c\u7684\u5355\u636e\u6027\u8d28\u548c\u53d1\u7968\u79cd\u7c7b\u624d\u80fd\u6279\u91cf\u64cd\u4f5c", (String)"InvoiceOriginalBillPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("select_bill_issyetype");
            return false;
        }
        if (typeSet.iterator().next().equals("-1")) {
            return this.isSpecialInvoice((AbstractFormPlugin)this, dynamicObjects, "isNotExsit");
        }
        return true;
    }

    private void queryInvoices(ListSelectedRowCollection rows) {
        Object[] primaryKeyValues = this.getRow(rows);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"orgid", (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
        CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_QUERYINVOICES, (DynamicObject[])dynamicObjects);
        if (primaryKeyValues == null || primaryKeyValues.length == 0) {
            return;
        }
        HashMap<String, Object[]> param = new HashMap<String, Object[]>();
        param.put("orginalBillPrimaryKey", primaryKeyValues);
        ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_origin_bill_invoices", null);
    }

    private void addRelateInvoice(ListSelectedRowCollection rows) {
        try {
            Object[] primaryKeyValues = this.getRelateinvoiceRow(rows);
            if (primaryKeyValues == null) {
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "orgid", "billstatus", "billno", "confirmstate", "validstate", "totalamount", "systemsource"), (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
            CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_ADDRELATEINVOICE, (DynamicObject[])dynamicObjects);
            int endCount = 0;
            ArrayList<Long> pkList = new ArrayList<Long>(4);
            BigDecimal allTotalAmount = BigDecimal.ZERO;
            HashSet<String> systemSourceSet = new HashSet<String>(dynamicObjects.length);
            boolean hasXk = false;
            for (DynamicObject dataShelve : dynamicObjects) {
                allTotalAmount = allTotalAmount.add(dataShelve.getBigDecimal("totalamount"));
                if (InvoiceOriginalBillPlugin.operationOriginalBill(dataShelve.getString("billstatus"), "addrelateinvoice")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7684\u5355\u636e\u5ba1\u6279\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_80", (String)"imc-sim-formplugin", (Object[])new Object[0]), dataShelve.getString("billno"), InvoiceOriginalBillPlugin.getOriginalBillStatuNameByCode(dataShelve.getString("billstatus"))), Integer.valueOf(2000));
                    return;
                }
                if (!"0".equals(dataShelve.getString("confirmstate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\"\u672a\u7533\u8bf7\"\u7684\u5355\u636e\u4e0d\u80fd\u518d\u624b\u52a8\u8865\u5145\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_41", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("2".equals(dataShelve.getString("validstate"))) {
                    pkList.add(dataShelve.getLong("id"));
                    ++endCount;
                }
                if ("XKQJ".equals(dataShelve.getString("systemsource"))) {
                    hasXk = true;
                }
                systemSourceSet.add("Kingdee_Excel".equals(dataShelve.getString("systemsource")) ? "" : dataShelve.getString("systemsource"));
            }
            if (BigDecimalUtil.compareZero((BigDecimal)allTotalAmount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5408\u8ba1\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u96f6\uff0c\u4e0d\u5141\u8bb8\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_121", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (endCount != 0 && endCount != dynamicObjects.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u7ed3\u675f\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (hasXk && dynamicObjects.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9500\u552e\u53d1\u7968\u5355\u63a8\u9001\u7684\u5355\u636e\u53ea\u5141\u8bb8\u5355\u5f20\u56de\u586b!", (String)"InvoiceOriginalBillPlugin_124", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (systemSourceSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u540c\u4e1a\u52a1\u7cfb\u7edf\u7684\u5355\u636e\u4e0d\u80fd\u540c\u65f6\u56de\u586b!", (String)"InvoiceOriginalBillPlugin_125", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("primaryKey", StringUtils.join((Object[])primaryKeyValues, (String)","));
            String billEditType = "1";
            if (endCount == 0) {
                param.put("permitEdit", "true");
            } else {
                DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)String.join((CharSequence)",", "billdetailid", "serialno"), (QFilter[])new QFilter("originalbillid", "in", (Object)pkList.toArray()).and(BillHelper.notCancelFilter()).toArray());
                Set detailIdSet = Stream.of(dbRelate).map(a -> a.getString("billdetailid")).collect(Collectors.toSet());
                List detailIdSetNotEmpty = detailIdSet.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.toString())).collect(Collectors.toList());
                if (detailIdSet.contains("")) {
                    if (detailIdSetNotEmpty.size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5305\u542b\u4e24\u79cd\u56de\u586b\u65b9\u5f0f\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    billEditType = "2";
                }
                if (dbRelate.length > 0) {
                    HashSet<String> typeSet = new HashSet<String>(dbRelate.length);
                    for (DynamicObject invoice : dbRelate) {
                        typeSet.add(invoice.getString("serialno"));
                    }
                    if (typeSet.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5305\u542b\u591a\u4e2a\u56de\u586b\u6279\u6b21\u53f7\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                param.put("permitEdit", "false");
            }
            param.put("editType", billEditType);
            param.put("orgId", DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObjects[0].get("orgid")));
            ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_add_relate_inv", (String)"addrelateinvoice");
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void cancelRelateInvoice(ListSelectedRowCollection rows) {
        try {
            Object[] primaryKeyValues = this.getRelateinvoiceRow(rows);
            if (primaryKeyValues == null) {
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "orgid", "billstatus", "billno", "confirmstate", "validstate", "id"), (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
            CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_CANCELRELATEINVOICE, (DynamicObject[])dynamicObjects);
            int endCount = 0;
            ArrayList<Long> pkList = new ArrayList<Long>(4);
            for (DynamicObject dataShelve : dynamicObjects) {
                if (InvoiceOriginalBillPlugin.operationOriginalBill(dataShelve.getString("billstatus"), "cancelrelateinvoice")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7684\u5355\u636e\u5ba1\u6279\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u53d6\u6d88\u56de\u586b", (String)"InvoiceOriginalBillPlugin_81", (String)"imc-sim-formplugin", (Object[])new Object[0]), dataShelve.getString("billno"), InvoiceOriginalBillPlugin.getOriginalBillStatuNameByCode(dataShelve.getString("billstatus"))), Integer.valueOf(2000));
                    return;
                }
                if (!"0".equals(dataShelve.getString("confirmstate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\"\u672a\u7533\u8bf7\"\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53d6\u6d88\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!"2".equals(dataShelve.getString("validstate"))) continue;
                pkList.add(dataShelve.getLong("id"));
                ++endCount;
            }
            if (endCount != 0 && endCount != dynamicObjects.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\"\u5f00\u7968\u7ed3\u675f\"\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u56de\u586b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] relateInvoice = IssueInvoiceControlHelper.findRelateInvoice(pkList);
            if (relateInvoice != null && relateInvoice.length > 0) {
                List relateInvoicepks = Arrays.stream(relateInvoice).map(e -> e.getLong("id")).collect(Collectors.toList());
                Object[] billpks = Arrays.stream(relateInvoice).map(e -> e.getLong("originalbillid")).toArray();
                QFilter qFilter = new QFilter("id", "in", (Object)billpks);
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"billno", (QFilter[])qFilter.toArray());
                List billNos = Arrays.stream(bills).map(e -> e.getString("billno")).collect(Collectors.toList());
                StringBuilder msg = new StringBuilder();
                for (String billNo : billNos) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%1$s\u3002%2$s", (String)"InvoiceOriginalBillPlugin_88", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, "<br>"));
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                if (billNos.size() > 1) {
                    customParams.put("title", ResManager.loadKDString((String)"\u672c\u6279\u6b21\u56de\u586b\u5305\u542b\u591a\u4e2a\u5355\u636e\uff0c\u662f\u5426\u5168\u90e8\u53d6\u6d88\u56de\u586b\uff1f", (String)"InvoiceOriginalBillPlugin_49", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                } else {
                    customParams.put("title", ResManager.loadKDString((String)"\u672c\u6279\u6b21\u56de\u586b\u5305\u542b\u5982\u4e0b\u5355\u636e\uff0c\u662f\u5426\u53d6\u6d88\u56de\u586b\uff1f", (String)"InvoiceOriginalBillPlugin_50", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                customParams.put("msg", msg.toString());
                customParams.put("hasMore", billNos.size() > 2);
                customParams.put("listdata", relateInvoicepks);
                ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"sim_cancel_relate_invoice", (String)"sim_cancel_relate_invoice_callkey");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u56de\u586b\u53d1\u7968\u4fe1\u606f", (String)"InvoiceOriginalBillPlugin_51", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e2) {
            this.getView().showTipNotification(e2.getMessage());
        }
    }

    private Object[] getRow(ListSelectedRowCollection rows) {
        Object[] primaryKeyValues = rows.getPrimaryKeyValues();
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u67e5\u770b\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_52", (String)"imc-sim-formplugin", (Object[])new Object[0]), SimCommonConstant.SHOW_TIME);
            return null;
        }
        return primaryKeyValues;
    }

    private Object[] getRelateinvoiceRow(ListSelectedRowCollection rows) {
        Object[] primaryKeyValues = rows.getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceOriginalBillPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), SimCommonConstant.SHOW_TIME);
            return null;
        }
        return primaryKeyValues;
    }

    private void refresh() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
        billList.clearSelection();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        switch (args.getFieldName()) {
            case "invoicetype": {
                args.setCancel(true);
                HashMap<String, Object[]> param = new HashMap<String, Object[]>();
                param.put("orginalBillPrimaryKey", new Object[]{row.getPrimaryKeyValue()});
                ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_origin_bill_invoices", null);
                break;
            }
            case "invoiceno": {
                args.setCancel(true);
                ListSelectedRowCollection rows = new ListSelectedRowCollection();
                rows.add((Object)row);
                this.queryInvoices(rows);
                break;
            }
            case "comprehensivestatus": 
            case "operatebatch": {
                this.operateBatchRepeat(args, row, args.getFieldName());
            }
        }
    }

    private void operateBatchRepeat(HyperLinkClickArgs args, ListSelectedRow row, String key) {
        args.setCancel(true);
        DynamicObject bill = QueryServiceHelper.queryOne((String)"sim_original_bill", (String)String.join((CharSequence)",", "operatebatch", "orgid"), (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_BILL_PROCESS, (DynamicObject[])new DynamicObject[]{bill});
        if (StringUtils.isBlank((CharSequence)bill.getString("operatebatch"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u64cd\u4f5c\u6279\u6b21\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u518d\u6b21\u8fdb\u5165\u5de5\u4f5c\u53f0", (String)"InvoiceOriginalBillPlugin_122", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pk", row.getPrimaryKeyValue());
        if ("operatebatch".equals(key)) {
            params.put("operatebatch", bill.getString("operatebatch"));
        }
        ViewUtil.openDialog((AbstractFormPlugin)this, params, (String)"sim_alle_bill_process", (String)"sim_alle_bill_process");
    }

    private void billWithDraw(ListSelectedRowCollection rows) {
        try {
            if (rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"InvoiceOriginalBillPlugin_54", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (rows.getPrimaryKeyValues().length > 500) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u56de\u64a4\u6700\u5927\u652f\u6301500\u6761", (String)"InvoiceOriginalBillPlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            DynamicObject oriBillObj = BusinessDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue(), (String)"sim_original_bill", (String)String.join((CharSequence)",", "salertaxno", "systemsource"));
            if (null == oriBillObj) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u59cb\u5355\u636e\u5217\u8868\u6570\u636e\u5df2\u5237\u65b0,\u8bf7\u91cd\u8bd5", (String)"InvoiceOriginalBillPlugin_56", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            String taxNo = oriBillObj.getString("salertaxno");
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0d\u5b58\u5728", (String)"InvoiceOriginalBillPlugin_57", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            DynamicObject[] selOriBillList = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "orgid", "confirmstate", "billno", "validstate", "billsource", "billstatus", "id", "closestatus", "billsourcetype"), (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray());
            CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_BILL_WITHDRAW, (DynamicObject[])selOriBillList);
            if (selOriBillList.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u59cb\u5355\u636e\u5217\u8868\u6570\u636e\u5df2\u5237\u65b0,\u8bf7\u91cd\u8bd5", (String)"InvoiceOriginalBillPlugin_56", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("sbillid", "in", (Object)rows.getPrimaryKeyValues()).toArray());
            Set billIdSet = Stream.of(relations).map(o -> o.getLong("sbillid")).collect(Collectors.toSet());
            for (DynamicObject bill : selOriBillList) {
                if (!"0".equals(bill.getString("confirmstate"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u672a\u7533\u8bf7\u201d\u7684\u5f00\u7968\u7533\u8bf7\u5355\u624d\u80fd\u56de\u64a4\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"InvoiceOriginalBillPlugin_59", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                    return;
                }
                if (OriginalBillConstant.isSpecialSourcType((Object)bill.getString("billsourcetype"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u666e\u901a\u5355\u652f\u6301\u56de\u9000\u4e0a\u6e38\u5355\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"InvoiceOriginalBillPlugin_84", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                    return;
                }
                if (!"0".equals(bill.getString("validstate"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u7684\u5f00\u7968\u7533\u8bf7\u5355\u624d\u80fd\u56de\u64a4\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"InvoiceOriginalBillPlugin_60", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                    return;
                }
                if (!("2".equals(bill.getString("billsource")) || "3".equals(bill.getString("billsource")) || "8".equals(bill.getString("billsource")))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e\u6765\u6e90\u4e0d\u652f\u6301\u56de\u64a4\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"InvoiceOriginalBillPlugin_61", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                    return;
                }
                if (!BillStatusEnum.TEMP_SAVE.getCode().equals(bill.getString("billstatus")) && !BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(bill.getString("billstatus"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6682\u5b58\u201d\u6216\u201c\u65e0\u9700\u5ba1\u6279\u201d\u7684\u5f00\u7968\u7533\u8bf7\u5355\u624d\u80fd\u56de\u64a4\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"InvoiceOriginalBillPlugin_62", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                    return;
                }
                if (billIdSet.contains(bill.getLong("id"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0d\u652f\u6301\u56de\u64a4\uff0c\u5355\u636e\u5df2\u5173\u8054\u53d1\u7968\uff0c\u65e0\u6cd5\u56de\u64a4", (String)"InvoiceOriginalBillPlugin_63", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                    return;
                }
                if (!"1".equals(bill.getString("closestatus"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5173\u95ed%s\u4e0d\u652f\u6301\u56de\u64a4", (String)"InvoiceOriginalBillPlugin_64", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                return;
            }
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u56de\u64a4%s\u6761\u5355\u636e\u5417", (String)"InvoiceOriginalBillPlugin_65", (String)"imc-sim-formplugin", (Object[])new Object[0]), selOriBillList.length), (String)"btn_bill_withdraw");
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getCallBackId().equals("isPreview")) {
            if (event.getResult() == MessageBoxResult.Yes) {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                this.billProcessPreView(bills);
            }
        } else if ("chongxiao".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                Object[] billPks = rows.getPrimaryKeyValues();
                Set billPkSet = Arrays.stream(billPks).collect(Collectors.toSet());
                BotpHelper.manualWriteOffArBill(billPkSet);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u6210\u529f", (String)"InvoiceOriginalBillPlugin_87", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
            }
        } else if ("closeEASBills".equals(event.getCallBackId()) || "closeBills".equals(event.getCallBackId())) {
            OperationResult result;
            if (event.getResult() == MessageBoxResult.Yes && (result = this.getView().invokeOperation("closebill")).isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f", (String)"InvoiceOriginalBillPlugin_120", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        } else if ("negativeBillDiffIssuePush".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                OriginalBillPluginIssueControl.issuePush((AbstractFormPlugin)this, (Object[])rows.getPrimaryKeyValues(), (Map)JSON.parseObject((String)event.getCustomVaule()));
            }
        } else if ("negativeBillDiffPreview".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                JSONObject returnData = JSON.parseObject((String)event.getCustomVaule());
                returnData.put("step", (Object)"preview");
                this.openWorkBench((AbstractFormPlugin)this, bills, (Map<String, Object>)returnData);
            }
        } else {
            SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)event);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)closedCallBackEvent);
    }

    public void pageRelease(EventObject e) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        BillHelper.clearWorkbench((ListSelectedRowCollection)list.getSelectedRows());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        HashSet needCheckKeySet = new HashSet();
        Collections.addAll(needCheckKeySet, "submit", "unsubmit", "audit", "unaudit", "bill_process_preview", "cancel_invoice", "bill_process", "bill_pratiques_part", "addrelateinvoice", "cancelrelateinvoice", "baritemap", "bill_red_reopen", "bill_invalid", "bill_invalid_reopen", "bill_reopen", "shelve", "recovery");
        Set itemKeys = ImcConfigUtil.getConfigStringArray((String)"CheckCloseItemKey", (String)"needCheckCloseItemKey");
        needCheckKeySet.addAll(itemKeys);
        Set removeItemKeys = ImcConfigUtil.getConfigStringArray((String)"CheckCloseItemKey", (String)"needRemoveItemKey");
        Set needCheckKeyList = needCheckKeySet.stream().filter(o -> !removeItemKeys.contains(o)).collect(Collectors.toSet());
        if (needCheckKeyList.contains(itemKey) && rows.size() > 0) {
            DynamicObject[] oriBills;
            for (DynamicObject oriBill : oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"closestatus,billno", (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray())) {
                if (!"1".equals(oriBill.getString("closestatus"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\uff1a%s\u4e3a\u5df2\u5173\u95ed\u5355\u636e\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"InvoiceOriginalBillPlugin_69", (String)"imc-sim-formplugin", (Object[])new Object[0]), oriBill.getString("billno")));
            }
        }
        if ("closebill".equals(itemKey)) {
            this.closeBill(rows);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (OriginSelectInvoiceControl.isReverseOperation((String)operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                this.openSelectInvoice(args, operateKey);
            }
        } else if ("trackupori".equals(operateKey)) {
            BillHelper.originalBillTrackup((AbstractListPlugin)this);
        } else if ("next_query".equals(operateKey)) {
            BillHelper.nextQuery((AbstractFormPlugin)this, (Object[])this.getSelectedRows().getPrimaryKeyValues());
        }
    }

    private void openSelectInvoice(AfterDoOperationEventArgs args, String operateKey) {
        DynamicObject[] bills;
        Map billNos = args.getOperationResult().getBillNos();
        Object[] keys = billNos.keySet().stream().map(e -> Long.parseLong(e.toString())).toArray();
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill"), (QFilter[])new QFilter("id", "in", (Object)keys).toArray())) {
            if (CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5305\u542b\u5916\u5e01\u5355\u636e\u4e0d\u652f\u6301\u5728\u5f00\u7968\u7533\u8bf7\u5355\u8fdb\u884c%s\u64cd\u4f5c", (String)"InvoiceOriginalBillPlugin_70", (String)"imc-sim-formplugin", (Object[])new Object[0]), OriginSelectInvoiceControl.getReverseOperateName((String)operateKey)));
                return;
            }
            String invoiceType = bill.getString("invoicetype");
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) continue;
            EquipmentHelper.checkIssueOriginalBillJQBH((DynamicObject)bill);
        }
        HashMap param = Maps.newHashMap();
        param.put("keys", keys);
        param.put("operateKey", operateKey);
        String operate = OriginSelectInvoiceControl.isInvalidOperation((String)operateKey) ? "\u4f5c\u5e9f" : (OriginSelectInvoiceControl.isRedOperation((String)operateKey) ? "\u7ea2\u51b2" : "\u91cd\u5f00");
        LOGGER.info(String.format("openSelectInvoice keys:%s", keys));
        List invoiceList = OriginSelectInvoiceControl.geFilterInvoice((Object[])keys, (String)operateKey);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5%s\u6570\u636e", (String)"InvoiceOriginalBillPlugin_83", (String)"imc-sim-formplugin", (Object[])new Object[0]), operate));
            return;
        }
        param.put("invoiceList", invoiceList);
        LOGGER.info(String.format("openSelectInvoice invoiceList:%s", invoiceList));
        ViewUtil.openDialog((AbstractFormPlugin)this, (Map)param, (String)SIM_ORIGIN_SELECT, (String)SIM_ORIGIN_SELECT);
    }
}

