/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.CurrencyConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceBuyerTypeEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OriginalBillHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.QueryTitleHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.SplitRuleHelper;
import kd.imc.bdm.common.helper.SynchronizationQuotaHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.DrawerStrategyWithFilterHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.SimCallBackHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.AllEleLqAddressSplitUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.AbstractInvoiceOriginalBillWorkbenchPlugin;
import kd.imc.sim.formplugin.bill.originalbill.InvoiceOriginalBillPlugin;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginAddControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginBaseControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginCopyRedInfoControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginPreviewIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginRowControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginTaxCodeControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginZSFSControl;
import kd.imc.sim.formplugin.bill.originalbill.op.AbstractOriginalBillSavePlugin;
import kd.imc.sim.formplugin.bill.originalbill.util.Dto.CheckResult;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceViewCloseCallBackControl;
import kd.imc.sim.formplugin.issuing.util.RedInvoiceUtil;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.lang.time.StopWatch;

public class InvoiceOriginalFormPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener,
SimFormPluginConstellationUntrans {
    public static final String BILL_EDIT = "billEdit";
    public static final String FROM_COPY = "fromCopy";
    private static Log LOGGER = LogFactory.getLog(InvoiceOriginalFormPlugin.class);
    public static final String UPDATE_BILL_TOTAL_AMOUNT = "updateBillTotalAmount";
    private static final String CUSTOM_CONTROL_KEY = "epnamequery";
    private static final Set<String> disableTaxAdjust = new ImmutableSet.Builder().add((Object)"3").add((Object)"4").add((Object)"5").add((Object)"7").build();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        this.addClickListeners(new String[]{"saleraddr", "buyername", "buyeraddr"});
        InvoiceOriginalFormControl.addTextEditClickListener((AbstractFormPlugin)this, (String[])new String[]{"infocode", "blueinvoiceno", "blueinvoicecode", "startplace", "endplace", "travelerstartplace", "travelerendplace", "saleprincename"});
        this.addF7SelectListener("goodsid", "materialtype", "taxratecodeid", "expenseitem", "materielfield", "mergerule", "operator", "unitfield", "bizcontroltype", "salebasedata");
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "blueinvoiceno": 
            case "blueinvoicecode": {
                this.openVatInvoiceListView();
                break;
            }
            case "infocode": {
                if (this.isAllEleInvoice() || AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"))) {
                    this.openRedConfirmBillView();
                    break;
                }
                this.openRedInvoiceListView();
                break;
            }
            case "saleraddr": {
                QFilter qFilter = new QFilter("taxno", "=", this.getModel().getValue("salertaxno"));
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)"close_call_back_seller_bank_addr");
                break;
            }
            case "buyeraddr": {
                Object orgId = this.getOrgId();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("orgId", orgId);
                customParams.put("name", this.getModel().getValue("buyername"));
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u62ac\u5934\u4fe1\u606f\u5217\u8868", (String)"InvoiceOriginalFormPlugin_53", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"bdm_invice_title_adr_ctr", (String)"close_call_back_buyer_bank_addr");
                break;
            }
            case "startplace": 
            case "endplace": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "travelerstartplace": 
            case "travelerendplace": {
                ListShowParameter showParameter2 = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
                showParameter2.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm((FormShowParameter)showParameter2);
                break;
            }
            case "saleprincename": {
                ListShowParameter showParameter4 = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
                showParameter4.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm((FormShowParameter)showParameter4);
            }
        }
    }

    private boolean isAllEleInvoice() {
        Object invoiceType = this.getModel().getValue("invoicetype");
        return InvoiceUtils.isAllEInvoice((Object)String.valueOf(invoiceType)) || AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"));
    }

    private void openRedConfirmBillView() {
        QFilter buyerFilter;
        QFilter filter = RedConfirmHelper.getNormalUsefulFilter();
        BigDecimal negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)Long.parseLong(this.getOrgId().toString()), (String)"negativebilldiff");
        if (MathUtils.isZero((BigDecimal)negativeBillDiff)) {
            BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
            BigDecimal totalTax = (BigDecimal)this.getModel().getValue("totaltax");
            if (!BigDecimalUtil.compareZero((BigDecimal)totalAmount)) {
                QFilter totalAmountFilter = new QFilter("totalamount", "=", (Object)totalAmount);
                QFilter totalTaxFilter = new QFilter("totaltax", "=", (Object)totalTax);
                filter = filter.and(totalAmountFilter).and(totalTaxFilter);
            }
        }
        Object buyerName = this.getModel().getValue("buyername");
        Object buyerTaxNo = this.getModel().getValue("buyertaxno");
        if (StringUtils.isNotBlank((Object)buyerTaxNo)) {
            buyerFilter = "E12".equals(this.getModel().getValue("specialtype")) ? new QFilter("salertaxno", "=", buyerTaxNo) : new QFilter("buyertaxno", "=", buyerTaxNo);
            filter = filter.and(buyerFilter);
        } else if (StringUtils.isNotBlank((Object)buyerName)) {
            buyerFilter = "E12".equals(this.getModel().getValue("specialtype")) ? new QFilter("salername", "=", buyerName) : new QFilter("buyername", "=", buyerName);
            filter = filter.and(buyerFilter);
        }
        Object org = this.getModel().getValue("orgid");
        Long orgPk = org instanceof DynamicObject ? Long.valueOf(((DynamicObject)org).getLong("id")) : (Long)org;
        Object isElePaper = this.getModel().getValue("iselepaper");
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        filter = AllEleAuthHelper.isElePaper((Object)isElePaper) ? (InvoiceUtils.isNormalInvoice((String)invoiceType) ? filter.and(new QFilter("originalinvoicetype", "in", (Object)new String[]{"026", "007"})) : filter.and(new QFilter("originalinvoicetype", "in", (Object)new String[]{"028", "004"}))) : (InvoiceUtils.isNormalInvoice((String)invoiceType) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType) ? filter.and(new QFilter("originalinvoicetype", "in", (Object)new String[]{"026", "007", "10xdp"})) : filter.and(new QFilter("originalinvoicetype", "in", (Object)new String[]{"028", "004", "08xdp"})));
        QFilter confirmStatusFilter = new QFilter("confirmstatus", "in", (Object)new String[]{"01", "04"});
        QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgPk);
        QFilter billUsedFilter = RedConfirmHelper.getBillUsedFilter();
        QFilter taxNoFilter = "E12".equals(this.getModel().getValue("specialtype")) ? new QFilter("buyertaxno", "=", this.getModel().getValue("salertaxno")) : new QFilter("salertaxno", "=", this.getModel().getValue("salertaxno"));
        filter = filter.and(baseDataFilter).and(billUsedFilter).and(taxNoFilter).and(confirmStatusFilter);
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)filter, (String)"sim_red_confirm_bill", (String)"infocode", (boolean)true, (boolean)false, null, null, null);
    }

    private void chooseBuyerTitle() {
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getInvTitleFilter((Object)this.getOrgId()), (String)"bdm_invice_title_strate", (String)"close_call_back_buyer_name");
    }

    private void openRedInvoiceListView() {
        String infocode = this.getModel().getValue("infocode").toString();
        String[] codeArr = null;
        Object orgId = this.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)infocode)) {
            String[] infos = infocode.split(",");
            QFilter filter = new QFilter("infocode", "in", (Object)infos).and("org", "=", orgId);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"infoserialno", (QFilter[])filter.toArray());
            codeArr = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                codeArr[i] = ids[i].getString("infoserialno");
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoserialnos", codeArr);
        params.put("orgPk", orgId);
        if (StringUtils.isBlank((Object)this.getModel().getValue("applicant"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9", (String)"InvoiceOriginalFormPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        params.put("applicant", this.getModel().getValue("applicant"));
        params.put("buyertaxno", this.getModel().getValue("buyertaxno"));
        params.put("salertaxno", this.getModel().getValue("salertaxno"));
        ViewUtil.openDialog((AbstractFormPlugin)this, null, params, (String)"sim_redinfo_approve_check", (String)"infocode", (boolean)false);
    }

    private void openVatInvoiceListView() {
        QFilter qFilter = new QFilter("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("orgid", "=", this.getOrgId()).and("occupystatus", "!=", (Object)"1");
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
            qFilter.and("invoicetype", "in", (Object)InvoiceUtils.getNormalInvoiceType());
        } else if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
                qFilter.and("invoicetype", "in", (Object)new String[]{InvoiceType.ALL_E_SPECIAL.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()});
            } else if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                qFilter.and("invoicetype", "in", (Object)new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()});
            }
            qFilter.and("invoicestatus", "in", (Object)new String[]{"0", "2"});
        } else {
            qFilter.and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType());
        }
        if ("02".equals(this.getModel().getValue("specialtype"))) {
            Object salerTaxNo = this.getModel().getValue("salertaxno");
            if (StringUtils.isNotBlank((Object)salerTaxNo)) {
                qFilter.and("buyertaxno", "=", salerTaxNo);
            }
        } else {
            Object buyerTaxNo = this.getModel().getValue("buyertaxno");
            if (StringUtils.isNotBlank((Object)buyerTaxNo)) {
                qFilter.and("buyertaxno", "=", buyerTaxNo);
            }
        }
        boolean elePaper = AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"));
        qFilter.and("iselepaper", elePaper ? "=" : "!=", (Object)"1");
        ImmutableSet integerImmutableSet = ImmutableSet.of((Object)"8", (Object)"10");
        qFilter.and("buyertype", "not in", (Object)integerImmutableSet);
        qFilter.and("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_choose_vatinvoice", (String)"blueinvoicecode");
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "save": {
                this.getPageCache().remove(BILL_EDIT);
                break;
            }
            case "itemdel": {
                this.goodsItemDel();
                break;
            }
            case "nextquery": {
                PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (ImcPermItemEnum)ImcPermItemEnum.IMC_NEXT_QUERY);
                BillHelper.nextQuery((AbstractFormPlugin)this, (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()});
                break;
            }
            case "refresh": {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"InvoiceOriginalFormPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
                break;
            }
            case "addrow": {
                EntryGrid grid = (EntryGrid)this.getControl("sim_original_bill_item");
                Object rowcount = grid.getEntryData().getData().get("rowcount");
                OriginalBillPluginRowControl.addRow((IFormView)this.getView(), (int)((Integer)rowcount));
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "delrow": {
                this.deleteRow();
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "newdiscountrow": {
                OriginalBillPluginRowControl.addDiscountRow((AbstractFormPlugin)this, (IFormView)this.getView());
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "copyrow": {
                OriginalBillPluginRowControl.copyRow((AbstractFormPlugin)this, (IFormView)this.getView());
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "openinvoice": {
                PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid")), (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_OPEN_INVOICE);
                this.openInvoice();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "close": {
                try {
                    String billno = (String)this.getModel().getValue("billno");
                    if (!StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)(billno + "needCheckTotalAmount")))) break;
                    OriginalBillFormEditUtil.removeCacheHelperEditAmount((String)billno);
                }
                catch (Exception billno) {}
                break;
            }
            case "bill_process_preview": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                EquipmentHelper.checkIssueOriginalBillJQBH((DynamicObject)bill);
                OriginalBillPluginPreviewIssueControl.openProcessPreview(bill, this);
                break;
            }
            case "importitems": {
                Object org = this.getModel().getValue("orgid");
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
                PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.ITEMS_IMPORT);
                HashMap<String, Object> seqPkMap = new HashMap<String, Object>(8);
                Object billNoStr = this.getModel().getValue("billno");
                if (null != org) {
                    QFilter filters = new QFilter("billno", "=", billNoStr).and("orgid", "=", ((DynamicObject)org).getPkValue());
                    DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])filters.toArray());
                    if (array.length > 0) {
                        Object pkValue = array[0].getPkValue();
                        QFilter filter = new QFilter("sbillid", "=", pkValue);
                        seqPkMap = new HashMap();
                        seqPkMap.put("id", array[0].getPkValue());
                        DynamicObjectCollection items = array[0].getDynamicObjectCollection("sim_original_bill_item");
                        for (int i = 0; i < items.size(); ++i) {
                            DynamicObject item = (DynamicObject)items.get(i);
                            seqPkMap.put(String.valueOf(i), item.getPkValue());
                        }
                        if (QueryServiceHelper.exists((String)"sim_bill_inv_relation", (QFilter[])filter.toArray())) {
                            seqPkMap.put("UPDATE_ITEM", "UPDATE_ITEM");
                        }
                    }
                }
                seqPkMap.put("orgId", orgId);
                seqPkMap.put("specialtype", this.getModel().getValue("specialtype"));
                seqPkMap.put("invoicetype", this.getModel().getValue("invoicetype"));
                seqPkMap.put("iselepaper", this.getModel().getValue("iselepaper"));
                ViewUtil.openDialog((AbstractFormPlugin)this, seqPkMap, (String)"sim_bill_items_import", (String)"importitems");
                break;
            }
            case "bill_pratiques_part": {
                HashMap<String, Object> partMap = new HashMap<String, Object>(1);
                partMap.put("step", "process");
                partMap.put("pageSource", "pratiques");
                this.openPartWorkBench(partMap);
                break;
            }
            case "bill_process": 
            case "bill_tempsave_preview": {
                this.checkSpecialBill(key);
                this.billProcess(key);
            }
        }
    }

    public void openPartWorkBench(Map<String, Object> param) {
        Object[] primaryKeyValues = new Object[]{this.getView().getModel().getDataEntity().get("id")};
        try {
            InvoiceOriginalBillPlugin originalBillPlugin = new InvoiceOriginalBillPlugin();
            originalBillPlugin.checkPartWorkbenchData(this, primaryKeyValues);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        param.put("pks", primaryKeyValues);
        ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_split_process", (String)"sim_split_process");
    }

    @Deprecated
    protected void billProcess() {
        this.billProcess("bill_process");
    }

    private void billProcess(String key) {
        Object billId = this.getView().getModel().getDataEntity().get("id");
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("step", "process");
        if ("bill_tempsave_preview".equals(key)) {
            map.put("tempSavePreview", true);
        }
        InvoiceOriginalBillPlugin originalBillPlugin = new InvoiceOriginalBillPlugin();
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"sim_original_bill");
        originalBillPlugin.openWorkBench(this, new DynamicObject[]{bill}, map);
    }

    private void checkSpecialBill(String key) {
        Object id = this.getView().getModel().getDataEntity().get("id");
        InvoiceOriginalBillPlugin invoiceOriginalBillPlugin = new InvoiceOriginalBillPlugin();
        invoiceOriginalBillPlugin.checkSpecialBill(new Object[]{id}, "\u5355\u636e\u5904\u7406", "bill_tempsave_preview".equals(key));
        DynamicObject bill = this.getModel().getDataEntity();
        EquipmentHelper.checkIssueOriginalBillJQBH((DynamicObject)bill);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Object closeStatus;
        String itemKey = evt.getItemKey();
        HashSet needCheckKeySet = new HashSet();
        Collections.addAll(needCheckKeySet, "submit", "unsubmit", "audit", "unaudit", "bill_process_preview", "cancel_invoice", "bill_process", "bill_pratiques_part", "addrelateinvoice", "cancelrelateinvoice", "baritemap", "bill_red_reopen", "bill_invalid", "bill_invalid_reopen", "bill_reopen", "shelve", "recovery");
        Set itemKeys = ImcConfigUtil.getConfigStringArray((String)"CheckCloseItemKey", (String)"needCheckCloseItemKey");
        needCheckKeySet.addAll(itemKeys);
        Set removeItemKeys = ImcConfigUtil.getConfigStringArray((String)"CheckCloseItemKey", (String)"needRemoveItemKey");
        Set needCheckKeyList = needCheckKeySet.stream().filter(o -> !removeItemKeys.contains(o)).collect(Collectors.toSet());
        if (needCheckKeyList.contains(itemKey) && "1".equals(closeStatus = this.getModel().getValue("closestatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5173\u95ed\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c", (String)"InvoiceOriginalFormPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if ("trackup".equals(itemKey) && !BillHelper.originalBillTrackup((AbstractFormPlugin)this, (String)this.getView().getEntityId(), (Object[])new Object[]{this.getModel().getValue("id")})) {
            evt.setCancel(true);
        }
    }

    public void afterCopyData(EventObject e) {
        this.getView().setEnable(Boolean.TRUE, new String[]{"salertaxno", "salername", "buyerproperty", "salesorg", "settlementorg", "capitalorg"});
        IDataModel model = this.getModel();
        model.setValue("systemsource", (Object)"");
        model.setValue("billsource", (Object)"6");
        model.setValue("billsourcetype", (Object)"A");
        model.setValue("confirmstate", (Object)"0");
        DynamicObject bill = this.getModel().getDataEntity(true);
        AbstractOriginalBillSavePlugin.setBillTaxRate(bill);
        model.setValue("billtaxrate", (Object)bill.getString("billtaxrate"));
        model.setValue("editable", (Object)"");
        this.getPageCache().put(FROM_COPY, FROM_COPY);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String systemSource = dataEntity.getString("systemsource");
        if (BotpHelper.isFromAr((Object)systemSource)) {
            InvoiceOriginalFormControl.botpNotEdit((AbstractFormPlugin)this);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"newdiscountrow", "terminalno"});
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (StringUtils.isNotBlank((CharSequence)customParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
        String specialtype = dataEntity.getString("specialtype");
        try {
            DynamicObjectCollection sales;
            if (("E05".equals(specialtype) || "E06".equals(specialtype)) && CollectionUtils.isEmpty((Collection)(sales = dataEntity.getDynamicObjectCollection("estatesales")))) {
                DynamicObject dynamicObject = sales.addNew();
                DynamicObject simpleAddressObj = dataEntity.getDynamicObject("simpleaddress");
                Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleAddressObj.getString("name"));
                dynamicObject.set("saleestateid", (Object)dataEntity.getString("estateid"));
                dynamicObject.set("saleprincename", adrressMap.get("province"));
                dynamicObject.set("salecityname", adrressMap.get("city"));
                dynamicObject.set("saledetailaddress", (Object)dataEntity.getString("detailaddress"));
                dynamicObject.set("salecrosscitysign", (Object)dataEntity.getString("crosscitysign"));
                dynamicObject.set("saleunit", (Object)dataEntity.getString("areaunit"));
                if ("E06".equals(specialtype)) {
                    dynamicObject.set("leasestartdate", (Object)dataEntity.getDate("startleasedate"));
                    dynamicObject.set("leaseenddate", (Object)dataEntity.getDate("endleasedate"));
                } else if ("E05".equals(specialtype)) {
                    dynamicObject.set("saleestatecode", (Object)dataEntity.getString("estatecode"));
                    dynamicObject.set("onlinecontracteno", (Object)"");
                    dynamicObject.set("salelandtaxno", (Object)dataEntity.getString("landtaxno"));
                    dynamicObject.set("assessmenttaxamount", (Object)dataEntity.getBigDecimal("approvedprice"));
                    dynamicObject.set("actualtotalamount", (Object)dataEntity.getBigDecimal("actualturnover"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("change history bulidingsale data error:" + ex);
        }
    }

    private void initCustomControl() {
        this.setBuyerNameFlex();
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        showDataMap.put("inputStyle", "border: none; border-bottom: 1px solid #999;padding-bottom: 15px; font-size: 16px");
        showDataMap.put("eventkey", "enable_title");
        showDataMap.put("buyername", this.getModel().getValue("buyername"));
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)CUSTOM_CONTROL_KEY);
    }

    private void setBuyerNameFlex() {
        Object billStatus = this.getModel().getValue("billstatus");
        boolean isEditStatus = BillStatusEnum.TEMP_SAVE.getCode().equals(billStatus) || BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(billStatus);
        boolean isNormalBill = !OriginalBillConstant.isSpecialSourcType((Object)this.getModel().getValue("billsourcetype"));
        boolean isValidNormal = "0".equals(this.getModel().getValue("validstate"));
        if (isEditStatus && isNormalBill && isValidNormal && "0".equals(this.getModel().getValue("confirmstate"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOM_CONTROL_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buyername"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buyername"});
            this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOM_CONTROL_KEY});
        }
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        switch (e.getEventName()) {
            case "queryTitle": {
                this.getModel().setValue("buyername", (Object)args);
                this.getView().addClientCallBack("queryTitle");
                break;
            }
            case "updateBuyerTaxNo": {
                this.confirmEnterprise(args);
                break;
            }
            case "chooseTitle": {
                this.chooseBuyerTitle();
            }
        }
    }

    private void confirmEnterprise(String args) {
        JSONObject jsonObject = JSONObject.parseObject((String)args);
        this.getView().getModel().setValue("buyertaxno", jsonObject.get((Object)"tax"));
        this.getView().getModel().setValue("buyername", jsonObject.get((Object)"name"));
    }

    public void afterBindData(EventObject e) {
        try {
            DynamicObject entity;
            ImmutableSet billSourceSet;
            Object confirmState;
            InvoiceOriginalFormControl.buyerNameEdit((AbstractFormPlugin)this);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.getModel().setValue("taxadjust", (Object)Boolean.FALSE);
            this.getPageCache().remove(BILL_EDIT);
            long orgId = Long.parseLong(this.getOrgId().toString());
            String taxno = (String)this.getModel().getValue("salertaxno");
            if (EquipmentHelper.isDisableJQBH((Object)this.getModel().getValue("salertaxno"), (Object)this.getModel().getValue("jqbh"))) {
                this.getModel().setValue("jqbh", null);
            }
            OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
            LOGGER.info("operationStatus:" + operationStatus);
            if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
                EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgId, (String)taxno, (String)"jqbh", (String)"terminalno", (boolean)true);
            } else {
                EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgId, (String)taxno, (String)"jqbh", (String)"terminalno", (boolean)false);
            }
            SplitRuleHelper.bindSplitRuleByOrg((AbstractFormPlugin)this, (String)"splitrule", (Long)orgId, (boolean)true);
            this.getPageCache().put("itemsMaxTaxDiff", new BillMergeHelper().getItemsMaxTaxDiff(dataEntity, dataEntity.getString("jqbh")).toPlainString());
            String systemSource = (String)this.getModel().getValue("systemsource");
            if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
                Object billstatus = this.getModel().getValue("billstatus");
                this.getPageCache().put("isAddNew", "true");
                if (this.getModel().getEntryEntity("sim_original_bill_item").size() == 0) {
                    this.getModel().setValue("showsalerbank", (Object)SystemParameterHelper.getBdmParameterBoolean((long)orgId, (String)"showsalerbank"));
                    this.getModel().setValue("showbuyerbank", (Object)SystemParameterHelper.getBdmParameterBoolean((long)orgId, (String)"showbuyerbank"));
                    this.getModel().setValue("showbuyeraddresstel", (Object)SystemParameterHelper.getBdmParameterBoolean((long)orgId, (String)"showbuyeraddresstel"));
                    this.getModel().setValue("showsaleraddresstel", (Object)SystemParameterHelper.getBdmParameterBoolean((long)orgId, (String)"showsaleraddresstel"));
                }
                if (!BillStatusEnum.IN_AUDIT.getCode().equals(billstatus) && !BillStatusEnum.AUDIT_SUCCESS.getCode().equals(billstatus)) {
                    OpenStyle openStyle = this.getView().getFormShowParameter().getOpenStyle();
                    if (BotpHelper.isFromAr((Object)systemSource) || "BGD_COLLECT".equals(systemSource)) {
                        if (ShowType.InContainer.equals((Object)openStyle.getShowType())) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap", "shelve", "refresh", "nextquery", "addrow", "copyrow"});
                        } else {
                            String refreshKey = this.getPageCache().get("refreshKey");
                            if (StringUtils.isBlank((CharSequence)refreshKey)) {
                                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "shelve", "refresh", "nextquery", "audit", "viewflowchart", "addrow", "copyrow"});
                                this.getPageCache().put("refreshKey", "refreshKey");
                            }
                        }
                    } else if ("3".equals(this.getModel().getValue("billsource"))) {
                        OriginalBillPluginAddControl.initBotpBill((AbstractFormPlugin)this);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"shelve", "refresh", "nextquery"});
                    } else {
                        OriginalBillPluginAddControl.initNewBill((AbstractFormPlugin)this, (IFormView)this.getView());
                        this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"shelve", "refresh", "nextquery"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"travelerflex"});
                    }
                }
            } else if (OperationStatus.VIEW.equals((Object)operationStatus)) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"shelve"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
            } else if (OperationStatus.EDIT.equals((Object)operationStatus)) {
                confirmState = this.getModel().getValue("confirmstate");
                Object billStatus = this.getModel().getValue("billstatus");
                Object validState = this.getModel().getValue("validstate");
                if (!"2".equals(confirmState) && "0".equals(validState) && BillStatusEnum.isEditStatus((Object)billStatus)) {
                    this.formEdit();
                }
                if ("2".equals(validState)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"travelerflex", "vehichevesselflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap5", "advconbaritemap6", "advconbaritemap7", "advconbaritemap8"});
                }
            }
            confirmState = dataEntity.getString("confirmstate");
            if ("2".equals(confirmState) || "1".equals(confirmState)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"hsbz"});
            } else if ("0".equals(confirmState)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"hsbz"});
            }
            if ("-1".equals(dataEntity.getString("billproperties"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"redinfo"});
                this.setRedOriginlBillVisibleColumn(false);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"redinfo"});
            }
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(FROM_COPY))) {
                this.fromCopy(dataEntity);
            }
            if ((billSourceSet = ImmutableSet.of((Object)"3", (Object)"2", (Object)"5")).contains((Object)dataEntity.getString("billsource"))) {
                this.showEditItem(Boolean.FALSE);
            }
            String complete = dataEntity.getString("billcomplete");
            this.getView().setVisible(Boolean.TRUE, new String[]{"itemdel"});
            DynamicObjectCollection itemList = this.getModel().getEntryEntity("sim_original_bill_item");
            this.initCustomControl();
            String invoiceType = String.valueOf(this.getView().getModel().getValue("invoicetype"));
            if (StringUtils.isEmpty((CharSequence)invoiceType) || StringUtils.isEmpty((CharSequence)InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType))) {
                this.getModel().setValue("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
            }
            OriginalBillPluginControl.initInvoiceSpecialType((AbstractFormPlugin)this, (String)invoiceType);
            Object editable = this.getModel().getValue("editable");
            if (StringUtils.isNotBlank((Object)editable) || !OperationStatus.ADDNEW.equals((Object)operationStatus) && BotpHelper.isBotpSystemSource((String)String.valueOf(systemSource)) && !BotpHelper.isNotComplete((Object)complete) || BotpHelper.isNotComplete((Object)complete)) {
                InvoiceOriginalFormControl.editableInfluence((DynamicObjectCollection)itemList, (Object)editable, (AbstractFormPlugin)this);
            }
            if (BotpHelper.isNotComplete((Object)complete)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"addrow", "newdiscountrow", "copyrow"});
            }
            if (BotpHelper.isArBotpCompleteBill((Object)systemSource, (Object)complete)) {
                InvoiceOriginalFormControl.dealItemEnalbeStatus((DynamicObjectCollection)itemList, (AbstractFormPlugin)this);
                InvoiceOriginalFormControl.enableUnitChange((DynamicObjectCollection)itemList, (AbstractFormPlugin)this);
                this.getView().setEnable(Boolean.FALSE, new String[]{"hsbz"});
            }
            if ("3".equals((entity = this.getModel().getDataEntity()).getString("billsource"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"itemdel"});
            }
            Object pkValue = entity.getPkValue();
            QFilter filter = new QFilter("sbillid", "=", pkValue);
            if (null != pkValue && !Objects.equals(pkValue, 0L) && QueryServiceHelper.exists((String)"sim_bill_inv_relation", (QFilter[])filter.toArray())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"itemdel", "addrow", "newdiscountrow", "copyrow"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"billno", "billdate", "reductiontaxtype", "bizcontroltype"});
            }
            InvoiceOriginalFormControl.notEdit((AbstractFormPlugin)this);
            this.getPageCache().remove(FROM_COPY);
            if (!InvoiceUtils.isAllEInvoice((Object)String.valueOf(this.getModel().getValue("invoicetype")))) {
                SynchronizationQuotaHelper.checkAndOpenSyncQuota((AbstractFormPlugin)this, (String)(this.getModel().getValue("salertaxno") + ""), (String)(this.getModel().getValue("jqbh") + ""));
            }
            OriginalBillPluginControl.changeSpecialType((AbstractFormPlugin)this);
            if (AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"))) {
                OriginalBillFormEditUtil.clearElePaperOtherData((IDataModel)this.getModel());
            }
            this.getModel().setDataChanged(false);
            if (!InvoiceUtils.isAllEInvoice((Object)dataEntity.getString("invoicetype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"reductiontaxtype"});
            }
            if (EnterpriseHelper.isLqptChannel((String)((String)this.getModel().getValue("salertaxno")))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"reductiontaxtype"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"reductiontaxtype"});
            if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(dataEntity.getString("taxationstyle"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"reductiontaxtype"});
            }
            boolean isAllEle = (InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(this.getModel().getValue("iselepaper"))) && "1".equals(this.getModel().getValue("billproperties"));
            this.getView().setVisible(Boolean.valueOf(isAllEle), new String[]{"advconap"});
            if (!"0".equals(confirmState)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"extra", "addextrainfo", "advconbaritemap10"});
            }
            DynamicObjectCollection entry = this.getModel().getEntryEntity("extra");
            for (int i = 0; i < entry.size(); ++i) {
                if ("2".equals(this.getModel().getValue("extrainfotype", i))) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"extrainfotime"});
            }
            this.setPurchaseField();
            this.setBuyerProperty();
        }
        catch (Exception ex) {
            LOGGER.error("OriginalBillPluginInitError" + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private void setBuyerProperty() {
        Object buyerProperty = this.getModel().getValue("buyerproperty");
        boolean isEnterprise = "0".equals(buyerProperty);
        TextEdit control = (TextEdit)this.getView().getControl("buyertaxno");
        if (isEnterprise) {
            control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"CreateInvoicePlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        } else {
            control.setCaption(new LocaleString("\u8bc1\u4ef6\u53f7\u7801:"));
        }
    }

    private void setPurchaseField() {
        boolean isAllEle;
        Object invoiceType = this.getModel().getValue("invoicetype");
        Object specialType = this.getModel().getValue("specialtype");
        TextEdit control = (TextEdit)this.getView().getControl("buyertaxno");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"));
        if (isAllEle && "02".equals(specialType)) {
            control.setCaption(new LocaleString("\u8bc1\u4ef6\u53f7\u7801:"));
            OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
                this.getModel().setValue("buyerproperty", (Object)"1");
                if ("-1".equals(this.getModel().getValue("billproperties"))) {
                    this.getModel().setValue("salerorbuyer", (Object)"1");
                }
            }
        } else {
            control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"CreateInvoicePlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        }
    }

    private void lockItemEdit(boolean lock) {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("sim_original_bill_item");
        for (int i = 0; i < itemList.size(); ++i) {
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"num", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"amount", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"taxamount", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"unitprice", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"taxunitprice", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"taxrate", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"taxratecodeid", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"expenseitem", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"materielfield", (boolean)lock, (int)i);
            ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"goodsid", (boolean)lock, (int)i);
        }
    }

    private void showEditItem(Boolean aFalse) {
        this.getView().setVisible(aFalse, new String[]{"addrow", "itemdel", "newdiscountrow", "copyrow"});
    }

    private void fromCopy(DynamicObject dataEntity) {
        this.showEditItem(Boolean.TRUE);
        this.getView().setEnable(Boolean.TRUE, new String[]{"sim_original_bill_item"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"taxationstyle"});
        this.getModel().setValue("billproperties", dataEntity.get("billproperties"));
        this.getModel().setValue("mainissuedamount", (Object)0);
        this.getModel().setValue("mainissuedtax", (Object)0);
        this.getModel().setValue("confirmamount", (Object)0);
        this.getModel().setValue("maintaxdeviation", (Object)0);
        this.getModel().setValue("surplusamount", dataEntity.get("invoiceamount"));
        this.getModel().setValue("surplustax", dataEntity.get("totaltax"));
        this.getModel().setValue("invoicecode", null);
        this.getModel().setValue("invoiceno", null);
        this.getModel().setValue("issuetime", null);
        this.getModel().setValue("invoicestatus", null);
        this.getModel().setValue("invoicedtotalamount", null);
        this.getModel().setValue("invoicedtax", null);
        this.getModel().setValue("invoicedamount", null);
        this.getModel().setValue("applicant", (Object)"");
        this.getModel().setValue("infocode", (Object)"");
        this.getModel().setValue("blueinvoicecode", (Object)"");
        this.getModel().setValue("blueinvoiceno", (Object)"");
        this.getModel().setValue("originalissuetime", null);
        DynamicObjectCollection items = dataEntity.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < items.size(); ++i) {
            this.getModel().setValue("remainvalidnum", ((DynamicObject)items.get(i)).get("num"), i);
            this.getModel().setValue("remainvalidtax", ((DynamicObject)items.get(i)).get("tax"), i);
            if ("0".equals(dataEntity.get("hsbz"))) {
                this.getModel().setValue("remainvalidamount", ((DynamicObject)items.get(i)).get("amount"), i);
            } else {
                this.getModel().setValue("remainvalidamount", ((DynamicObject)items.get(i)).get("taxamount"), i);
            }
            this.getModel().setValue("taxdeviation", (Object)0, i);
            this.getModel().setValue("amountdeviation", (Object)0, i);
            this.getModel().setValue("numdeviation", (Object)0, i);
            this.getModel().setValue("issuedamount", (Object)0, i);
            this.getModel().setValue("issuedtax", (Object)0, i);
            this.getModel().setValue("issuedtotaltaxamount", (Object)0, i);
            this.getModel().setValue("zeropushflag", null, i);
        }
        String property = dataEntity.getString("billproperties");
        if ("-1".equals(property)) {
            this.setRedOriginlBillVisibleColumn();
        }
    }

    private void setRedOriginlBillVisibleColumn() {
        this.setRedOriginlBillVisibleColumn(true);
    }

    private void setRedOriginlBillVisibleColumn(boolean isReSetValue) {
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        boolean isSpecialInvoice = InvoiceUtils.isSpecialInvoice((String)invoiceType);
        Object isElePaper = this.getModel().getValue("iselepaper");
        if (AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            isSpecialInvoice = false;
        }
        boolean elePaper = AllEleAuthHelper.isElePaper((Object)isElePaper);
        this.getView().setVisible(Boolean.valueOf(isSpecialInvoice), new String[]{"applicant", "infocode"});
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || elePaper) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"salerorbuyer", "infocode", "blueinvoicetype", "blueinvoiceno", "originalissuetime", "redreason"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"applicant", "blueinvoicecode"});
            if (elePaper) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"blueinvoicecode", "originaletaxinvoiceno"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"blueinvoicetype", "blueinvoicecode", "blueinvoiceno", "originalissuetime", "salerorbuyer"});
            OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)operationStatus) && StringUtils.isBlank((Object)this.getModel().getValue("salerorbuyer"))) {
                this.getModel().setValue("salerorbuyer", (Object)"0");
            }
            this.getModel().setValue("applicant", null);
            if (isReSetValue) {
                this.getModel().setValue("infocode", null);
                this.getModel().setValue("blueinvoicecode", null);
                this.getModel().setValue("blueinvoiceno", null);
                this.getModel().setValue("originalissuetime", null);
                this.getModel().setValue("blueinvoicetype", null);
                this.getModel().setValue("redreason", null);
                this.getModel().setValue("originaletaxinvoiceno", null);
                this.getModel().setValue("salerorbuyer", (Object)"0");
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"blueinvoiceno", "originalissuetime"});
            if (elePaper) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"blueinvoicecode", "originaletaxinvoiceno"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"blueinvoiceno"});
            }
        } else if (isSpecialInvoice) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"salerorbuyer", "blueinvoicetype", "redreason", "originaletaxinvoiceno"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"blueinvoicecode", "blueinvoiceno", "originalissuetime", "infocode", "applicant"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"blueinvoicecode", "blueinvoiceno", "originalissuetime", "infocode", "applicant"});
            this.getModel().setValue("salerorbuyer", null);
            if (isReSetValue) {
                this.getModel().setValue("infocode", null);
                this.getModel().setValue("originaletaxinvoiceno", null);
                this.getModel().setValue("blueinvoicecode", null);
                this.getModel().setValue("blueinvoiceno", null);
                this.getModel().setValue("originalissuetime", null);
                this.getModel().setValue("blueinvoicetype", null);
                this.getModel().setValue("redreason", null);
                this.getModel().setValue("applicant", null);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"applicant", "infocode", "salerorbuyer", "originaletaxinvoiceno"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"originalissuetime", "blueinvoicetype", "redreason", "blueinvoiceno", "blueinvoicecode"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"originalissuetime", "blueinvoicetype", "redreason", "blueinvoiceno", "blueinvoicecode"});
            this.getModel().setValue("applicant", null);
            this.getModel().setValue("salerorbuyer", null);
            if (isReSetValue) {
                this.getModel().setValue("infocode", null);
                this.getModel().setValue("blueinvoicecode", null);
                this.getModel().setValue("blueinvoiceno", null);
                this.getModel().setValue("originalissuetime", null);
                this.getModel().setValue("originaletaxinvoiceno", null);
                this.getModel().setValue("blueinvoicetype", null);
                this.getModel().setValue("redreason", null);
            }
        }
    }

    private void goodsItemDel() {
        EntryGrid entry = (EntryGrid)this.getControl("sim_original_bill_item");
        if (entry.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5546\u54c1\u884c", (String)"InvoiceOriginalFormPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"0".equals(this.getModel().getValue("confirmstate"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5df2\u62c6\u5206\u6216\u786e\u8ba4\uff0c\u8bf7\u56de\u9000\u5355\u636e\u6216\u79fb\u6b65\u81f3\u5df2\u786e\u8ba4\u5355\u636e\u4fee\u6539\u76f8\u5173\u5546\u54c1\u4fe1\u606f\u3002", (String)"InvoiceOriginalFormPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] rows = entry.getSelectRows();
        DynamicObjectCollection items = this.getModel().getEntryEntity("sim_original_bill_item");
        HashSet<Integer> rowsSet = new HashSet<Integer>(items.size());
        for (int rowNum : rows) {
            DynamicObject itemNext;
            String nextRowType;
            DynamicObject item = (DynamicObject)items.get(rowNum);
            String rowType = item.getString("rowtype");
            rowsSet.add(rowNum);
            if ("1".equals(rowType)) {
                boolean isDeleteLastRow;
                try {
                    Object lastRowType = this.getModel().getValue("rowtype", rowNum - 1);
                    isDeleteLastRow = null == lastRowType ? false : !"1".equals(lastRowType);
                }
                catch (Exception e) {
                    isDeleteLastRow = false;
                }
                if (!isDeleteLastRow) continue;
                rowsSet.add(rowNum - 1);
                continue;
            }
            if (rowNum + 1 >= items.size() || !"1".equals(nextRowType = (itemNext = (DynamicObject)items.get(rowNum + 1)).getString("rowtype"))) continue;
            rowsSet.add(rowNum + 1);
        }
        Integer[] rowsInteger = rowsSet.toArray(new Integer[0]);
        int[] rowsNew = new int[rowsSet.size()];
        for (int i = 0; i < rowsInteger.length; ++i) {
            rowsNew[i] = rowsInteger[i];
        }
        this.getModel().deleteEntryRows("sim_original_bill_item", rowsNew);
        OriginalBillPluginControl.countHeadAmount((IDataModel)this.getModel());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"InvoiceOriginalFormPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
    }

    private void formEdit() {
        DynamicObject dataEntity;
        ImmutableSet billSourceSet;
        Object complete;
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("sim_original_bill_item");
        boolean arEdit = BotpHelper.isArEdit((Object)this.getModel().getValue("systemsource"), (OperationStatus)this.getView().getFormShowParameter().getStatus());
        for (int i = 0; i < itemList.size(); ++i) {
            if (!arEdit) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"amount"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"taxamount"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"num"});
        }
        String billSource = (String)this.getModel().getValue("billsource");
        if (!"0".equals(this.getModel().getValue("confirmstate")) || disableTaxAdjust.contains(billSource) || "2".equals(billSource) && StringUtils.equalsIgnoreCase((CharSequence)"KINGDEE_FI", (CharSequence)((String)this.getModel().getValue("systemsource")))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxadjust"});
        }
        if (BotpHelper.isNotComplete((Object)(complete = this.getModel().getValue("billcomplete")))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"taxadjust"});
        }
        if ((billSourceSet = ImmutableSet.of((Object)"3", (Object)"2", (Object)"5")).contains((Object)billSource) && !BotpHelper.isNotComplete((Object)complete)) {
            this.showEditItem(Boolean.FALSE);
        } else {
            this.showEditItem(Boolean.TRUE);
        }
        if ("3".equals(billSource)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"itemdel"});
        }
        ViewUtil.setAllViewDisable((IFormView)this.getView(), (boolean)true, (String)"sim_original_bill");
        if (OriginalBillPluginBaseControl.isCETaxStyle((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxadjust"});
        }
        this.getView().setEnable(Boolean.valueOf("1".equals(this.getModel().getValue("billproperties"))), new String[]{"taxationstyle"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"billproperties"});
        if (arEdit) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"hsbz"});
        }
        if (billSourceSet.contains((Object)(dataEntity = this.getModel().getDataEntity(true)).getString("billsource"))) {
            if (!"3".equals(dataEntity.getString("billsource")) && !CallbackHelperUtil.isSystemSourceFi((String)dataEntity.getString("systemsource")) && StringUtils.isEmpty((CharSequence)this.getPageCache().get(FROM_COPY))) {
                CacheHelper.put((String)(dataEntity.getString("billno") + "needCheckTotalAmount"), (String)"1", (int)3600);
            }
            CacheHelper.put((String)(dataEntity.getString("billno") + "invoiceamount"), (String)dataEntity.getString("invoiceamount"), (int)3600);
            CacheHelper.put((String)(dataEntity.getString("billno") + "totalamount"), (String)dataEntity.getString("totalamount"), (int)3600);
            CacheHelper.put((String)(dataEntity.getString("billno") + "totaltax"), (String)dataEntity.getString("totaltax"), (int)3600);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getCallBackId().equals("isNotExsit")) {
            if (event.getResult() == MessageBoxResult.Yes) {
                ArrayList objects = Lists.newArrayListWithCapacity((int)1);
                objects.add(this.getModel().getDataEntity().getPkValue());
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])objects.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                HashSet typeSet = Sets.newHashSet();
                typeSet.add("-1");
                BillHelper.checkIssuePushSpecialCodeRemark((AbstractFormPlugin)this, (DynamicObject[])dynamicObjects, (HashSet)typeSet);
            }
        } else if ("negativeBillDiffIssuePush".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                ArrayList objects = Lists.newArrayListWithCapacity((int)1);
                objects.add(this.getModel().getDataEntity().getPkValue());
                OriginalBillPluginIssueControl.issuePush((AbstractFormPlugin)this, (Object[])objects.toArray(), (Map)JSON.parseObject((String)event.getCustomVaule()));
            }
        } else if ("negativeBillDiffPreview".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                String customValue = event.getCustomVaule();
                JSONObject jsonObject = JSON.parseObject((String)customValue);
                jsonObject.put("pks", (Object)new Object[]{jsonObject.get((Object)"pks")});
                ViewUtil.openDialog((AbstractFormPlugin)this, (Map)jsonObject, (String)"sim_bill_process", (String)"sim_bill_process");
            }
        } else {
            String callBackId = event.getCallBackId();
            if (callBackId.startsWith("ZSFS_") && event.getResult() == MessageBoxResult.Cancel) {
                this.getModel().setValue("taxationstyle", (Object)this.getPageCache().get("oldZSFS"));
                this.getPageCache().remove("oldZSFS");
                return;
            }
            SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "infocode": {
                if (this.isAllEleInvoice()) {
                    this.setRedConfirmBill(returnData);
                    break;
                }
                this.setInfoCode(returnData);
                break;
            }
            case "blueinvoicecode": {
                this.setBlueInvoiceInfo(returnData);
                break;
            }
            case "sim_bill_split_call": {
                if (returnData == null) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6210\u529f", (String)"InvoiceOriginalFormPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "close_call_back_seller_bank_addr": {
                CreateInvoiceViewCloseCallBackControl.handleChooseSaleAddress((ClosedCallBackEvent)event, (IFormView)this.getView());
                break;
            }
            case "close_call_back_buyer_bank_addr": {
                Map customParams = (Map)event.getReturnData();
                if (customParams == null) break;
                this.getModel().setValue("buyeraddr", customParams.get("buyeraddr"));
                this.getModel().setValue("buyerbank", customParams.get("buyerbank"));
                String email = (String)this.getModel().getValue("buyeremail");
                String redEmail = (String)this.getModel().getValue("buyerredemail");
                String phone = (String)this.getModel().getValue("buyerphone");
                if (!StringUtils.isEmpty((CharSequence)email) || !StringUtils.isEmpty((CharSequence)phone) || !StringUtils.isEmpty((CharSequence)redEmail)) break;
                this.getModel().setValue("buyeremail", customParams.get("buyeremail"));
                this.getModel().setValue("buyerphone", customParams.get("buyerphone"));
                this.getModel().setValue("buyerredemail", customParams.get("buyerredemail"));
                break;
            }
            case "close_call_back_buyer_name": {
                this.setBuyerTitleData(returnData);
                break;
            }
            case "importitems": {
                try {
                    if (null == returnData) break;
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start();
                    this.getPageCache().put("not_property_change" + this.getView().getPageId(), "id");
                    this.getModel().beginInit();
                    this.createItems(returnData);
                    this.getModel().endInit();
                    this.getView().updateView("sim_original_bill_item");
                    this.getView().updateView("hsbz");
                    this.getView().updateView("totaltax");
                    this.getView().updateView("totalamount");
                    this.getView().updateView("invoiceamount");
                    this.getView().updateView("oldtotalamount");
                    this.getView().updateView("surplusamount");
                    this.getView().updateView("surplustax");
                    this.getView().updateView("billproperties");
                    stopWatch.stop();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"InvoiceOriginalFormPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("OriginalBillItemsImportFail:" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25%s", (String)"InvoiceOriginalFormPlugin_40", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
                    break;
                }
                finally {
                    this.getPageCache().remove("not_property_change" + this.getView().getPageId());
                }
            }
            case "startplace": 
            case "endplace": {
                ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return;
                }
                DynamicObject admindivision = BusinessDataServiceHelper.loadSingleFromCache((Object)list.get(0).getPrimaryKeyValue(), (String)"bdm_admindivision");
                EntryGrid grid = (EntryGrid)this.getControl("freights");
                this.getModel().setValue(actionId, (Object)admindivision.getString("name"), grid.getSelectRows()[0]);
                break;
            }
            case "travelerstartplace": 
            case "travelerendplace": {
                ListSelectedRowCollection list2 = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)list2)) {
                    return;
                }
                DynamicObject admindivision2 = BusinessDataServiceHelper.loadSingleFromCache((Object)list2.get(0).getPrimaryKeyValue(), (String)"bdm_admindivision");
                EntryGrid entryGrid = (EntryGrid)this.getControl("travelers");
                this.getModel().setValue(actionId, (Object)admindivision2.getString("name"), entryGrid.getSelectRows()[0]);
                break;
            }
            case "saleprincename": {
                ListSelectedRowCollection list4 = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)list4)) {
                    return;
                }
                DynamicObject admindivision4 = BusinessDataServiceHelper.loadSingleFromCache((Object)list4.get(0).getPrimaryKeyValue(), (String)"bdm_admindivision");
                EntryGrid entryGrid4 = (EntryGrid)this.getControl("estatesales");
                String address = admindivision4.getString("name");
                Map adrressMap = AllEleLqAddressSplitUtil.split((String)address);
                String provinceName = (String)adrressMap.get("province");
                String cityName = (String)adrressMap.get("city");
                this.getModel().setValue("saleprincename", (Object)provinceName, entryGrid4.getSelectRows()[0]);
                this.getModel().setValue("salecityname", (Object)cityName, entryGrid4.getSelectRows()[0]);
            }
        }
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRedConfirmBill(Object returnData) {
        QFilter invFilter;
        DynamicObject[] blueInv;
        if (null == returnData) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        if (list.size() == 0) {
            this.getModel().setValue("infocode", (Object)"");
            return;
        }
        QFilter redInfoFilter = new QFilter("id", "in", (Object)list.getPrimaryKeyValues());
        DynamicObject[] redConfirmBillArray = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])redInfoFilter.toArray());
        if (null == redConfirmBillArray || redConfirmBillArray.length == 0) {
            return;
        }
        ArrayList<DynamicObject> redConfirms = new ArrayList<DynamicObject>(Arrays.asList(redConfirmBillArray));
        String redConfirmNo = redConfirms.stream().map(o -> o.getString("number")).collect(Collectors.joining(","));
        RedConfirmHelper.checkInvoiceExistConfirmBillNo((String)redConfirmNo);
        DynamicObject redConfirm = redConfirms.get(0);
        String invoiceType = redConfirm.getString("invoicetype");
        this.getModel().setValue("invoicetype", (Object)invoiceType);
        if (StringUtils.isBlank((Object)this.getModel().getValue("buyername"))) {
            Object buyerName = redConfirm.get("buyername");
            this.updateBuyerName(buyerName);
            this.getModel().setValue("buyername", buyerName);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("buyertaxno"))) {
            this.getModel().setValue("buyertaxno", (Object)redConfirm.getString("buyertaxno"));
        }
        this.getModel().setValue("infocode", (Object)redConfirmNo);
        Object originalInvoiceNo = redConfirm.get("originalinvoiceno");
        Object originalInvoiceType = redConfirm.get("originalinvoicetype");
        Object originalIssueTime = redConfirm.get("originalissuetime");
        Object oriInvoiceCode = redConfirm.get("originalinvoicecode");
        Object redReason = redConfirm.get("redreason");
        Object oriEtaxNo = redConfirm.get("originalEtaxInvoiceNo");
        Object applyCant = redConfirm.get("applicant");
        String billRedReason = RedConfirmHelper.matchBillRedReason((Object)redReason);
        if ((StringUtils.isBlank((Object)this.getModel().getValue("buyeraddr")) || StringUtils.isBlank((Object)this.getModel().getValue("buyerbank"))) && (blueInv = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"buyeraddr,buyerbank", (QFilter[])(invFilter = InvoiceUtils.getInvoiceFilter((Object)oriInvoiceCode, (Object)originalInvoiceNo)).toArray())).length > 0) {
            if (StringUtils.isBlank((Object)this.getModel().getValue("buyeraddr"))) {
                this.getModel().setValue("buyeraddr", (Object)blueInv[0].getString("buyeraddr"));
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue("buyerbank"))) {
                this.getModel().setValue("buyerbank", (Object)blueInv[0].getString("buyerbank"));
            }
        }
        this.getModel().setValue("originalissuetime", originalIssueTime);
        this.getModel().setValue("blueinvoiceno", originalInvoiceNo);
        this.getModel().setValue("blueinvoicetype", originalInvoiceType);
        this.getModel().setValue("redreason", (Object)billRedReason);
        this.getModel().setValue("applicant", applyCant);
        this.getModel().setValue("salerorbuyer", "2".equals(applyCant) ? "0" : applyCant);
        if (AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"))) {
            this.getModel().setValue("blueinvoicecode", oriInvoiceCode);
        }
        this.getModel().setValue("originaletaxinvoiceno", oriEtaxNo);
        DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("sim_original_bill_item");
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Object hsbz = redConfirm.get("hsbz");
        HashSet skipKey = new HashSet();
        Collections.addAll(skipKey, "id", "seq");
        if (OperationStatus.ADDNEW.equals((Object)operationStatus) && entry.size() == 0) {
            OriginalBillPluginCopyRedInfoControl.deleteRow((AbstractFormPlugin)this);
            this.getModel().setValue("hsbz", hsbz);
            try {
                this.getPageCache().put("fillCopyInfo", "id");
                DataEntityPropertyCollection collect = this.getModel().getEntryEntity("sim_original_bill_item").getDynamicObjectType().getProperties();
                for (DynamicObject item : items) {
                    int index = this.getModel().createNewEntryRow("sim_original_bill_item");
                    for (IDataEntityProperty property : item.getDataEntityType().getProperties()) {
                        String name = property.getName();
                        Object value = item.get(name);
                        if (skipKey.contains(name)) continue;
                        if (name.equals("rowtype")) {
                            Object object = value = "0".equals(value) ? "2" : value;
                        }
                        if (!collect.containsKey((Object)name)) continue;
                        this.getModel().setValue(name, value, index);
                    }
                    this.getModel().setValue("originalseq", item.get("originseq"), index);
                    this.getModel().setValue("policycontants", item.get("zzstsgl"), index);
                    this.getModel().setValue("policylogo", item.get("taxpremark"), index);
                    this.getModel().setValue("remainvalidnum", this.getFiledValue("num", index), index);
                    this.getModel().setValue("remainvalidtax", this.getFiledValue("tax", index), index);
                    this.getModel().setValue("orispecification", this.getFiledValue("specification", index), index);
                    this.getModel().setValue("orinum", this.getFiledValue("num", index), index);
                    this.getModel().setValue("oriunit", this.getFiledValue("unit", index), index);
                    this.getModel().setValue("oriunitprice", this.getFiledValue("unitprice", index), index);
                    DynamicObject goodsCode = TaxClassCodeCheckHelper.geTaxCode((String)String.valueOf(this.getFiledValue("goodscode", index)));
                    this.getModel().setValue("taxratecodeid", (Object)goodsCode, index);
                    if (null != goodsCode) {
                        this.getModel().setValue("goodssimplename", (Object)goodsCode.getString("simplename"), index);
                    }
                    if ("0".equals(hsbz)) {
                        this.getModel().setValue("remainvalidamount", this.getFiledValue("amount", index), index);
                        continue;
                    }
                    this.getModel().setValue("remainvalidamount", this.getFiledValue("taxamount", index), index);
                }
                OriginalBillPluginControl.countHeadAmount((IDataModel)this.getModel());
            }
            finally {
                this.getPageCache().remove("fillCopyInfo");
            }
        }
    }

    private Object getFiledValue(String name, int index) {
        return this.getModel().getValue(name, index);
    }

    private void createItems(Object returnData) {
        List list = (List)returnData;
        Map rowMapFirst = (Map)list.get(0);
        String hsbz = (String)rowMapFirst.get("hsbz");
        if (StringUtils.isNotBlank((CharSequence)hsbz)) {
            this.getModel().setValue("hsbz", (Object)hsbz);
        }
        if (StringUtils.isNotBlank(rowMapFirst.get("itempk"))) {
            this.updateRow(list);
            return;
        }
        this.getModel().deleteEntryData("sim_original_bill_item");
        HashSet<String> otherKey = new HashSet<String>(8);
        otherKey.add("flag");
        otherKey.add("row");
        otherKey.add("itempk");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.getModel().batchCreateNewEntryRow("sim_original_bill_item", list.size());
            int rowIndex = 0;
            for (Map stringObjectMap : list) {
                Set entries = stringObjectMap.entrySet();
                for (Map.Entry entry : entries) {
                    if (otherKey.contains(entry.getKey())) continue;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    this.getModel().setValue(key, value, rowIndex);
                    if ("tax".equals(key)) {
                        totalTax = totalTax.add(new BigDecimal(String.valueOf(value)));
                        continue;
                    }
                    if ("taxamount".equals(key)) {
                        totalAmount = totalAmount.add(new BigDecimal(String.valueOf(value)));
                        continue;
                    }
                    if (!"amount".equals(key)) continue;
                    invoiceAmount = invoiceAmount.add(new BigDecimal(String.valueOf(value)));
                }
                ++rowIndex;
            }
            stopWatch.stop();
            this.getModel().setValue("totaltax", (Object)totalTax);
            this.getModel().setValue("totalamount", (Object)totalAmount);
            this.getModel().setValue("invoiceamount", (Object)invoiceAmount);
            this.getModel().setValue("oldtotalamount", (Object)totalAmount);
            this.getModel().setValue("surplusamount", (Object)invoiceAmount);
            this.getModel().setValue("surplustax", (Object)totalTax);
            String billProperties = BigDecimal.ZERO.compareTo(totalAmount) > 0 ? "-1" : "1";
            this.getModel().setValue("billproperties", (Object)billProperties);
        }
        catch (Exception e) {
            LOGGER.error("itemImportError:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u660e\u7ec6\u5bfc\u5165\u5f02\u5e38", (String)"InvoiceOriginalFormPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateRow(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> row = list.get(i);
            if ("1".equals(this.getModel().getValue("rowtype", i))) continue;
            this.getModel().setValue("specification", row.get("specification"), i);
            this.getModel().setValue("unit", row.get("unit"), i);
            this.getModel().setValue("remark", row.get("remark"), i);
        }
    }

    private void setBuyerTitleData(Object returnData) {
        if (null == returnData || ((ListSelectedRowCollection)returnData).size() == 0) {
            return;
        }
        Object buyerTitlePk = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
        String filed = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)buyerTitlePk, (String)"bdm_invice_title_strate", (String)filed);
        String epName = dynamicObject.getString("name");
        this.getModel().setValue("buyername", (Object)epName);
        this.updateBuyerName(epName);
        String buyer_property_invTitle = dynamicObject.getString("buyertype");
        String buyerProperty = "";
        if (InvoiceBuyerTypeEnum.company.getTypeCode().equals(buyer_property_invTitle)) {
            buyerProperty = "0";
        } else if (InvoiceBuyerTypeEnum.person.getTypeCode().equals(buyer_property_invTitle)) {
            buyerProperty = "1";
        } else if (InvoiceBuyerTypeEnum.NO_COMPANY_PERSON.getTypeCode().equals(buyer_property_invTitle)) {
            buyerProperty = "2";
        }
        this.getModel().setValue("buyerproperty", (Object)buyerProperty);
        String taxNo = buyerProperty.equals("0") ? dynamicObject.getString("taxno") : dynamicObject.getString("idcode");
        this.getModel().setValue("buyertaxno", (Object)taxNo);
        if (!BotpHelper.isFromAr((Object)this.getModel().getValue("systemsource"))) {
            this.setCustomer(dynamicObject);
        }
        this.initMobileAndEmail(dynamicObject);
    }

    private void setCustomer(DynamicObject buyer) {
        this.getModel().setValue("customnameid", null);
        if (buyer != null) {
            DynamicObjectCollection items = buyer.getDynamicObjectCollection("cust");
            if (items.size() != 1) {
                return;
            }
            Object custom = ((DynamicObject)items.get(0)).get("custom");
            this.getModel().setValue("customnameid", custom);
        }
    }

    private void initMobileAndEmail(DynamicObject dynamicObject) {
        IDataModel model = this.getModel();
        model.setValue("buyeraddr", (Object)"");
        model.setValue("buyerbank", (Object)"");
        model.setValue("buyerphone", (Object)"");
        model.setValue("buyeremail", (Object)"");
        model.setValue("buyerredemail", (Object)"");
        DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
        if (items.isEmpty()) {
            return;
        }
        new BillMatchHelper().matchBuyerAddrAndBank(model.getDataEntity(), items);
        IFormView view = this.getView();
        view.updateView("buyerphone");
        view.updateView("buyeremail");
        view.updateView("buyeraddr");
        view.updateView("buyerbank");
        view.updateView("buyerredemail");
    }

    private void updateBuyerName(Object epname) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        showDataMap.put("buyername", epname);
        showDataMap.put("inputStyle", "border: none; border-bottom: 1px solid #999;padding-bottom: 15px; font-size: 16px");
        showDataMap.put("eventkey", "updateTitle");
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)CUSTOM_CONTROL_KEY);
    }

    private void setInfoCode(Object returnData) {
        String buyerBank;
        String buyerAddr;
        if (null == returnData) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        if (list.size() == 0) {
            this.getModel().setValue("infocode", (Object)"");
            return;
        }
        if (list.size() > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009'\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7'\u6570\u91cf\u6700\u591a\u4e0d\u80fd\u8d85\u8fc710\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalFormPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        QFilter redInfoFilter = new QFilter("id", "in", (Object)list.getPrimaryKeyValues());
        DynamicObject[] redInfoArray = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true), (QFilter[])redInfoFilter.toArray());
        if (list.size() == 1) {
            if (redInfoArray == null) {
                return;
            }
            this.getModel().setValue("blueinvoicecode", redInfoArray[0].get("originalinvoicecode"));
            this.getModel().setValue("blueinvoiceno", redInfoArray[0].get("originalinvoiceno"));
            this.getModel().setValue("originalissuetime", redInfoArray[0].get("originalissuetime"));
        }
        if (null == redInfoArray || redInfoArray.length == 0) {
            return;
        }
        ArrayList<DynamicObject> redInfoObjs = new ArrayList<DynamicObject>(Arrays.asList(redInfoArray));
        String infoCodes = redInfoObjs.stream().map(o -> o.getString("infocode")).collect(Collectors.joining(","));
        boolean addNew = "6".equals(this.getModel().getValue("billsource"));
        if (!addNew) {
            RedInfoHelper.checkRedInfoNotNull((String)infoCodes, (DynamicObject)this.getView().getModel().getDataEntity());
        }
        this.getPageCache().put("callBackRedInfo", "0");
        this.getModel().setValue("infocode", (Object)infoCodes);
        if (StringUtils.isBlank((Object)this.getModel().getValue("buyername"))) {
            Object buyerName = redInfoObjs.get(0).get("buyername");
            this.updateBuyerName(buyerName);
            this.getModel().setValue("buyername", buyerName);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("buyertaxno"))) {
            this.getModel().setValue("buyertaxno", (Object)redInfoObjs.get(0).getString("buyertaxno"));
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerAddr = redInfoObjs.get(0).getString("buyeraddr")))) {
            this.getModel().setValue("buyeraddr", (Object)redInfoObjs.get(0).getString("buyeraddr"));
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerBank = redInfoObjs.get(0).getString("buyerbank")))) {
            this.getModel().setValue("buyerbank", (Object)redInfoObjs.get(0).getString("buyerbank"));
        }
    }

    private void setBlueInvoiceInfo(Object returnData) {
        boolean addNew;
        if (null == returnData) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        if (list.size() == 0) {
            return;
        }
        Object objId = list.get(0).getPrimaryKeyValue();
        QFilter filter = new QFilter("id", "=", objId);
        DynamicObject vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
        this.getModel().setValue("blueinvoicecode", (Object)vatObj.getString("invoicecode"));
        this.getModel().setValue("blueinvoiceno", (Object)vatObj.getString("invoiceno"));
        this.getModel().setValue("originalissuetime", (Object)vatObj.getString("issuetime"));
        this.getModel().setValue("blueinvoicetype", (Object)vatObj.getString("invoicetype"));
        this.getModel().setValue("redreason", (Object)RedReasonEnum.INVOICE_ERR.getTypeCode());
        this.getModel().setValue("salerorbuyer", (Object)"0");
        this.getView().setEnable(Boolean.FALSE, new String[]{"originalissuetime"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"blueinvoicetype"});
        String buyerName = vatObj.getString("buyername");
        this.updateBuyerName(buyerName);
        if (StringUtils.isEmpty((CharSequence)this.getModel().getValue("buyername").toString())) {
            this.getModel().setValue("buyername", (Object)buyerName);
        }
        if (StringUtils.isEmpty((CharSequence)this.getModel().getValue("buyertaxno").toString())) {
            this.getModel().setValue("buyertaxno", (Object)vatObj.getString("buyertaxno"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getModel().getValue("buyeraddr").toString())) {
            this.getModel().setValue("buyeraddr", (Object)vatObj.getString("buyeraddr"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getModel().getValue("buyerbank").toString())) {
            this.getModel().setValue("buyerbank", (Object)vatObj.getString("buyerbank"));
        }
        if ("02".equals(vatObj.getString("specialtype"))) {
            this.getModel().setValue("buyertaxno", vatObj.get("salertaxno"));
            this.getModel().setValue("buyername", vatObj.get("salername"));
            this.getModel().setValue("buyeraddr", vatObj.get("saleraddr"));
            this.getModel().setValue("buyerbank", vatObj.get("salerbank"));
            this.getModel().setValue("specialtype", vatObj.get("specialtype"));
            this.getModel().setValue("cardtype", vatObj.get("cardtype"));
            this.getModel().setValue("salertaxno", vatObj.get("buyertaxno"));
            this.getModel().setValue("salername", vatObj.get("buyername"));
            this.getModel().setValue("saleraddr", vatObj.get("buyeraddr"));
            this.getModel().setValue("salerbank", vatObj.get("buyerbank"));
            this.getModel().setValue("nation", vatObj.get("nation"));
        }
        if ((addNew = "6".equals(this.getView().getModel().getValue("billsource"))) && !OriginalBillPluginCopyRedInfoControl.isFromRedInfo((AbstractFormPlugin)this)) {
            OriginalBillPluginCopyRedInfoControl.disableControl((AbstractFormPlugin)this, (DynamicObject)vatObj);
            OriginalBillPluginCopyRedInfoControl.copyVatInvoiceDetail((AbstractFormPlugin)this, (DynamicObject[])new DynamicObject[]{vatObj});
            this.getPageCache().put("itemType", "fromInvoice");
        }
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)this.getModel().getValue("blueinvoicecode").toString())), new String[]{"blueinvoicecode"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put(BILL_EDIT, "1");
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("fillCopyInfo"))) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("DOES_NOT_CHANGE"))) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("not_property_change" + this.getView().getPageId()))) {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int editIndex = changeData.getRowIndex();
        switch (name) {
            case "invoicetype": {
                boolean isAllEle;
                OriginalBillFormEditUtil.editINVOICETYPE((AbstractFormPlugin)this, (Object)newValue, (Object)oldValue);
                this.showRedInfoView(this.getModel().getValue("billproperties"));
                OriginalBillPluginControl.initInvoiceSpecialType((AbstractFormPlugin)this, (String)String.valueOf(newValue));
                boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)newValue) || "1".equals(this.getModel().getValue("iselepaper"));
                if (!isAllEle) {
                    this.getModel().deleteEntryData("extra");
                }
                this.getView().setVisible(Boolean.valueOf(isAllEle), new String[]{"advconap"});
                break;
            }
            case "buyerphone": {
                OriginalBillFormEditUtil.editBUYERPHONE((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "buyeremail": {
                OriginalBillFormEditUtil.editBUYEREMAIL((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "buyerbank": {
                OriginalBillFormEditUtil.editBUYERBANK((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "applicant": {
                OriginalBillFormEditUtil.editAPPLICANT((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "infocode": {
                if (this.isAllEleInvoice()) {
                    OriginalBillFormEditUtil.editRedConfirmBill((AbstractFormPlugin)this, (Object)newValue, (Object)oldValue);
                    break;
                }
                OriginalBillFormEditUtil.editINFOCODE((AbstractFormPlugin)this, (Object)this.getModel().getValue("billno"), (Object)newValue, (Object)oldValue);
                break;
            }
            case "blueinvoicecode": {
                OriginalBillFormEditUtil.editBLUEINVOICECODE((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "blueinvoiceno": {
                OriginalBillFormEditUtil.editBLUEINVOICECONO((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "buyeraddr": {
                OriginalBillFormEditUtil.editBUYERADDR((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "originalissuetime": {
                OriginalBillFormEditUtil.editORIGINALISSUETIME((AbstractFormPlugin)this, (Object)newValue);
                break;
            }
            case "deduction": {
                boolean needChange = OriginalBillPluginZSFSControl.editDeduction((AbstractFormPlugin)this, (IFormView)this.getView(), (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                if (!needChange) break;
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "num": {
                if (this.relateCalculateStop(newValue, "num", editIndex)) {
                    return;
                }
                boolean isFromZanGu = BotpHelper.isFromArZANGU((Object)this.getModel().getValue("systemsource"));
                boolean botpCreateBill = BotpHelper.isBotpCreateBill((AbstractFormPlugin)this);
                if (botpCreateBill && !BotpHelper.isNotComplete((Object)this.getModel().getValue("billcomplete")) && !isFromZanGu && this.editArFiNum((BigDecimal)newValue, oldValue, editIndex)) {
                    return;
                }
                if (isFromZanGu && "GIFT".equals(this.getModel().getValue("discountmode", editIndex))) {
                    Object taxFlag = this.getModel().getValue("hsbz");
                    BigDecimal taxRate = new BigDecimal((String)this.getModel().getValue("taxrate", editIndex));
                    OriginalBillPluginControl.alterInfoAllDiscountRowByNum((IFormView)this.getView(), (BigDecimal)((BigDecimal)newValue), (BigDecimal)taxRate, (Object)taxFlag, (int)editIndex);
                    return;
                }
                OriginalBillPluginControl.changeNum((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                this.calculateCombineAmount(editIndex);
                break;
            }
            case "unitprice": {
                if (this.relateCalculateStop(newValue, "unitprice", editIndex)) {
                    return;
                }
                OriginalBillPluginControl.changeUnitPrice((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "taxunitprice": {
                if (this.relateCalculateStop(newValue, "taxunitprice", editIndex)) {
                    return;
                }
                OriginalBillPluginControl.changeTaxUnitPrice((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "taxrate": {
                String newPrice;
                BigDecimal unitPrice;
                OriginalBillPluginControl.changeTaxRate((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                if (StringUtils.isBlank((Object)newValue)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a\u7a7a", (String)"InvoiceOriginalFormPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (StringUtils.isBlank((Object)oldValue)) break;
                BigDecimal oldRate = new BigDecimal(String.valueOf(oldValue));
                BigDecimal newRate = new BigDecimal(String.valueOf(newValue));
                BigDecimal num = (BigDecimal)this.getModel().getValue("num");
                String oldPrice = num.multiply(unitPrice = (BigDecimal)this.getModel().getValue("unitprice")).multiply(oldRate).setScale(2, 4).stripTrailingZeros().toPlainString();
                if (oldPrice.equals(newPrice = num.multiply(unitPrice).multiply(newRate).setScale(2, 4).stripTrailingZeros().toPlainString())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u7387\u5df2\u7531 %1$s%% \u53d8\u66f4\u4e3a %2$s%%", (String)"InvoiceOriginalFormPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), oldRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString(), newRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString()));
                    break;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u7387\u5df2\u7531%1$s%% \u53d8\u66f4\u4e3a %2$s%%\n\u7a0e\u989d\u5df2\u7531%3$s\u5143 \u53d8\u66f4\u4e3a%4$s\u5143", (String)"InvoiceOriginalFormPlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]), oldRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString(), newRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString(), oldPrice, newPrice));
                break;
            }
            case "amount": {
                boolean isFromZanGu = BotpHelper.isFromArZANGU((Object)this.getModel().getValue("systemsource"));
                if (BotpHelper.isBotpCreateBill((AbstractFormPlugin)this) && !BotpHelper.isNotComplete((Object)this.getModel().getValue("billcomplete")) && !isFromZanGu) {
                    String amountCacheKey = "amount" + editIndex;
                    String taxAmountCacheKey = "taxamount" + editIndex;
                    IPageCache pageCache = this.getPageCache();
                    if (StringUtils.isBlank((CharSequence)pageCache.get(amountCacheKey))) {
                        pageCache.put(amountCacheKey, String.valueOf(oldValue));
                        pageCache.put(taxAmountCacheKey, String.valueOf(this.getModel().getValue("taxamount", editIndex)));
                    }
                }
                OriginalBillPluginControl.changeAmount((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                this.calculateCombineAmount(editIndex);
                break;
            }
            case "taxamount": {
                boolean isFromZanGu = BotpHelper.isFromArZANGU((Object)this.getModel().getValue("systemsource"));
                if (BotpHelper.isBotpCreateBill((AbstractFormPlugin)this) && !BotpHelper.isNotComplete((Object)this.getModel().getValue("billcomplete")) && !isFromZanGu) {
                    String amountCacheKey = "amount" + editIndex;
                    String taxAmountCacheKey = "taxamount" + editIndex;
                    IPageCache pageCache = this.getPageCache();
                    if (StringUtils.isBlank((CharSequence)pageCache.get(amountCacheKey))) {
                        pageCache.put(taxAmountCacheKey, String.valueOf(oldValue));
                        pageCache.put(amountCacheKey, String.valueOf(this.getModel().getValue("amount", editIndex)));
                    }
                    if (this.greater((BigDecimal)newValue, new BigDecimal(pageCache.get(taxAmountCacheKey)))) {
                        OriginalBillPluginControl.setRowValueWithCache((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)oldValue, (int)editIndex, (String)"do_not_change_tax_amount", (String)"taxamount");
                        String pageId = this.getView().getPageId();
                        if (StringUtils.isBlank((CharSequence)CacheHelper.get((String)(pageId + "taxamount")))) {
                            CacheHelper.put((String)(pageId + "taxamount"), (String)"id", (int)2);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e0b\u63a8\u542b\u7a0e\u91d1\u989d", (String)"InvoiceOriginalFormPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        }
                        return;
                    }
                }
                OriginalBillPluginControl.changeTaxAmount((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                this.calculateCombineAmount(editIndex);
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "policylogo": {
                OriginalBillPluginControl.changeYHZC((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "policycontants": {
                OriginalBillPluginControl.changeYHZCNR((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "taxationstyle": {
                OriginalBillPluginZSFSControl.changeZSFS((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue);
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "billproperties": {
                this.changeRedOrBlue(newValue, oldValue);
                break;
            }
            case "taxadjust": {
                Object systemSource = this.getModel().getValue("systemsource");
                if (!CallbackHelperUtil.isSystemSourceFi((String)((String)systemSource))) break;
                DynamicObjectCollection itemList = this.getModel().getEntryEntity("sim_original_bill_item");
                InvoiceOriginalFormControl.itemEditAble((DynamicObjectCollection)itemList, (Boolean)((Boolean)newValue), (AbstractFormPlugin)this);
                break;
            }
            case "tax": {
                OriginalBillPluginControl.changeTaxAdjust((AbstractFormPlugin)this, (IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "specialtype": {
                OriginalBillPluginControl.changeSpecialType((AbstractFormPlugin)this);
                this.setPurchaseField();
                break;
            }
            case "jqbh": {
                String taxno = (String)this.getModel().getValue("salertaxno");
                if (StringUtils.isEmpty((CharSequence)taxno)) {
                    SaleInfo saleinfo = TaxUtils.getSaleInfoByOrg((Long)Long.parseLong(this.getOrgId().toString()));
                    taxno = saleinfo.getSaleTaxNo();
                }
                EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)((String)newValue), (String)taxno, (String)"terminalno", (boolean)false);
                DynamicObject bill = this.getModel().getDataEntity();
                DrawerInfo info = DrawerStrategyWithFilterHelper.getOriginalBillDrawerStrategy((Object)newValue, (DynamicObject)bill);
                this.getModel().setValue("drawer", (Object)info.getDrawer());
                this.getModel().setValue("payee", (Object)info.getPayee());
                this.getModel().setValue("reviewer", (Object)info.getReviewer());
                break;
            }
            case "fromamount": {
                OriginalBillPluginControl.changeFromAmount((IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "fromtaxamount": {
                OriginalBillPluginControl.changeFromTaxAmount((IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "gift": {
                if (!OriginalBillPluginControl.changeFromGift((IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex)) break;
                this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
                break;
            }
            case "modelnumrate": {
                OriginalBillPluginControl.changeModelNumRate((IFormView)this.getView(), (Object)newValue, (Object)oldValue, (int)editIndex);
                break;
            }
            case "buyertaxno": 
            case "buyername": {
                if (!BotpHelper.isFromAr((Object)this.getModel().getValue("systemsource"))) {
                    this.getModel().setValue("customnameid", null);
                }
                OriginalBillPluginControl.updateNation((AbstractFormPlugin)this);
                this.updateBuyerName(this.getModel().getValue("buyername"));
                break;
            }
            case "iselepaper": {
                if ("0".equals(newValue)) {
                    Object invoiceType = this.getModel().getValue("invoicetype");
                    if (InvoiceUtils.isAllEInvoice((Object)String.valueOf(invoiceType))) break;
                    this.getView().setVisible(Boolean.TRUE, new String[]{"jqbh"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"jqbh", "terminalno"});
                break;
            }
            case "exrate": {
                if (!BigDecimalUtil.greaterZero((BigDecimal)((BigDecimal)newValue))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"InvoiceOriginalFormPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object quotation = this.getModel().getValue("quotation");
                if (StringUtils.isBlank((Object)quotation)) {
                    return;
                }
                InvoiceOriginalFormControl.editExchangeRte((AbstractFormPlugin)this, (String)((String)quotation), (BigDecimal)((BigDecimal)newValue));
                break;
            }
            case "quotation": {
                Object quotation = this.getModel().getValue("quotation");
                if (StringUtils.isBlank((Object)quotation)) {
                    return;
                }
                Object exrate = this.getModel().getValue("exrate");
                if (!BigDecimalUtil.greaterZero((BigDecimal)((BigDecimal)exrate))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"InvoiceOriginalFormPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                InvoiceOriginalFormControl.editExchangeRte((AbstractFormPlugin)this, (String)((String)quotation), (BigDecimal)((BigDecimal)exrate));
                break;
            }
            case "exratetable": 
            case "exchangedate": 
            case "fromcurr": 
            case "tocurr": {
                InvoiceOriginalFormControl.updateExrate((AbstractFormPlugin)this);
                break;
            }
            case "modelnum_rate": {
                InvoiceOriginalFormControl.editModelNumRate((PropertyChangedArgs)e, (AbstractFormPlugin)this, (int)editIndex);
                break;
            }
            case "salebasedata": {
                InvoiceOriginalFormPlugin.setEstateSalesValue(this, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "extrainfotime": {
                if (null == newValue) break;
                String timeStr = DateUtils.format((Date)((Date)newValue), (String)"yyyy-MM-dd");
                this.getModel().setValue("extrainfovalue", (Object)timeStr, editIndex);
                break;
            }
            case "extrainfotype": {
                this.getModel().setValue("extrainfovalue", null, editIndex);
                break;
            }
            case "invoiceremark": {
                Object org = this.getModel().getValue("orgid");
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
                Object invoiceType = this.getModel().getValue("invoicetype");
                Object isElePaper = this.getModel().getValue("iselepaper");
                if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper)) {
                    if (String.valueOf(newValue).length() > 450 && InvoiceUtils.isCutRemark((Long)orgId)) {
                        String billRemark = InvoiceUtils.cutRemarkChar((String)((String)newValue), (int)450);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5907\u6ce8\u8d85\u957f\u505a\u622a\u53d6", (String)"InvoiceOriginalFormPlugin_63", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("invoiceremark", (Object)billRemark);
                    }
                } else if (GBKUtils.getGBKLength((String)String.valueOf(newValue)) > 230 && InvoiceUtils.isCutRemark((Long)orgId)) {
                    String remark = GBKUtils.cutGBKString((String)((String)newValue), (int)230);
                    this.getModel().setValue("invoiceremark", (Object)remark);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5907\u6ce8\u8d85\u957f\u505a\u622a\u53d6", (String)"InvoiceOriginalFormPlugin_63", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                this.getView().updateView("invoiceremark");
                break;
            }
            case "cardtype": {
                OriginalBillPluginControl.updateNation((AbstractFormPlugin)this);
                break;
            }
            case "buyerproperty": {
                this.setBuyerProperty();
                break;
            }
        }
    }

    public static void setEstateSalesValue(AbstractFormPlugin plugin, int rowIndex) {
        DynamicObjectCollection entryEntity = plugin.getView().getModel().getEntryEntity("estatesales");
        boolean haveRowValue = rowIndex >= 0 && rowIndex < entryEntity.size();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject saleInfo;
            if (haveRowValue && i != rowIndex || (saleInfo = ((DynamicObject)entryEntity.get(i)).getDynamicObject("salebasedata")) == null) continue;
            String simpleaddress = saleInfo.getDynamicObject("simpleaddress").getString("name");
            Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleaddress);
            plugin.getView().getModel().setValue("saleestatecode", (Object)saleInfo.getString("estatecode"), i);
            plugin.getView().getModel().setValue("saleprincename", adrressMap.get("province"), i);
            plugin.getView().getModel().setValue("salecityname", adrressMap.get("city"), i);
            plugin.getView().getModel().setValue("saledetailaddress", (Object)saleInfo.getString("detailaddress"), i);
            plugin.getView().getModel().setValue("onlinecontracteno", (Object)saleInfo.getString("onlinecontracteno"), i);
            plugin.getView().getModel().setValue("salelandtaxno", (Object)saleInfo.getString("landtaxno"), i);
            plugin.getView().getModel().setValue("salecrosscitysign", (Object)saleInfo.getString("crosscitysign"), i);
            plugin.getView().getModel().setValue("assessmenttaxamount", (Object)saleInfo.getString("approvedprice"), i);
            plugin.getView().getModel().setValue("actualtotalamount", (Object)saleInfo.getString("actualturnover"), i);
            plugin.getView().getModel().setValue("saleestateid", (Object)saleInfo.getString("estateid"), i);
            plugin.getView().getModel().setValue("saleunit", (Object)saleInfo.getString("areaunit"), i);
        }
    }

    public static void setEstateSalesValue(AbstractFormPlugin plugin) {
        InvoiceOriginalFormPlugin.setEstateSalesValue(plugin, -1);
    }

    private boolean relateCalculateStop(Object newValue, String key, int editIndex) {
        if (BigDecimalUtil.compareZero((BigDecimal)((BigDecimal)newValue))) {
            return false;
        }
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)this.getModel().getValue("invoicetype"))) || "1".equals(this.getModel().getValue("iselepaper"));
        BigDecimal inputValue = ((BigDecimal)newValue).stripTrailingZeros();
        int length = inputValue.toPlainString().replace("-", "").length();
        if (isAllEle && !"num".equals(key)) {
            if (length > 25) {
                BigDecimal standardValue = PriceHelper.getValue((BigDecimal)inputValue, (boolean)isAllEle);
                this.getModel().setValue(key, (Object)standardValue, editIndex);
                return true;
            }
        } else if (length > 16) {
            BigDecimal standardValue = UnitPriceHelper.getNumValue((BigDecimal)inputValue, null);
            this.getModel().setValue(key, (Object)standardValue, editIndex);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean editArFiNum(BigDecimal newValue, Object oldValue, int editIndex) {
        try {
            Object nextRowType;
            DynamicObjectCollection items;
            int itemSize;
            Object billComplete;
            OriginalBillHelper.noReact((IFormView)this.getView());
            this.putAmountCache(editIndex);
            BigDecimal oriNum = (BigDecimal)this.getModel().getValue("orinum", editIndex);
            BigDecimal modelnumrate = (BigDecimal)this.getModel().getValue("modelnumrate", editIndex);
            BigDecimal newNumber = BigDecimalUtil.compareZero((BigDecimal)modelnumrate) ? oriNum : oriNum.multiply(modelnumrate);
            if (BigDecimalUtil.greaterZero((BigDecimal)newNumber) && BigDecimalUtil.lessZero((BigDecimal)newValue)) {
                this.getModel().setValue("num", oldValue, editIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6570\u91cf\u4e0e\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"InvoiceOriginalFormPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)newNumber) && BigDecimalUtil.greaterZero((BigDecimal)newValue)) {
                this.getModel().setValue("num", oldValue, editIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6570\u91cf\u4e0e\u5fc5\u987b\u4e3a\u8d1f\u6570", (String)"InvoiceOriginalFormPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            if (this.greater(newValue, newNumber)) {
                this.getModel().setValue("num", oldValue, editIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u4e0b\u63a8\u6570\u91cf", (String)"InvoiceOriginalFormPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            if (BigDecimal.ZERO.compareTo((BigDecimal)oldValue) != 0 && BigDecimal.ZERO.compareTo(newValue) == 0) {
                this.getModel().setValue("num", oldValue, editIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u80fd\u4fee\u6539\u4e3a0", (String)"InvoiceOriginalFormPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            Object systemSource = this.getModel().getValue("systemsource");
            if (BotpHelper.isArBotpCompleteBill((Object)systemSource, (Object)(billComplete = this.getModel().getValue("billcomplete"))) && (itemSize = (items = this.getModel().getEntryEntity("sim_original_bill_item")).size()) >= editIndex + 2 && "1".equals(nextRowType = this.getModel().getValue("rowtype", editIndex + 1))) {
                Object taxFlag = this.getModel().getValue("hsbz");
                BigDecimal taxRate = new BigDecimal((String)this.getModel().getValue("taxrate", editIndex));
                OriginalBillPluginControl.alterInfoAllDiscountRowByNum((IFormView)this.getView(), (BigDecimal)newValue, (BigDecimal)taxRate, (Object)taxFlag, (int)editIndex);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            OriginalBillHelper.react((IFormView)this.getView());
        }
        return false;
    }

    private void calculateCombineAmount(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection itemList = model.getEntryEntity("sim_original_bill_item");
        int size = itemList.size();
        BigDecimal nextRowCombineAmount = BigDecimal.ZERO;
        BigDecimal fromCombineAmt = BigDecimal.ZERO;
        BigDecimal fromAmt = BigDecimal.ZERO;
        BigDecimal lastFromAmt = BigDecimal.ZERO;
        BigDecimal combineAmount = BigDecimal.ZERO;
        Object curr = this.getModel().getValue("fromcurr");
        boolean isFrom = false;
        if (null != curr) {
            String currNumber = ((DynamicObject)curr).getString("number");
            isFrom = !CurrencyConstant.CHW.equalsIgnoreCase(currNumber);
        }
        int combineIndex = rowIndex;
        Object rowType = model.getValue("rowtype", rowIndex);
        if ("1".equals(rowType)) {
            BigDecimal currentRowTaxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
            BigDecimal lastRowTaxAmount = (BigDecimal)model.getValue("taxamount", rowIndex - 1);
            combineAmount = currentRowTaxAmount.add(lastRowTaxAmount);
            if (isFrom) {
                fromAmt = (BigDecimal)model.getValue("fromtaxamount", rowIndex);
                lastFromAmt = (BigDecimal)model.getValue("fromtaxamount", rowIndex - 1);
                fromCombineAmt = fromAmt.add(lastFromAmt);
            }
            --combineIndex;
        } else {
            Object nextRowType;
            BigDecimal modelNumRate = (BigDecimal)this.getModel().getValue("modelnumrate");
            BigDecimal currentRowTaxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
            if (rowIndex + 1 < size && "1".equals(nextRowType = model.getValue("rowtype", rowIndex + 1))) {
                nextRowCombineAmount = nextRowCombineAmount.add((BigDecimal)model.getValue("taxamount", rowIndex + 1));
            }
            if (isFrom) {
                fromCombineAmt = (BigDecimal)model.getValue("fromtaxamount", rowIndex);
            }
            BigDecimal num = (BigDecimal)this.getModel().getValue("num");
            BigDecimal oriNum = MaterialToGoodsInfoHelp.gerOriNum((BigDecimal)modelNumRate, (BigDecimal)num);
            combineAmount = currentRowTaxAmount.add(nextRowCombineAmount);
            model.setValue("combinenum", (Object)oriNum);
        }
        if (isFrom) {
            model.setValue("combineamount", (Object)fromCombineAmt, combineIndex);
            model.setValue("combinelocalamount", (Object)combineAmount, combineIndex);
        } else {
            model.setValue("combineamount", (Object)combineAmount, combineIndex);
            model.setValue("combinelocalamount", (Object)combineAmount, combineIndex);
        }
    }

    private void putAmountCache(int editIndex) {
        String amountCacheKey = "amount" + editIndex;
        String taxAmountCacheKey = "taxamount" + editIndex;
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isBlank((CharSequence)pageCache.get(amountCacheKey))) {
            pageCache.put(amountCacheKey, String.valueOf(this.getModel().getValue("amount", editIndex)));
            pageCache.put(taxAmountCacheKey, String.valueOf(this.getModel().getValue("taxamount", editIndex)));
        }
    }

    private void openErBaseUnit(List<QFilter> list, BeforeF7SelectEvent evt) {
        DynamicObject[] units;
        EntryGrid entry = (EntryGrid)this.getControl("sim_original_bill_item");
        int length = entry.getSelectRows().length;
        if (length == 0) {
            return;
        }
        int selectRow = entry.getSelectRows()[0];
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("materielfield", selectRow);
        if (null == material) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u540e\u64cd\u4f5c", (String)"InvoiceOriginalFormPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ArrayList pks = Lists.newArrayListWithCapacity((int)list.size());
        for (DynamicObject unit : units = MaterialInfoUtil.querySourceUnitByMater((Object)material.getPkValue(), null)) {
            pks.add(unit.getDynamicObject("measureunitid").getPkValue());
        }
        list.add(new QFilter("id", "in", (Object)pks));
    }

    private boolean greater(BigDecimal biggerOne, BigDecimal lessOne) {
        return biggerOne.abs().compareTo(lessOne.abs()) > 0;
    }

    private void changeRedOrBlue(Object newValue, Object oldValue) {
        this.showRedInfoView(newValue);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection items = this.getModel().getEntryEntity("sim_original_bill_item");
        if (items.size() > 0) {
            DynamicObjectCollection dynamicObjectCollection = RedInvoiceUtil.convertItemsBlueToRed((DynamicObject)dataEntity, (DynamicObjectCollection)items, (String)"sim_original_bill");
            if (StringUtils.isNotBlank((Object)oldValue)) {
                this.getView().getModel().deleteEntryData("sim_original_bill_item");
            }
            OriginalBillPluginRowControl.warpRow((DynamicObjectCollection)dynamicObjectCollection, (AbstractFormPlugin)this, (IFormView)this.getView());
            this.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
        }
        BigDecimal deduction = dataEntity.getBigDecimal("deduction");
        if ("-1".equals(newValue) && BigDecimalUtil.greaterZero((BigDecimal)deduction) || "1".equals(newValue) && BigDecimalUtil.lessZero((BigDecimal)deduction)) {
            this.getModel().setValue("deduction", (Object)BigDecimal.ZERO);
        }
        if ("-1".equals(newValue)) {
            this.getModel().deleteEntryData("extra");
        }
        this.getModel().setValue("invoiceremark", null);
    }

    private void showRedInfoView(Object newValue) {
        boolean isShow = "-1".equals(newValue);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"redinfo"});
        if ("-1".equals(newValue)) {
            this.setRedOriginlBillVisibleColumn();
        }
    }

    private void deleteRow() {
        EntryGrid grid = (EntryGrid)this.getControl("sim_original_bill_item");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u518d\u8fdb\u884c\u64cd\u4f5c!", (String)"InvoiceOriginalFormPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        this.getModel().deleteEntryRows("sim_original_bill_item", selectRows);
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        int[] rows;
        String key = ((Control)event.getSource()).getKey();
        EntryGrid grid = (EntryGrid)this.getControl("sim_original_bill_item");
        if (key.equals("salebasedata")) {
            grid = (EntryGrid)this.getControl("estatesales");
        }
        if ((rows = grid.getSelectRows()).length < 1) {
            return;
        }
        int selectRow = grid.getSelectRows()[0];
        switch (key) {
            case "goodsid": {
                OriginalBillPluginTaxCodeControl.selectGoodsId((AfterF7SelectEvent)event, (IFormView)this.getView(), (int)selectRow);
                break;
            }
            case "taxratecodeid": {
                OriginalBillPluginControl.afterF7TaxCode((int)selectRow, (IFormView)this.getView());
                break;
            }
            case "materielfield": {
                OriginalBillPluginControl.afterF7Materiel((int)selectRow, (IFormView)this.getView());
                break;
            }
            case "expenseitem": {
                OriginalBillPluginControl.afterF7ExpenseItem((int)selectRow, (IFormView)this.getView());
                break;
            }
            case "unitfield": {
                OriginalBillPluginControl.afterF7UnitSelect((int)selectRow, (IFormView)this.getView());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        ArrayList list = Lists.newArrayList();
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "goodsid": {
                break;
            }
            case "mergerule": {
                list.add(new QFilter("enable", "=", (Object)"1"));
                break;
            }
            case "taxratecodeid": {
                QFilter taxClassQilter = new QFilter("sumitem", "=", (Object)"0");
                list.add(taxClassQilter);
                break;
            }
            case "unitfield": {
                this.openErBaseUnit(list, evt);
                break;
            }
            case "bizcontroltype": {
                list.add(new QFilter("org", "=", this.getOrgId()));
                break;
            }
            case "salebasedata": {
                if ("E05".equals(this.getModel().getValue("specialtype"))) {
                    list.add(new QFilter("estatetype", "=", (Object)"estateSaleInfo"));
                    break;
                }
                if (!"E06".equals(this.getModel().getValue("specialtype"))) break;
                list.add(new QFilter("estatetype", "=", (Object)"estateLeaseInfo"));
            }
        }
        evt.setCustomQFilters((List)list);
    }

    private void openInvoice() {
        ArrayList errMsgList;
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        String billEdit = this.getPageCache().get(BILL_EDIT);
        if (StringUtils.isNotBlank((CharSequence)billEdit) && BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(this.getModel().getValue("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u5f00\u7968", (String)"InvoiceOriginalFormPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (Objects.isNull(pkValue)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5f02\u5e38", (String)"InvoiceOriginalFormPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        DynamicObject originalBillObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"sim_original_bill");
        if (originalBillObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fd8\u672a\u4fdd\u5b58\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e\uff0c\u4e0d\u80fd\u4e00\u952e\u5f00\u7968\uff01", (String)"InvoiceOriginalFormPlugin_48", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (InvoiceOriginalBillPlugin.operationOriginalBill((String)this.getModel().getValue("billstatus"), "issuepush")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7684\u5355\u636e\u5ba1\u6279\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u4e00\u952e\u5f00\u7968", (String)"InvoiceOriginalFormPlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), InvoiceOriginalBillPlugin.getOriginalBillStatuNameByCode((String)this.getModel().getValue("billstatus"))), Integer.valueOf(2000));
            return;
        }
        if ("2".equals(this.getModel().getValue("confirmstate"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u975e\u201c\u5df2\u7533\u8bf7\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvoiceOriginalFormPlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"0".equals(this.getModel().getValue("validstate"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u201c\u6b63\u5e38\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalFormPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("1".equals(this.getModel().getValue("closestatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\uff0c\u4e0d\u80fd\u5f00\u7968", (String)"InvoiceOriginalFormPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet typeSet = Sets.newHashSetWithExpectedSize((int)1);
        BigDecimal totalamount = (BigDecimal)this.getModel().getValue("totalamount");
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        boolean isRedInfo = totalamount.compareTo(new BigDecimal(0)) < 0 && InvoiceUtils.isSpecialInvoice((String)invoiceType);
        boolean elePaper = AllEleAuthHelper.isElePaper((Object)this.getModel().getValue("iselepaper"));
        if (isRedInfo && !elePaper) {
            typeSet.add("-1");
        } else {
            typeSet.add("1");
        }
        if (typeSet.iterator().next().equals("-1")) {
            ArrayList objects = Lists.newArrayListWithCapacity((int)1);
            objects.add(pkValue);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])objects.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            if (!this.isSpecialInvoice(dynamicObjects)) {
                return;
            }
        }
        DynamicObject bill = this.getModel().getDataEntity(true);
        EquipmentHelper.checkIssueOriginalBillJQBH((DynamicObject)bill);
        OriginalBillPluginPreviewIssueControl.checkDescription("\u4e00\u952e\u5f00\u7968", bill.getString("billsourcetype"));
        CheckResult result = OriginalBillFormEditUtil.checkNormalRedReasonInfo((DynamicObject[])new DynamicObject[]{bill}, (Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE);
        if (RedConfirmHelper.isRedConfirmBill((DynamicObject)bill)) {
            RedConfirmHelper.checkOriginalBillRedConfirmInfo((DynamicObject)bill);
            RedConfirmHelper.checkRedConfirmBillNoUsed((DynamicObject)bill);
        }
        if (!(errMsgList = result.getErrMsgList()).isEmpty()) {
            String errMsg = String.join((CharSequence)"\r\n", errMsgList);
            ViewUtil.openConfirm((String)"normal_red_invoice", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ea2\u5b57\u666e\u7968\u6570\u636e\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u4fee\u6b63", (String)"InvoiceOriginalFormPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceOriginalFormPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceOriginalFormPlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)errMsg);
            return;
        }
        ArrayList updateList = result.getUpdateList();
        if (!updateList.isEmpty()) {
            ImcSaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        BillHelper.checkIssuePushSpecialCodeRemark((AbstractFormPlugin)this, (DynamicObject[])new DynamicObject[]{bill}, (HashSet)typeSet);
    }

    private boolean isSpecialInvoice(DynamicObject[] dynamicObjects) {
        Map<String, List<String>> isExsit = AbstractInvoiceOriginalBillWorkbenchPlugin.checkRedSpecial(dynamicObjects);
        if (!isExsit.isEmpty()) {
            switch (isExsit.keySet().iterator().next()) {
                case "isnull": {
                    List<String> isnull = isExsit.get("isnull");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u7ea2\u5b57\u4fe1\u606f\u8868\u540e\u518d\u5f00\u7968", (String)"InvoiceOriginalFormPlugin_35", (String)"imc-sim-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", isnull), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    this.getPageCache().remove("select_bill_issyetype");
                    return false;
                }
                case "blueInvoice": {
                    List<String> blueInvoice = isExsit.get("blueInvoice");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u7684\u9500\u65b9\u7533\u8bf7\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8865\u5145\u6216\u4fee\u6b63\u540e\u518d\u5f00\u7968", (String)"InvoiceOriginalFormPlugin_36", (String)"imc-sim-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", blueInvoice), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    this.getPageCache().remove("select_bill_issyetype");
                    return false;
                }
                case "isNotExsit": {
                    List<String> isNotExsit = isExsit.get("isNotExsit");
                    AbstractInvoiceOriginalBillWorkbenchPlugin.oneKeyNegInvoiceCheck(dynamicObjects, isNotExsit);
                    ViewUtil.openConfirm((String)"isNotExsit", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6821\u9a8c\u53ef\u7ea2\u51b2\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"InvoiceOriginalFormPlugin_37", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceOriginalFormPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7ee7\u7eed\u5f00\u7968", (String)"InvoiceOriginalFormPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"InvoiceOriginalFormPlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", isNotExsit)));
                    return false;
                }
            }
        }
        return true;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        switch (e.getName()) {
            case "updateBillTotalAmount": {
                OriginalBillPluginBaseControl.updateBillTotalAmount((AbstractFormPlugin)this);
                break;
            }
            case "queryTitle": {
                String name = (String)this.getModel().getValue("buyername");
                QueryTitleHelper.queryBuyerTitle((String)name, (String)CUSTOM_CONTROL_KEY, (AbstractFormPlugin)this);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            Object confirmState = this.getModel().getValue("confirmstate");
            Object billStatus = this.getModel().getValue("billstatus");
            if (!"2".equals(confirmState) && BillStatusEnum.isEditStatus((Object)billStatus)) {
                this.getView().setStatus(OperationStatus.EDIT);
            }
            this.initCustomControl();
            this.getView().setVisible(Boolean.TRUE, new String[]{"shelve", "refresh", "submit", "audit", "nextquery", "viewflowchart", "refresh"});
        }
        if ("save".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            String billComplete = String.valueOf(this.getModel().getValue("billcomplete"));
            String billSource = String.valueOf(this.getModel().getValue("billsource"));
            if (!BotpHelper.isNotComplete((Object)billComplete) && "3".equals(billSource)) {
                this.lockItemEdit(false);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private Object getOrgId() {
        Object orgId = this.getModel().getValue("orgid");
        orgId = orgId == null ? RequestContext.get().getOrgId() : DynamicObjectUtil.getDynamicObjectLongValue((Object)orgId);
        return orgId;
    }
}

