/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillRelateInvoicesConstant;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallBackProcessVo;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.bill.BillHelper;
import kd.imc.bdm.common.helper.callback.CallBackLogHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MqPublishUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.FillInInvoiceRequestDTO;
import kd.imc.sim.common.dto.FillInInvoiceResponseDTO;
import kd.imc.sim.common.helper.FillInInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;

public class OriginalBillAddRelateInvoicesPlugin
extends AbstractFormPlugin {
    private static final String ORIGINAL_BILL_PRIMARY_KEY = "originalBillPrimaryKey";
    private static final String INVOICENO = "invoiceno";
    private static final String INVOICECODE = "invoicecode";
    private static final String INVOICECHOOSE = "invoicechoose";
    private static final Log LOGGER = LogFactory.getLog(OriginalBillAddRelateInvoicesPlugin.class);
    public static final String ORG_ID_KEY = "orgId";

    public void afterCreateNewData(EventObject e) {
        Label notice = (Label)this.getView().getControl("notice");
        notice.setText(ResManager.loadKDString((String)"\u52fe\u9009\u591a\u4e2a\u5355\u636e\u65f6\uff0c\u9ed8\u8ba4\u4e3a\u591a\u4e2a\u5355\u636e\u5408\u5e76\u5f00\u7968\u3002\u70b9\u51fb\u3010\u786e\u8ba4\u3011\u89c6\u4e3a\u5f00\u7968\u7ed3\u675f\uff0c\u5f00\u7968\u7ed3\u675f\u540e\u4e0d\u53ef\u518d\u6b21\u56de\u586b\u53d1\u7968\u3002", (String)"OriginalBillAddRelateInvoicesPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object primaryKey = customParams.get("primaryKey");
        Object permitEdit = customParams.get("permitEdit");
        String editType = customParams.get("editType").toString();
        if (!this.checkBillEditType(editType)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u56de\u586b\u65b9\u5f0f:%s,\u4e0d\u5b58\u5728", (String)"OriginalBillAddRelateInvoicesPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), editType));
            return;
        }
        this.getModel().setValue("billedittype", (Object)editType);
        String orgId = String.valueOf(customParams.get(ORG_ID_KEY));
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            this.getPageCache().put(ORG_ID_KEY, orgId);
        }
        this.getPageCache().put(ORIGINAL_BILL_PRIMARY_KEY, String.valueOf(primaryKey));
        Object[] pkList = this.getPkList(primaryKey);
        DynamicObject[] billDynamicObjects = BusinessDataServiceHelper.load((Object[])pkList, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        Map<Object, List<DynamicObject>> originalBillMapById = Stream.of(billDynamicObjects).collect(Collectors.groupingBy(DataEntityBase::getPkValue));
        BigDecimal oriTotalAmount = BigDecimal.ZERO;
        BigDecimal oriTotalTax = BigDecimal.ZERO;
        BigDecimal oriInvoiceAmount = BigDecimal.ZERO;
        for (DynamicObject oriBill : billDynamicObjects) {
            oriTotalAmount = oriTotalAmount.add(oriBill.getBigDecimal("totalamount"));
            oriTotalTax = oriTotalTax.add(oriBill.getBigDecimal("totaltax"));
            oriInvoiceAmount = oriInvoiceAmount.add(oriBill.getBigDecimal("invoiceamount"));
        }
        Label billTips = (Label)this.getView().getControl("billtips");
        billTips.setText(String.format(ResManager.loadKDString((String)"\u672c\u6279\u6b21\u5355\u636e\u4e0d\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\uff1a%1$s\u5143\uff0c\u7a0e\u989d\u5408\u8ba1\uff1a%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1\uff1a%3$s\u5143", (String)"OriginalBillAddRelateInvoicesPlugin_39", (String)"imc-sim-formplugin", (Object[])new Object[0]), oriInvoiceAmount.setScale(2, 4), oriTotalTax.setScale(2, 4), oriTotalAmount.setScale(2, 4)));
        if ("false".equals(String.valueOf(permitEdit))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancel", "cofirmaddrelateinvs"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"billedittype"});
            DynamicObject[] dbRelate = this.getDbRelate(pkList, editType);
            int index = 0;
            for (DynamicObject invoiceDynamicObject : dbRelate) {
                this.getModel().createNewEntryRow("entryentity");
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"invoicetype", INVOICECODE, INVOICENO, "issuetime", "invoiceamount", "totaltax", "totalamount"});
                this.getModel().setValue("invoicetype", invoiceDynamicObject.get("invoicetype"), index);
                this.getModel().setValue(INVOICECODE, invoiceDynamicObject.get(INVOICECODE), index);
                this.getModel().setValue(INVOICENO, invoiceDynamicObject.get(INVOICENO), index);
                this.getModel().setValue("invoiceamount", (Object)this.trimEndZero(invoiceDynamicObject.get("invoiceamount")), index);
                this.getModel().setValue("totaltax", (Object)this.trimEndZero(invoiceDynamicObject.get("totaltax")), index);
                this.getModel().setValue("totalamount", (Object)this.trimEndZero(invoiceDynamicObject.get("totalamount")), index);
                this.getModel().setValue("issuetime", invoiceDynamicObject.get("issuetime"), index);
                if ("2".equals(editType)) {
                    DynamicObject originalBill = originalBillMapById.get(invoiceDynamicObject.getLong("originalbillid")).get(0);
                    DynamicObjectCollection originalBillItems = originalBill.getDynamicObjectCollection("sim_original_bill_item");
                    this.getModel().setValue("billno", (Object)originalBill.getString("billno"), index);
                    Map<Object, List<DynamicObject>> billItemMapById = originalBillItems.stream().collect(Collectors.groupingBy(a -> a.get("id").toString()));
                    String billDetailId = invoiceDynamicObject.getString("billdetailid");
                    this.getModel().setValue("billdetailid", (Object)billDetailId, index);
                    List<DynamicObject> dynamicObjects = billItemMapById.get(billDetailId);
                    if (dynamicObjects != null) {
                        DynamicObject billItem = dynamicObjects.get(0);
                        Object goodsName = billItem.get("goodsname");
                        String num = billItem.getString("num");
                        this.getModel().setValue("num", (Object)this.trimEndZero(num), index);
                        Object specification = billItem.get("specification");
                        Object taxAmount = billItem.get("taxamount");
                        this.getModel().setValue("goodsname", goodsName, index);
                        this.getModel().setValue("specification", specification, index);
                        this.getModel().setValue("taxamount", (Object)this.trimEndZero(taxAmount), index);
                    }
                }
                ++index;
            }
        }
        this.updateFieldVisableByEditType(editType);
        this.updateButtonVisableByEditType(editType);
    }

    private boolean checkBillEditType(String editType) {
        return "1".equals(editType) || "2".equals(editType);
    }

    private DynamicObject[] getDbRelate(Object[] pkList, String editType) {
        List<Object> billIds = new ArrayList<Object>();
        if ("1".equals(editType)) {
            billIds.add(pkList[0]);
        } else {
            billIds = Arrays.asList(pkList);
        }
        return BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)false), (QFilter[])new QFilter("originalbillid", "in", billIds).and(BillHelper.notCancelFilter()).toArray());
    }

    private String trimEndZero(Object num) {
        if (null == num || StringUtils.isEmpty((CharSequence)num.toString())) {
            return "";
        }
        BigDecimal result = new BigDecimal(num.toString()).stripTrailingZeros();
        return result.toPlainString();
    }

    private DynamicObject[] getBillByPk(Object primaryKey) {
        Object[] pkList = this.getPkList(primaryKey);
        return BusinessDataServiceHelper.load((Object[])pkList, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
    }

    private Object[] getPkList(Object primaryKey) {
        String[] originalBillIdArr = String.valueOf(primaryKey).split(",");
        return Arrays.stream(originalBillIdArr).map(Long::parseLong).toArray();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
        TextEdit invoiceNoEdit = (TextEdit)this.getView().getControl(INVOICENO);
        invoiceNoEdit.addClickListener((ClickListener)this);
        TextEdit invoiceCodeNoEdit = (TextEdit)this.getView().getControl(INVOICECODE);
        invoiceCodeNoEdit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (INVOICENO.equals(key) || INVOICECODE.equals(key)) {
            this.openVatInvoiceListView();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "cofirmaddrelateinvs": {
                LOGGER.info("\u53d1\u7968\u56de\u586b\u5f00\u59cb");
                this.cofirmAddRelateInvs();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        int editIndex = changeData.getRowIndex();
        switch (name) {
            case "invoicetype": {
                this.autoWriteDiscountInvoiceType(editIndex);
                break;
            }
            case "invoiceno": {
                this.autoWriteAmount(editIndex, name);
                break;
            }
            case "invoicecode": {
                this.autoWriteAmount(editIndex, name);
                break;
            }
            case "invoiceamount": {
                this.writeTotalAmount(editIndex);
                break;
            }
            case "totaltax": {
                this.writeTotalAmount(editIndex);
                break;
            }
            case "billedittype": {
                this.changeEditType(changeData);
            }
        }
    }

    private void changeEditType(ChangeData changeData) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeEditType", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5426", (String)"OriginalBillAddRelateInvoicesPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"OriginalBillAddRelateInvoicesPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String oldValue = changeData.getOldValue().toString();
        this.getPageCache().put("billedittypeoldValue", oldValue);
        String newValue = changeData.getNewValue().toString();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() != 0) {
            String content = ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u672c\u6b21\u6309%s\u7684\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OriginalBillAddRelateInvoicesPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            if ("1".equals(oldValue) && "2".equals(newValue)) {
                content = String.format(content, ResManager.loadKDString((String)"\"\u53d1\u7968\u56de\u586b\"", (String)"OriginalBillAddRelateInvoicesPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            } else if ("2".equals(oldValue) && "1".equals(newValue)) {
                content = String.format(content, ResManager.loadKDString((String)"\"\u660e\u7ec6\u56de\u586b\"", (String)"OriginalBillAddRelateInvoicesPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5207\u6362\u56de\u586b\u65b9\u5f0f\u5f02\u5e38", (String)"OriginalBillAddRelateInvoicesPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(content, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        } else {
            this.initBillGoods();
        }
    }

    private void writeTotalAmount(int editIndex) {
        BigDecimal invoiceAmount = (BigDecimal)this.getView().getModel().getValue("invoiceamount", editIndex);
        BigDecimal totalTax = (BigDecimal)this.getView().getModel().getValue("totaltax", editIndex);
        BigDecimal totalAmount = null == invoiceAmount ? (null == totalTax ? null : totalTax.setScale(2, RoundingMode.HALF_UP)) : (null == totalTax ? invoiceAmount.setScale(2, RoundingMode.HALF_UP) : invoiceAmount.add(totalTax).setScale(2, RoundingMode.HALF_UP));
        this.getView().getModel().setValue("totalamount", (Object)totalAmount, editIndex);
    }

    private void autoWriteDiscountInvoiceType(int editIndex) {
        int nextIndex;
        DynamicObject nextObject;
        DynamicObjectCollection entryEntity;
        int size;
        String invoiceType = (String)this.getView().getModel().getValue("invoicetype", editIndex);
        String invoiceNo = (String)this.getView().getModel().getValue(INVOICENO, editIndex);
        String billEditType = this.getPageCache().get("billedittypeoldValue");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            this.updateTableField(editIndex, INVOICECODE, "");
            if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && !RegexUtil.isAllElectricInvoiceNo((String)invoiceNo)) {
                this.updateTableField(editIndex, INVOICENO, "");
            }
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{INVOICECODE});
        } else {
            this.getView().setEnable(Boolean.TRUE, editIndex, new String[]{INVOICECODE});
        }
        if ("2".equals(billEditType) && editIndex < (size = (entryEntity = this.getModel().getEntryEntity("entryentity")).size()) - 1 && "1".equals((nextObject = (DynamicObject)entryEntity.get(nextIndex = editIndex + 1)).getString("rowtype"))) {
            this.updateTableField(nextIndex, "invoicetype", invoiceType);
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                this.updateTableField(nextIndex, INVOICECODE, "");
            }
        }
    }

    private void updateTableField(int editIndex, String fieldName, String s) {
        this.getModel().beginInit();
        this.getModel().setValue(fieldName, (Object)s, editIndex);
        this.getModel().endInit();
        this.getView().updateView(fieldName, editIndex);
    }

    private void autoWriteAmount(int editIndex, String name) {
        int nextIndex;
        DynamicObject nextObject;
        DynamicObjectCollection entryEntity;
        int size;
        String billEditType;
        QFilter filter;
        String invoiceCode = (String)this.getView().getModel().getValue(INVOICECODE, editIndex);
        String invoiceNo = (String)this.getView().getModel().getValue(INVOICENO, editIndex);
        String invoiceType = (String)this.getView().getModel().getValue("invoicetype", editIndex);
        this.getView().setEnable(Boolean.TRUE, editIndex, new String[]{"issuetime"});
        DynamicObject invoice = null;
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (this.checkInvoiceNo(name, invoiceNo)) {
                return;
            }
            filter = new QFilter(INVOICENO, "=", (Object)invoiceNo);
            invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])filter.toArray());
        } else if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isNotBlank((CharSequence)invoiceNo)) {
            if (this.checkInvoiceCodeAndNo(name, invoiceCode, invoiceNo, invoiceType)) {
                return;
            }
            filter = new QFilter(INVOICECODE, "=", (Object)invoiceCode).and(INVOICENO, "=", (Object)invoiceNo);
            invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])filter.toArray());
        }
        if (invoice != null) {
            this.getModel().setValue("invoiceamount", (Object)this.trimEndZero(invoice.get("invoiceamount")), editIndex);
            this.getModel().setValue("totalamount", (Object)this.trimEndZero(invoice.get("totalamount")), editIndex);
            this.getModel().setValue("totaltax", (Object)this.trimEndZero(invoice.get("totaltax")), editIndex);
            this.getModel().setValue("invoicetype", (Object)invoice.getString("invoicetype"), editIndex);
            this.getModel().setValue("issuetime", (Object)invoice.getString("issuetime"), editIndex);
            this.getPageCache().put(invoiceCode.concat(invoiceNo), String.valueOf(invoice.getPkValue()));
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"issuetime"});
        }
        if ("2".equals(billEditType = this.getPageCache().get("billedittypeoldValue")) && editIndex < (size = (entryEntity = this.getModel().getEntryEntity("entryentity")).size()) - 1 && "1".equals((nextObject = (DynamicObject)entryEntity.get(nextIndex = editIndex + 1)).getString("rowtype"))) {
            this.getModel().beginInit();
            this.getModel().setValue("invoicetype", (Object)invoiceType, nextIndex);
            this.getModel().setValue(INVOICECODE, (Object)invoiceCode, nextIndex);
            this.getModel().setValue(INVOICENO, (Object)invoiceNo, nextIndex);
            this.getModel().endInit();
            this.getView().updateView("invoicetype", nextIndex);
            this.getView().updateView(INVOICECODE, nextIndex);
            this.getView().updateView(INVOICENO, nextIndex);
        }
    }

    private boolean checkInvoiceNo(String name, String invoiceNo) {
        if (INVOICENO.equals(name) && !RegexUtil.isAllElectricInvoiceNo((String)invoiceNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u516520\u4f4d\u6570\u5b57", (String)"OriginalBillAddRelateInvoicesPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkInvoiceCodeAndNo(String name, String invoiceCode, String invoiceNo, String invoiceType) {
        if (INVOICENO.equals(name) && !RegexUtil.isInvoiceNo((String)invoiceNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u51658\u4f4d\u6570\u5b57", (String)"OriginalBillAddRelateInvoicesPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (INVOICECODE.equals(name)) {
            if (("028".equals(invoiceType) || "026".equals(invoiceType)) && !RegexUtil.isEtcInvoiceCode((String)invoiceCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u7968\u53d1\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u516512\u4f4d\u6570\u5b57", (String)"OriginalBillAddRelateInvoicesPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (("004".equals(invoiceType) || "007".equals(invoiceType)) && !RegexUtil.isPaperInvoiceCode((String)invoiceCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7eb8\u7968\u53d1\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u516510\u4f4d\u6570\u5b57", (String)"OriginalBillAddRelateInvoicesPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void openVatInvoiceListView() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int selectRow = grid.getSelectRows()[0];
        String invoiceNo = this.getModel().getValue(INVOICENO, selectRow).toString();
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            QFilter qFilter = new QFilter(INVOICENO, "=", (Object)invoiceNo);
            ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_vatinvoice", (String)INVOICECHOOSE, (boolean)true, (boolean)true, null);
        } else {
            Object editType;
            DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)false), (QFilter[])new QFilter("createtime", ">=", (Object)DateUtils.addMonth((Date)new Date(), (int)-2)).and(BillHelper.notCancelFilter()).toArray());
            ArrayList<Long> invoiceIdList = new ArrayList<Long>(4);
            for (DynamicObject dynamicObject : dbRelate) {
                String invoiceId = dynamicObject.getString("invoiceid");
                if (!StringUtils.isNotBlank((CharSequence)invoiceId)) continue;
                invoiceIdList.add(Long.parseLong(invoiceId));
            }
            Long org = this.getOrgId();
            QFilter qFilter1 = new QFilter("orgid", "=", (Object)org).and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray);
            String invoiceType = (String)this.getModel().getValue("invoicetype");
            if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
                if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
                    qFilter1.and("invoicetype", "in", (Object)InvoiceUtils.getNormalInvoiceType());
                } else if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                    qFilter1.and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType());
                } else if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                    qFilter1.and("invoicetype", "in", (Object)InvoiceUtils.getAllEInvoiceType());
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u7c7b\u578b, \u8bf7\u624b\u5de5\u8f93\u5165", (String)"OriginalBillAddRelateInvoicesPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if ("2".equals(editType = this.getModel().getValue("billedittype"))) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int[] rows = entryGrid.getSelectRows();
                String billNo = (String)this.getModel().getValue("billno", rows[0]);
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"billproperties", (QFilter[])new QFilter("billno", "=", (Object)billNo).toArray());
                QFilter issueTypeFilter = new QFilter("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
                if (bills.length > 0 && "-1".equals(bills[0].getString("billproperties"))) {
                    issueTypeFilter = new QFilter("issuetype", "=", (Object)IssueType.RED_INVOICE.getTypeCode());
                }
                qFilter1 = qFilter1.and(issueTypeFilter);
            }
            QFilter qFilter2 = new QFilter("id", "not in", (Object)invoiceIdList.toArray());
            QFilter qFilter = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_RELATE_INV_SIMPLE_FILTER)) ? qFilter1.and("buyertype", "!=", (Object)"4") : qFilter1.and(qFilter2).and("buyertype", "!=", (Object)"4");
            ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_vatinvoice", (String)INVOICECHOOSE, (boolean)true, (boolean)true, null);
        }
    }

    private void setChooseInvoiceForEditByGoods(DynamicObjectCollection invoiceObjs) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        this.getModel().setValue("invoicetype", ((DynamicObject)invoiceObjs.get(0)).get("invoicetype"), rows[0]);
        String invoiceCode = ((DynamicObject)invoiceObjs.get(0)).getString(INVOICECODE);
        String invoiceNo = ((DynamicObject)invoiceObjs.get(0)).getString(INVOICENO);
        QFilter filter = new QFilter(INVOICECODE, "=", (Object)invoiceCode);
        filter.and(new QFilter(INVOICENO, "=", (Object)invoiceNo));
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])filter.toArray());
        this.getPageCache().put(invoiceCode + invoiceNo, String.valueOf(invoice.get("id")));
        this.getModel().setValue(INVOICECODE, (Object)invoiceCode, rows[0]);
        this.getModel().setValue(INVOICENO, (Object)invoiceNo, rows[0]);
        this.getModel().setValue("invoiceamount", ((DynamicObject)invoiceObjs.get(0)).get("invoiceamount"), rows[0]);
        this.getModel().setValue("totaltax", ((DynamicObject)invoiceObjs.get(0)).get("totaltax"), rows[0]);
        this.getModel().setValue("totalamount", ((DynamicObject)invoiceObjs.get(0)).get("totalamount"), rows[0]);
        this.getModel().setValue("issuetime", ((DynamicObject)invoiceObjs.get(0)).get("issuetime"), rows[0]);
    }

    private void setChooseInvoiceForEditByInvoice(DynamicObjectCollection invoiceObjs) {
        String invoiceNo;
        String invoiceCode;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int size = entryEntity.size();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(size);
        if (size > 0) {
            for (DynamicObject object : entryEntity) {
                invoiceCode = object.getString(INVOICECODE);
                invoiceNo = object.getString(INVOICENO);
                if (!InvoiceUtils.isAllEInvoice((Object)object.getString("invoicetype")) ? StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceNo) : StringUtils.isBlank((CharSequence)invoiceNo)) continue;
                if (map.containsKey(invoiceCode + invoiceNo)) continue;
                map.put(invoiceCode + invoiceNo, object);
            }
        }
        for (DynamicObject invoiceObj : invoiceObjs) {
            invoiceCode = String.valueOf(invoiceObj.get(INVOICECODE));
            invoiceNo = String.valueOf(invoiceObj.get(INVOICENO));
            if (map.containsKey(invoiceCode + invoiceNo)) continue;
            DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            invoiceDynamicObject.set("invoicetype", invoiceObj.get("invoicetype"));
            invoiceDynamicObject.set("invoiceamount", invoiceObj.get("invoiceamount"));
            invoiceDynamicObject.set("totaltax", invoiceObj.get("totaltax"));
            invoiceDynamicObject.set("totalamount", invoiceObj.get("totalamount"));
            invoiceDynamicObject.set(INVOICECODE, (Object)invoiceCode);
            invoiceDynamicObject.set(INVOICENO, (Object)invoiceNo);
            invoiceDynamicObject.set("issuetime", invoiceObj.get("issuetime"));
            this.getPageCache().put(invoiceCode + invoiceNo, String.valueOf(invoiceObj.get("id")));
            map.put(invoiceCode + invoiceNo, invoiceDynamicObject);
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().createNewEntryRow("entryentity");
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject invoiceDynamicObject = (DynamicObject)entry.getValue();
            this.getModel().setValue("invoicetype", invoiceDynamicObject.get("invoicetype"), index);
            String invoiceCode2 = invoiceDynamicObject.getString(INVOICECODE);
            String invoiceNo2 = invoiceDynamicObject.getString(INVOICENO);
            this.getModel().setValue(INVOICECODE, (Object)invoiceCode2, index);
            this.getModel().setValue(INVOICENO, (Object)invoiceNo2, index);
            this.getModel().setValue("invoiceamount", invoiceDynamicObject.get("invoiceamount"), index);
            this.getModel().setValue("totaltax", invoiceDynamicObject.get("totaltax"), index);
            this.getModel().setValue("totalamount", invoiceDynamicObject.get("totalamount"), index);
            this.getModel().setValue("issuetime", invoiceDynamicObject.get("issuetime"), index);
            if (index < map.size() - 1) {
                this.getModel().createNewEntryRow("entryentity");
            }
            ++index;
        }
    }

    private void cofirmAddRelateInvs() {
        try {
            DynamicObject[] invoices;
            String content;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int size = entryEntity.size();
            if (0 == size) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u53d1\u7968\u4fe1\u606f", (String)"OriginalBillAddRelateInvoicesPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            String originalBillIds = String.valueOf(this.getPageCache().get(ORIGINAL_BILL_PRIMARY_KEY));
            if (StringUtils.isBlank((CharSequence)originalBillIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"OriginalBillAddRelateInvoicesPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            long currentOrgId = this.getOrgId();
            String userId = RequestContext.get().getUserId();
            DynamicObject[] billDynamicObjects = this.getBillByPk(originalBillIds);
            DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)false), (QFilter[])new QFilter("originalbillid", "in", (Object)this.getPkList(originalBillIds)).and(BillHelper.notCancelFilter()).toArray());
            BigDecimal oriTotalAmount = BigDecimal.ZERO;
            for (DynamicObject oriBill : billDynamicObjects) {
                oriTotalAmount = oriTotalAmount.add(oriBill.getBigDecimal("totalamount"));
            }
            HashMap<String, String> addInvoices = new HashMap<String, String>();
            BigDecimal addTotalAmount = BigDecimal.ZERO;
            String editType = (String)this.getModel().getValue("billedittype");
            boolean isItemFillIn = "2".equalsIgnoreCase(editType);
            HashSet<String> invoiceCodeNoSet = new HashSet<String>(size);
            QFilter filter = null;
            for (int i = 0; i < size; ++i) {
                boolean isInvoiceCode;
                boolean isInvoiceNo;
                String key;
                DynamicObject relateInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_add_invoice");
                DynamicObject object = (DynamicObject)entryEntity.get(i);
                if ("1".equals(object.getString("rowtype"))) continue;
                Object invoiceType = object.get("invoicetype");
                this.checkInvoiceType(invoiceType, i);
                relateInvoice.set("invoicetype", invoiceType);
                String invoiceNo = object.getString(INVOICENO);
                String invoiceCode = object.getString(INVOICECODE);
                String string = key = StringUtils.isBlank((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + invoiceNo;
                if (!invoiceCodeNoSet.contains(key)) {
                    if (null == filter) {
                        filter = new QFilter(INVOICENO, "=", (Object)invoiceNo);
                        if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                            filter = filter.and(INVOICECODE, "=", (Object)invoiceCode);
                        }
                    } else {
                        QFilter otherFilter = new QFilter(INVOICENO, "=", (Object)invoiceNo);
                        if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                            otherFilter = otherFilter.and(INVOICECODE, "=", (Object)invoiceCode);
                        }
                        filter = filter.or(otherFilter);
                    }
                    invoiceCodeNoSet.add(key);
                }
                if (InvoiceUtils.isAllEInvoice((Object)invoiceType.toString())) {
                    isInvoiceNo = RegexUtil.isAllElectricInvoiceNo((String)invoiceNo);
                    isInvoiceCode = true;
                } else {
                    isInvoiceNo = RegexUtil.isInvoiceNo((String)invoiceNo);
                    isInvoiceCode = RegexUtil.isInvoiceCode((String)invoiceCode);
                }
                this.showCheckTip(isInvoiceNo, ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"OriginalBillAddRelateInvoicesPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), i);
                this.showCheckTip(isInvoiceCode, ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"OriginalBillAddRelateInvoicesPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), i);
                relateInvoice.set(INVOICENO, (Object)invoiceNo);
                this.checkRepeatAdd(invoiceCode, invoiceNo, dbRelate, addInvoices, i);
                relateInvoice.set(INVOICECODE, (Object)invoiceCode);
                BigDecimal totalTax = object.getBigDecimal("totaltax");
                if (null == object.getBigDecimal("totaltax")) {
                    totalTax = BigDecimal.ZERO;
                }
                relateInvoice.set("totaltax", (Object)totalTax);
                BigDecimal invoiceAmount = object.getBigDecimal("invoiceamount");
                if (null == invoiceAmount) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillAddRelateInvoicesPlugin_40", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d", (String)"OriginalBillAddRelateInvoicesPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                }
                BigDecimal totalAmount = object.getBigDecimal("totalamount");
                if (null == totalAmount) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillAddRelateInvoicesPlugin_40", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"OriginalBillAddRelateInvoicesPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                }
                if (totalTax.add(invoiceAmount).compareTo(totalAmount) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\"\u4ef7\u7a0e\u5408\u8ba1\"\u4e0d\u7b49\u4e8e\"\u53d1\u7968\u91d1\u989d\"\u52a0\"\u7a0e\u989d\"", (String)"OriginalBillAddRelateInvoicesPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                }
                BigDecimal taxAmount = (BigDecimal)object.get("taxamount");
                if (i + 1 < size && "1".equals(((DynamicObject)entryEntity.get(i + 1)).getString("rowtype"))) {
                    BigDecimal nextRowTaxAmount = ((DynamicObject)entryEntity.get(i + 1)).getBigDecimal("taxamount");
                    taxAmount = taxAmount.add(nextRowTaxAmount);
                }
                if (isItemFillIn && taxAmount.compareTo(totalAmount) != 0 && !"1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.FORCE_CHECK_ITEM_AMOUNT))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u56de\u586b\u7684\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u8be5\u660e\u7ec6\u884c\u7684\u4ef7\u7a0e\u5408\u8ba1(\u82e5\u4e0b\u4e00\u884c\u4e3a\u6298\u6263\u884c\uff0c\u5219\u8be5\u884c\u56de\u586b\u7684\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u987b\u7b49\u540c\u4e8e\u8be5\u884c\u548c\u6298\u6263\u884c\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e4b\u548c)", (String)"OriginalBillAddRelateInvoicesPlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                }
                relateInvoice.set("invoiceamount", (Object)invoiceAmount);
                relateInvoice.set("org", (Object)currentOrgId);
                relateInvoice.set("creator", (Object)userId);
                addTotalAmount = addTotalAmount.add(totalTax);
                addTotalAmount = addTotalAmount.add(invoiceAmount);
            }
            this.checkOriAmountAndAddAmount(oriTotalAmount, addTotalAmount);
            if (oriTotalAmount.abs().compareTo(addTotalAmount.abs()) != 0) {
                BigDecimal sub = oriTotalAmount.abs().subtract(addTotalAmount.abs()).abs();
                content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u603b\u91d1\u989d\u548c\u5df2\u586b\u5199\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u76f8\u5dee%s\u5143\uff0c\u662f\u5426\u786e\u8ba4\u5f00\u7968\u7ed3\u675f\uff1f", (String)"OriginalBillAddRelateInvoicesPlugin_41", (String)"imc-sim-formplugin", (Object[])new Object[0]), sub.setScale(2, 4));
            } else {
                content = ResManager.loadKDString((String)"\u5f00\u7968\u7ed3\u675f\u540e\u4e0d\u53ef\u518d\u6b21\u56de\u586b\u53d1\u7968\uff0c\u662f\u5426\u786e\u8ba4\u5f00\u7968\u7ed3\u675f\uff1f", (String)"OriginalBillAddRelateInvoicesPlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            this.getPageCache().put("addContent", content);
            if (null != filter && this.checkBuyerInfoShowTip(billDynamicObjects, invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray()))) {
                return;
            }
            this.showTip(content);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"OriginalBillAddRelateInvoicesPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void showTip(String content) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("add", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5426", (String)"OriginalBillAddRelateInvoicesPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"OriginalBillAddRelateInvoicesPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(content, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private boolean checkBuyerInfoShowTip(DynamicObject[] billDynamicObjects, DynamicObject[] invoices) {
        if (billDynamicObjects.length == 0 || invoices.length == 0) {
            return false;
        }
        String billBuyerName = billDynamicObjects[0].getString("buyername");
        String billBuyerTaxNo = billDynamicObjects[0].getString("buyertaxno");
        StringBuilder tip = new StringBuilder();
        for (DynamicObject invoice : invoices) {
            String buyerName = invoice.getString("buyername");
            String buyerTaxNo = invoice.getString("buyertaxno");
            String specialType = invoice.getString("specialtype");
            if ("02".equals(specialType)) {
                buyerName = invoice.getString("salername");
                buyerTaxNo = invoice.getString("salertaxno");
            }
            if (String.valueOf(buyerName).contains("\uff08\u4e2a\u4eba\uff09")) {
                buyerName = buyerName.replace("\uff08\u4e2a\u4eba\uff09", "");
            }
            if (billBuyerName.equals(buyerName) && billBuyerTaxNo.equals(buyerTaxNo)) continue;
            tip.append(invoice.getString(INVOICENO)).append(ResManager.loadKDString((String)"\u53d1\u7968\u4e0e\u5355\u636e\u62ac\u5934\u4fe1\u606f\u4e0d\u4e00\u81f4", (String)"OriginalBillAddRelateInvoicesPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
        }
        if (tip.length() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("checkBuyerInfo", (IFormPlugin)this);
            tip.append(ResManager.loadKDString((String)"\u786e\u8ba4\u56de\u586b\u53d1\u7968\u5417\uff1f", (String)"OriginalBillAddRelateInvoicesPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(tip.toString(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null);
            return true;
        }
        return false;
    }

    private void checkOriAmountAndAddAmount(BigDecimal oriTotalAmount, BigDecimal addTotalAmount) {
        int oriFlag = oriTotalAmount.signum();
        int addFlag = addTotalAmount.signum();
        if (oriFlag != 0 && addFlag != 0 && oriFlag != addFlag) {
            throw new KDBizException(oriFlag == 1 ? ResManager.loadKDString((String)"\u5355\u636e\u5408\u8ba1\u4e3a\u6b63\uff0c\u8bf7\u586b\u5199\u6b63\u6570\u53d1\u7968\u53ca\u6b63\u6570\u91d1\u989d", (String)"OriginalBillAddRelateInvoicesPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u636e\u5408\u8ba1\u4e3a\u8d1f\uff0c\u8bf7\u586b\u5199\u8d1f\u6570\u53d1\u7968\u53ca\u8d1f\u6570\u91d1\u989d", (String)"OriginalBillAddRelateInvoicesPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkInvoiceType(Object invoiceType, int rowIndex) {
        if (null == invoiceType) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillAddRelateInvoicesPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    private void showCheckTip(boolean success, String fieldName, int rowIndex) {
        if (success) {
            return;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u6709\u8bef", (String)"OriginalBillAddRelateInvoicesPlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1, fieldName));
    }

    private void checkRepeatAdd(String invoiceCode, String invoiceNo, DynamicObject[] dbRelate, HashMap<String, String> addInvoices, int rowIndex) {
        for (DynamicObject object : dbRelate) {
            if (!object.getString(INVOICECODE).equals(invoiceCode) || !object.getString(INVOICENO).equals(invoiceNo)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u6570\u636e\u5df2\u7ecf\u5173\u8054\u8fc7\u8be5\u539f\u59cb\u5355\u636e", (String)"OriginalBillAddRelateInvoicesPlugin_35", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        if (addInvoices.containsKey(invoiceNo) && invoiceCode.equals(addInvoices.get(invoiceNo))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u91cd\u590d", (String)"OriginalBillAddRelateInvoicesPlugin_36", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "add": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.save();
                this.getView().returnDataToParent((Object)"SUCCESS");
                this.getView().close();
                break;
            }
            case "changeEditType": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().deleteEntryData("entryentity");
                    this.initBillGoods();
                    break;
                }
                this.getModel().beginInit();
                String oldValue = this.getPageCache().get("billedittypeoldValue");
                this.getModel().setValue("billedittype", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("billedittype");
                this.updateFieldVisableByEditType(oldValue);
                this.updateButtonVisableByEditType(oldValue);
                break;
            }
            case "checkBuyerInfo": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                String content = this.getPageCache().get("addContent");
                this.showTip(content);
            }
        }
    }

    private void updateFieldVisableByEditType(String editType) {
        if ("2".equals(editType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"billno", "goodsname", "specification", "num", "taxamount"});
        } else if ("1".equals(editType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billno", "goodsname", "specification", "num", "taxamount"});
        }
    }

    private void updateButtonVisableByEditType(String editType) {
        if ("2".equals(editType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new", "delete"});
        } else if ("1".equals(editType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"new", "delete"});
        }
    }

    private void initBillGoods() {
        String billEditType = this.getModel().getDataEntity().get("billedittype").toString();
        this.updateFieldVisableByEditType(billEditType);
        this.updateButtonVisableByEditType(billEditType);
        this.getPageCache().put("billedittypeoldValue", billEditType);
        if ("2".equals(billEditType)) {
            String primaryKey = this.getPageCache().get(ORIGINAL_BILL_PRIMARY_KEY);
            DynamicObject[] originalBills = this.getBillByPk(primaryKey);
            int index = 0;
            for (DynamicObject originalBill : originalBills) {
                DynamicObjectCollection billItems = originalBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject billItem : billItems) {
                    this.getModel().createNewEntryRow("entryentity");
                    String rowType = billItem.getString("rowtype");
                    this.getModel().setValue("rowtype", (Object)rowType, index);
                    this.getModel().setValue("billno", (Object)originalBill.getString("billno"), index);
                    String billDetailId = billItem.get("id").toString();
                    this.getModel().setValue("billdetailid", (Object)billDetailId, index);
                    this.getModel().setValue("goodsname", (Object)billItem.getString("goodsname"), index);
                    String num = billItem.getString("num");
                    this.getModel().setValue("num", (Object)this.trimEndZero(num), index);
                    this.getModel().setValue("specification", (Object)billItem.getString("specification"), index);
                    this.getModel().setValue("taxamount", (Object)this.trimEndZero(billItem.getString("taxamount")), index);
                    if ("1".equals(rowType)) {
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"invoicetype", INVOICECODE, INVOICENO, "issuetime", "invoiceamount", "totaltax", "totalamount"});
                    }
                    ++index;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (INVOICECHOOSE.equals(actionId)) {
            ListSelectedRowCollection list = this.checkReturnData(returnData);
            if (null == list) {
                return;
            }
            Object[] pks = list.getPrimaryKeyValues();
            Set pkStrSet = Arrays.stream(pks).map(o -> String.valueOf(o)).collect(Collectors.toSet());
            QFilter filter = new QFilter("invoiceid", "in", pkStrSet).and(BillHelper.notCancelFilter());
            DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)false), (QFilter[])filter.toArray());
            StringBuilder invoiceNoBuilder = new StringBuilder(ResManager.loadKDString((String)"\u53d1\u7968:", (String)"OriginalBillAddRelateInvoicesPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            for (DynamicObject dynamicObject : dbRelate) {
                invoiceNoBuilder.append("[").append(dynamicObject.getString(INVOICENO)).append("]");
            }
            invoiceNoBuilder.append(ResManager.loadKDString((String)"\u5df2\u56de\u586b\u5176\u4ed6\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"OriginalBillAddRelateInvoicesPlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            if (dbRelate.length > 0) {
                this.getView().showTipNotification(invoiceNoBuilder.toString(), Integer.valueOf(7000));
                return;
            }
            QFilter invoiceFilter = new QFilter("id", "in", (Object)list.getPrimaryKeyValues());
            DynamicObjectCollection invoiceObjs = QueryServiceHelper.query((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])invoiceFilter.toArray());
            if (null == invoiceObjs || invoiceObjs.isEmpty()) {
                return;
            }
            String billEditType = this.getModel().getDataEntity().getString("billedittype");
            if ("1".equals(billEditType)) {
                this.setChooseInvoiceForEditByInvoice(invoiceObjs);
            } else {
                if (list.size() > 1) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6309\"\u660e\u7ec6\u56de\u586b\"\u6bcf\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u53d1\u7968", (String)"OriginalBillAddRelateInvoicesPlugin_37", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setChooseInvoiceForEditByGoods(invoiceObjs);
            }
        }
    }

    private ListSelectedRowCollection checkReturnData(Object returnData) {
        if (null == returnData) {
            return null;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    private void save() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        long currentOrgId = this.getOrgId();
        String userId = RequestContext.get().getUserId();
        String originalBillIds = String.valueOf(this.getPageCache().get(ORIGINAL_BILL_PRIMARY_KEY));
        DynamicObject[] originalBills = this.getBillByPk(originalBillIds);
        List<Object> callbackLogs = new ArrayList(1);
        String billEditType = this.getModel().getDataEntity().getString("billedittype");
        try (TXHandle tx = TX.requiresNew();){
            try {
                FillInInvoiceResponseDTO response;
                String randomStr = RandomString.nextString((int)3, (boolean)true, (boolean)false);
                String fillInBatchNo = "FillIn" + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + randomStr;
                if ("1".equals(billEditType)) {
                    callbackLogs = this.saveByInvoice(entryEntity, currentOrgId, userId, originalBills, fillInBatchNo);
                    FillInInvoiceRequestDTO request = FillInInvoiceHelper.generateInvoiceFillInRequest((DynamicObjectCollection)entryEntity, (DynamicObject[])originalBills);
                    response = FillInInvoiceHelper.fillInvoice((FillInInvoiceRequestDTO)request);
                } else if ("2".equals(billEditType)) {
                    callbackLogs = this.saveByGoods(entryEntity, currentOrgId, userId, originalBills, fillInBatchNo);
                    response = FillInInvoiceHelper.getDetailFillInInvoiceResponse((DynamicObjectCollection)entryEntity, (DynamicObject[])originalBills);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u56de\u586b\u65b9\u5f0f", (String)"OriginalBillAddRelateInvoicesPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                IssuedInvoiceWriteBackHelper.fillInInvoiceWriteBack2OriginalBill((DynamicObject[])originalBills, (FillInInvoiceResponseDTO)response, (String)fillInBatchNo, (boolean)false);
                for (DynamicObject originalBill : originalBills) {
                    originalBill.set("comprehensivestatus", (Object)"09");
                }
                SaveServiceHelper.update((DynamicObject[])originalBills);
                if (!CollectionUtils.isEmpty(callbackLogs)) {
                    ImcSaveServiceHelper.save(callbackLogs);
                }
                this.invokeBillCenter(originalBillIds, entryEntity);
            }
            catch (Exception e) {
                callbackLogs.clear();
                this.getView().showErrorNotification(e.getMessage());
                tx.markRollback();
            }
        }
        if (!CollectionUtils.isEmpty(callbackLogs)) {
            for (DynamicObject callbackLog : callbackLogs) {
                CallbackLogVo callbackLogVo = (CallbackLogVo)DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, (DynamicObject)callbackLog);
                MqPublishUtils.publish((String)"imc", (String)"imc.sim.api_queue", (Object)JSONObject.toJSONString((Object)callbackLogVo));
            }
        }
    }

    private void invokeBillCenter(String originalBillIds, DynamicObjectCollection invoiceObjectCollection) {
        DynamicObject[] billDynamicObjects;
        if (StringUtils.isBlank((CharSequence)originalBillIds)) {
            LOGGER.error("invokeBillCenter, \u53cd\u5199\u8d26\u5355\u4e2d\u5fc3\u65f6\u5f00\u7968\u7533\u8bf7\u5355\u7684\u4e3b\u952eid\u503c\u5217\u8868\u4e3a\u7a7a\uff01");
            return;
        }
        for (DynamicObject originalBillObject : billDynamicObjects = this.getBillByPk(originalBillIds)) {
            Long originalId = originalBillObject.getLong("id");
            String systemSource = originalBillObject.getString("systemsource");
            String systemCode = originalBillObject.getString("textfield1");
            LOGGER.info("invokeBillCenter, originalId:{}, systemSource:{}, systemCode:{}", new Object[]{originalId, systemSource, systemCode});
            if (!"BILL_CENTER".equals(systemSource) || !StringUtils.isNotBlank((CharSequence)systemCode)) continue;
            for (DynamicObject invoiceItemObject : invoiceObjectCollection) {
                DynamicObject invoiceObject;
                String invoiceNo = invoiceItemObject.getString(INVOICENO);
                String invoiceCode = invoiceItemObject.getString(INVOICECODE);
                QFilter qFilter = new QFilter(INVOICENO, "=", (Object)invoiceNo);
                if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                    qFilter = qFilter.and(INVOICECODE, "=", (Object)invoiceCode);
                }
                if ((invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])qFilter.toArray())) == null) continue;
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callbackByOpType", (Object[])new Object[]{invoiceObject.getPkValue(), originalId, "callbackByFillIn"});
                LOGGER.info("invokeBillCenter, invoiceNo:{}, invoiceCode:{}, \u56de\u5199\u8d26\u5355\u4e2d\u5fc3\u5b8c\u6210!", (Object)invoiceNo, (Object)invoiceCode);
            }
        }
    }

    private List<DynamicObject> saveByGoods(DynamicObjectCollection entryEntity, long currentOrgId, String userId, DynamicObject[] billDynamicObjects, String serialno) {
        Map<String, List<DynamicObject>> entryEntityMapByBillNo = entryEntity.stream().collect(Collectors.groupingBy(a -> a.getString("billno")));
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        HashSet<String> createCallbackBusinessFids = new HashSet<String>(entryEntity.size());
        ArrayList<DynamicObject> callbackLogs = new ArrayList<DynamicObject>(objs.size());
        for (DynamicObject originalBill : billDynamicObjects) {
            objs.clear();
            String invoiceNo = null;
            String invoiceCode = null;
            if (entryEntityMapByBillNo.containsKey(originalBill.getString("billno"))) {
                List<DynamicObject> entryEntityByBillNo = entryEntityMapByBillNo.get(originalBill.getString("billno"));
                for (DynamicObject entryObj : entryEntityByBillNo) {
                    DynamicObject relateInvoice = this.createNewDynamicObj(entryObj, originalBill, serialno, currentOrgId, userId);
                    String billDetailId = entryObj.getString("billdetailid");
                    if (StringUtils.isNotEmpty((CharSequence)billDetailId)) {
                        relateInvoice.set("billdetailid", (Object)billDetailId);
                    }
                    invoiceNo = entryObj.getString(INVOICENO);
                    invoiceCode = entryObj.getString(INVOICECODE);
                    objs.add(relateInvoice);
                }
                this.setOriginalBillIssueTime(originalBill, entryEntityByBillNo);
            }
            ImcSaveServiceHelper.save(objs);
            callbackLogs.addAll(this.addFillinCallBackRecords(originalBill, objs, createCallbackBusinessFids, serialno));
            originalBill.set("validstate", (Object)"2");
            originalBill.set(INVOICECODE, invoiceCode);
            originalBill.set(INVOICENO, invoiceNo);
            SaveServiceHelper.update((DynamicObject)originalBill);
        }
        return callbackLogs;
    }

    private void setOriginalBillIssueTime(DynamicObject originalBill, List<DynamicObject> entryEntityByBillNo) {
        Object[] objects = entryEntityByBillNo.stream().filter(a -> null != a.getDate("issuetime")).map(a -> a.getDate("issuetime")).sorted().toArray();
        if (0 != objects.length) {
            Object issueTime = objects[objects.length - 1];
            originalBill.set("issuetime", issueTime);
        }
    }

    private List<DynamicObject> saveByInvoice(DynamicObjectCollection entryEntity, long currentOrgId, String userId, DynamicObject[] billDynamicObjects, String fillInBatchNo) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        HashSet<String> createCallbackBusinessFids = new HashSet<String>(entryEntity.size());
        ArrayList<DynamicObject> callbackLogs = new ArrayList<DynamicObject>(objs.size());
        for (DynamicObject originalBill : billDynamicObjects) {
            objs.clear();
            String invoiceNo = null;
            String invoiceCode = null;
            for (DynamicObject entryObj : entryEntity) {
                DynamicObject relateInvoice = this.createNewDynamicObj(entryObj, originalBill, fillInBatchNo, currentOrgId, userId);
                objs.add(relateInvoice);
                invoiceNo = entryObj.getString(INVOICENO);
                invoiceCode = entryObj.getString(INVOICECODE);
            }
            ImcSaveServiceHelper.save(objs);
            callbackLogs.addAll(this.addFillinCallBackRecords(originalBill, objs, createCallbackBusinessFids, fillInBatchNo));
            originalBill.set("validstate", (Object)"2");
            originalBill.set(INVOICECODE, invoiceCode);
            originalBill.set(INVOICENO, (Object)invoiceNo);
            this.setOriginalBillIssueTime(originalBill, (List<DynamicObject>)entryEntity);
        }
        return callbackLogs;
    }

    private List<DynamicObject> addFillinCallBackRecords(DynamicObject originalBill, List<DynamicObject> objs, Set<String> createCallbackBusinessFids, String fillInBatchNo) {
        ArrayList<DynamicObject> callbackLogs = new ArrayList<DynamicObject>(objs.size());
        String systemSource = originalBill.getString("systemsource");
        String billSource = originalBill.getString("billsource");
        ArrayList<String> urls = new ArrayList<String>(4);
        if (BotpHelper.isFromAr((Object)systemSource)) {
            urls.add("");
        } else if ("XKQJ".equals(systemSource)) {
            urls.add("\u661f\u7a7a\u65d7\u8230\u7248");
        } else {
            if (systemSource == null || CallbackHelperUtil.isSystemSourceFi((String)systemSource) || !"2".equals(billSource)) {
                return callbackLogs;
            }
            DynamicObject businessSystem = CallbackHelperUtil.getBusinessSystemByCode((String)systemSource);
            if (businessSystem == null) {
                return callbackLogs;
            }
            urls.add(businessSystem.getString("callback_url"));
            urls.add(businessSystem.getString("callback_url_two"));
            urls.add(businessSystem.getString("callback_url_thr"));
            urls.removeIf(StringUtils::isBlank);
            if (CollectionUtils.isEmpty(urls)) {
                return callbackLogs;
            }
        }
        for (DynamicObject obj : objs) {
            String invoiceId = obj.getString("invoiceid");
            if (StringUtils.isBlank((CharSequence)invoiceId) || createCallbackBusinessFids.contains(invoiceId)) continue;
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(invoiceId), (String)"sim_vatinvoice");
            String businessCode = IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype")) ? OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode() : OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode();
            for (String url : urls) {
                CallBackProcessVo vo = new CallBackProcessVo(invoice, systemSource, businessCode, url);
                vo.setCallbackno(fillInBatchNo);
                DynamicObject callbackLog = CallBackLogHelper.createCallBackObj((CallBackProcessVo)vo, (String)invoice.getString("issuetype"), (boolean)true);
                if (callbackLog == null) continue;
                callbackLog.set("callbacktype", (Object)CallBackLogTypeEnum.fillin.getValue());
                callbackLog.set("business_type", (Object)OpenApiCallbackInterfaceCodeEnum.INVOICE_FILL_IN.getCode());
                callbackLogs.add(callbackLog);
            }
            createCallbackBusinessFids.add(invoiceId);
        }
        return callbackLogs;
    }

    private DynamicObject createNewDynamicObj(DynamicObject entryObj, DynamicObject originalBill, String serialno, long currentOrgId, String userId) {
        DynamicObject relateInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_add_invoice");
        relateInvoice.set("serialno", (Object)serialno);
        Object invoiceType = entryObj.get("invoicetype");
        relateInvoice.set("invoicetype", invoiceType);
        String invoiceNo = entryObj.getString(INVOICENO);
        relateInvoice.set(INVOICENO, (Object)invoiceNo);
        String invoiceCode = entryObj.getString(INVOICECODE);
        relateInvoice.set(INVOICECODE, (Object)invoiceCode);
        BigDecimal totalTax = entryObj.getBigDecimal("totaltax");
        relateInvoice.set("totaltax", (Object)totalTax);
        BigDecimal invoiceAmount = entryObj.getBigDecimal("invoiceamount");
        relateInvoice.set("invoiceamount", (Object)invoiceAmount);
        BigDecimal totalAmount = entryObj.getBigDecimal("totalamount");
        relateInvoice.set("totalamount", (Object)totalAmount);
        relateInvoice.set("org", (Object)currentOrgId);
        relateInvoice.set("originalbillid", originalBill.getPkValue());
        relateInvoice.set("billno", (Object)originalBill.getString("billno"));
        relateInvoice.set("creator", (Object)userId);
        relateInvoice.set("createtime", (Object)new Date());
        relateInvoice.set("invoiceid", (Object)this.getPageCache().get(invoiceCode.concat(invoiceNo)));
        relateInvoice.set("issuetime", entryObj.get("issuetime"));
        relateInvoice.set("writebacklable", (Object)BillRelateInvoicesConstant.WriteBackEnum.NO);
        relateInvoice.set("iscancel", (Object)BillRelateInvoicesConstant.IsCancelEnum.NO);
        return relateInvoice;
    }

    private long getOrgId() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(ORG_ID_KEY)) ? RequestContext.get().getOrgId() : DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getPageCache().get(ORG_ID_KEY));
    }
}

