/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.dto.TotalTaxWC;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.helper.cache.GoodsInfoCacheHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.formplugin.bill.originalbill.AbstractOriginalBillImportPlugin;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OriginalBillItemsImportPlugin
extends AbstractOriginalBillImportPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(OriginalBillItemsImportPlugin.class);
    private static final String TEMPLATE_DIR = "excel_templates";
    private static final String TEMPLATE_JSON_NAME = "originalBillItems.json";
    public static final int GOODSNAME_LENGTH = 92;
    public static final int UNIT_LENGTH = 22;
    public static final int SPECIFICATION_LENGTH = 40;
    private static final String ITEM_PK = "itempk";
    private String InputFilePath = null;
    private boolean isChangeHSBZ = false;
    private String FirstRowHSBZ = null;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_data_export", "btn_download_template", "btn_reset_file", "btn_upload", "btn_cancel"});
        Image label = (Image)this.getControl("btn_file_upload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
    }

    protected void uploadFile(String filepath, InputStream inputStream, Workbook workbook) {
        if (!filepath.equals(this.InputFilePath)) {
            this.InputFilePath = filepath;
            this.isChangeHSBZ = true;
        }
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        Object invoiceType = this.getView().getFormShowParameter().getCustomParam("invoicetype");
        Object isElePaperStr = this.getView().getFormShowParameter().getCustomParam("iselepaper");
        boolean isElePaper = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaperStr);
        PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)orgId), (ImcPermItemEnum)ImcPermItemEnum.IMC_IMPORT);
        String suffix = filepath.substring(filepath.lastIndexOf(46));
        String errFileName = ExcelHelper.getErrorExcelFileName((String)filepath, (String)suffix);
        if (ExcelHelper.isExcelFile((String)suffix)) {
            int startRow = 2;
            int dataNum = workbook.getSheetAt(0).getLastRowNum() - startRow + 1;
            if (dataNum < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"OriginalBillItemsImportPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                return;
            }
            if (dataNum > 5000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u5f15\u51655000\u884c\u660e\u7ec6\u4fe1\u606f", (String)"OriginalBillItemsImportPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                return;
            }
            List fileFieldList = ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)TEMPLATE_JSON_NAME);
            ExcelHelper.replaceFieldName((List)fileFieldList, (String)"sim_original_bill");
            List fileFields = ExcelHelper.getFileFields((Row)workbook.getSheetAt(0).getRow(startRow - 1), (List)fileFieldList);
            Map<String, FileField> fieldMap = fileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
            ConcurrentHashMap<String, String> errMap = new ConcurrentHashMap<String, String>(dataNum >> 1);
            List list = ExcelHelper.doParse((Workbook)workbook, (List)fileFields, (int)startRow, (boolean)true, errMap);
            if (CollectionUtils.isEmpty((Collection)list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"OriginalBillItemsImportPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                return;
            }
            this.fillInData(list);
            Map<String, Object> returnMap = this.checkOriginalBill(list, fieldMap, errMap, isElePaper);
            int successSize = Integer.parseInt(returnMap.get("successSize").toString());
            LOGGER.info(String.format("OriginalBillItemsImportPlugin uploadFile successSize:%s,listSize:%s", successSize, list.size()));
            if (successSize != list.size() && errMap.size() > 0) {
                ExcelHelper.showErrorResult((Workbook)workbook, (int)list.size(), (int)successSize, errMap, (String)errFileName, (AbstractFormPlugin)this, (String)"sim_original_bill_import", (String)"sim_inv_import_result");
            } else {
                super.resetFile();
                List<Map<String, Object>> result = this.createNewList(list);
                this.getView().returnDataToParent(result);
                this.getView().close();
            }
        }
    }

    private void fillInData(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); ++i) {
            String taxAmount;
            String itemTax;
            Map<String, Object> currentRow = list.get(i);
            String itemAmount = (String)currentRow.get("amount");
            if (StringUtils.isNotBlank((CharSequence)itemAmount) && BigDecimalUtil.isNumber((String)itemAmount)) {
                String amountStr = new BigDecimal(itemAmount).setScale(2, RoundingMode.HALF_UP).toPlainString();
                currentRow.put("amount", amountStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(itemTax = (String)currentRow.get("tax"))) && BigDecimalUtil.isNumber((String)itemTax)) {
                String itemTaxStr = new BigDecimal(itemTax).setScale(2, RoundingMode.HALF_UP).toPlainString();
                currentRow.put("tax", itemTaxStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(taxAmount = (String)currentRow.get("taxamount"))) && BigDecimalUtil.isNumber((String)taxAmount)) {
                String taxAmountStr = new BigDecimal(taxAmount).setScale(2, RoundingMode.HALF_UP).toPlainString();
                currentRow.put("taxamount", taxAmountStr);
            }
            Object currentRowType = currentRow.get("rowtype");
            Object policyLogo = currentRow.get("policylogo");
            Object hsbz = currentRow.get("hsbz");
            if ("\u6298\u6263\u884c".equals(currentRowType)) {
                currentRow.put("rowtype", "1");
            } else if ("\u666e\u901a\u5546\u54c1\u884c".equals(currentRowType) || StringUtils.isBlank((Object)currentRowType)) {
                currentRow.put("rowtype", "2");
            }
            currentRowType = currentRow.get("rowtype");
            if (StringUtils.isBlank((Object)policyLogo)) {
                currentRow.put("policylogo", "");
            } else if ("\u4eab\u53d7".equals(policyLogo)) {
                currentRow.put("policylogo", "1");
            } else if ("\u4e0d\u4eab\u53d7".equals(policyLogo)) {
                currentRow.put("policylogo", "0");
            }
            if (StringUtils.isBlank((Object)hsbz) || "\u4e0d\u542b\u7a0e".equals(hsbz)) {
                currentRow.put("hsbz", "0");
            } else if ("\u542b\u7a0e".equals(hsbz)) {
                currentRow.put("hsbz", "1");
            }
            policyLogo = currentRow.get("policylogo");
            Object policyContants = currentRow.get("policycontants");
            if (!"1".equals(currentRowType)) continue;
            Object currentRowTaxRate = currentRow.get("taxrate");
            Object currentRowGoodsCode = currentRow.get("goodscode");
            if (i == 0) continue;
            Map<String, Object> lastRow = list.get(i - 1);
            Object lastRowType = lastRow.get("rowtype");
            Object discountAmount = lastRow.get("discountamount");
            Object discountRate = lastRow.get("discountrate");
            Object lastRowPolicyLogo = lastRow.get("policylogo");
            Object lastRowPolicyConstant = lastRow.get("policycontants");
            if (StringUtils.isBlank((Object)policyLogo)) {
                currentRow.put("policylogo", lastRowPolicyLogo);
            }
            if (StringUtils.isBlank((Object)policyContants)) {
                currentRow.put("policycontants", lastRowPolicyConstant);
            }
            if (!StringUtils.isBlank((Object)lastRowType) && !"2".equals(lastRowType) || !StringUtils.isBlank((Object)discountAmount) || !StringUtils.isBlank((Object)discountRate)) continue;
            if (StringUtils.isBlank((Object)currentRowTaxRate)) {
                currentRow.put("taxrate", lastRow.get("taxrate"));
            }
            if (!StringUtils.isBlank((Object)currentRowGoodsCode)) continue;
            currentRow.put("goodscode", lastRow.get("goodscode"));
        }
    }

    private List<Map<String, Object>> createNewList(List<Map<String, Object>> list) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> row = list.get(i);
            Object rowType = row.get("rowtype");
            String disCountAmount = (String)row.get("discountamount");
            String disCountRate = (String)row.get("discountrate");
            boolean isIncludeTax = "1".equals(row.get("hsbz"));
            if (StringUtils.isBlank((CharSequence)disCountAmount) && StringUtils.isNotBlank((CharSequence)disCountRate)) {
                String amount = (String)row.get("amount");
                String taxAmount = (String)row.get("taxamount");
                disCountAmount = isIncludeTax ? new BigDecimal(disCountRate).multiply(new BigDecimal(taxAmount)).setScale(2, RoundingMode.HALF_UP).toPlainString() : new BigDecimal(disCountRate).multiply(new BigDecimal(amount)).setScale(2, RoundingMode.HALF_UP).toPlainString();
            }
            row.put("discountamount", null);
            row.put("discountrate", null);
            if (isIncludeTax) {
                row.put("remainvalidamount", row.get("taxamount"));
            } else {
                row.put("remainvalidamount", row.get("amount"));
            }
            row.put("origoodsname", row.get("goodsname"));
            row.put("orispecification", row.get("specification"));
            row.put("orinum", row.get("num"));
            row.put("oritaxamount", row.get("taxamount"));
            row.put("oriunit", row.get("unit"));
            row.put("remainvalidtax", row.get("tax"));
            row.put("remainvalidnum", row.get("num"));
            result.add(row);
            if ("1".equals(row.get("rowtype"))) {
                this.clearItemData(row);
            }
            if (i + 1 < size && "2".equals(rowType) && !"1".equals(list.get(i + 1).get("rowtype")) && StringUtils.isNotBlank((CharSequence)disCountAmount)) {
                result.add(this.createNewDiscount(row, disCountAmount, isIncludeTax));
                continue;
            }
            if (i + 1 != size || !"2".equals(rowType) || !StringUtils.isNotBlank((CharSequence)disCountAmount)) continue;
            result.add(this.createNewDiscount(row, disCountAmount, isIncludeTax));
        }
        return result;
    }

    private Map<String, Object> createNewDiscount(Map<String, Object> row, String disCountAmount, boolean isIncludeTax) {
        BigDecimal discountTax;
        BigDecimal discountAmountValue;
        BigDecimal discountTaxAmountValue;
        HashMap<String, Object> discountMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            discountMap.put(entry.getKey(), entry.getValue());
        }
        String taxRate = (String)row.get("taxrate");
        discountMap.put("rowtype", "1");
        if (isIncludeTax) {
            discountTaxAmountValue = new BigDecimal(disCountAmount).negate();
            discountAmountValue = discountTaxAmountValue.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 2, RoundingMode.HALF_UP);
            discountTax = discountTaxAmountValue.subtract(discountAmountValue);
        } else {
            discountAmountValue = new BigDecimal(disCountAmount).negate();
            discountTax = new BigDecimal(taxRate).multiply(discountAmountValue).setScale(2, RoundingMode.HALF_UP);
            discountTaxAmountValue = discountAmountValue.add(discountTax);
        }
        discountMap.put("tax", discountTax.toPlainString());
        discountMap.put("amount", discountAmountValue.toPlainString());
        discountMap.put("taxamount", discountTaxAmountValue.toPlainString());
        discountMap.put("oritaxamount", discountMap.get("taxamount"));
        discountMap.put("remainvalidamount", isIncludeTax ? discountTaxAmountValue : discountAmountValue);
        discountMap.put("remainvalidtax", discountTax.toPlainString());
        discountMap.put("discountamount", null);
        discountMap.put("discountrate", null);
        this.clearItemData(discountMap);
        return discountMap;
    }

    private Map<String, Object> checkOriginalBill(List<Map<String, Object>> itemList, Map<String, FileField> fieldMap, Map<String, String> errMap, boolean isAllEle) {
        boolean isFarmSaleTaxRateCode;
        ConcurrentHashMap checkGoodsCodeMap = new ConcurrentHashMap();
        DynamicObject issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)RequestContext.get().getOrgId());
        boolean isSplit = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"));
        boolean isHint = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"));
        Object org = this.getView().getFormShowParameter().getCustomParam("orgId");
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        boolean goodsInfoSwitch = this.getGoodsInfoSwitch(orgId);
        boolean isCompletion = MaterialToGoodsInfoHelp.getCompletion((long)orgId);
        if (goodsInfoSwitch || isCompletion) {
            HashSet codeSet = Sets.newHashSet();
            HashSet nameSet = Sets.newHashSet();
            HashSet materialTypeSet = Sets.newHashSet();
            MaterialToGoodsInfoHelp.intiQuerySet((Set)codeSet, (Set)nameSet, (Set)materialTypeSet, itemList);
            Map goodsCodeMap = GoodsInfoCacheHelper.getGoodsInfoList((String)"number", (Long)RequestContext.get().getOrgId(), (Set)codeSet);
            Map goodsNameMap = GoodsInfoCacheHelper.getGoodsInfoList((String)"name", (Long)RequestContext.get().getOrgId(), (Set)nameSet);
            MaterialInfoUtil.getInstance((long)orgId, (Set)nameSet, (Set)codeSet, (Set)materialTypeSet, (boolean)false);
            if (goodsInfoSwitch) {
                this.matchingOriginalBillItems(itemList, goodsCodeMap, goodsNameMap);
            }
            if (isCompletion) {
                boolean isCompletionPolicylogo = MaterialToGoodsInfoHelp.getCompletionPolicylogo((long)orgId);
                for (Map<String, Object> detail : itemList) {
                    this.fillInGoodsInfo(detail, goodsNameMap, goodsCodeMap, true, isCompletionPolicylogo);
                    String goodsCode = (String)detail.get("spbm");
                    String goodsName = (String)detail.get("goodsname");
                    List objs = goodsCodeMap.get(goodsCode) == null ? (List)goodsNameMap.get(goodsName) : (List)goodsCodeMap.get(goodsCode);
                    DynamicObject obj = this.filterGoodsInfoByTaxRate(objs, detail);
                    if (obj == null) continue;
                    String goodsInfoTaxRate = obj.getString("taxrate");
                    String taxRate = (String)detail.get("taxrate");
                    boolean isEquals = false;
                    try {
                        BigDecimal goodsInfoTaxRateValue = new BigDecimal(goodsInfoTaxRate);
                        BigDecimal inputValue = new BigDecimal(taxRate);
                        isEquals = inputValue.compareTo(goodsInfoTaxRateValue) == 0;
                    }
                    catch (Exception goodsInfoTaxRateValue) {
                        // empty catch block
                    }
                    if (isEquals) continue;
                    Row row = (Row)detail.get("row");
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u8be5\u884c\u660e\u7ec6\u7a0e\u7387\u4e0e\u5339\u914d\u5230\u7684\u5f00\u7968\u9879\u7684\u7a0e\u7387\u4e0d\u4e00\u81f4", (String)"OriginalBillItemsImportPlugin_99", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
        }
        AtomicInteger successSize = new AtomicInteger();
        ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService();
        CountDownLatch countdownlatch = new CountDownLatch(itemList.size());
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object update_item = params.get("UPDATE_ITEM");
        boolean updateItem = "UPDATE_ITEM".equals(update_item);
        String specialType = (String)params.get("specialtype");
        RequestContext requestContext = RequestContext.get();
        TotalTaxWC totalTaxWC = new TotalTaxWC(BigDecimal.ZERO);
        boolean billFarmSaleTaxRateCode = isFarmSaleTaxRateCode = false;
        for (int i = 0; i < itemList.size(); ++i) {
            int index = i;
            Map<String, Object> item = itemList.get(i);
            if (StringUtils.isBlank((Object)item.get("policylogo"))) {
                item.put("policylogo", "0");
            }
            if (this.isChangeHSBZ && i == 0) {
                Map<String, Object> firstMap = itemList.get(index);
                this.FirstRowHSBZ = "1".equals(firstMap.get("hsbz")) ? "1" : "0";
                this.isChangeHSBZ = false;
            }
            executorService.execute(() -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                Map originalItemMap = (Map)itemList.get(index);
                Row row = (Row)originalItemMap.get("row");
                try {
                    Map<String, String> errorMsg;
                    String rowType;
                    String currentHSBZ;
                    boolean checkFlag = true;
                    boolean isItemAmountCheck = false;
                    Object itemPk = originalItemMap.get(ITEM_PK);
                    String string = currentHSBZ = "1".equals(originalItemMap.get("hsbz")) ? "1" : "0";
                    if (updateItem && StringUtils.isBlank(itemPk)) {
                        ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get(ITEM_PK)), (String)ResManager.loadKDString((String)"\u660e\u7ec6id\u4e3a\u7a7a\uff0c\u9488\u5bf9\u5df2\u7ecf\u6709\u63a8\u5230\u4e0b\u6e38\u7684\u5355\u636e\uff0c\u53ea\u80fd\u505a\u66f4\u65b0\u64cd\u4f5c\uff0c\u8bf7\u5148\u5bfc\u51fa\u660e\u7ec6\u6570\u636e\u540e\u518d\u5bfc\u5165\u660e\u7ec6\u6570\u636e", (String)"OriginalBillItemsImportPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        checkFlag = false;
                    }
                    if (!this.FirstRowHSBZ.equals(currentHSBZ)) {
                        ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("hsbz")), (String)ResManager.loadKDString((String)"\u542b\u7a0e\u6807\u5fd7\u6709\u8bef", (String)"OriginalBillItemsImportPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        checkFlag = false;
                    }
                    String goodsCode = (String)originalItemMap.get("goodscode");
                    String invoiceType = (String)params.get("invoicetype");
                    if (!this.checkRowMark(originalItemMap, fieldMap, errMap)) {
                        checkFlag = false;
                    }
                    if (goodsInfoSwitch) {
                        Object goodsName = originalItemMap.get("goodsname");
                        String mergerCode = (String)checkGoodsCodeMap.get(goodsName);
                        if (StringUtils.isBlank((CharSequence)mergerCode)) {
                            MaterialToGoodsInfoHelp.setGoodsInfoByInstitute((Map)originalItemMap, (Map)checkGoodsCodeMap);
                        } else {
                            originalItemMap.put("goodscode", mergerCode);
                        }
                    }
                    if (updateItem) {
                        if (!this.checkPk(index, itemPk, originalItemMap, fieldMap, errMap)) {
                            checkFlag = false;
                        } else if (!this.checkItemCommonSimple(originalItemMap, fieldMap, errMap, isHint, isSplit)) {
                            checkFlag = false;
                        }
                        Object pk = params.get(String.valueOf(index));
                        if (!String.valueOf(itemPk).equals(String.valueOf(pk))) {
                            ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get(ITEM_PK)), (String)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4id\u6216\u884c\u987a\u5e8f\u8c03\u6574\u6216\u5219\u884c\u65b0\u589e\u7b49\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u660e\u7ec6\u540e\u5bfc\u5165", (String)"OriginalBillItemsImportPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                            checkFlag = false;
                        }
                        if (checkFlag) {
                            successSize.getAndIncrement();
                        }
                        return;
                    }
                    if (!((Boolean)originalItemMap.get("flag")).booleanValue()) {
                        checkFlag = false;
                    }
                    if ("1".equals(rowType = (String)originalItemMap.get("rowtype"))) {
                        if (index == 0 || "1".equals(((Map)itemList.get(index - 1)).get("rowtype"))) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("rowtype")), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u4e0a\u4e00\u884c\u5fc5\u987b\u4e3a\u666e\u901a\u5546\u54c1\u884c", (String)"OriginalBillItemsImportPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        }
                        Map lastRowMap = null;
                        if (index > 0) {
                            lastRowMap = (Map)itemList.get(index - 1);
                        }
                        if (!this.checkDiscountRow(lastRowMap, originalItemMap, fieldMap, errMap)) {
                            checkFlag = false;
                        }
                        if (null != lastRowMap) {
                            String o = (String)lastRowMap.get("discountrate");
                            String disCountAmount = (String)lastRowMap.get("discountamount");
                            if (StringUtils.isNotBlank((CharSequence)o) || StringUtils.isNotBlank((CharSequence)disCountAmount)) {
                                ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("rowtype")), (String)ResManager.loadKDString((String)"\u4e0a\u4e00\u884c\u6709\u6298\u6263\u91d1\u989d\u6216\u6298\u6263\u7387\u7684\u5546\u54c1\u884c\uff0c\u5f53\u524d\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c", (String)"OriginalBillItemsImportPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                                checkFlag = false;
                            }
                        }
                    } else if (!"2".equals(rowType)) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("rowtype")), (String)ResManager.loadKDString((String)"\u884c\u6027\u8d28\u6709\u8bef", (String)"OriginalBillItemsImportPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                    }
                    if (!this.checkItemCommon(originalItemMap, fieldMap, errMap, isHint, isSplit)) {
                        checkFlag = false;
                    }
                    String currentRowType = (String)originalItemMap.get("rowtype");
                    if (index > 0 && "1".equals(currentRowType) && StringUtils.isBlank((CharSequence)goodsCode)) {
                        goodsCode = (String)((Map)itemList.get(index - 1)).get("goodscode");
                    }
                    DynamicObject taxClassCode = null;
                    if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
                        taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)goodsCode);
                    }
                    if (null == taxClassCode) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("goodscode")), (String)ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u6c47\u603b\u9879\u6216\u4e0d\u5b58\u5728", (String)"OriginalBillItemsImportPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                    } else {
                        originalItemMap.put("taxratecodeid", taxClassCode.getPkValue());
                        originalItemMap.put("goodssimplename", taxClassCode.getString("simplename"));
                        String policyContants = String.valueOf(originalItemMap.get("policycontants"));
                        String taxRate = (String)originalItemMap.get("taxrate");
                        if (ExcelHelper.isNormalTaxRate((String)taxRate)) {
                            BigDecimal policyTaxRate;
                            taxRate = ExcelHelper.getDBTaxRate((String)taxRate);
                            originalItemMap.put("taxrate", taxRate);
                            BigDecimal o = taxClassCode.getBigDecimal("taxrate");
                            String policyLogo = (String)originalItemMap.get("policylogo");
                            boolean noUsePolicy = StringUtils.isBlank((CharSequence)policyLogo) || "0".equals(policyLogo);
                            Object lastRowTaxRate = null;
                            if (index > 0) {
                                Map lastRow = (Map)itemList.get(index - 1);
                                Object lastRowType = lastRow.get("rowtype");
                                Object discountRate = lastRow.get("discountrate");
                                Object discountAmount = lastRow.get("discountamount");
                                Object lastPolicyLogo = lastRow.get("policylogo");
                                lastRowTaxRate = lastRow.get("taxrate");
                                if ("2".equals(lastRowType) && StringUtils.isBlank(discountRate) && StringUtils.isBlank(discountAmount) && "1".equals(lastPolicyLogo) && StringUtils.isBlank((CharSequence)policyLogo)) {
                                    noUsePolicy = false;
                                }
                            }
                            if ("1".equals(currentRowType) && !String.valueOf(taxRate).equals(lastRowTaxRate)) {
                                ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("taxrate")), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u7a0e\u7387\u5fc5\u987b\u548c\u4e0a\u4e00\u884c\u7a0e\u7387\u4e00\u81f4", (String)"OriginalBillItemsImportPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                                checkFlag = false;
                            }
                            if (!noUsePolicy && policyContants.contains(ReducedHelper.REDUCED_PRIVILEGE_TYPE_SPECIAL) && new BigDecimal(taxRate).compareTo(policyTaxRate = ReducedHelper.getReducedTaxRate((Object)policyContants)) != 0) {
                                ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("taxrate")), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u548c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u5339\u914d", (String)"OriginalBillItemsImportPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                                checkFlag = false;
                            }
                            originalItemMap.put("taxratecodeid", taxClassCode);
                            Map lastRowMap = null;
                            if (index > 0) {
                                lastRowMap = (Map)itemList.get(index - 1);
                            }
                            if (!this.checkTaxpremarkAndTaxRate(originalItemMap, fieldMap, errMap, lastRowMap)) {
                                checkFlag = false;
                            } else {
                                isItemAmountCheck = true;
                            }
                        } else {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("taxrate")), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u683c\u5f0f\u6709\u8bef", (String)"OriginalBillItemsImportPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        }
                    }
                    if ("E12".equals(specialType) && (errorMsg = this.checkItems(originalItemMap)).size() > 0) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get(errorMsg.get("key"))), (String)errorMsg.get("description"), (Map)errMap);
                    }
                    if (!this.checkDiscountData(originalItemMap, fieldMap, errMap)) {
                        checkFlag = false;
                    }
                    if (isItemAmountCheck && !this.checkPriceNum(originalItemMap, fieldMap, errMap, totalTaxWC, isAllEle)) {
                        checkFlag = false;
                    }
                    if (checkFlag) {
                        successSize.getAndIncrement();
                    }
                }
                catch (Exception e) {
                    ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("goodsname")), (String)String.format(ResManager.loadKDString((String)"\u8be5\u884c\u660e\u7ec6\u6821\u9a8c\u51fa\u5f02\u5e38\uff1a%s", (String)"OriginalBillItemsImportPlugin_64", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()), (Map)errMap);
                    LOGGER.error("\u660e\u7ec6\u5bfc\u5165\u51fa\u9519", (Throwable)e);
                }
                finally {
                    countdownlatch.countDown();
                }
            });
        }
        try {
            countdownlatch.await();
            executorService.shutdown();
        }
        catch (Exception e) {
            throw new KDBizException(e.toString());
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
        returnMap.put("successSize", successSize);
        return returnMap;
    }

    private Map<String, String> checkItems(Map<String, Object> originalItemMap) {
        Object policyLogo = originalItemMap.get("policylogo");
        String taxRate = (String)originalItemMap.get("taxrate");
        Object policyConstant = originalItemMap.get("policycontants");
        HashMap<String, String> result = new HashMap<String, String>();
        BigDecimal taxRateDecimalValue = BigDecimal.TEN;
        try {
            taxRateDecimalValue = new BigDecimal(taxRate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!"1".equals(policyLogo)) {
            result.put("key", "policylogo");
            result.put("description", ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u5fc5\u987b\u4e3a\uff1a\u4eab\u53d7", (String)"OriginalBillItemsImportPlugin_67", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!"\u514d\u7a0e".equals(policyConstant)) {
            result.put("key", "policycontants");
            result.put("description", ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u5fc5\u987b\u4e3a\u514d\u7a0e", (String)"OriginalBillItemsImportPlugin_68", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (taxRateDecimalValue.compareTo(BigDecimal.ZERO) != 0) {
            result.put("key", "taxrate");
            result.put("description", ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u7a0e\u7387\u5fc5\u987b\u4e3a0", (String)"OriginalBillItemsImportPlugin_69", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private void matchingOriginalBillItems(List<Map<String, Object>> itemList, Map<String, List<DynamicObject>> goodsCodeMap, Map<String, List<DynamicObject>> goodsNameMap) {
        for (Map<String, Object> detail : itemList) {
            String spbm = (String)detail.get("spbm");
            String goodsName = (String)detail.get("goodsname");
            if (this.checkGoodsInfo(detail)) {
                LOGGER.info(String.format("\u7f16\u53f7\uff1a%s\uff0c\u540d\u79f0\uff1a%s\u6570\u636e\u5df2\u5b8c\u6574\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5f00\u7968\u9879\u6620\u5c04", spbm, goodsName));
                continue;
            }
            this.fillInGoodsInfo(detail, goodsNameMap, goodsCodeMap, false, false);
            if (goodsCodeMap.containsKey(spbm) || goodsNameMap.containsKey(goodsName)) {
                LOGGER.info(String.format("\u540d\u79f0\u4f5c\u4e3a\u5f00\u7968\u9879\u5df2\u7ecf\u5339\u914d\u5b8c\u6210\uff0c\u76f4\u63a5\u8fd4\u56de code:%s name:%s", spbm, goodsName));
                continue;
            }
            MaterialToGoodsInfoHelp.matchGoodsInfoJournal(detail, (String)spbm, (String)goodsName);
        }
    }

    private boolean checkDiscountData(Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        String discountRate = (String)originalItemMap.get("discountrate");
        String discountAmount = (String)originalItemMap.get("discountamount");
        String amount = (String)originalItemMap.get("amount");
        Row row = (Row)originalItemMap.get("row");
        if (StringUtils.isNotBlank((CharSequence)discountAmount)) {
            if (!ExcelHelper.isNormalExcelDiscountAmount((String)discountAmount)) {
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("discountamount"), (String)ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u5e94\u8be5\u4e3a\u5927\u4e8e0\u7684\u6570", (String)"OriginalBillItemsImportPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)amount) && ExcelHelper.isNormalExcelDiscountAmount((String)amount)) {
                if (new BigDecimal(discountAmount).compareTo(new BigDecimal(amount)) > 0) {
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("discountamount"), (String)ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u5e94\u8be5\u5c0f\u4e8e\u7b49\u4e8e\u91d1\u989d", (String)"OriginalBillItemsImportPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    return false;
                }
                return true;
            }
        } else if (StringUtils.isNotBlank((CharSequence)discountRate)) {
            String parsedDiscountRate = ExcelHelper.parseExcelDiscountRate((String)discountRate);
            if (StringUtils.isBlank((CharSequence)parsedDiscountRate)) {
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("discountrate"), (String)ResManager.loadKDString((String)"\u6298\u6263\u7387\u6709\u8bef", (String)"OriginalBillItemsImportPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                return false;
            }
            originalItemMap.put("discountrate", parsedDiscountRate);
        }
        return true;
    }

    private boolean checkRowMark(Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        Row row = (Row)originalItemMap.get("row");
        String remark = (String)originalItemMap.get("remark");
        if (GBKUtils.getGBKLength((String)String.valueOf(remark)) > 100) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("remark"), (String)ResManager.loadKDString((String)"\u884c\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", (String)"OriginalBillItemsImportPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        return true;
    }

    private boolean checkPk(int i, Object itempK, Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Row row = (Row)originalItemMap.get("row");
        if (null == params) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get(ITEM_PK), (String)ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u4f20\u5165\u660e\u7ec6\u884cid", (String)"OriginalBillItemsImportPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        Object parentItemPk = params.get(String.valueOf(i));
        if (!String.valueOf(parentItemPk).equals(itempK)) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get(ITEM_PK), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u884cid\u4e0d\u7b26,\u8bf7\u5148\u5bfc\u51fa\u8986\u76d6\u5546\u54c1\u660e\u7ec6\u6a21\u7248\u518d\u5bfc\u5165", (String)"OriginalBillItemsImportPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        return true;
    }

    private boolean checkDiscountRow(Map<String, Object> lastRowMap, Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        BigDecimal lastRowNum;
        Row row = (Row)originalItemMap.get("row");
        if (null == lastRowMap) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u4e0a\u4e00\u884c\u5fc5\u987b\u4e3a\u666e\u901a\u5546\u54c1\u884c", (String)"OriginalBillItemsImportPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        String amountStr = (String)originalItemMap.get("amount");
        BigDecimal amount = new BigDecimal(amountStr);
        String lastRowAmountStr = (String)lastRowMap.get("amount");
        if (StringUtils.isBlank((CharSequence)lastRowAmountStr)) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u4e0a\u4e00\u884c\u91d1\u989d\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        BigDecimal lastRowAmount = new BigDecimal(lastRowAmountStr);
        String lastRowNumStr = (String)lastRowMap.get("num");
        Row lastRow = (Row)originalItemMap.get("row");
        if (BigDecimal.ZERO.compareTo(amount) < 0) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u91d1\u989d\u5fc5\u987b\u4e3a\u8d1f\u6570", (String)"OriginalBillItemsImportPlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        if (BigDecimal.ZERO.compareTo(lastRowAmount) > 0) {
            ExcelHelper.setErrorMessage((Row)lastRow, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u4e0a\u4e00\u884c\u7684\u91d1\u989d\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"OriginalBillItemsImportPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        if (amount.abs().compareTo(lastRowAmount) >= 0) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u91d1\u989d\u7edd\u5bf9\u503c\u5fc5\u987b\u5c0f\u4e8e\u4e0a\u4e00\u884c\u7684\u91d1\u989d", (String)"OriginalBillItemsImportPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)lastRowNumStr) && BigDecimal.ZERO.compareTo(lastRowNum = new BigDecimal(lastRowNumStr)) > 0) {
            ExcelHelper.setErrorMessage((Row)lastRow, (FileField)fieldMap.get("num"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u4e0a\u4e00\u884c\u5982\u679c\u5b58\u5728\u6570\u91cf\u5219\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"OriginalBillItemsImportPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        return true;
    }

    private boolean checkPriceNum(Map<String, Object> item, Map<String, FileField> fieldMap, Map<String, String> errMap, TotalTaxWC totalTaxWC, boolean isAllEle) {
        boolean flag = true;
        Row row = (Row)item.get("row");
        String hsbz = (String)item.get("hsbz");
        if (!"1".equals(hsbz) && !"0".equals(hsbz)) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("hsbz"), (String)ResManager.loadKDString((String)"\u542b\u7a0e\u6807\u5fd7\u4f20\u5165\u6709\u8bef", (String)"OriginalBillItemsImportPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        String unitPrice = (String)item.get("unitprice");
        if (!BigDecimalUtil.isNumber((String)unitPrice)) {
            unitPrice = "";
            item.put("unitprice", "");
        } else if (unitPrice.replace("-", "").length() > 16) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)ResManager.loadKDString((String)"\u5355\u4ef7\uff08\u5305\u542b\u5c0f\u6570\u70b9\uff09\u6700\u591a16\u4f4d\u6570", (String)"OriginalBillItemsImportPlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else {
            try {
                unitPrice = PriceHelper.getStrValue((String)unitPrice, (String)"\u5355\u4ef7", (boolean)true);
            }
            catch (KDBizException e) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)e.getMessage(), errMap);
            }
        }
        String num = (String)item.get("num");
        if (!BigDecimalUtil.isNumber((String)num)) {
            num = "";
            item.put("num", "");
        } else if (num.length() > 16) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)ResManager.loadKDString((String)"\u6570\u91cf\uff08\u5305\u542b\u5c0f\u6570\u70b9\uff09\u6700\u591a16\u4f4d\u6570", (String)"OriginalBillItemsImportPlugin_36", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else {
            try {
                num = UnitPriceHelper.getNumStrValue((String)num, (String)"\u6570\u91cf");
            }
            catch (KDBizException e) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)e.getMessage(), errMap);
            }
        }
        String amount = (String)item.get("amount");
        String deduction = (String)item.get("deduction");
        String taxRate = (String)item.get("taxrate");
        String tax = (String)item.get("tax");
        if (StringUtils.isBlank((CharSequence)taxRate)) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else if (StringUtils.isNotBlank((CharSequence)amount)) {
            if (StringUtils.isBlank((CharSequence)tax)) {
                tax = this.calcTax(taxRate, hsbz, amount, deduction).toPlainString();
                item.put("tax", tax);
            } else {
                BigDecimal calcTax = "0.015".equals(taxRate) ? ("0".equals(hsbz) ? ReducedHelper.calcTaxWithoutTax((Object)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (BigDecimal)new BigDecimal(amount)) : ReducedHelper.calcTaxWithTax((Object)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (BigDecimal)new BigDecimal(amount))) : this.calcTax(taxRate, "0", "0".equals(hsbz) ? amount : new BigDecimal(amount).subtract(new BigDecimal(tax)).toString(), deduction);
                BigDecimal wc = calcTax.subtract(new BigDecimal(tax)).abs();
                totalTaxWC.setWc(totalTaxWC.getWc().add(wc));
                if (wc.compareTo(InvoiceConstant.DIFFF_06) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u91d1\u989d\u4e58\u4ee5\u7a0e\u7387\u4e0e\u7a0e\u989d\u7684\u8bef\u5dee\u8d85\u8fc7\u9650\u52360.06", (String)"OriginalBillItemsImportPlugin_39", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
                if (totalTaxWC.getWc().compareTo(InvoiceConstant.DIFF_127) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u6240\u6709\u660e\u7ec6\u7684\u7a0e\u989d\u8ba1\u7b97\u8bef\u5dee\u8d85\u8fc71.27", (String)"OriginalBillItemsImportPlugin_40", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
        }
        item.put("oriunitprice", unitPrice);
        if (flag && StringUtils.isNotBlank((CharSequence)amount)) {
            if (StringUtils.isNotBlank((CharSequence)unitPrice) && StringUtils.isNotBlank((CharSequence)num)) {
                BigDecimal calcAmount = new BigDecimal(unitPrice).multiply(new BigDecimal(num));
                if (calcAmount.subtract(new BigDecimal(amount)).abs().compareTo(InvoiceConstant.DIFF_01) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u5355\u4ef7\u6570\u91cf\u91d1\u989d\u8bef\u5dee\u5927\u4e8e0.01", (String)"OriginalBillItemsImportPlugin_41", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                } else {
                    this.fillInPrice(amount, tax, hsbz, num, unitPrice, item, isAllEle);
                }
            } else if (StringUtils.isNotBlank((CharSequence)unitPrice) && StringUtils.isBlank((CharSequence)num)) {
                try {
                    num = UnitPriceHelper.calcNum((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal(unitPrice)).toPlainString();
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)e.getMessage(), errMap);
                }
                item.put("num", num);
                this.fillInPrice(amount, tax, hsbz, num, unitPrice, item, isAllEle);
            } else if (StringUtils.isBlank((CharSequence)unitPrice) && StringUtils.isNotBlank((CharSequence)num)) {
                try {
                    unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal(num), (boolean)true).toPlainString();
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)e.getMessage(), errMap);
                }
                this.fillInPrice(amount, tax, hsbz, num, unitPrice, item, isAllEle);
                item.put("oriunitprice", "0".equals(hsbz) ? item.get("unitprice") : item.get("taxunitprice"));
            } else if (StringUtils.isNotBlank((CharSequence)amount) && StringUtils.isNotBlank((CharSequence)tax)) {
                String taxAmount = "0".equals(hsbz) ? new BigDecimal(amount).add(new BigDecimal(tax)).setScale(2, 4).toPlainString() : amount;
                amount = "1".equals(hsbz) ? new BigDecimal(amount).subtract(new BigDecimal(tax)).setScale(2, 4).toPlainString() : amount;
                item.put("taxamount", taxAmount);
                item.put("amount", amount);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)unitPrice) && new BigDecimal(unitPrice).compareTo(BigDecimal.ZERO) < 0) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"OriginalBillItemsImportPlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        return flag;
    }

    private BigDecimal calcTax(String taxRateStr, String hsbz, String amountStr, String deductionStr) {
        BigDecimal taxRate = new BigDecimal(taxRateStr);
        BigDecimal amount = new BigDecimal(amountStr).subtract(StringUtils.isBlank((CharSequence)deductionStr) ? BigDecimal.ZERO : new BigDecimal(deductionStr));
        BigDecimal tax = "0".equals(hsbz) ? amount.multiply(taxRate).divide("0.015".equals(taxRateStr) ? new BigDecimal("1.035") : BigDecimal.ONE, 2, 4) : amount.multiply(taxRate).divide(BigDecimal.ONE.add("0.015".equals(taxRateStr) ? new BigDecimal("0.05") : taxRate), 2, 4);
        return tax;
    }

    private void fillInPrice(String amountStr, String tax, String hsbz, String num, String unitPrice, Map<String, Object> item, boolean isAllEle) {
        if ("0".equals(hsbz)) {
            BigDecimal taxAmount = new BigDecimal(amountStr).add(new BigDecimal(tax)).setScale(2, RoundingMode.HALF_UP);
            item.put("taxamount", taxAmount.toPlainString());
            item.put("amount", amountStr);
            item.put("unitprice", unitPrice);
            if (StringUtils.isNotBlank((CharSequence)unitPrice)) {
                item.put("taxunitprice", PriceHelper.getValue((BigDecimal)taxAmount.divide(new BigDecimal(amountStr), 20, RoundingMode.HALF_UP).multiply(new BigDecimal(unitPrice)), (String)"\u542b\u7a0e\u5355\u4ef7", (boolean)isAllEle));
            }
        } else {
            BigDecimal amount = new BigDecimal(amountStr).subtract(new BigDecimal(tax)).setScale(2, RoundingMode.HALF_UP);
            item.put("taxamount", amountStr);
            item.put("amount", amount.toPlainString());
            item.put("taxunitprice", unitPrice);
            if (StringUtils.isNotBlank((CharSequence)unitPrice)) {
                item.put("unitprice", PriceHelper.getValue((BigDecimal)amount.divide(new BigDecimal(amountStr), 20, RoundingMode.HALF_UP).multiply(new BigDecimal(unitPrice)), (String)"\u5355\u4ef7", (boolean)isAllEle).toPlainString());
            }
        }
    }

    private boolean checkTaxpremarkAndTaxRate(Map<String, Object> itemMap, Map<String, FileField> fieldMap, Map<String, String> errMap, Map<String, Object> lastRowMap) {
        boolean flag = true;
        Row row = (Row)itemMap.get("row");
        String taxRate = (String)itemMap.get("taxrate");
        String rowtype = (String)itemMap.get("rowtype");
        String invoiceType = (String)itemMap.get("invoicetype");
        String zzstsgl = (String)itemMap.get("policycontants");
        String taxpremark = (String)itemMap.get("policylogo");
        if (null != lastRowMap && "1".equals(rowtype)) {
            Object lastTaxpremark = lastRowMap.get("policylogo");
            Object lastPolicyConstants = lastRowMap.get("policycontants");
            if (!String.valueOf(lastTaxpremark).equals(taxpremark)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policylogo"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u548c\u88ab\u6298\u6263\u884c\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u4e0d\u4e00\u81f4", (String)"OriginalBillItemsImportPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (!String.valueOf(lastPolicyConstants).equals(zzstsgl)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u548c\u88ab\u6298\u6263\u884c\u4f18\u60e0\u653f\u7b56\u4e0d\u4e00\u81f4", (String)"OriginalBillItemsImportPlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        taxpremark = (String)itemMap.get("policylogo");
        if (StringUtils.isBlank((CharSequence)taxRate)) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) == 0) {
            if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"0\u7a0e\u7387\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"OriginalBillItemsImportPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if ("0".equals(taxpremark)) {
                zzstsgl = "\u666e\u901a\u96f6\u7a0e\u7387";
                itemMap.put("policycontants", "\u666e\u901a\u96f6\u7a0e\u7387");
            } else if (!("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u51fa\u53e3\u9000\u7a0e".equals(zzstsgl))) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u7387\u4e3a\u96f6, \u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u4e3a[\u51fa\u53e3\u9000\u7a0e\uff0c\u514d\u7a0e\uff0c\u4e0d\u5f81\u7a0e]\u4e2d\u7684\u4e00\u79cd", (String)"OriginalBillItemsImportPlugin_52", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        } else if ("1".equals(taxpremark) && ("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u51fa\u53e3\u9000\u7a0e".equals(zzstsgl))) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5", (String)"OriginalBillItemsImportPlugin_53", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if ("1".equals(taxpremark)) {
            if (StringUtils.isBlank((CharSequence)zzstsgl)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_54", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)taxRate) || BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) != 0) {
                itemMap.put("policycontants", "");
                itemMap.put("policylogo", "0");
            }
            if (StringUtils.isNotBlank((Object)itemMap.get("policycontants")) && !"\u666e\u901a\u96f6\u7a0e\u7387".equals(itemMap.get("policycontants"))) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u4e0d\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        return flag;
    }

    private boolean checkItemCommonSimple(Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap, boolean isHint, boolean isSplit) {
        String specification;
        boolean flag = true;
        Row row = (Row)originalItemMap.get("row");
        String unit = (String)originalItemMap.get("unit");
        if (StringUtils.isBlank((CharSequence)unit)) {
            if (GBKUtils.getGBKLength((String)unit) > 22 && isSplit) {
                originalItemMap.put("unit", GBKUtils.cutGBKString((String)unit, (int)22));
            } else if (GBKUtils.getGBKLength((String)unit) > 22 && isHint) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unit"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getMsg(), errMap);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(specification = (String)originalItemMap.get("specification")))) {
            if (GBKUtils.getGBKLength((String)specification) > 40 && isSplit) {
                originalItemMap.put("specification", GBKUtils.cutGBKString((String)specification, (int)40));
            } else if (GBKUtils.getGBKLength((String)specification) > 40 && isHint) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("specification"), (String)ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getMsg(), errMap);
            }
        }
        return flag;
    }

    private boolean checkItemCommon(Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap, boolean isHint, boolean isSplit) {
        String simpleName;
        String specification;
        String unit;
        boolean flag = true;
        Row row = (Row)originalItemMap.get("row");
        String goodsName = (String)originalItemMap.get("goodsname");
        if (StringUtils.isBlank((CharSequence)goodsName)) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodsname"), (String)ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_56", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (StringUtils.isBlank((CharSequence)(unit = (String)originalItemMap.get("unit")))) {
            if (GBKUtils.getGBKLength((String)unit) > 22 && isSplit) {
                originalItemMap.put("unit", GBKUtils.cutGBKString((String)unit, (int)22));
            } else if (GBKUtils.getGBKLength((String)unit) > 22 && isHint) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unit"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getMsg(), errMap);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(specification = (String)originalItemMap.get("specification")))) {
            if (GBKUtils.getGBKLength((String)specification) > 40 && isSplit) {
                originalItemMap.put("specification", GBKUtils.cutGBKString((String)specification, (int)40));
            } else if (GBKUtils.getGBKLength((String)specification) > 40 && isHint) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("specification"), (String)ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getMsg(), errMap);
            }
        }
        if (((simpleName = "*" + originalItemMap.get("goodssimplename") + "*") + goodsName).length() > 100 && isSplit) {
            originalItemMap.put("goodsname", StringUtils.substring((String)(simpleName + goodsName), (int)0, (int)100).replace(simpleName, ""));
        } else if (goodsName.length() > 100 && isSplit) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodsname"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODNAMELENGTH.getMsg(), errMap);
        }
        return flag;
    }

    private void clearItemData(Map<String, Object> item) {
        item.put("specification", null);
        item.put("unit", null);
        item.put("num", null);
        item.put("unitprice", null);
        item.put("oriunit", null);
        item.put("oriunitprice", null);
        item.put("orinum", null);
        item.put("orispecification", null);
        item.put("taxunitprice", null);
        item.put("remark", null);
        item.put("remainvalidnum", null);
        item.put("discountamount", null);
        item.put("discountrate", null);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_download_template": {
                this.downloadTemplate();
                break;
            }
            case "btn_reset_file": {
                this.resetFile();
                break;
            }
            case "btn_upload": {
                try {
                    this.excelUpload();
                }
                catch (Exception e) {
                    if (String.valueOf(e.getMessage()).contains("OLE2")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u5bfc\u5165", (String)"OriginalBillItemsImportPlugin_57", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    LOGGER.error("originalBillItemsImport:" + e.getMessage(), (Throwable)e);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"OriginalBillItemsImportPlugin_65", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
                break;
            }
            case "btn_cancel": {
                this.resetFile();
                break;
            }
            case "btn_data_export": {
                try {
                    Map params = this.getView().getFormShowParameter().getCustomParams();
                    this.exportData(params);
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("originalBillItemsExportFail:" + e.getMessage(), (Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a%s", (String)"OriginalBillItemsImportPlugin_66", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
    }

    public void exportData(Map<String, Object> params) throws IOException {
        if (null == params || StringUtils.isBlank((Object)params.get("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u7968\u7533\u8bf7\u5355\u672a\u4fdd\u5b58\uff0c\u4e0d\u53ef\u5bfc\u51fa\u660e\u7ec6\u8fdb\u884c\u66f4\u65b0\uff0c\u5982\u9700\u5bfc\u51fa\u660e\u7ec6\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58", (String)"OriginalBillItemsImportPlugin_60", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        boolean isUpdateItem = StringUtils.isNotBlank((Object)params.get("UPDATE_ITEM"));
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)params.get("id"), (String)"sim_original_bill");
        DynamicObjectCollection collection = bill.getDynamicObjectCollection("sim_original_bill_item");
        try (InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("excel_templates/\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx");){
            if (inStream == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5bfc\u51fa\u6a21\u677f\u4e3a\u7a7a", (String)"OriginalBillItemsImportPlugin_62", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            XSSFWorkbook wb = new XSSFWorkbook(inStream);
            SXSSFWorkbook workBook = new SXSSFWorkbook(wb);
            SXSSFSheet sheet0 = workBook.getSheetAt(0);
            String hsbz = bill.getString("hsbz");
            boolean isIncludeTax = "1".equals(hsbz);
            String hsbzDescription = isIncludeTax ? "\u542b\u7a0e" : "\u4e0d\u542b\u7a0e";
            int seq = 2;
            for (DynamicObject item : collection) {
                SXSSFRow row1 = sheet0.createRow(seq++);
                Object rowType = item.get("rowtype");
                int i = 0;
                row1.createCell(i).setCellValue(hsbzDescription);
                row1.createCell(i + 1).setCellValue(this.getRowType(rowType));
                row1.createCell(i + 2).setCellValue(item.getString("goodsname"));
                row1.createCell(i + 3).setCellValue(item.getString("spbm"));
                row1.createCell(i + 4).setCellValue(item.getString("specification"));
                row1.createCell(i + 5).setCellValue(item.getString("unit"));
                BigDecimal unitPrice = item.getBigDecimal("unitprice");
                BigDecimal taxUnitPrice = item.getBigDecimal("taxunitprice");
                unitPrice = isIncludeTax ? taxUnitPrice : unitPrice;
                unitPrice = PriceHelper.getValue((BigDecimal)unitPrice, (String)"\u5355\u4ef7", (boolean)true);
                row1.createCell(i + 6).setCellValue(BigDecimal.ZERO.compareTo(unitPrice) == 0 ? null : unitPrice.toPlainString());
                BigDecimal num = item.getBigDecimal("num");
                num = UnitPriceHelper.getNumValue((BigDecimal)num, (String)"\u6570\u91cf");
                row1.createCell(i + 7).setCellValue(BigDecimal.ZERO.compareTo(num) == 0 ? null : num.toPlainString());
                BigDecimal writeAmount = isIncludeTax ? item.getBigDecimal("taxamount") : item.getBigDecimal("amount");
                writeAmount = writeAmount.setScale(2, RoundingMode.HALF_UP);
                row1.createCell(i + 8).setCellValue(writeAmount.toPlainString());
                row1.createCell(i + 9).setCellValue(item.getString("taxrate"));
                row1.createCell(i + 10).setCellValue(item.getBigDecimal("tax").setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
                row1.createCell(i + 13).setCellValue(item.getString("goodscode"));
                if (!"1".equals(rowType)) {
                    row1.createCell(i + 14).setCellValue(this.getPolicyLogo(item.getString("policylogo")));
                    row1.createCell(i + 15).setCellValue(item.getString("policycontants"));
                    row1.createCell(i + 16).setCellValue(item.getString("remark"));
                }
                row1.createCell(i + 17).setCellValue(item.getString("extrafield"));
                row1.createCell(i + 18).setCellValue(item.getString("extrafield2"));
                row1.createCell(i + 19).setCellValue(item.getString("extrafield3"));
                row1.createCell(i + 20).setCellValue(item.getString("extrafield4"));
                row1.createCell(i + 21).setCellValue(item.getString("extrafield5"));
                if (!isUpdateItem) continue;
                row1.createCell(i + 22).setCellValue(item.getPkValue().toString());
            }
            this.flushFileIO(workBook);
        }
    }

    private String getPolicyLogo(Object plicyLogo) {
        if ("1".equals(plicyLogo)) {
            return "\u4eab\u53d7";
        }
        return "\u4e0d\u542b\u7a0e";
    }

    private String getRowType(Object rowType) {
        if ("1".equals(rowType)) {
            return "\u6298\u6263\u884c";
        }
        return "\u666e\u901a\u5546\u54c1\u884c";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFileIO(SXSSFWorkbook wb) {
        ByteArrayInputStream bais = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            wb.write((OutputStream)byteArrayOutputStream);
            bais = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6.xlsx", (InputStream)bais, 5000);
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u53d1\u7968\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u5bfc\u51fa\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6 IO close \u5931\u8d25", (Throwable)e);
                }
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25");
                }
            }
        }
    }

    protected void downloadTemplate() {
        this.downloadTemplate(TEMPLATE_DIR, "\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx", TEMPLATE_JSON_NAME);
    }
}

