/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EasBusinessHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillHelper;

public class InvoiceOriginalBillClosePlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        BigDecimal redRemainAmount;
        String invoiceStatus;
        DynamicObject[] invoices;
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length >= 20) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u4e00\u6b21\u5355\u636e\u4e0d\u80fd\u8d85\u8fc720\u6761", (String)"InvoiceOriginalBillPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        JSONArray array = new JSONArray();
        for (DynamicObject obj : dataEntities) {
            array.add((Object)obj.getString("billno"));
        }
        ArrayList<Object> redSpecialPks = new ArrayList<Object>();
        ArrayList<Object> otherPks = new ArrayList<Object>();
        ArrayList<Object> redConfirmPks = new ArrayList<Object>();
        HashSet<Object> orgSet = new HashSet<Object>();
        HashSet<String> systemSourceSet = new HashSet<String>();
        List easSystems = CallbackHelperUtil.getEasSystemSource();
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>();
        for (DynamicObject originalBill : dataEntities) {
            String systemSource;
            String issueType;
            bills.add(originalBill);
            String invoiceType = originalBill.getString("invoicetype");
            orgSet.add(originalBill.getDynamicObject("orgid").getPkValue());
            String string = issueType = "1".equals(originalBill.getString("billproperties")) ? IssueType.BLUE_INVOICE.getTypeCode() : IssueType.RED_INVOICE.getTypeCode();
            if ("1".equals(originalBill.getString("billcomplete"))) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u6765\u6e90\u4e8e\u5e94\u6536\u5355\u4e0d\u542b\u660e\u7ec6\u4e0b\u63a8\u4e0d\u652f\u6301\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalBillPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), originalBill.getString("billno")));
            }
            if (InvoiceUtils.isRedInfoInvoice((String)issueType, (String)invoiceType)) {
                redSpecialPks.add(originalBill.getPkValue());
            } else if (InvoiceUtils.isRedConfirmInvoice((String)issueType, (String)invoiceType)) {
                redConfirmPks.add(originalBill.getPkValue());
            } else {
                otherPks.add(originalBill.getPkValue());
            }
            if ("1".equals(originalBill.getString("closestatus"))) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u5df2\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceOriginalBillPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), originalBill.getString("billno")));
            }
            if (!BotpHelper.isFromAr((Object)(systemSource = originalBill.getString("systemsource"))) && !easSystems.contains(systemSource)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u975e\u5e94\u6536\u6216\u8005EAS\u6765\u6e90\u7684\u5355\u636e\u4e0d\u80fd\u5173\u95ed", (String)"InvoiceOriginalBillPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            systemSourceSet.add(originalBill.getString("systemsource"));
            if (orgSet.size() > 1) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u4e1a\u52a1\u5355\u5143\u7684\u6570\u636e\u8fdb\u884c\u5173\u95ed", (String)"InvoiceOriginalBillPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (systemSourceSet.size() <= 1) continue;
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u4e1a\u52a1\u5355\u5143\u7684\u6570\u636e\u8fdb\u884c\u5173\u95ed", (String)"InvoiceOriginalBillPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        try {
            BillHelper.checkRelation(redSpecialPks, otherPks, redConfirmPks);
        }
        catch (KDBizException kde) {
            e.setCancel(true);
            e.setCancelMessage(kde.getMessage());
        }
        if (easSystems.contains(systemSourceSet.iterator().next())) {
            for (DynamicObject invoice : invoices = RelationHelper.loadInvoiceByBills((DynamicObject[])bills.toArray(new DynamicObject[0]))) {
                invoiceStatus = invoice.getString("invoicestatus");
                if ("6".equals(invoiceStatus) || BigDecimal.ZERO.compareTo(redRemainAmount = invoice.getBigDecimal("remainredamount")) == 0) continue;
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u53d1\u7968\u672a\u88ab\u7ea2\u51b2\u6216\u8005\u4f5c\u5e9f\u7684\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5", (String)"InvoiceOriginalBillPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        if (easSystems.contains(systemSourceSet.iterator().next())) {
            for (DynamicObject invoice : invoices = RelationHelper.loadInvoiceByBills((DynamicObject[])dataEntities)) {
                invoiceStatus = invoice.getString("invoicestatus");
                if ("6".equals(invoiceStatus) || BigDecimal.ZERO.compareTo(redRemainAmount = invoice.getBigDecimal("remainredamount")) == 0) continue;
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u53d1\u7968\u672a\u88ab\u7ea2\u51b2\u6216\u8005\u4f5c\u5e9f\u7684\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5", (String)"InvoiceOriginalBillPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            DynamicObject accessConfigObj = CallbackHelperUtil.getAccessConfig((String)((String)systemSourceSet.iterator().next()));
            if (null == accessConfigObj) {
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5728[\u53d1\u7968\u4e91]-[\u7cfb\u7edf\u7ba1\u7406]-[\u4e1a\u52a1\u7cfb\u7edf]\u914d\u7f6e\u597d\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]", (String)"InvoiceOriginalBillCallBack_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), systemSourceSet.iterator().next()));
                return;
            }
        }
        try (DLock lock = DLock.create((String)"closestatus");){
            if (lock.tryLock(10L)) {
                for (Object o : array) {
                    String s = CacheHelper.get((String)("closestatus" + o));
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u6b63\u5728\u88ab\u5173\u95ed\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"InvoiceOriginalBillPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), s));
                }
                for (Object o : array) {
                    CacheHelper.put((String)("closestatus" + o), (String)((String)o), (int)60);
                }
            } else {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"InvoiceOriginalBillPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_original_bill", (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        JSONArray array = new JSONArray();
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            array.add((Object)obj.getString("billno"));
        }
        ArrayList billNos = new ArrayList(array);
        try {
            for (Object o2 : array) {
                CacheHelper.put((String)("closestatus" + o2), (String)((String)o2), (int)600);
            }
            List easSystems = CallbackHelperUtil.getEasSystemSource();
            if (easSystems.contains(dataEntities[0].getString("systemsource"))) {
                String systemSource = (String)easSystems.get(0);
                String param = EasBusinessHelper.getEasRequestData((String)JSONObject.toJSONString(billNos), (String)"closeEASBills");
                QFilter systemSourceFilter = new QFilter("business_system_code", "=", (Object)systemSource);
                DynamicObject callBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_callback_config"), (QFilter[])systemSourceFilter.toArray());
                String result = CallbackHelperUtil.postEas((DynamicObject)callBackConfig, (String)param, (String)systemSource);
                if (StringUtils.isEmpty((CharSequence)result)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f[eas\u5355\u636e\u5173\u95ed\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a]", (String)"InvoiceOriginalBillCallBack_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                JSONObject jsonObject = JSON.parseObject((String)result);
                if (!ApiErrCodeEnum.OK.getCode().equals(jsonObject.getString("errCode"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25 %s", (String)"InvoiceOriginalBillCallBack_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), jsonObject.getString("description")));
                }
                EasBusinessHelper.handleEasResponse((JSONObject)jsonObject);
                if (ApiErrCodeEnum.OK.getCode().equals(jsonObject.getString("errorCode"))) {
                    Arrays.stream(dataEntities).forEach(o -> o.set("closestatus", (Object)"1"));
                    SaveServiceHelper.update((DynamicObject[])dataEntities);
                    return;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f[eas\u5355\u636e\u5173\u95ed\u5931\u8d25]%s", (String)"InvoiceOriginalBillCallBack_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), jsonObject.getString("message")));
            }
            List billPks = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])billPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            BotpHelper.closeBills((DynamicObject[])dynamicObjects);
        }
        finally {
            for (Object o3 : array) {
                CacheHelper.remove((String)("closestatus" + o3));
            }
        }
    }
}

