/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.formplugin.bill.originalbill.op.AbstractOriginalBillSavePlugin;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;

public class InvoiceOriginalBillRedSavePlugin
extends AbstractOriginalBillSavePlugin {
    private static final Log LOG = LogFactory.getLog(InvoiceOriginalBillRedSavePlugin.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] arr = e.getDataEntities();
        if (arr != null && arr.length > 0) {
            String sizeLimit = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_ORIGINAL_BILL_SAVE_LIMIT);
            if (arr.length > Integer.parseInt(sizeLimit)) {
                e.setCancel(true);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58\u7533\u8bf7\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a", (String)"InvoiceOriginalBillSavePlugin_82", (String)"imc-sim-formplugin", (Object[])new Object[]{sizeLimit}), sizeLimit));
            }
            for (DynamicObject originBillDynamicObject : arr) {
                ApiResult normalInfoResult;
                boolean isEle;
                if (BotpHelper.isBillNotComplete((Object)originBillDynamicObject.getString("billcomplete"))) continue;
                BotpHelper.dealPushArFields((DynamicObject[])new DynamicObject[]{originBillDynamicObject});
                InvoiceOriginalBillRedSavePlugin.checkNormalRedBlueInvoiceSurplusAmount(originBillDynamicObject);
                InvoiceOriginalBillRedSavePlugin.billSavePluginCheckRed(originBillDynamicObject);
                boolean bl = isEle = InvoiceUtils.isAllEInvoice((Object)originBillDynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)originBillDynamicObject.getString("iselepaper"));
                if (StringUtils.isNotBlank((Object)originBillDynamicObject.get("applicant")) && !isEle) {
                    OriginalBillFormEditUtil.checkBillRedInfoDO((DynamicObject)originBillDynamicObject);
                }
                OriginalBillFormEditUtil.checkBillRedConfirmBillDO((DynamicObject)originBillDynamicObject);
                RedInfoHelper.checkRedInfo((String)originBillDynamicObject.getString("infocode"), (DynamicObject)originBillDynamicObject);
                BillVo bill = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)originBillDynamicObject);
                if (null == bill || (normalInfoResult = BillValidaterHelper.checkRedNormalInfo((BillVo)bill)) == null || normalInfoResult.getErrorCode().equals(ApiErrCodeEnum.OK.getCode())) continue;
                LOG.info("InvoiceOriginalBillRedSavePlugin setCancel");
                throw new KDBizException(normalInfoResult.getMessage());
            }
        }
    }
}

