/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.op.AbstractOriginalBillSavePlugin;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class InvoiceOriginalBillSavePlugin
extends AbstractOriginalBillSavePlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOG = LogFactory.getLog(InvoiceOriginalBillSavePlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                DynamicObjectCollection items;
                if (StringUtils.isBlank((CharSequence)obj.getString("billno")) && OriginalBillConstant.isSpecialSourcType((Object)obj.getString("billsourcetype"))) {
                    obj.set("billno", (Object)("INV_" + UUID.getBatchNumber()));
                }
                obj.set("itemcount", (Object)obj.getDynamicObjectCollection("sim_original_bill_item").size());
                InvoiceOriginalBillSavePlugin.setBillTaxRate(obj);
                if (!TaxedTypeEnum.all_e_deduction.getValue().equals(obj.getString("taxationstyle"))) {
                    items = obj.getDynamicObjectCollection("deductions");
                    items.clear();
                }
                if (TaxedTypeEnum.all_e_deduction.getValue().equals(obj.getString("taxationstyle")) && (obj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 || "-1".equals(obj.getString("billproperties")))) {
                    items = obj.getDynamicObjectCollection("deductions");
                    items.clear();
                }
                if (!"E04".equals(obj.getString("specialtype"))) {
                    items = obj.getDynamicObjectCollection("freights");
                    items.clear();
                }
                if (!"E09".equals(obj.getString("specialtype"))) {
                    items = obj.getDynamicObjectCollection("travelers");
                    items.clear();
                }
                if ("E05".equals(obj.getString("specialtype")) || "E06".equals(obj.getString("specialtype"))) {
                    if ("1".equals(obj.getString("billproperties"))) {
                        int size = 0;
                        for (DynamicObject dynamicObject : obj.getDynamicObjectCollection("sim_original_bill_item")) {
                            if (dynamicObject.getInt("rowtype") == 1) continue;
                            ++size;
                        }
                        int estateSize = obj.getDynamicObjectCollection("estatesales").size();
                        if (estateSize == 0 && "E06".equals(obj.getString("specialtype"))) {
                            estateSize = 1;
                        }
                        if ("E05".equals(obj.getString("specialtype"))) {
                            String msg;
                            if (obj.getBoolean("cobuyerflag") && StringUtils.isNotBlank((CharSequence)(msg = InvoiceOriginalBillSavePlugin.checkCoBuyer((DynamicObjectCollection)obj.get("cobuyers"))))) {
                                throw new KDBizException(msg);
                            }
                        } else if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)obj, (String)"cobuyers")) {
                            InvoiceOriginalBillSavePlugin.clearCollection(obj.getDynamicObjectCollection("cobuyers"));
                        }
                    }
                } else {
                    if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)obj, (String)"estatesales")) {
                        InvoiceOriginalBillSavePlugin.clearCollection(obj.getDynamicObjectCollection("estatesales"));
                    }
                    if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)obj, (String)"cobuyers")) {
                        InvoiceOriginalBillSavePlugin.clearCollection(obj.getDynamicObjectCollection("cobuyers"));
                    }
                }
                if ("E07".equals(obj.getString("specialtype"))) continue;
                DynamicObjectCollection itemObjectCollection = obj.getDynamicObjectCollection("vehichevesselships");
                itemObjectCollection.clear();
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] arr = e.getDataEntities();
        HashMap billStatusMap = null;
        if (arr != null && arr.length > 0) {
            String sizeLimit = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_ORIGINAL_BILL_SAVE_LIMIT);
            if (arr.length > Integer.parseInt(sizeLimit)) {
                e.setCancel(true);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58\u7533\u8bf7\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a", (String)"InvoiceOriginalBillSavePlugin_82", (String)"imc-sim-formplugin", (Object[])new Object[]{sizeLimit}), sizeLimit));
            }
            for (DynamicObject originBillDynamicObject : arr) {
                if (!"1".equals(ImcConfigUtil.getValue((String)"checkBillStateWhileSave", (String)"checkBillStateWhileSave")) && !BillStatusEnum.isEditStatus((Object)originBillDynamicObject.getString("billstatus"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e:%s, \u53ea\u6709\u6682\u5b58\u6216\u65e0\u9700\u5ba1\u6279\u7684\u5355\u636e\u624d\u80fd\u4fdd\u5b58\u3002", (String)"InvoiceOriginalBillSavePlugin_65", (String)"imc-sim-formplugin", (Object[])new Object[]{originBillDynamicObject.getString("billno")}));
                }
                String systemSource = originBillDynamicObject.getString("systemsource");
                if (BotpHelper.isFromBotp((String)originBillDynamicObject.getString("billsource"))) {
                    this.checkAmountPrision(originBillDynamicObject);
                }
                if (BotpHelper.isBillNotComplete((Object)originBillDynamicObject.getString("billcomplete")) || !BotpHelper.isForceGoodsMatch()) continue;
                BotpHelper.dealPushArFields((DynamicObject[])new DynamicObject[]{originBillDynamicObject});
                if (BotpHelper.isFromAr((Object)systemSource)) {
                    billStatusMap = BotpHelper.checkCloseStatusClosed((DynamicObject[])arr, billStatusMap, (DynamicObject)originBillDynamicObject);
                }
                if (!BotpHelper.onlySubmitCheck((DynamicObject)originBillDynamicObject)) {
                    InvoiceOriginalBillSavePlugin.checkTotalAmount(originBillDynamicObject);
                }
                InvoiceOriginalBillSavePlugin.checkLength(originBillDynamicObject);
                InvoiceOriginalBillSavePlugin.simpleCheckInvoiceInfoDO(originBillDynamicObject, false);
                this.dealCheckTraveleServiceMethod(originBillDynamicObject);
                BillValidaterHelper.dealCheckVessalVehicheMethod((DynamicObject)originBillDynamicObject);
                BillValidaterHelper.checkExtraInfo((DynamicObject)originBillDynamicObject);
                String errorMsg = BillValidaterHelper.checkDigitalInvoiceBuyerSellerInfo((DynamicObject)originBillDynamicObject);
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    throw new KDBizException(errorMsg);
                }
                InvoiceOriginalBillSavePlugin.checkFromAmount(originBillDynamicObject);
                InvoiceOriginalBillSavePlugin.checkSameTaxRate(originBillDynamicObject);
                ApiResult apiResult = BillValidaterHelper.validBillInvoice((DynamicObject)originBillDynamicObject, (boolean)true, (BillCheckProcessDto)new BillCheckProcessDto(Boolean.valueOf(false), false));
                if ("success".equalsIgnoreCase(apiResult.getErrorCode())) {
                    LOG.info("InvoiceOriginalBillSavePlugin setCancel,code:" + apiResult.getErrorCode());
                }
                if (!apiResult.getErrorCode().equals(ApiErrCodeEnum.OK.getCode()) && !"success".equalsIgnoreCase(apiResult.getErrorCode())) {
                    LOG.info("InvoiceOriginalBillSavePlugin setCancel,code:" + apiResult.getErrorCode());
                    throw new KDBizException(apiResult.getMessage());
                }
                LOG.info("updateTaxOrg");
                IssueInvoiceService.updateTaxOrg((DynamicObject)originBillDynamicObject);
                if (!BotpHelper.isFromXMY((Object)systemSource) && BotpHelper.isBotpSystemSource((String)systemSource)) {
                    originBillDynamicObject.set("editable", (Object)"1");
                }
                if ("3".equals(originBillDynamicObject.getString("taxationstyle")) && !EnterpriseHelper.isLqptChannel((String)originBillDynamicObject.getString("salertaxno")) && StringUtils.isEmpty((CharSequence)originBillDynamicObject.getString("reductiontaxtype"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u51cf\u6309\u5f81\u7a0e\u65f6\uff0c\u51cf\u6309\u5f81\u7a0e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_72", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                BillValidaterHelper.dealSetPeriodDateMethod((DynamicObject)originBillDynamicObject);
            }
        }
    }

    private void dealCheckTraveleServiceMethod(DynamicObject originBillDynamicObject) {
        String billNo = originBillDynamicObject.getString("billno");
        String invoiceType = originBillDynamicObject.getString("invoicetype");
        String specialType = originBillDynamicObject.getString("specialtype");
        boolean flag = InvoiceType.checkIsTaxInvoice((String)invoiceType);
        DynamicObjectCollection dynamicObjectCollection = originBillDynamicObject.getDynamicObjectCollection("travelers");
        if (flag && "E09".equals(specialType) && dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5f00\u5177\u7a0e\u63a7\u53d1\u7968\u65f6\uff0c\u4e0d\u80fd\u591f\u652f\u6301\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1", (String)"InvoiceOriginalBillSavePlugin_66", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private void checkAmountPrision(DynamicObject bill) {
        String billNo = bill.getString("billno");
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject row = (DynamicObject)items.get(i);
            BigDecimal amount = row.getBigDecimal("amount");
            BigDecimal tax = row.getBigDecimal("tax");
            BigDecimal taxAmount = row.getBigDecimal("taxamount");
            this.checkPrision(billNo, ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceOriginalBillSavePlugin_73", (String)"imc-sim-formplugin", (Object[])new Object[0]), amount, i + 1);
            this.checkPrision(billNo, ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceOriginalBillSavePlugin_74", (String)"imc-sim-formplugin", (Object[])new Object[0]), tax, i + 1);
            this.checkPrision(billNo, ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"InvoiceOriginalBillSavePlugin_75", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxAmount, i + 1);
        }
        this.checkPrision(billNo, ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceOriginalBillSavePlugin_76", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getBigDecimal("totalamount"), 0);
        this.checkPrision(billNo, ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d", (String)"InvoiceOriginalBillSavePlugin_77", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getBigDecimal("invoiceamount"), 0);
        this.checkPrision(billNo, ResManager.loadKDString((String)"\u5408\u8ba1\u7a0e\u989d", (String)"InvoiceOriginalBillSavePlugin_78", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getBigDecimal("totaltax"), 0);
    }

    private void checkPrision(String billNo, String keyName, BigDecimal amount, int rowSeq) {
        String[] array;
        String amountStr = amount.stripTrailingZeros().toPlainString();
        if (amountStr.contains("\\.") && (array = amountStr.split("\\.")).length > 1 && array[1].length() > 2) {
            if (rowSeq == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s\u8d85\u8fc72\u4f4d\u5c0f\u6570\uff0c\u8bf7\u5904\u7406\u4e3a2\u4f4d\u5c0f\u6570\u540e\u4fdd\u5b58", (String)"InvoiceOriginalBillSavePlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, keyName));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7b2c%2$s\u884c\u660e\u7ec6\u7684%3$s\u8d85\u8fc72\u4f4d\u5c0f\u6570\uff0c\u8bf7\u5904\u7406\u4e3a2\u4f4d\u5c0f\u6570\u540e\u4fdd\u5b58", (String)"InvoiceOriginalBillSavePlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, rowSeq, keyName));
        }
    }

    public static void checkSameTaxRate(DynamicObject bill) {
        if (!InvoiceUtils.normalRowCheck()) {
            return;
        }
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < items.size(); ++i) {
            String lastTaxRate;
            DynamicObject currentRow = (DynamicObject)items.get(i);
            if (!"1".equals(currentRow.getString("rowtype"))) continue;
            if (i == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u4e2d\u7b2c1\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c", (String)"InvoiceOriginalBillPlugin_89", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
            }
            DynamicObject lastRow = (DynamicObject)items.get(i - 1);
            String taxRate = currentRow.getString("taxrate");
            if (Objects.equals(taxRate, lastTaxRate = lastRow.getString("taxrate"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4e2d\u7b2c%2$s\u884c\u548c\u5176\u6298\u6263\u884c\u7a0e\u7387\u4e0d\u4e00\u81f4", (String)"InvoiceOriginalBillSavePlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), i));
        }
    }

    public static void checkFromAmount(DynamicObject originalBill) {
        String billNo = originalBill.getString("billno");
        String systemSource = originalBill.getString("systemsource");
        if (CurrencyHelper.isFrom((Object)originalBill.get("fromcurr"))) {
            DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            BigDecimal calTotalTax = BigDecimal.ZERO;
            BigDecimal calTotalAmount = BigDecimal.ZERO;
            BigDecimal calTotalInvoiceAmount = BigDecimal.ZERO;
            int rowIndex = 1;
            for (DynamicObject item : items) {
                BigDecimal fromTax = item.getBigDecimal("fromtax");
                BigDecimal fromAmount = item.getBigDecimal("fromamount");
                BigDecimal fromTaxAmount = item.getBigDecimal("fromtaxamount");
                if (fromTax.add(fromAmount).compareTo(fromTaxAmount) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u539f\u5e01\u91d1\u989d\u548c\u539f\u5e01\u7a0e\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u539f\u5e01\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceOriginalBillSavePlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex));
                }
                calTotalTax = calTotalTax.add(fromTax);
                calTotalAmount = calTotalAmount.add(fromTaxAmount);
                calTotalInvoiceAmount = calTotalInvoiceAmount.add(fromAmount);
                ++rowIndex;
            }
            BigDecimal fromTax = originalBill.getBigDecimal("foreigntax");
            BigDecimal fromTotalAmount = originalBill.getBigDecimal("foreigntotalamount");
            BigDecimal FromInvoiceAmout = originalBill.getBigDecimal("foreigninvoiceamount");
            if (fromTax.compareTo(calTotalTax) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u660e\u7ec6\u539f\u5e01\u7a0e\u989d\u5408\u8ba1\u548c\u5355\u636e\u5934\u539f\u5e01\u7a0e\u989d\u4e0d\u76f8\u7b49", (String)"InvoiceOriginalBillSavePlugin_54", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (FromInvoiceAmout.compareTo(calTotalInvoiceAmount) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u660e\u7ec6\u539f\u5e01\u91d1\u989d\u5408\u8ba1\u548c\u5355\u636e\u5934\u5408\u8ba1\u91d1\u989d\u4e0d\u76f8\u7b49", (String)"InvoiceOriginalBillSavePlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (fromTotalAmount.compareTo(calTotalAmount) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u660e\u7ec6\u539f\u5e01\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u548c\u5355\u636e\u5934\u539f\u5e01\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49", (String)"InvoiceOriginalBillSavePlugin_56", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
        }
        if (BotpHelper.isFromArZANGU((Object)systemSource)) {
            if (!BigDecimalUtil.greaterZero((BigDecimal)originalBill.getBigDecimal("exrate"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u6c47\u7387\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6570\u5b57", (String)"InvoiceOriginalBillSavePlugin_57", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (null == originalBill.get("fromcurr")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u539f\u5e01\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_58", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (null == originalBill.get("tocurr")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u672c\u4f4d\u5e01\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_59", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (CurrencyHelper.isFrom((Object)originalBill.get("tocurr"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u53ea\u652f\u6301\u4eba\u6c11\u5e01", (String)"InvoiceOriginalBillSavePlugin_60", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (null == originalBill.get("exratetable")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u6c47\u7387\u8868\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_61", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (null == originalBill.get("exchangedate")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u6c47\u7387\u65e5\u671f\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_62", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if (StringUtils.isBlank((Object)originalBill.get("quotation"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u6362\u7b97\u65b9\u5f0f\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_63", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
        }
    }

    public static void checkTotalAmount(DynamicObject originBillDynamicObject) {
        if (!StringUtils.isEmpty((CharSequence)CacheHelper.get((String)(originBillDynamicObject.getString("billno") + "needCheckTotalAmount")))) {
            OriginalBillFormEditUtil.systemSourceSaveDataCheck((DynamicObject)originBillDynamicObject);
        }
        originBillDynamicObject.set("buyerphone", (Object)originBillDynamicObject.getString("buyerphone").replace(" ", ""));
        BigDecimal invoiceamount = originBillDynamicObject.getBigDecimal("invoiceamount").setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalamount = originBillDynamicObject.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP);
        if (BigDecimal.ZERO.compareTo(totalamount) == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u7b49\u4e8e0", (String)"InvoiceOriginalBillSavePlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), originBillDynamicObject.getString("billno")));
        }
        BigDecimal totaltax = originBillDynamicObject.getBigDecimal("totaltax").setScale(2, RoundingMode.HALF_UP);
        BigDecimal newinvoiceamount = BigDecimal.ZERO;
        BigDecimal newtotalamount = BigDecimal.ZERO;
        BigDecimal newtotaltax = BigDecimal.ZERO;
        DynamicObjectCollection items = originBillDynamicObject.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            if (item.getBoolean("gift")) continue;
            newinvoiceamount = newinvoiceamount.add(item.getBigDecimal("amount"));
            newtotalamount = newtotalamount.add(item.getBigDecimal("taxamount"));
            newtotaltax = newtotaltax.add(item.getBigDecimal("tax"));
        }
        if (invoiceamount.compareTo(newinvoiceamount.setScale(2, RoundingMode.HALF_UP)) != 0 || totalamount.compareTo(newtotalamount.setScale(2, RoundingMode.HALF_UP)) != 0 || totaltax.compareTo(newtotaltax.setScale(2, RoundingMode.HALF_UP)) != 0) {
            LOG.error("\u5f53\u524d\u660e\u7ec6\u603b\u4ef7\u7a0e\u5408\u8ba1\u3001\u603b\u7a0e\u989d\u3001\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u5355\u636e\u5934\u4ef7\u7a0e\u5408\u8ba1\u3001\u7a0e\u989d\u3001\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\uff01\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1" + totalamount + "\u5143\uff0c\u7a0e\u989d" + totaltax + "\u5143\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d" + invoiceamount + "\u5143");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u660e\u7ec6\u603b\u4ef7\u7a0e\u5408\u8ba1\u3001\u603b\u7a0e\u989d\u3001\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u5355\u636e\u5934\u4ef7\u7a0e\u5408\u8ba1\u3001\u7a0e\u989d\u3001\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\uff01\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1%1$s\u5143\uff0c\u7a0e\u989d%2$s\u5143\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d%3$s\u5143", (String)"InvoiceOriginalBillSavePlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]), totalamount, totaltax, invoiceamount));
        }
    }

    public static void checkLength(DynamicObject originBillDynamicObject) {
        InvoiceOriginalBillSavePlugin.checkLength(originBillDynamicObject, "textfield1");
        InvoiceOriginalBillSavePlugin.checkLength(originBillDynamicObject, "textfield2");
        InvoiceOriginalBillSavePlugin.checkLength(originBillDynamicObject, "textfield3");
        InvoiceOriginalBillSavePlugin.checkLength(originBillDynamicObject, "textfield4");
        InvoiceOriginalBillSavePlugin.checkLength(originBillDynamicObject, "textfield5");
    }

    private static void checkLength(DynamicObject bill, String key) {
        DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
        if (property instanceof TextProp) {
            int maxLenth = ((TextProp)property).getMaxLenth();
            if (GBKUtils.getGBKLength((String)bill.getString(key)) > maxLenth) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u8d85\u957f", (String)"OriginalBillFormEditUtil_9", (String)"imc-sim-service", (Object[])new Object[0]), property.getDisplayName().getLocaleValue()));
            }
        }
    }

    public static void simpleCheckInvoiceInfoDO(DynamicObject dynamicObject, boolean needCheckRed) {
        String invoiceType = dynamicObject.getString("invoicetype");
        String specialType = dynamicObject.getString("specialtype");
        String buyerProperty = dynamicObject.getString("buyerproperty");
        String billNo = dynamicObject.getString("billno");
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType) || InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            if ("1".equals(buyerProperty)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u4e13\u7528\u53d1\u7968\u8bf7\u9009\u62e9\u4f01\u4e1a\u7c7b\u578b", (String)"InvoiceOriginalBillSavePlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            InvoiceOriginalBillSavePlugin.checkBuyerNull(dynamicObject.getString("buyername"), String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo), specialType);
            InvoiceOriginalBillSavePlugin.checkBuyerNull(dynamicObject.getString("buyertaxno"), String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo), specialType);
            if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && !AllEleAuthHelper.isElePaper((Object)dynamicObject.get("iselepaper"))) {
                InvoiceOriginalBillSavePlugin.checkBuyerNull(dynamicObject.getString("buyeraddr"), String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u8d2d\u65b9\u5730\u5740\u3001\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo), specialType);
                InvoiceOriginalBillSavePlugin.checkBuyerNull(dynamicObject.getString("buyerbank"), String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u8d2d\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo), specialType);
            }
        } else {
            InvoiceOriginalBillSavePlugin.checkBuyerNull(dynamicObject.getString("buyername"), String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo), specialType);
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && "-1".equals(dynamicObject.getString("billproperties"))) {
            InvoiceOriginalBillSavePlugin.checkRedConfirm(dynamicObject);
        }
        if (InvoiceUtils.isEtcInvoice((String)invoiceType) && dynamicObject.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0) {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("orgid"));
            orgId = orgId == 0L ? RequestContext.get().getOrgId() : orgId;
            String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)orgId);
            if (CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone) && StringUtils.isBlank((CharSequence)dynamicObject.getString("buyerphone")) && StringUtils.isBlank((CharSequence)dynamicObject.getString("buyeremail"))) {
                throw new KDBizException(ApiErrCodeEnum.BILL_PUSH_EMAIL_OR_PHONE.getMsg());
            }
        }
        if ("02".equals(dynamicObject.get("specialtype"))) {
            if (!InvoiceUtils.isNormalInvoice((String)invoiceType) && !InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u7684\u53d1\u7968\u7c7b\u578b\u5fc5\u987b\u4e3a\u666e\u7968", (String)"InvoiceOriginalBillSavePlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            if ("1".equals(dynamicObject.getString("billproperties"))) {
                boolean isAllEle;
                if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && StringUtils.isEmpty((CharSequence)dynamicObject.getString("cardtype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s \u6570\u7535\u7968\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\uff0c\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_64", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
                }
                String confirmState = dynamicObject.getString("confirmstate");
                String cardType = dynamicObject.getString("cardtype");
                String buyerTaxNo = dynamicObject.getString("buyertaxno");
                boolean bl = isAllEle = "1".equals(dynamicObject.getString("iselepaper")) || InvoiceUtils.isAllEInvoice((Object)invoiceType);
                if ("0".equals(confirmState) && isAllEle) {
                    DynamicObject nation = dynamicObject.getDynamicObject("nation");
                    if (null == nation) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u6570\u7535\u7968\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\uff0c\u56fd\u7c4d\uff08\u5730\u533a\uff09\u5fc5\u586b", (String)"InvoiceOriginalBillSavePlugin_81", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
                    }
                    InvoiceValidHelper.validateCardNoInfo((String)cardType, (String)buyerTaxNo);
                    DynamicObject queryNation = InvoiceUtils.getNation((String)cardType, (String)buyerTaxNo);
                    if (null != queryNation && !Objects.equals(nation.getPkValue(), queryNation.getPkValue())) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u8bc1\u4ef6\u7c7b\u578b\u548c\u56fd\u7c4d\uff08\u5730\u533a\uff09\u4e0d\u5339\u914d", (String)"InvoiceOriginalBillSavePlugin_80", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
                    }
                }
            }
        }
        if ("E12".equals(dynamicObject.get("specialtype"))) {
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u81ea\u4ea7\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968", (String)"InvoiceOriginalBillPlugin_90", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("sim_original_bill_item");
            int i = 1;
            for (DynamicObject item : items) {
                String privilegeContent = item.getString("policycontants");
                String privilegeFlag = item.getString("policylogo");
                String taxRate = item.getString("taxrate");
                BigDecimal taxRateDecimalValue = BigDecimal.TEN;
                try {
                    taxRateDecimalValue = new BigDecimal(taxRate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!"1".equals(privilegeFlag) || !"\u514d\u7a0e".equals(privilegeContent) || taxRateDecimalValue.compareTo(BigDecimal.ZERO) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7b2c%2$s\u884c\u660e\u7ec6\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a\uff1a0,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u4e3a\uff1a\u4eab\u53d7\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\uff1a\u514d\u7a0e\uff08\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u7a0e\u7387\u8981\u6c42\u5fc5\u987b\u4e3a\u514d\u7a0e\uff09", (String)"InvoiceOriginalBillPlugin_91", (String)"imc-sim-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno"), i));
                }
                ++i;
            }
        }
        InvoiceOriginalBillSavePlugin.simpleCheckBillItem(dynamicObject.getDynamicObjectCollection("sim_original_bill_item"), dynamicObject.getString("specialtype"), dynamicObject.getString("invoicetype"), billNo);
        if (needCheckRed) {
            InvoiceOriginalBillSavePlugin.billSavePluginCheckRed(dynamicObject);
        }
    }

    private static void checkRedConfirm(DynamicObject dynamicObject) {
        BigDecimal billTotalAmount;
        String billNo = dynamicObject.getString("billno");
        String redConfirmBill = dynamicObject.getString("infocode");
        if (StringUtils.isBlank((CharSequence)redConfirmBill)) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)redConfirmBill);
        Object org = dynamicObject.get("orgid");
        long orgPk = org instanceof DynamicObject ? ((DynamicObject)org).getLong("id") : ((Long)org).longValue();
        QFilter baseFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgPk);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter[]{filter, baseFilter});
        if (array.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"InvoiceOriginalBillSavePlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
        }
        String issueStatus = array[0].getString("issuestatus");
        if (!"2".equals(issueStatus) && !"3".equals(issueStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c\u53ea\u80fd\u9009\u62e9\u672a\u5f00\u7968\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff1a%2$s", (String)"InvoiceOriginalBillSavePlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, redConfirmBill));
        }
        String uploadStatus = array[0].getString("uploadstatus");
        if (!"1".equals(uploadStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c\u53ea\u80fd\u9009\u62e9\u5df2\u4e0a\u4f20\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff1a%2$s", (String)"InvoiceOriginalBillSavePlugin_48", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, redConfirmBill));
        }
        BigDecimal confirmTotalAmount = array[0].getBigDecimal("totalamount");
        if (confirmTotalAmount.compareTo(billTotalAmount = dynamicObject.getBigDecimal("totalamount")) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u4ef7\u7a0e\u5408\u8ba1\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4", (String)"InvoiceOriginalBillSavePlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
        }
        BigDecimal confirmTotalTax = array[0].getBigDecimal("totaltax");
        BigDecimal billTotalTax = dynamicObject.getBigDecimal("totaltax");
        BigDecimal negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("orgid")), (String)"negativebilldiff");
        if (MathUtils.isZero((BigDecimal)negativeBillDiff)) {
            if (confirmTotalTax.compareTo(billTotalTax) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5408\u8ba1\u7a0e\u989d\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u5408\u8ba1\u7a0e\u989d\u4e0d\u4e00\u81f4", (String)"InvoiceOriginalBillSavePlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
            }
        } else {
            BigDecimal redConfirmDiff;
            BigDecimal configDiff = negativeBillDiff.abs();
            if (configDiff.subtract(redConfirmDiff = confirmTotalTax.abs().subtract(billTotalTax.abs()).abs()).compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a\uff1a%2$s\uff0c\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s", (String)"InvoiceOriginalBillSavePlugin_79", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, redConfirmDiff, configDiff));
            }
        }
        Object billBuyerTaxNo = dynamicObject.get("buyertaxno");
        Object buyerTaxNo = array[0].get("buyertaxno");
        if (!String.valueOf(billBuyerTaxNo).equals(String.valueOf(buyerTaxNo))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u8d2d\u65b9\u7a0e\u53f7\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"InvoiceOriginalBillSavePlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo));
        }
        String confirmInovicNo = array[0].getString("originalinvoiceno");
        String confirmInovicType = array[0].getString("originalinvoicetype");
        Date confirmIssueTime = array[0].getDate("originalissuetime");
        String billBlueInvoiceNo = dynamicObject.getString("blueinvoiceno");
        String billBlueInvoiceType = dynamicObject.getString("blueinvoicetype");
        Date billBlueIssueTime = dynamicObject.getDate("originalissuetime");
        InvoiceOriginalBillSavePlugin.compare(confirmInovicNo, billBlueInvoiceNo, ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u53f7\u7801", (String)"InvoiceOriginalBillPlugin_92", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
        InvoiceOriginalBillSavePlugin.compare(confirmInovicType, billBlueInvoiceType, ResManager.loadKDString((String)"\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b", (String)"InvoiceOriginalBillPlugin_93", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
        String confirmDateStr = DateUtils.format((Date)confirmIssueTime, (String)"yyyyMMdd");
        String billBlueIssueTimeStr = DateUtils.format((Date)billBlueIssueTime, (String)"yyyyMMdd");
        InvoiceOriginalBillSavePlugin.compare(confirmDateStr, billBlueIssueTimeStr, ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f", (String)"InvoiceOriginalBillPlugin_94", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
    }

    private static void compare(String value1, String value2, String fildName, String billNo) {
        if (!String.valueOf(value1).equals(String.valueOf(value2))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355%1$s\u7684%2$s\u548c\u7ea2\u5b57\u786e\u8ba4\u5355%3$s\u4e0d\u4e00\u81f4", (String)"InvoiceOriginalBillSavePlugin_49", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, fildName, fildName));
        }
    }

    private static void checkNull(Object fieldValue, String msg) {
        if (StringUtils.isBlank((Object)fieldValue)) {
            throw new KDBizException(msg);
        }
    }

    private static void checkBuyerNull(Object fieldValue, String msg, String specialType) {
        if (TaxUtils.isPurchaseInvoice((String)specialType)) {
            msg = msg.replace(ResManager.loadKDString((String)"\u8d2d\u65b9", (String)"InvoiceOriginalBillPlugin_95", (String)"imc-sim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9500\u65b9", (String)"InvoiceOriginalBillPlugin_96", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        InvoiceOriginalBillSavePlugin.checkNull(fieldValue, msg);
    }

    public static void simpleCheckBillItem(DynamicObjectCollection items, String specialType, String invoiceType, String billNo) {
        if (items.size() == 0) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            if (StringUtils.isBlank((CharSequence)item.getString("goodscode"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u7b2c%2$s\u884c\u5546\u54c1\u7a0e\u6536\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_50", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, i + 1));
            }
            if (TaxUtils.isPurchaseInvoice((String)specialType)) {
                if (!item.getString("taxrate").equals("0")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u7b2c%2$s\u884c\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u7684\u7a0e\u7387\u987b\u4e3a0", (String)"InvoiceOriginalBillSavePlugin_51", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, i + 1));
                }
                if (!ResManager.loadKDString((String)"\u514d\u7a0e", (String)"InvoiceOriginalBillSavePlugin_39", (String)"imc-sim-formplugin", (Object[])new Object[0]).equals(item.getString("policycontants")) || !"1".equals(item.getString("policylogo"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u6536\u8d2d\u7968\u7b2c%2$s\u884c\u5546\u54c1\u5fc5\u987b\u4e3a\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u548c\u514d\u7a0e", (String)"InvoiceOriginalBillSavePlugin_52", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, i + 1));
                }
            }
            String num = item.getString("num");
            String price = item.getString("unitprice");
            String unit = item.getString("unit");
            String rowType = item.getString("rowtype");
            try {
                InvoiceCheckService.checkVehicleItem((String)specialType, (String)invoiceType, (String)rowType, (int)i, (String)num, (String)price, (String)unit);
                continue;
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s", (String)"InvoiceOriginalBillSavePlugin_53", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, e.getMessage()));
            }
        }
    }

    public static String checkCoBuyer(DynamicObjectCollection dynamicObjects) {
        if (dynamicObjects.size() == 0) {
            return ResManager.loadKDString((String)"\u5171\u540c\u8d2d\u4e70\u65b9\u52fe\u9009\u540e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_68", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (StringUtils.isBlank((CharSequence)dynamicObject.getString("cobuyer")) || !dynamicObject.getString("cobuyer").matches("[\\u4e00-\\u9fa5a-zA-Z]+")) {
                return ResManager.loadKDString((String)"\u5171\u540c\u8d2d\u4e70\u65b9\u5fc5\u586b\uff0c\u4e14\u53ea\u80fd\u586b\u5199\u6c49\u5b57\u3001\u82f1\u6587\u5927\u5c0f\u5199", (String)"InvoiceOriginalBillSavePlugin_69", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)dynamicObject.getString("cobuyercardtype"))) {
                return ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_70", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("cobuyercardno"))) continue;
            return ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceOriginalBillSavePlugin_71", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public static void clearCollection(DynamicObjectCollection dynamicObjects) {
        dynamicObjects.clear();
    }
}

