/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;
import kd.imc.sim.formplugin.bill.originalbill.op.AbstractOriginalBillSavePlugin;
import kd.imc.sim.formplugin.bill.originalbill.op.InvoiceOriginalBillSavePlugin;
import kd.imc.sim.formplugin.bill.originalbill.op.validator.OriginalBillSubmitValidator;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;

public class InvoiceOriginalBillSubmitPlugin
extends AbstractOperationServicePlugIn {
    private static Log LOGGER = LogFactory.getLog(InvoiceOriginalBillSubmitPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_original_bill", (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OriginalBillSubmitValidator());
        DynamicObject[] objs = e.getDataEntities();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                if ("E09".equals(obj.getString("specialtype"))) continue;
                DynamicObjectCollection items = obj.getDynamicObjectCollection("travelers");
                items.clear();
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] arr = e.getDataEntities();
        HashMap billStatusMap = null;
        if (arr == null || arr.length == 0) {
            return;
        }
        String sizeLimit = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_ORIGINAL_BILL_SUB_LIMIT);
        if (arr.length > Integer.parseInt(sizeLimit)) {
            e.setCancel(true);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u7533\u8bf7\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a", (String)"InvoiceOriginalBillSavePlugin_83", (String)"imc-sim-formplugin", (Object[])new Object[]{sizeLimit}), sizeLimit));
        }
        for (DynamicObject dynamicObject : arr) {
            BotpHelper.dealPushArFields((DynamicObject[])new DynamicObject[]{dynamicObject});
            AbstractOriginalBillSavePlugin.setBillTaxRate(dynamicObject);
            if ("C".equals(dynamicObject.getString("billsourcetype")) || "B".equals(dynamicObject.getString("billsourcetype"))) continue;
            String errorMsg = BillValidaterHelper.checkDigitalInvoiceBuyerSellerInfo((DynamicObject)dynamicObject);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                throw new KDBizException(errorMsg);
            }
            ApiResult apiResult = BillValidaterHelper.validBillInvoice((DynamicObject)dynamicObject, (boolean)false, (BillCheckProcessDto)new BillCheckProcessDto(Boolean.valueOf(true), true));
            String systemSource = dynamicObject.getString("systemsource");
            if (BotpHelper.isFromAr((Object)systemSource)) {
                billStatusMap = BotpHelper.checkCloseStatusClosed((DynamicObject[])arr, billStatusMap, (DynamicObject)dynamicObject);
            }
            if (!apiResult.getErrorCode().equals(ApiErrCodeEnum.OK.getCode())) {
                LOGGER.info("InvoiceOriginalBillSavePlugin setCancel");
                e.setCancelMessage(apiResult.getMessage());
                e.setCancel(true);
                return;
            }
            IssueInvoiceService.updateTaxOrg((DynamicObject)dynamicObject);
            this.checkSubmit(dynamicObject);
            if (!"11".equals(dynamicObject.getString("comprehensivestatus"))) continue;
            dynamicObject.set("comprehensivestatus", (Object)"12");
        }
    }

    private void checkSubmit(DynamicObject bill) {
        if (!BotpHelper.isNotComplete((Object)bill.get("billcomplete"))) {
            InvoiceOriginalBillSavePlugin.checkTotalAmount(bill);
        }
        InvoiceOriginalBillSavePlugin.checkLength(bill);
        InvoiceOriginalBillSavePlugin.simpleCheckInvoiceInfoDO(bill, true);
        RedInfoHelper.checkRedInfo((String)bill.getString("infocode"), (DynamicObject)bill);
        InvoiceOriginalBillSavePlugin.checkNormalRedBlueInvoiceSurplusAmount(bill);
        OriginalBillFormEditUtil.checkBillRedConfirmBillDO((DynamicObject)bill);
        InvoiceOriginalBillSavePlugin.checkFromAmount(bill);
        InvoiceOriginalBillSavePlugin.checkSameTaxRate(bill);
        this.dealCheckTraveleServiceMethod(bill);
        BillValidaterHelper.dealCheckVessalVehicheMethod((DynamicObject)bill);
        BillValidaterHelper.dealSetPeriodDateMethod((DynamicObject)bill);
    }

    private void dealCheckTraveleServiceMethod(DynamicObject bill) {
        String billNo = bill.getString("billno");
        String invoiceType = bill.getString("invoicetype");
        String specialType = bill.getString("specialtype");
        boolean flag = InvoiceType.checkIsTaxInvoice((String)invoiceType);
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("travelers");
        if (flag && "E09".equals(specialType) && dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5f00\u5177\u7a0e\u63a7\u53d1\u7968\u65f6\uff0c\u4e0d\u80fd\u591f\u652f\u6301\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1", (String)"InvoiceOriginalBillSavePlugin_66", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        try {
            if ("E09".equals(specialType)) {
                DynamicObjectCollection itemObjectCollection = bill.getDynamicObjectCollection("sim_original_bill_item");
                InvoiceOriginalFormControl.dealCheckTravelerItemMethod((String)billNo, (DynamicObjectCollection)itemObjectCollection, (DynamicObjectCollection)dynamicObjectCollection);
                InvoiceOriginalFormControl.dealCheckTransportTypeMethod((DynamicObjectCollection)dynamicObjectCollection);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

