/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.formplugins;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.sim.common.utils.MathUtils;

public class BillSplitWorkbenchBatchDiscountRowPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        model.setValue("bediscountrow", formShowParameter.getCustomParam("rows"));
        BigDecimal canDiscountAmount = (BigDecimal)formShowParameter.getCustomParam("canDiscountAmount");
        model.setValue("discountamount", (Object)canDiscountAmount);
        BigDecimal sumUnSpecifiedAmount = (BigDecimal)formShowParameter.getCustomParam("sumUnSpecifiedAmount");
        model.setValue("sumunspecifiedamount", (Object)sumUnSpecifiedAmount);
        model.setValue("discountrate", (Object)canDiscountAmount.abs().divide(sumUnSpecifiedAmount, 2, 4));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            BigDecimal canDiscountAmount = (BigDecimal)formShowParameter.getCustomParam("canDiscountAmount");
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount");
            if (MathUtils.isNullOrZero((BigDecimal)discountAmount)) {
                BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate");
                if (discountRate.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d/\u6298\u6263\u7387\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillSplitWorkbenchBatchDiscountRowPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                discountAmount = canDiscountAmount.multiply(discountRate).setScale(2, 4);
            } else if (discountAmount.abs().compareTo(canDiscountAmount.abs()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u6298\u6263\u91d1\u989d", (String)"BillSplitWorkbenchBatchDiscountRowPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal sumUnSpecifiedAmount = (BigDecimal)formShowParameter.getCustomParam("sumUnSpecifiedAmount");
            if (discountAmount.abs().compareTo(sumUnSpecifiedAmount) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9009\u4e2d\u884c\u5269\u4f59\u53ef\u6307\u5b9a\u91d1\u989d", (String)"BillSplitWorkbenchBatchDiscountRowPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)discountAmount);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        BigDecimal sumUnSpecifiedAmount = (BigDecimal)this.getView().getFormShowParameter().getCustomParam("sumUnSpecifiedAmount");
        ChangeData changeData = e.getChangeSet()[0];
        if ("discountamount".equals(e.getProperty().getName())) {
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (MathUtils.isNullOrZero((BigDecimal)newValue)) {
                return;
            }
            if (newValue.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("discountamount", (Object)newValue.negate());
            }
            model.beginInit();
            model.setValue("discountrate", (Object)newValue.abs().divide(sumUnSpecifiedAmount, 2, 4));
            model.endInit();
            this.getView().updateView("discountrate");
        } else if ("discountrate".equals(e.getProperty().getName())) {
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            BigDecimal canDiscountAmount = (BigDecimal)this.getView().getFormShowParameter().getCustomParam("canDiscountAmount");
            BigDecimal discountAmount = newValue.multiply(sumUnSpecifiedAmount).setScale(2, 4).abs();
            model.beginInit();
            if (discountAmount.compareTo(canDiscountAmount.abs()) > 0) {
                discountAmount = ((BigDecimal)model.getValue("discountamount")).abs();
                model.setValue("discountrate", changeData.getOldValue());
            }
            model.setValue("discountamount", (Object)discountAmount.negate());
            model.endInit();
            this.getView().updateView("discountamount");
        }
    }
}

