/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.formplugins;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.dto.SpecifiedDiscountRelationDTO;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitWorkBenchMergeHelper;
import org.apache.commons.lang3.StringUtils;

public class BillSplitWorkbenchSpecifiedDiscountRowPlugin
extends AbstractFormPlugin {
    private static final String POSITIVE_RELATION = "positive_relation";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ((Label)this.getControl("allamountlabel")).setText((String)customParams.get("allAmount"));
        ((Label)this.getControl("alltaxlabel")).setText((String)customParams.get("allTax"));
        ((Label)this.getControl("alltaxamountlabel")).setText((String)customParams.get("allTaxAmount"));
        if (this.isManualSpecifiedDiscount()) {
            JSONArray items = (JSONArray)customParams.get("items");
            this.setPositiveAndNegativeEntryByInvoiceItems(items, items);
            return;
        }
        this.setPositiveAndNegativeEntry(customParams);
    }

    private boolean isManualSpecifiedDiscount() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return customParams.containsKey("items");
    }

    private void setPositiveAndNegativeEntry(Map<String, Object> customParams) {
        JSONObject billInvoiceJson = (JSONObject)customParams.get("treatmentInvoiceList");
        if (billInvoiceJson == null) {
            return;
        }
        JSONObject originBillInvoicceJson = (JSONObject)customParams.get("origin_treatmentInvoiceList");
        Set billIdSet = billInvoiceJson.keySet();
        for (String billId : billIdSet) {
            JSONArray invoiceArr = billInvoiceJson.getJSONArray(billId);
            JSONArray originInvoiceArr = originBillInvoicceJson.getJSONArray(billId);
            for (int invoiceIndex = 0; invoiceIndex < invoiceArr.size(); ++invoiceIndex) {
                JSONArray originItems = originInvoiceArr.getJSONObject(invoiceIndex).getJSONArray("items");
                JSONArray items = invoiceArr.getJSONObject(invoiceIndex).getJSONArray("items");
                this.setPositiveAndNegativeEntryByInvoiceItems(originItems, items);
            }
        }
    }

    private void setPositiveAndNegativeEntryByInvoiceItems(JSONArray originItems, JSONArray items) {
        IDataModel model = this.getModel();
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            int index;
            JSONObject item = items.getJSONObject(itemIndex);
            Set<String> billNo = this.getBillNo(originItems, item);
            if ("2".equals(item.getString("rowtype"))) {
                JSONObject discountItem = items.getJSONObject(itemIndex + 1);
                BigDecimal remainTaxAmount = item.getBigDecimal("taxamount").add(discountItem.getBigDecimal("taxamount"));
                billNo.addAll(this.getBillNo(originItems, discountItem));
                if (remainTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                    item.put("taxamount", (Object)remainTaxAmount);
                    item.put("tax", (Object)item.getBigDecimal("tax").add(discountItem.getBigDecimal("tax")));
                    item.put("id", (Object)item.getString("id"));
                    item.put("negativediscountid", discountItem.get((Object)"id"));
                } else {
                    item.put("discountamount", discountItem.get((Object)"taxamount"));
                    item.put("positivediscountid", discountItem.get((Object)"id"));
                }
                ++itemIndex;
            }
            if (item.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) < 0) {
                index = this.getModel().createNewEntryRow("negativeentry");
                model.setValue("negativeid", (Object)item.getString("id"), index);
                model.setValue("negativediscountid", (Object)item.getString("negativediscountid"), index);
                model.setValue("negative_billno", (Object)String.join((CharSequence)"\u3001", billNo), index);
                model.setValue("negative_goodsname", (Object)item.getString("goodsname"), index);
                model.setValue("negative_taxrate", (Object)item.getString("taxrate"), index);
                model.setValue("negative_taxamount", (Object)item.getBigDecimal("taxamount"), index);
                model.setValue("negative_tax", (Object)item.getBigDecimal("tax"), index);
                model.setValue("negative_unspecified", (Object)item.getBigDecimal("taxamount"), index);
                continue;
            }
            index = this.getModel().createNewEntryRow("positiveentry");
            model.setValue("positiveid", (Object)item.getString("id"), index);
            model.setValue("positivediscountid", (Object)item.getString("positivediscountid"), index);
            model.setValue("positive_billno", (Object)String.join((CharSequence)"\u3001", billNo), index);
            model.setValue("positive_goodsname", (Object)item.getString("goodsname"), index);
            model.setValue("positive_taxrate", (Object)item.getString("taxrate"), index);
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal discountAmount = item.getBigDecimal("discountamount");
            model.setValue("positive_taxamount", (Object)taxAmount, index);
            model.setValue("positive_discountamount", (Object)discountAmount, index);
            model.setValue("positive_unspecified", (Object)taxAmount.add(discountAmount), index);
        }
    }

    private Set<String> getBillNo(JSONArray originItems, JSONObject item) {
        String itemIds = item.getString("id");
        HashSet<String> billNoSet = new HashSet<String>(originItems.size());
        for (int i = 0; i < originItems.size(); ++i) {
            JSONObject originItem = originItems.getJSONObject(i);
            if (!itemIds.contains(originItem.getString("id"))) continue;
            billNoSet.add(originItem.getString("billNo"));
        }
        return billNoSet;
    }

    public void afterBindData(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getControl("negativeentry");
        grid.selectRows(0);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        if ("positive_specifi".equals(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            BigDecimal specifi = (BigDecimal)changeData.getNewValue();
            if (specifi.compareTo(BigDecimal.ZERO) > 0) {
                if (MathUtils.isNullOrZero((BigDecimal)specifi)) {
                    return;
                }
                if (specifi.compareTo(BigDecimal.ZERO) > 0) {
                    model.setValue("positive_specifi", (Object)specifi.negate(), changeData.getRowIndex());
                }
            }
            BigDecimal unSpcifiedAmount = (BigDecimal)model.getValue("positive_unspecified", changeData.getRowIndex());
            BigDecimal discountRate = BigDecimal.ZERO;
            if (specifi.abs().compareTo(unSpcifiedAmount) <= 0) {
                discountRate = specifi.abs().divide(this.getRowTaxAmount(changeData), 2, 4);
            }
            model.beginInit();
            model.setValue("positive_specifi_discount", (Object)discountRate, changeData.getRowIndex());
            model.endInit();
            this.getView().updateView("positive_specifi_discount", changeData.getRowIndex());
        } else if ("positive_specifi_discount".equals(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            model.beginInit();
            model.setValue("positive_specifi", (Object)this.getRowTaxAmount(changeData).negate().multiply(newValue).setScale(2, 4), changeData.getRowIndex());
            model.endInit();
            this.getView().updateView("positive_specifi", changeData.getRowIndex());
        }
    }

    private BigDecimal getRowTaxAmount(ChangeData changeData) {
        IDataModel model = this.getModel();
        BigDecimal taxAmount = (BigDecimal)model.getValue("positive_taxamount", changeData.getRowIndex());
        BigDecimal discountAmount = (BigDecimal)model.getValue("positive_discountamount", changeData.getRowIndex());
        taxAmount = taxAmount.add(discountAmount);
        return taxAmount;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = args.getOperateKey()) {
            case "ok": {
                this.specifiedDiscount();
                break;
            }
            case "cancel": {
                this.unSpecifiedDiscount();
            }
        }
    }

    private void specifiedDiscount() {
        String taxRateStr;
        EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
        int negativeIndex = negativeEntry.getSelectRows()[0];
        EntryGrid positiveEntry = (EntryGrid)this.getControl("positiveentry");
        int positiveIndex = positiveEntry.getSelectRows()[0];
        BigDecimal specifi = (BigDecimal)this.getModel().getValue("positive_specifi", positiveIndex);
        BigDecimal specifiRate = (BigDecimal)this.getModel().getValue("positive_specifi_discount", positiveIndex);
        if (specifi.compareTo(BigDecimal.ZERO) == 0 && specifiRate.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (specifi.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d1f\u6570\u7684\u91d1\u989d", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (specifi.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("positive_taxamount", positiveIndex);
            specifi = taxAmount.multiply(specifiRate).setScale(2, 4).negate();
        }
        if (!(taxRateStr = (String)this.getModel().getValue("positive_taxrate", positiveIndex)).equals(this.getModel().getValue("negative_taxrate", negativeIndex))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8d1f\u6570\u884c\u4e0e\u6307\u5b9a\u6b63\u6570\u884c\u7a0e\u7387\u4e0d\u540c\uff0c\u65e0\u6cd5\u6307\u5b9a", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal negativeUnSpecified = (BigDecimal)this.getModel().getValue("negative_unspecified", negativeIndex);
        if (specifi.compareTo(negativeUnSpecified) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6307\u5b9a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9009\u4e2d\u8d1f\u6570\u884c\u5f85\u6307\u5b9a\u542b\u7a0e\u91d1\u989d", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal unSpecifiedAmount = (BigDecimal)this.getModel().getValue("positive_unspecified", positiveIndex);
        if (specifi.abs().compareTo(unSpecifiedAmount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6307\u5b9a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6b63\u6570\u884c\u53ef\u88ab\u6307\u5b9a\u91d1\u989d", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.specifiedDiscount(negativeIndex, positiveIndex, specifi);
        this.getModel().setValue("positive_specifi", (Object)BigDecimal.ZERO, positiveIndex);
        this.getModel().setValue("positive_specifi_discount", (Object)0, positiveIndex);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u6210\u529f\uff0c\u672c\u6b21\u5df2\u6307\u5b9a%s", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), specifi.setScale(2, 4)));
    }

    private void specifiedDiscount(int negativeIndex, int positiveIndex, BigDecimal specifi) {
        BigDecimal specifyTax;
        IDataModel model = this.getModel();
        BigDecimal specifiedAmount = (BigDecimal)this.getModel().getValue("positive_specified", positiveIndex);
        BigDecimal unSpecifiedAmount = (BigDecimal)this.getModel().getValue("positive_unspecified", positiveIndex);
        model.setValue("positive_specified", (Object)specifiedAmount.add(specifi.abs()), positiveIndex);
        model.setValue("positive_unspecified", (Object)unSpecifiedAmount.subtract(specifi.abs()), positiveIndex);
        BigDecimal negativeUnSpecified = (BigDecimal)this.getModel().getValue("negative_unspecified", negativeIndex);
        String taxRateStr = (String)this.getModel().getValue("positive_taxrate", positiveIndex);
        BigDecimal negativeSpecified = (BigDecimal)this.getModel().getValue("negative_specified", negativeIndex);
        model.setValue("negative_specified", (Object)negativeSpecified.add(specifi), negativeIndex);
        BigDecimal negativeUnSpecifiedAmount = negativeUnSpecified.subtract(specifi);
        model.setValue("negative_unspecified", (Object)negativeUnSpecified.subtract(specifi), negativeIndex);
        if (negativeUnSpecifiedAmount.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal tax = (BigDecimal)this.getModel().getValue("negative_tax", negativeIndex);
            specifyTax = tax.subtract((BigDecimal)this.getModel().getValue("negative_specified_tax", negativeIndex));
        } else {
            BigDecimal taxRate = new BigDecimal(taxRateStr);
            specifyTax = specifi.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, 4);
        }
        model.setValue("negative_unspecified", (Object)negativeUnSpecifiedAmount, negativeIndex);
        model.setValue("negative_specified_tax", (Object)((BigDecimal)this.getModel().getValue("negative_specified_tax", negativeIndex)).add(specifyTax), negativeIndex);
        String negativeId = (String)model.getValue("negativeid", negativeIndex);
        String positiveId = (String)model.getValue("positiveid", positiveIndex);
        String positiveRelation = this.getPageCache().get(POSITIVE_RELATION);
        List relationList = JSONObject.parseArray((String)positiveRelation, SpecifiedDiscountRelationDTO.class);
        relationList = relationList == null ? new ArrayList() : relationList;
        Optional<SpecifiedDiscountRelationDTO> first = relationList.stream().filter(relation -> relation.getsBillId().equals(negativeId) && relation.gettBillId().equals(positiveId)).findFirst();
        if (first.isPresent()) {
            SpecifiedDiscountRelationDTO relation2 = first.get();
            relation2.setSpecifiedAmount(relation2.getSpecifiedAmount().add(specifi));
            relation2.setSpecifiedTax(relation2.getSpecifiedTax().add(specifyTax));
        } else {
            relationList.add(new SpecifiedDiscountRelationDTO(negativeId, positiveId, Integer.valueOf(negativeIndex), specifi, specifyTax));
        }
        this.getPageCache().put(POSITIVE_RELATION, JSONObject.toJSONString((Object)relationList));
    }

    private void unSpecifiedDiscount() {
        EntryGrid grid = (EntryGrid)this.getControl("positiveentry");
        this.unSpecifiedDiscount(grid.getSelectRows()[0]);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6307\u5b9a\u6210\u529f", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    private void unSpecifiedDiscount(int selectIndex) {
        IDataModel model = this.getModel();
        BigDecimal positiveSpecifiedAmount = (BigDecimal)this.getModel().getValue("positive_specified", selectIndex);
        if (positiveSpecifiedAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal taxAmount = ((BigDecimal)model.getValue("positive_taxamount", selectIndex)).add((BigDecimal)model.getValue("positive_discountamount", selectIndex));
        model.setValue("positive_specified", (Object)BigDecimal.ZERO, selectIndex);
        model.setValue("positive_unspecified", (Object)taxAmount, selectIndex);
        String positiveId = (String)this.getModel().getValue("positiveid", selectIndex);
        List relationList = JSONObject.parseArray((String)this.getPageCache().get(POSITIVE_RELATION), SpecifiedDiscountRelationDTO.class);
        List relations = relationList.stream().filter(relation -> relation.gettBillId().equals(positiveId)).collect(Collectors.toList());
        for (SpecifiedDiscountRelationDTO relation2 : relations) {
            Integer index = relation2.getIndex();
            BigDecimal specifiedAmount = (BigDecimal)model.getValue("negative_specified", index.intValue());
            BigDecimal unSpecifiedAmount = (BigDecimal)model.getValue("negative_unspecified", index.intValue());
            BigDecimal specifiedTax = (BigDecimal)model.getValue("negative_specified_tax", index.intValue());
            model.setValue("negative_specified", (Object)specifiedAmount.subtract(relation2.getSpecifiedAmount()), index.intValue());
            model.setValue("negative_unspecified", (Object)unSpecifiedAmount.add(relation2.getSpecifiedAmount()), index.intValue());
            model.setValue("negative_specified_tax", (Object)specifiedTax.subtract(relation2.getSpecifiedTax()), index.intValue());
        }
        relationList.removeAll(relations);
        this.getPageCache().put(POSITIVE_RELATION, JSONObject.toJSONString((Object)relationList));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            if (this.isManualSpecifiedDiscount()) {
                this.manualSpecifiedDiscount();
                return;
            }
            this.createInvoiceItemsAndRelation();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("batch_discount".equals(evt.getItemKey())) {
            IDataModel model = this.getModel();
            EntryGrid entry = (EntryGrid)this.getControl("positiveentry");
            int[] positiveSelectRows = entry.getSelectRows();
            if (positiveSelectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6279\u91cf\u6298\u6263\u7684\u884c", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
            BigDecimal negativeUnSpecifiedAmount = (BigDecimal)model.getValue("negative_unspecified", negativeEntry.getSelectRows()[0]);
            if (MathUtils.isNullOrZero((BigDecimal)negativeUnSpecifiedAmount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8d1f\u6570\u884c\u5f85\u6307\u5b9a\u542b\u7a0e\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u6279\u91cf\u6298\u6263", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal sumUnSpecifiedAmount = BigDecimal.ZERO;
            for (int positiveIndex : positiveSelectRows) {
                String taxRateStr = (String)model.getValue("positive_taxrate", positiveIndex);
                if (!taxRateStr.equals(model.getValue("negative_taxrate", negativeEntry.getSelectRows()[0]))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8d1f\u6570\u884c\u4e0e\u6307\u5b9a\u6b63\u6570\u884c\u7a0e\u7387\u4e0d\u540c\uff0c\u65e0\u6cd5\u6307\u5b9a", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal unSpecifiedAmount = (BigDecimal)model.getValue("positive_unspecified", positiveIndex);
                sumUnSpecifiedAmount = sumUnSpecifiedAmount.add(unSpecifiedAmount);
            }
            if (sumUnSpecifiedAmount.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u8ba1\u5f85\u6307\u5b9a\u6b63\u6570\u884c\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal canDiscountAmount = (BigDecimal)this.getModel().getValue("negative_unspecified", negativeEntry.getSelectRows()[0]);
            HashMap<String, Number> param = new HashMap<String, Number>(4);
            param.put("rows", positiveSelectRows.length);
            param.put("canDiscountAmount", canDiscountAmount.setScale(2, 4));
            param.put("sumUnSpecifiedAmount", sumUnSpecifiedAmount.setScale(2, 4));
            ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_process_batchdiscount", (String)"sim_process_batchdiscount");
            return;
        }
        if ("batch_undiscount".equals(evt.getItemKey())) {
            int[] positiveSelectRows;
            EntryGrid entry = (EntryGrid)this.getControl("positiveentry");
            for (int positiveSelectRow : positiveSelectRows = entry.getSelectRows()) {
                this.unSpecifiedDiscount(positiveSelectRow);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6307\u5b9a\u6210\u529f", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("sim_process_batchdiscount".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            IDataModel model = this.getModel();
            BigDecimal discountAmount = (BigDecimal)closedCallBackEvent.getReturnData();
            BigDecimal remainDiscountAmount = (BigDecimal)closedCallBackEvent.getReturnData();
            EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
            EntryGrid entry = (EntryGrid)this.getControl("positiveentry");
            int[] positiveSelectRows = entry.getSelectRows();
            BigDecimal sumUnSpecifiedAmount = BigDecimal.ZERO;
            for (int positiveSelectRow : positiveSelectRows) {
                BigDecimal unSpecifiedAmount = (BigDecimal)model.getValue("positive_unspecified", positiveSelectRow);
                sumUnSpecifiedAmount = sumUnSpecifiedAmount.add(unSpecifiedAmount);
            }
            for (int i = 0; i < positiveSelectRows.length; ++i) {
                BigDecimal specifi = remainDiscountAmount;
                if (i != positiveSelectRows.length - 1) {
                    BigDecimal unSpecifiedAmount = (BigDecimal)model.getValue("positive_unspecified", positiveSelectRows[i]);
                    specifi = unSpecifiedAmount.divide(sumUnSpecifiedAmount, 6, 4).multiply(discountAmount).setScale(2, 1);
                    remainDiscountAmount = remainDiscountAmount.subtract(specifi);
                }
                if (specifi.compareTo(BigDecimal.ZERO) == 0) continue;
                this.specifiedDiscount(negativeEntry.getSelectRows()[0], positiveSelectRows[i], specifi);
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u6298\u6263\u6210\u529f\uff0c\u672c\u6b21\u5df2\u6298\u6263%s", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), discountAmount.setScale(2, 4)));
        }
    }

    private void manualSpecifiedDiscount() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray items = (JSONArray)customParams.get("items");
        Map<String, JSONObject> idItemsMap = items.stream().map(item -> (JSONObject)item).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (v1, v2) -> v1));
        EntryGrid entry = (EntryGrid)this.getControl("positiveentry");
        DynamicObject[] positiveEntry = entry.getEntryData().getDataEntitys();
        JSONObject invRelation = (JSONObject)customParams.get("invRealtion");
        JSONArray relations = (JSONArray)invRelation.values().toArray()[0];
        JSONArray newRelations = this.getNewRelations(positiveEntry, relations);
        HashMap<String, JSONObject> negativeRelationJson = new HashMap<String, JSONObject>(relations.size());
        for (int i = 0; i < relations.size(); ++i) {
            JSONObject jsonObject = relations.getJSONObject(i);
            negativeRelationJson.put(jsonObject.getString("tdetailid"), jsonObject);
        }
        List specifiedDiscountRelationList = JSONObject.parseArray((String)this.getPageCache().get(POSITIVE_RELATION), SpecifiedDiscountRelationDTO.class);
        JSONArray newItems = new JSONArray();
        for (DynamicObject positive : positiveEntry) {
            BigDecimal specifiedAmount;
            String positiveId = positive.getString("positiveid");
            JSONObject normalItem = idItemsMap.get(positiveId);
            newItems.add((Object)normalItem);
            String discountId = positive.getString("positivediscountid");
            if (StringUtils.isNotBlank((CharSequence)discountId)) {
                JSONObject originDiscountItem = idItemsMap.get(discountId);
                newItems.add((Object)originDiscountItem);
            }
            if ((specifiedAmount = positive.getBigDecimal("positive_specified")).compareTo(BigDecimal.ZERO) == 0) continue;
            List specifiedDiscountRelations = specifiedDiscountRelationList.stream().filter(relation -> relation.gettBillId().equals(positiveId)).collect(Collectors.toList());
            JSONObject discountItem = null;
            if (StringUtils.isNotBlank((CharSequence)discountId)) {
                discountItem = idItemsMap.get(discountId);
            }
            for (SpecifiedDiscountRelationDTO discount : specifiedDiscountRelations) {
                String negativeId = discount.getsBillId();
                JSONObject relation2 = (JSONObject)negativeRelationJson.get(negativeId);
                JSONObject newRelation = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)relation2);
                newRelation.put("amount", (Object)discount.getSpecifiedAmount().subtract(discount.getSpecifiedTax()));
                newRelation.put("tax", (Object)discount.getSpecifiedTax());
                newRelation.put("num", (Object)BigDecimal.ZERO);
                newRelation.put("price", (Object)BigDecimal.ZERO);
                if (discountItem == null) {
                    JSONObject preItem = newItems.getJSONObject(newItems.size() - 1);
                    preItem.put("rowtype", (Object)"2");
                    discountItem = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)preItem);
                    discountItem.put("id", (Object)("items" + RandomString.getRandom((int)32)));
                    discountItem.put("specification", (Object)"");
                    discountItem.put("unit", (Object)"");
                    discountItem.put("unitprice", (Object)BigDecimal.ZERO);
                    discountItem.put("taxunitprice", (Object)BigDecimal.ZERO);
                    discountItem.put("num", (Object)BigDecimal.ZERO);
                    discountItem.put("rowtype", (Object)"1");
                    discountItem.put("amount", (Object)discount.getSpecifiedAmount().subtract(discount.getSpecifiedTax()));
                    discountItem.put("tax", (Object)discount.getSpecifiedTax());
                    discountItem.put("taxamount", (Object)discount.getSpecifiedAmount());
                    newItems.add((Object)discountItem);
                } else {
                    discountItem.put("amount", (Object)discountItem.getBigDecimal("amount").add(discount.getSpecifiedAmount()).subtract(discount.getSpecifiedTax()));
                    discountItem.put("tax", (Object)discountItem.getBigDecimal("tax").add(discount.getSpecifiedTax()));
                    discountItem.put("taxamount", (Object)discountItem.getBigDecimal("taxamount").add(discount.getSpecifiedAmount()));
                }
                newRelation.put("tdetailid", discountItem.get((Object)"id"));
                newRelations.add((Object)newRelation);
            }
        }
        customParams.put("items", newItems);
        invRelation.put((String)invRelation.keySet().toArray()[0], (Object)newRelations);
        customParams.put("invRealtion", invRelation);
        this.getView().returnDataToParent((Object)customParams);
        this.getView().close();
    }

    private JSONArray getNewRelations(DynamicObject[] positiveEntry, JSONArray relations) {
        HashSet<String> positiveSet = new HashSet<String>(positiveEntry.length);
        for (DynamicObject positive : positiveEntry) {
            positiveSet.add(positive.getString("positiveid"));
            String positiveDiscountId = positive.getString("positivediscountid");
            if (!StringUtils.isNotBlank((CharSequence)positiveDiscountId)) continue;
            positiveSet.add(positiveDiscountId);
        }
        JSONArray newRelations = new JSONArray();
        Iterator iterator = relations.iterator();
        while (iterator.hasNext()) {
            JSONObject relation = (JSONObject)iterator.next();
            if (!positiveSet.contains(relation.getString("tdetailid"))) continue;
            iterator.remove();
            newRelations.add((Object)relation);
        }
        return newRelations;
    }

    private void createInvoiceItemsAndRelation() {
        EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
        DynamicObject[] negativeObjs = negativeEntry.getEntryData().getDataEntitys();
        for (int i = 0; i < negativeObjs.length; ++i) {
            BigDecimal unspecifiedAmount = negativeObjs[i].getBigDecimal("negative_unspecified");
            if (unspecifiedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f85\u6307\u5b9a\u8d1f\u6570\u884c\u7684\u5f85\u6307\u5b9a\u542b\u7a0e\u91d1\u989d\u4e0d\u4e3a0", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject billInvoiceJson = (JSONObject)customParams.get("treatmentInvoiceList");
        String mergeBillId = billInvoiceJson.keySet().toArray(new String[0])[0];
        JSONObject mergeInvoice = billInvoiceJson.getJSONArray(mergeBillId).getJSONObject(0);
        Map<String, JSONObject> idItemsMap = mergeInvoice.getJSONArray("items").stream().map(item -> (JSONObject)item).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (v1, v2) -> v1));
        JSONObject invRelation = (JSONObject)customParams.get("invRealtion");
        List<JSONObject> relationList = invRelation.getJSONArray(mergeBillId).stream().map(relation -> (JSONObject)relation).collect(Collectors.toList());
        List specifiedDiscountRelationList = JSONObject.parseArray((String)this.getPageCache().get(POSITIVE_RELATION), SpecifiedDiscountRelationDTO.class);
        EntryGrid entry = (EntryGrid)this.getControl("positiveentry");
        DynamicObject[] positiveEntry = entry.getEntryData().getDataEntitys();
        JSONArray newItems = new JSONArray();
        JSONArray newRelations = new JSONArray();
        ArrayList<SpecifiedDiscountRelationDTO> relationArr = new ArrayList<SpecifiedDiscountRelationDTO>();
        for (DynamicObject positive : positiveEntry) {
            BigDecimal specifiedAmount;
            String positiveId = positive.getString("positiveid");
            JSONObject normalItem = idItemsMap.get(positiveId);
            newItems.add((Object)normalItem);
            newRelations.addAll((Collection)relationList.stream().filter(relation -> relation.getString("tdetailid").equals(normalItem.getString("id"))).collect(Collectors.toList()));
            String discountId = positive.getString("positivediscountid");
            if (StringUtils.isNotBlank((CharSequence)discountId)) {
                JSONObject originDiscountItem = idItemsMap.get(discountId);
                newItems.add((Object)originDiscountItem);
                newRelations.addAll((Collection)relationList.stream().filter(relation -> relation.getString("tdetailid").equals(originDiscountItem.getString("id"))).collect(Collectors.toList()));
            }
            if ((specifiedAmount = positive.getBigDecimal("positive_specified")).compareTo(BigDecimal.ZERO) == 0) continue;
            List<SpecifiedDiscountRelationDTO> specifiedDiscountRelations = specifiedDiscountRelationList.stream().filter(relation -> relation.gettBillId().equals(positiveId)).collect(Collectors.toList());
            relationArr.addAll(this.dealSpecifiedDiscountRow(newItems, normalItem, specifiedDiscountRelations));
        }
        newRelations.addAll((Collection)this.dealRelations(relationList, relationArr));
        mergeInvoice.put("mergelable", (Object)"1");
        mergeInvoice.put("items", (Object)newItems);
        invRelation.put(mergeBillId, (Object)newRelations);
        customParams.put("treatmentInvoiceList", billInvoiceJson);
        customParams.put("invRealtion", invRelation);
        this.getView().returnDataToParent((Object)customParams);
        this.getView().close();
    }

    private List<SpecifiedDiscountRelationDTO> dealSpecifiedDiscountRow(JSONArray newItems, JSONObject normalClone, List<SpecifiedDiscountRelationDTO> specifiedDiscountRelations) {
        ArrayList<SpecifiedDiscountRelationDTO> relationArr = new ArrayList<SpecifiedDiscountRelationDTO>(specifiedDiscountRelations.size());
        for (SpecifiedDiscountRelationDTO specifiedDiscountRelation : specifiedDiscountRelations) {
            JSONObject preItem = newItems.getJSONObject(newItems.size() - 1);
            boolean isExistDiscountRow = "1".equals(preItem.getString("rowtype"));
            SpecifiedDiscountRelationDTO relation = new SpecifiedDiscountRelationDTO(specifiedDiscountRelation.getsBillId(), specifiedDiscountRelation.getSpecifiedAmount(), specifiedDiscountRelation.getSpecifiedTax());
            if (isExistDiscountRow) {
                preItem.put("taxamount", (Object)preItem.getBigDecimal("taxamount").add(specifiedDiscountRelation.getSpecifiedAmount()));
                preItem.put("tax", (Object)preItem.getBigDecimal("tax").add(specifiedDiscountRelation.getSpecifiedTax()));
                preItem.put("amount", (Object)preItem.getBigDecimal("amount").add(specifiedDiscountRelation.getSpecifiedAmount().subtract(specifiedDiscountRelation.getSpecifiedTax())));
                relation.settBillId(preItem.getString("id"));
            } else {
                preItem.put("rowtype", (Object)"2");
                JSONObject negativeClone = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)normalClone);
                negativeClone.put("id", (Object)("items" + RandomString.getRandom((int)32)));
                negativeClone.put("taxamount", (Object)specifiedDiscountRelation.getSpecifiedAmount());
                negativeClone.put("tax", (Object)specifiedDiscountRelation.getSpecifiedTax());
                negativeClone.put("amount", (Object)specifiedDiscountRelation.getSpecifiedAmount().subtract(specifiedDiscountRelation.getSpecifiedTax()));
                negativeClone.put("num", null);
                negativeClone.put("unitprice", null);
                negativeClone.put("taxunitprice", null);
                negativeClone.put("specification", (Object)"");
                negativeClone.put("unit", (Object)"");
                negativeClone.put("rowtype", (Object)"1");
                newItems.add((Object)negativeClone);
                relation.settBillId(negativeClone.getString("id"));
            }
            relationArr.add(relation);
        }
        return relationArr;
    }

    private JSONArray dealRelations(List<JSONObject> relationList, List<SpecifiedDiscountRelationDTO> specifiedDiscountRelationList) {
        JSONArray relationArr = new JSONArray();
        EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
        DynamicObject[] negativeArr = negativeEntry.getEntryData().getDataEntitys();
        Map<String, String> negativeDiscountMap = Arrays.stream(negativeArr).collect(Collectors.toMap(k -> k.getString("negativeid"), v -> v.getString("negativediscountid"), (v1, v2) -> v1));
        Map<String, List<SpecifiedDiscountRelationDTO>> relationGroup = specifiedDiscountRelationList.stream().collect(Collectors.groupingBy(SpecifiedDiscountRelationDTO::getsBillId));
        Set<Map.Entry<String, List<SpecifiedDiscountRelationDTO>>> entries = relationGroup.entrySet();
        for (Map.Entry<String, List<SpecifiedDiscountRelationDTO>> entry : entries) {
            String negativeDiscountId = negativeDiscountMap.get(entry.getKey());
            List relations = relationList.stream().filter(relation -> relation.getString("tdetailid").equals(entry.getKey()) || relation.getString("tdetailid").equals(negativeDiscountId)).sorted(Comparator.comparing(relation -> relation.getBigDecimal("amount"))).collect(Collectors.toList());
            List<SpecifiedDiscountRelationDTO> specifiedDiscountRelations = entry.getValue();
            for (int i = 0; i < specifiedDiscountRelations.size(); ++i) {
                JSONObject newRelation;
                SpecifiedDiscountRelationDTO specifiedDiscountRelation = specifiedDiscountRelations.get(i);
                Iterator iterator = relations.iterator();
                while (iterator.hasNext()) {
                    JSONObject relation2 = (JSONObject)iterator.next();
                    BigDecimal amount = specifiedDiscountRelation.getSpecifiedAmount().subtract(specifiedDiscountRelation.getSpecifiedTax());
                    newRelation = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)relation2);
                    if (amount.compareTo(relation2.getBigDecimal("amount")) <= 0) {
                        newRelation.put("tdetailid", (Object)specifiedDiscountRelation.gettBillId());
                        newRelation.put("price", null);
                        newRelation.put("num", null);
                        specifiedDiscountRelation.setSpecifiedAmount(specifiedDiscountRelation.getSpecifiedAmount().subtract(relation2.getBigDecimal("amount")).subtract(relation2.getBigDecimal("tax")));
                        specifiedDiscountRelation.setSpecifiedTax(specifiedDiscountRelation.getSpecifiedTax().subtract(relation2.getBigDecimal("tax")));
                        relationArr.add((Object)newRelation);
                        iterator.remove();
                        continue;
                    }
                    newRelation.put("amount", (Object)amount);
                    newRelation.put("tax", (Object)specifiedDiscountRelation.getSpecifiedTax());
                    newRelation.put("tdetailid", (Object)specifiedDiscountRelation.gettBillId());
                    newRelation.put("price", null);
                    newRelation.put("num", null);
                    relation2.put("amount", (Object)relation2.getBigDecimal("amount").subtract(amount));
                    relation2.put("tax", (Object)relation2.getBigDecimal("tax").subtract(specifiedDiscountRelation.getSpecifiedTax()));
                    relationArr.add((Object)newRelation);
                    break;
                }
                if (CollectionUtils.isEmpty(relations) || i != specifiedDiscountRelations.size() - 1) continue;
                for (JSONObject relation3 : relations) {
                    newRelation = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)relation3);
                    newRelation.put("price", null);
                    newRelation.put("num", null);
                    newRelation.put("tdetailid", (Object)specifiedDiscountRelation.gettBillId());
                    relationArr.add((Object)newRelation);
                }
            }
        }
        return relationArr;
    }

    private static class PositiveEntry {
        private static final String ENTRY_NAME = "positiveentry";
        private static final String POSITIVEID = "positiveid";
        private static final String POSITIVEDISCOUNTID = "positivediscountid";
        private static final String POSITIVE_BILLNO = "positive_billno";
        private static final String POSITIVE_GOODSNAME = "positive_goodsname";
        private static final String POSITIVE_TAXRATE = "positive_taxrate";
        private static final String POSITIVE_TAXAMOUNT = "positive_taxamount";
        private static final String POSITIVE_DISCOUNTAMOUNT = "positive_discountamount";
        private static final String POSITIVE_SPECIFIED = "positive_specified";
        private static final String POSITIVE_UNSPECIFIED = "positive_unspecified";
        private static final String POSITIVE_SPECIFI = "positive_specifi";

        private PositiveEntry() {
        }
    }

    private static class NegativeEntry {
        private static final String ENTRY_NAME = "negativeentry";
        private static final String NEGATIVEID = "negativeid";
        private static final String NEGATIVEDISCOUNTID = "negativediscountid";
        private static final String NEGATIVE_BILLNO = "negative_billno";
        private static final String NEGATIVE_GOODSNAME = "negative_goodsname";
        private static final String NEGATIVE_TAXRATE = "negative_taxrate";
        private static final String NEGATIVE_TAX = "negative_tax";
        private static final String NEGATIVE_SPECIFIED_TAX = "negative_specified_tax";
        private static final String NEGATIVE_TAXAMOUNT = "negative_taxamount";
        private static final String NEGATIVE_SPECIFIED = "negative_specified";
        private static final String NEGATIVE_UNSPECIFIED = "negative_unspecified";

        private NegativeEntry() {
        }
    }
}

