/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.home;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.allele.AllEleCreditQuotaResponseDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.service.SxedService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceHomePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("daterangefield_startdate", (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        this.getModel().setValue("daterangefield_enddate", (Object)new Date());
        this.getModel().setValue("orgid", (Object)RequestContext.get().getOrgId());
        this.queryDate();
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("orgid");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        HasPermOrgResult userHasPermOrgs;
        Control source = (Control)beforeF7SelectEvent.getSource();
        if ("orgid".equals(source.getKey()) && !(userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()))).hasAllOrgPerm()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)userHasPermOrgs.getHasPermOrgs()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.queryDate();
    }

    public void queryDate() {
        String invoiceType;
        Date end;
        Date start;
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid"));
        QFilter qFilter = new QFilter("orgid", "=", (Object)orgId);
        if ("1".equals(ImcConfigUtil.getValue((String)"sharding", (String)"sim_vatinovice"))) {
            try {
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
                qFilter.and("salertaxno", "=", (Object)saleInfo.getSaleTaxNo());
            }
            catch (Exception saleInfo) {
                // empty catch block
            }
        }
        if ((start = (Date)this.getModel().getValue("daterangefield_startdate")) != null) {
            qFilter.and("issuetime", ">=", (Object)start);
        }
        if ((end = (Date)this.getModel().getValue("daterangefield_enddate")) != null) {
            qFilter.and("issuetime", "<", (Object)DateUtils.addDay((Date)DateUtils.trunc((Date)end), (int)1));
        }
        if (!"all".equals(invoiceType = (String)this.getModel().getValue("invoicetype"))) {
            qFilter.and("invoicetype", "=", (Object)invoiceType);
        }
        qFilter.and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        String selectFields = String.format("%s,%s,%s,%s,%s,%s", "id", "invoiceamount", "totaltax", "totalamount", "issuetype", "invoicestatus");
        DynamicObjectCollection vatInvoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)selectFields, (QFilter[])qFilter.toArray());
        Integer blueNum = 0;
        BigDecimal blueAmount = new BigDecimal(0);
        BigDecimal blueTax = new BigDecimal(0);
        BigDecimal blueTaxAmount = new BigDecimal(0);
        Integer redNum = 0;
        BigDecimal redAmount = new BigDecimal(0);
        BigDecimal redTax = new BigDecimal(0);
        BigDecimal redTaxAmount = new BigDecimal(0);
        Integer cancelNum = 0;
        BigDecimal cancelAmount = new BigDecimal(0);
        BigDecimal cancelTax = new BigDecimal(0);
        BigDecimal cancelTaxAmount = new BigDecimal(0);
        for (DynamicObject vatInvoice : vatInvoices) {
            IssueType issueType;
            Integer n;
            String invoiceStatus = vatInvoice.getString("invoicestatus");
            if (StringUtils.isBlank((CharSequence)invoiceStatus)) continue;
            if (invoiceStatus.equals("6")) {
                cancelAmount = cancelAmount.add(vatInvoice.getBigDecimal("invoiceamount"));
                cancelTax = cancelTax.add(vatInvoice.getBigDecimal("totaltax"));
                cancelTaxAmount = cancelTaxAmount.add(vatInvoice.getBigDecimal("totalamount"));
                Integer n2 = cancelNum;
                n = cancelNum = Integer.valueOf(cancelNum + 1);
                continue;
            }
            if (!InvoiceStatus.isNotAbolishInv((String)invoiceStatus) || Objects.isNull(issueType = IssueType.getIssueType((String)vatInvoice.getString("issuetype")))) continue;
            switch (issueType) {
                case BLUE_INVOICE: {
                    blueAmount = blueAmount.add(vatInvoice.getBigDecimal("invoiceamount"));
                    blueTax = blueTax.add(vatInvoice.getBigDecimal("totaltax"));
                    blueTaxAmount = blueTaxAmount.add(vatInvoice.getBigDecimal("totalamount"));
                    n = blueNum;
                    Integer n3 = blueNum = Integer.valueOf(blueNum + 1);
                    break;
                }
                case RED_INVOICE: {
                    redAmount = redAmount.add(vatInvoice.getBigDecimal("invoiceamount"));
                    redTax = redTax.add(vatInvoice.getBigDecimal("totaltax"));
                    redTaxAmount = redTaxAmount.add(vatInvoice.getBigDecimal("totalamount"));
                    n = redNum;
                    Integer n3 = redNum = Integer.valueOf(redNum + 1);
                }
            }
        }
        this.getModel().setValue("blueinvoicenum", (Object)blueNum);
        this.getModel().setValue("blueinvoiceamount", (Object)blueAmount.setScale(2, 4));
        this.getModel().setValue("blueinvoicetax", (Object)blueTax.setScale(2, 4));
        this.getModel().setValue("blueinvoicetox", (Object)blueTaxAmount.setScale(2, 4));
        this.getModel().setValue("redinvoicenum", (Object)redNum);
        this.getModel().setValue("redinvoiceamount", (Object)redAmount.setScale(2, 4));
        this.getModel().setValue("redinvoicetax", (Object)redTax.setScale(2, 4));
        this.getModel().setValue("redinvoicetotaltax", (Object)redTaxAmount.setScale(2, 4));
        this.getModel().setValue("cancelinvoicenum", (Object)cancelNum);
        this.getModel().setValue("cancelinvoiceamount", (Object)cancelAmount.setScale(2, 4));
        this.getModel().setValue("cancelinvoicetax", (Object)cancelTax.setScale(2, 4));
        this.getModel().setValue("cancelinvoicetotaltax", (Object)cancelTaxAmount.setScale(2, 4));
        this.showOrHideCreditQuota();
    }

    private void showOrHideCreditQuota() {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid"));
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (org == null) {
            this.showOrHideCreditQuotaFlex(Boolean.FALSE);
            return;
        }
        DynamicObject epInfo = org.getDynamicObject("epinfo");
        if (epInfo == null || StringUtils.isBlank((CharSequence)epInfo.getString("number"))) {
            this.showOrHideCreditQuotaFlex(Boolean.FALSE);
            return;
        }
        String taxNo = epInfo.getString("number");
        boolean isLq = EnterpriseHelper.isLqptChannel((String)taxNo);
        if (isLq || QueryServiceHelper.exists((String)"bdm_einvoice_account", (QFilter[])new QFilter("epinfo", "=", epInfo.getPkValue()).toArray())) {
            BigDecimal creditQuota;
            BigDecimal totalCreditQuota;
            this.showOrHideCreditQuotaFlex(Boolean.TRUE);
            if (isLq) {
                AllEleCreditQuotaResponseDTO allEleCreditQuotaResponseDTO = new SxedService().querySxed(taxNo);
                totalCreditQuota = new BigDecimal(allEleCreditQuotaResponseDTO.getTotalVolume());
                creditQuota = new BigDecimal(allEleCreditQuotaResponseDTO.getAvailableVolume());
            } else {
                totalCreditQuota = this.getCreditQuota("totalCreditQuota_" + taxNo);
                creditQuota = this.getCreditQuota("creditQuota_" + taxNo);
            }
            this.getModel().setValue("totalcreditquota", (Object)totalCreditQuota);
            this.getModel().setValue("creditquota", (Object)creditQuota);
            this.getModel().setValue("usecreditquota", (Object)totalCreditQuota.subtract(creditQuota));
        } else {
            this.showOrHideCreditQuotaFlex(Boolean.FALSE);
        }
    }

    private BigDecimal getCreditQuota(String key) {
        String creditQuota = CacheHelper.get((String)key);
        if (StringUtils.isBlank((CharSequence)creditQuota)) {
            creditQuota = "0.00";
        }
        return new BigDecimal(creditQuota.replaceAll(",", ""));
    }

    private void showOrHideCreditQuotaFlex(Boolean show) {
        this.getView().setVisible(show, new String[]{"creditquotaflex"});
        this.getView().setVisible(Boolean.valueOf(show == false), new String[]{"blueinvoiceamountflex", "redinvoiceamountflex", "cancelinvoiceamountflex"});
    }
}

