/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.dto.InvoiceBatchImportProcessVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.MsgSendAuthHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.invoicebatch.InvoiceBatchFileImportUtil;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class InvoiceBatchFileImportPlugin
extends AbstractFormPlugin
implements UploadListener,
SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(InvoiceBatchFileImportPlugin.class);
    private static final String BTN_DOWNLOAD_BLUE = "downtempblue";
    private static final String BTN_DOWNLOAD_RED = "downtempred";
    private static final String BTN_DOWNLOAD_EINVOICE = "downtempeinvoice";
    private static final String BTN_UPLOAD = "btn_upload";
    private static final String BTN_RESET_FILE = "btn_reset_file";
    private static final String EXCELUP_LOAD = "excelupload";
    private static final String TEMPLATE_DIR = "excel_templates";
    private static final String TEMPLATE_JSON_NAME = "InvoiceBatch.json";
    private static final String TEMPLATE_RED_JSON_NAME = "InvoiceBatchRed.json";
    private static final String TEMPLATE_AllE_JSON_NAME = "AllEInvoiceBatch.json";
    private static final String IMPORT_ALL_EINVOICE = "import_all_einvoice";
    public static final int GOODSNAME_LENGTH = 92;
    public static final int UNIT_LENGTH = 22;
    public static final int SPECIFICATION_LENGTH = 40;
    private static final String DETAIL_STATE = "-1";
    private static final ImmutableSet<String> POLICY_CONTENTS = new ImmutableSet.Builder().add((Object[])new String[]{"\u51fa\u53e3\u514d\u7a0e\u548c\u5176\u5b83\u514d\u7a0e\u4f18\u60e0\u653f\u7b56", "\u4e0d\u5f81\u589e\u503c\u7a0e", "\u5373\u5f81\u5373\u900050%"}).add((Object[])new String[]{"\u5373\u5f81\u5373\u900030%", "\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", "\u7a00\u571f\u4ea7\u54c1"}).add((Object[])new String[]{"\u8d85\u7a0e\u8d1f12%\u5373\u5f81\u5373\u9000", "\u4e0d\u5f81\u7a0e", "\u5373\u5f81\u5373\u900070%"}).add((Object[])new String[]{"\u7b80\u6613\u5f81\u6536", "\u63093%\u7b80\u6613\u5f81\u6536", "\u5373\u5f81\u5373\u9000100%"}).add((Object)"\u514d\u7a0e").add((Object[])new String[]{"50%\u5148\u5f81\u540e\u9000", "\u5148\u5f81\u540e\u9000", "\u63095%\u7b80\u6613\u5f81\u6536"}).add((Object[])new String[]{"\u8d85\u7a0e\u8d1f8%\u5373\u5f81\u5373\u9000", "100%\u5148\u5f81\u540e\u9000", "\u8d85\u7a0e\u8d1f3%\u5373\u5f81\u5373\u9000"}).build();

    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String issueType = customParams.get("issuetype").toString();
        this.getModel().setValue("issuetype", (Object)issueType);
        String importKey = (String)customParams.get("importKey");
        if (IMPORT_ALL_EINVOICE.equals(importKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attention", "attention2", BTN_DOWNLOAD_BLUE, "red_attention", BTN_DOWNLOAD_RED});
        } else if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attention", "attention2", "einvoice_attention", BTN_DOWNLOAD_BLUE, BTN_DOWNLOAD_EINVOICE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"red_attention", "einvoice_attention", BTN_DOWNLOAD_RED, BTN_DOWNLOAD_EINVOICE});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getModel().setValue("batchbelong", (Object)DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
    }

    private String getValidJsonName() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String importKey = (String)customParams.get("importKey");
        if (IMPORT_ALL_EINVOICE.equals(importKey)) {
            return TEMPLATE_AllE_JSON_NAME;
        }
        String issueType = customParams.get("issuetype").toString();
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            return TEMPLATE_RED_JSON_NAME;
        }
        return TEMPLATE_JSON_NAME;
    }

    private String getTemplateName() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String importKey = (String)customParams.get("importKey");
        if (IMPORT_ALL_EINVOICE.equals(importKey)) {
            return "\u6570\u7535\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx";
        }
        String issueType = customParams.get("issuetype").toString();
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            return "\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f-\u8d1f\u6570\u666e\u901a\u53d1\u7968.xlsx";
        }
        return "\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx";
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_DOWNLOAD_BLUE, BTN_DOWNLOAD_RED, BTN_RESET_FILE, EXCELUP_LOAD, BTN_DOWNLOAD_EINVOICE});
        Image label = (Image)this.getControl(BTN_UPLOAD);
        label.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            IDataModel model = this.getModel();
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue("filepath", (Object)url);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_RESET_FILE.equalsIgnoreCase(key)) {
            String filepath = (String)this.getModel().getValue("filepath");
            FileUploadUtils.delete((String)filepath);
            this.getModel().setValue("filename", (Object)"");
            this.getModel().setValue("filepath", (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
        } else if (EXCELUP_LOAD.equalsIgnoreCase(key)) {
            String batchbelong = this.getModel().getValue("batchbelong").toString();
            String issuetype = "\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f-\u8d1f\u6570\u666e\u901a\u53d1\u7968.xlsx".equalsIgnoreCase(this.getTemplateName()) ? IssueType.RED_INVOICE.getTypeCode() : IssueType.BLUE_INVOICE.getTypeCode();
            this.batcheBelongCheck(batchbelong, issuetype);
        } else if (key.startsWith("downtemp")) {
            String templateName;
            String issuetype = this.getModel().getValue("issuetype").toString();
            String string = templateName = IssueType.BLUE_INVOICE.getTypeCode().equals(issuetype) ? "\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx" : "\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f-\u8d1f\u6570\u666e\u901a\u53d1\u7968.xlsx";
            if (IMPORT_ALL_EINVOICE.equals(this.getView().getFormShowParameter().getCustomParam("importKey"))) {
                templateName = "\u6570\u7535\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx";
            }
            ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)templateName);
        }
    }

    private void batcheBelongCheck(String batchbelong, String issuetype) {
        if (batchbelong.equalsIgnoreCase("") || batchbelong.length() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceBatchFileImportPlugin_100", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        QFilter filter = new QFilter("batchbelong", "=", (Object)batchbelong);
        DynamicObject dObject = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"batchbelong", (QFilter[])new QFilter[]{filter});
        if (dObject != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u6279\u6b21\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u672c\u6b21\u7684\u5f00\u7968\u6279\u6b21", (String)"InvoiceBatchFileImportPlugin_101", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.importData(batchbelong, issuetype);
    }

    private void importData(String batchbelong, String issuetype) {
        String filepath = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)filepath)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c", (String)"InvoiceBatchFileImportPlugin_102", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream inputStream = service.getInputStream(filepath);
        try (Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            StringBuilder strMsg = new StringBuilder();
            String fileName = filepath.substring(filepath.lastIndexOf(47) + 1, filepath.lastIndexOf(46));
            String suffix = filepath.substring(filepath.lastIndexOf(46));
            strMsg.append(fileName).append(ResManager.loadKDString((String)"-\u9519\u8bef\u4fe1\u606f", (String)"InvoiceBatchFileImportPlugin_103", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(suffix);
            if (suffix.equalsIgnoreCase(".xlsx") || suffix.equalsIgnoreCase(".xls")) {
                int failRowNum;
                if (workbook.getSheetAt(0).getLastRowNum() > 5000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"excel\u6570\u636e\u6700\u5927\u4e0d\u8d85\u8fc75000\u884c", (String)"InvoiceBatchFileImportPlugin_104", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                Row titleRow = workbook.getSheetAt(0).getRow(1);
                InvoiceBatchImportProcessVo process = this.getInvoiceBatchImportProcessVo();
                String validJsonName = this.getValidJsonName();
                List fileFields = ExcelHelper.getFileFields((Row)titleRow, (List)ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)validJsonName));
                if (fileFields.size() < titleRow.getLastCellNum()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e0d\u662f\u6700\u65b0\u6a21\u677f\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\u540e\u518d\u505a\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_105", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map<String, FileField> fieldMap = fileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
                HashMap<String, String> errMap = new HashMap<String, String>();
                Map mapList = InvoiceBatchFileImportUtil.doParse((Workbook)workbook, (List)fileFields, (int)2, errMap, (String)"bill");
                HashSet<String> errorRowSet = this.getErrorRowSet(workbook, errMap, process);
                int baseSuccessSize = 0;
                for (Map.Entry entry : mapList.entrySet()) {
                    baseSuccessSize += ((LinkedList)entry.getValue()).size();
                }
                int totalRow = errorRowSet.size() + baseSuccessSize;
                process.setErrorBillNoMap(errorRowSet);
                List<Object> objs = new ArrayList();
                if (mapList.size() > 0) {
                    objs = this.checkAndFillData(workbook, mapList, fieldMap, errMap, batchbelong, process);
                    RequestContext context = RequestContext.get();
                    for (DynamicObject dynamicObject : objs) {
                        DynamicObjectCollection batchItems = dynamicObject.getDynamicObjectCollection("items");
                        if (batchItems.isEmpty()) continue;
                        BigDecimal totalTax = BigDecimal.ZERO;
                        BigDecimal totalPrice = BigDecimal.ZERO;
                        Boolean taxFlag = Boolean.TRUE;
                        BigDecimal deduction = dynamicObject.getBigDecimal("deduction");
                        String hsbz = dynamicObject.getString("hsbz");
                        BigDecimal taxRate = null;
                        for (DynamicObject dDetail : batchItems) {
                            String taxRateStr;
                            if (hsbz.equals("0")) {
                                taxFlag = Boolean.FALSE;
                            }
                            if (StringUtils.isNotBlank((CharSequence)(taxRateStr = dDetail.getString("taxrate")))) {
                                taxRate = new BigDecimal(taxRateStr);
                            }
                            BigDecimal detailTax = dDetail.getBigDecimal("tax");
                            if ("1".equals(hsbz)) {
                                BigDecimal hsAmount = dDetail.getBigDecimal("taxamount");
                                BigDecimal bhsAmount = hsAmount.subtract(detailTax);
                                dDetail.set("amount", (Object)bhsAmount);
                                totalPrice = totalPrice.add(bhsAmount);
                            } else if ("0".equals(hsbz)) {
                                BigDecimal bhsAmount = dDetail.getBigDecimal("amount");
                                BigDecimal hsAmount = bhsAmount.add(detailTax);
                                dDetail.set("taxamount", (Object)hsAmount);
                                totalPrice = totalPrice.add(bhsAmount);
                            }
                            totalTax = totalTax.add(detailTax);
                            dDetail.set("tax", (Object)detailTax);
                            ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)dDetail);
                        }
                        dynamicObject.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
                        BigDecimal totalAmountAndTax = totalTax.add(totalPrice);
                        if (deduction.compareTo(BigDecimal.ZERO) != 0) {
                            totalTax = TaxCalcUtil.calTax((BigDecimal)("1".equals(hsbz) ? totalAmountAndTax : totalPrice), (BigDecimal)deduction, (BigDecimal)taxRate, (Boolean)"1".equals(hsbz), (Boolean)Boolean.FALSE, (int)2);
                        }
                        dynamicObject.set("buyertype", (Object)"1");
                        dynamicObject.set("invoiceamount", (Object)totalPrice);
                        dynamicObject.set("totaltax", (Object)totalTax);
                        dynamicObject.set("totalamount", (Object)totalAmountAndTax);
                        dynamicObject.set("invoicingoperator", (Object)Long.parseLong(context.getUserId()));
                        if (!taxFlag.booleanValue()) {
                            dynamicObject.set("hsbz", (Object)"0");
                            continue;
                        }
                        dynamicObject.set("hsbz", (Object)"1");
                    }
                    this.saveInvoiceBatchInfo(objs);
                }
                int successNum = 0;
                if (!objs.isEmpty()) {
                    for (DynamicObject dynamicObject : objs) {
                        DynamicObjectCollection numCollection = dynamicObject.getDynamicObjectCollection("items");
                        successNum += numCollection.size();
                    }
                }
                if ((failRowNum = "\u6570\u7535\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx".equals(process.getTemplateName()) ? totalRow - successNum : workbook.getSheetAt(0).getLastRowNum() - 1 - successNum) > 0) {
                    InvoiceBatchFileImportUtil.showBatchFileImportResult((Workbook)workbook, (String)strMsg.toString(), (IFormView)this.getView(), (int)successNum, (int)failRowNum, errMap);
                } else {
                    this.getView().returnDataToParent((Object)"success");
                    this.getView().close();
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u6a21\u677f\u7684Excel\u6587\u4ef6", (String)"InvoiceBatchFileImportPlugin_106", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private HashSet<String> getErrorRowSet(Workbook workbook, Map<String, String> errMap, InvoiceBatchImportProcessVo process) {
        HashSet<String> errorBillNoSet = new HashSet<String>();
        if (!"\u6570\u7535\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx".equals(process.getTemplateName())) {
            return errorBillNoSet;
        }
        try {
            HashSet<Integer> errRowSet = new HashSet<Integer>();
            for (Map.Entry<String, String> entry : errMap.entrySet()) {
                String key = entry.getKey();
                boolean isNormal = false;
                StringBuilder rowNumStr = new StringBuilder();
                for (int i = 0; i < key.length(); ++i) {
                    char c = key.charAt(i);
                    if ('\u7b2c' == c) continue;
                    if ('\u884c' == c) break;
                    if (c != '0') {
                        isNormal = true;
                    }
                    if (!isNormal) continue;
                    rowNumStr = rowNumStr.append(c);
                }
                try {
                    int rowIntValue = Integer.parseInt(rowNumStr.toString());
                    errRowSet.add(rowIntValue - 1);
                }
                catch (Exception rowIntValue) {}
            }
            Sheet sheet = workbook.getSheetAt(0);
            Integer first = 0;
            for (Integer errorIndex : errRowSet) {
                Row row = sheet.getRow(errorIndex.intValue());
                if (row == null) continue;
                Cell billnumber = row.getCell(first.intValue());
                String billnumberNo = ExcelHelper.getStringValueFromCell((Cell)billnumber);
                errorBillNoSet.add(billnumberNo);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return errorBillNoSet;
    }

    private InvoiceBatchImportProcessVo getInvoiceBatchImportProcessVo() {
        String templateName = this.getTemplateName();
        InvoiceBatchImportProcessVo process = new InvoiceBatchImportProcessVo();
        process.setTemplateName(templateName);
        if ("\u6570\u7535\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f.xlsx".equals(templateName)) {
            QFilter baseDataFilter = ImcBaseDataHelper.getOperatorFilter((Object)RequestContext.get().getOrgId());
            DynamicObject[] operators = BusinessDataServiceHelper.load((String)"bdm_operator_info", (String)"id,number", (QFilter[])baseDataFilter.toArray());
            HashMap<String, DynamicObject> opertorMap = new HashMap<String, DynamicObject>();
            for (DynamicObject operator : operators) {
                opertorMap.put(operator.getString("number"), operator);
            }
            process.setOperatorMap(opertorMap);
        }
        String issueType = "\u6279\u91cf\u5f00\u7968\u5bfc\u5165\u6a21\u677f-\u8d1f\u6570\u666e\u901a\u53d1\u7968.xlsx".equalsIgnoreCase(templateName) ? IssueType.RED_INVOICE.getTypeCode() : IssueType.BLUE_INVOICE.getTypeCode();
        process.setIssueType(issueType);
        return process;
    }

    private void saveInvoiceBatchInfo(List<DynamicObject> dynamicObjectList) {
        SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
    }

    /*
     * Could not resolve type clashes
     */
    private List<DynamicObject> checkAndFillData(Workbook workbook, Map<String, LinkedList<Map<String, Object>>> mapList, Map<String, FileField> fieldMap, Map<String, String> errMap, String batchbelong, InvoiceBatchImportProcessVo process) {
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg();
        String issuetype = process.getIssueType();
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(mapList.size());
        boolean isTobacco = TaxUtils.isTobaccoEnterprise((Long)RequestContext.get().getOrgId());
        Map TAX_NUMBER_MAP = InvoiceBatchFileImportUtil.queryTaxNumber();
        Date today = new Date();
        Boolean msgSendFlag = MsgSendAuthHelper.msgSendAuthByCurrentOrgId();
        DynamicObject issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)RequestContext.get().getOrgId());
        boolean isSplit = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"));
        boolean isHint = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"));
        String invoiceWaitStatus = BillHelper.getBillStatusByTableName((String)"sim_invoice_wait", (String)"1");
        for (Map.Entry<String, LinkedList<Map<String, Object>>> linkeMaps : mapList.entrySet()) {
            Row row;
            int rowIndex;
            String invoiceType;
            Row row2;
            QFilter billFilter = new QFilter("billno", "=", (Object)linkeMaps.getKey());
            QFilter orgFilter = new QFilter("orgid", "=", (Object)RequestContext.get().getOrgId());
            boolean exists = QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])billFilter.and(orgFilter).toArray());
            LinkedList<Map<String, Object>> linkedMap = linkeMaps.getValue();
            int seq = 0;
            Boolean addFlag = Boolean.TRUE;
            BigDecimal addMoney = new BigDecimal(DETAIL_STATE);
            BigDecimal taxMoney = BigDecimal.ZERO;
            BigDecimal countAmout = BigDecimal.ZERO;
            String taxKinds = linkedMap.getFirst().get("hsbz").toString();
            String lastTaxRate = linkedMap.getFirst().get("taxrate").toString();
            HashSet<String> isTobaccoSet = new HashSet<String>(2);
            Boolean tobaccoFlag = Boolean.FALSE;
            Boolean switchFlag = Boolean.TRUE;
            boolean farmTaxRateCodeNum = false;
            boolean totalTaxRateCodeNum = false;
            for (Map map : linkedMap) {
                String specification;
                map.put("issuetype", issuetype);
                this.setSpecialType(map);
                this.dealExcelChoose(map);
                Integer rowIndex2 = Integer.parseInt(map.get("rowIndex").toString());
                row2 = workbook.getSheetAt(0).getRow(rowIndex2.intValue());
                invoiceType = (String)map.get("invoicetype");
                if (AllEleAuthHelper.elePaperSetValue((Object)saleInfo.getSaleTaxNo(), (Object)invoiceType)) {
                    map.put((String)"iselepaper", (Object)"1");
                }
                boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(map.get("iselepaper"));
                String remark = (String)map.get("remark");
                boolean isCutRemark = InvoiceUtils.isCutRemark((Long)saleInfo.getOrgId());
                if (isAllEle) {
                    if (String.valueOf(remark).length() > 450) {
                        if (isCutRemark) {
                            map.put((String)"remark", (Object)InvoiceUtils.cutRemarkChar((String)remark, (int)450));
                        } else {
                            addFlag = Boolean.FALSE;
                            InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7:450\u5b57\u7b26", (String)"InvoiceBatchFileImportPlugin_196", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"remark");
                        }
                    }
                } else if (GBKUtils.getGBKLength((String)remark) > 230) {
                    if (isCutRemark) {
                        map.put((String)"remark", (Object)GBKUtils.cutGBKString((String)remark, (int)230));
                    } else {
                        addFlag = Boolean.FALSE;
                        InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7:230\u5b57\u8282,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"InvoiceBatchFileImportPlugin_197", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"remark");
                    }
                }
                Map<String, String> goodsInfo = this.checkBillNumber(map, TAX_NUMBER_MAP);
                if (!addFlag.booleanValue()) {
                    switchFlag = false;
                }
                addFlag = this.checkOperator(map, process, row2, rowIndex2, errMap, fieldMap);
                if (exists) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u6b64\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728", (String)"InvoiceBatchFileImportPlugin_107", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"billno");
                    addFlag = Boolean.FALSE;
                }
                if (process.getErrorBillNoMap().contains(map.get("billno"))) {
                    addFlag = Boolean.FALSE;
                }
                Object taxRate = map.get("taxrate");
                addFlag = this.checkAllEInvoice(fieldMap, errMap, addFlag, map, rowIndex2, row2, taxRate, invoiceType);
                if (DETAIL_STATE.equals(goodsInfo.get("success"))) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0\u4e0d\u6b63\u786e\uff0c\u672a\u627e\u5230\u5339\u914d\u9879", (String)"InvoiceBatchFileImportPlugin_108", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"goodsname");
                    addFlag = Boolean.FALSE;
                    continue;
                }
                if (StringUtils.isNotBlank((Object)map.get("goodscode"))) {
                    if (goodsInfo.get("goodscode").equals(map.get("goodscode"))) {
                        map.put((String)"goodscode", (Object)goodsInfo.get("goodscode"));
                    } else {
                        InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0\u548c\u7a0e\u6536\u5408\u5e76\u7f16\u7801\u4e0d\u5339\u914d", (String)"InvoiceBatchFileImportPlugin_109", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"goodscode");
                        addFlag = Boolean.FALSE;
                    }
                } else {
                    map.put((String)"goodscode", (Object)goodsInfo.get("goodscode"));
                }
                DynamicObject goodsSimple = TaxClassCodeCheckHelper.geTaxCode((String)goodsInfo.get("goodscode"));
                if (goodsSimple != null) {
                    String simpleName = '*' + goodsSimple.getString("simplename") + '*';
                    map.put((String)"simplegoodsname", (Object)simpleName);
                    map.put((String)"goodsname", (Object)(simpleName + map.get("goodsname")));
                } else {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5bf9\u5e94\u7684\u5546\u54c1\u7b80\u7801", (String)"InvoiceBatchFileImportPlugin_110", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"goodscode");
                    addFlag = Boolean.FALSE;
                }
                String goodsName = (String)map.get("goodsname");
                if (StringUtils.isBlank((CharSequence)goodsName)) {
                    addFlag = Boolean.FALSE;
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_111", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"goodsname");
                } else if (goodsName.length() > 100 && isSplit) {
                    map.put((String)"goodsname", (Object)StringUtils.substring((String)goodsName, (int)0, (int)100));
                } else if (goodsName.length() > 100 && isHint) {
                    addFlag = Boolean.FALSE;
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ApiErrCodeEnum.INVOICE_OPEN_GOODNAMEISGBK.getMsg(), (String)"goodsname");
                }
                String unit = (String)map.get("unit");
                if (StringUtils.isNotBlank((CharSequence)unit)) {
                    if (GBKUtils.getGBKLength((String)unit) > 22 && isSplit) {
                        map.put((String)"unit", (Object)GBKUtils.cutGBKString((String)unit, (int)22));
                    } else if (GBKUtils.getGBKLength((String)unit) > 22 && isHint) {
                        addFlag = Boolean.FALSE;
                        InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getMsg(), (String)"unit");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(specification = (String)map.get("specification")))) {
                    if (GBKUtils.getGBKLength((String)specification) > 40 && isSplit) {
                        map.put((String)"specification", (Object)GBKUtils.cutGBKString((String)specification, (int)40));
                    } else if (GBKUtils.getGBKLength((String)specification) > 40 && isHint) {
                        addFlag = Boolean.FALSE;
                        InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getMsg(), (String)"specification");
                    }
                }
                boolean isTobaccoDetail = TaxUtils.isTobaccoGoods((String)map.get("goodscode").toString());
                isTobaccoSet.add(Boolean.toString(isTobaccoDetail));
                if (map.get("rowtype").toString().equals("1")) {
                    Map<String, Object> parseMap = this.parseDiscountRow(map, addMoney);
                    map = (Map)parseMap.get("result");
                    addMoney = new BigDecimal(parseMap.get("addMoney").toString());
                } else {
                    boolean isCompany;
                    if (isTobaccoDetail) {
                        tobaccoFlag = Boolean.TRUE;
                        if (isTobacco) {
                            map.put("specialtype", "11");
                            if (map.get("rowtype").toString().equals("2") && StringUtils.isBlank(map.get("unit"))) {
                                InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5377\u70df\u5546\u54c1\u7684\u88ab\u6298\u6263\u884c\u7684'\u5355\u4f4d'\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_112", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"unit");
                                addFlag = Boolean.FALSE;
                            }
                        } else {
                            InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u975e\u5377\u70df\u4f01\u4e1a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u5377\u70df\u660e\u7ec6\u53d1\u7968", (String)"InvoiceBatchFileImportPlugin_113", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"saleraddr");
                            addFlag = Boolean.FALSE;
                        }
                    }
                    if (isCompany = "0".equals(map.get("buyerproperty"))) {
                        this.checkBuyerName(map);
                    }
                    addFlag = this.TAX_PREMARKCheck(map, row2, errMap, addFlag, rowIndex2, fieldMap);
                    Map<String, Object> priceMap = this.priceAndQuantityCheck(map, row2, errMap, addFlag, rowIndex2, fieldMap, addMoney);
                    addFlag = (Boolean)priceMap.get("addFlag");
                    addMoney = new BigDecimal(priceMap.get("addMoney").toString());
                    addFlag = this.baseFieldCheck(map, row2, errMap, addFlag, rowIndex2, fieldMap, msgSendFlag);
                    String string = StringUtils.isBlank((CharSequence)lastTaxRate) ? map.get("taxrate").toString() : (lastTaxRate = !StringUtils.equals((CharSequence)lastTaxRate, (CharSequence)map.get("taxrate").toString()) ? map.get("taxrate").toString() : lastTaxRate);
                }
                if (isTobaccoSet.size() > 1) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex2, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5377\u70df\u4f01\u4e1a\u5f00\u5377\u70df\u7968\uff0c\u660e\u7ec6\u53ea\u80fd\u6709\u5377\u70df\u660e\u7ec6\uff0c\u4e0d\u80fd\u6709\u5377\u70df\u548c\u975e\u5377\u70df", (String)"InvoiceBatchFileImportPlugin_114", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"goodsname");
                    addFlag = Boolean.FALSE;
                }
                addFlag = this.checkFarmSaleItems(map, row2, errMap, addFlag, rowIndex2, fieldMap);
                map.put("orgid", RequestContext.get().getOrgId());
                Map<String, Object> taxMap = this.taxNumberCountAndCheck(map, row2, errMap, addFlag, rowIndex2, fieldMap, taxKinds);
                map = (Map)taxMap.get("result");
                addFlag = (Boolean)taxMap.get("addFlag");
                if (!addFlag.booleanValue()) {
                    switchFlag = false;
                }
                if (!addFlag.booleanValue() || !switchFlag.booleanValue() || !StringUtils.isNotBlank((Object)taxMap.get("countAmout"))) continue;
                taxMoney = taxMoney.add(new BigDecimal(map.get("tax").toString()));
                countAmout = countAmout.add(new BigDecimal(taxMap.get("countAmout").toString()));
            }
            for (int i = 0; i < linkedMap.size(); ++i) {
                Map map;
                map = linkedMap.get(i);
                map.put((String)"seq", seq++);
                if (!"1".equals(map.get("rowtype"))) continue;
                Map<String, Object> lastRow = linkedMap.get(i - 1);
                lastRow.put("rowtype", "2");
            }
            if (IssueType.BLUE_INVOICE.getTypeCode().equals(issuetype) && addMoney.compareTo(BigDecimal.ZERO) == 0) {
                rowIndex = Integer.parseInt(linkedMap.getFirst().get("rowIndex").toString());
                row = workbook.getSheetAt(0).getRow(rowIndex);
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7f16\u53f7\u7684\u660e\u7ec6\u6c47\u603b\u91d1\u989d\u4e3a0\uff0c\u4e0d\u505a\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_115", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                addFlag = Boolean.FALSE;
            } else if (IssueType.RED_INVOICE.getTypeCode().equals(issuetype) && addMoney.compareTo(BigDecimal.ZERO) >= 0) {
                rowIndex = Integer.parseInt(linkedMap.getFirst().get("rowIndex").toString());
                row = workbook.getSheetAt(0).getRow(rowIndex);
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8be5\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u6c47\u603b\u91d1\u989d\u4e3a\u5927\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u505a\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_116", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                addFlag = Boolean.FALSE;
            }
            if (taxMoney.subtract(countAmout).abs().compareTo(BigDecimal.valueOf(1.27)) > 0) {
                rowIndex = Integer.parseInt(linkedMap.getFirst().get("rowIndex").toString());
                row = workbook.getSheetAt(0).getRow(rowIndex);
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7f16\u53f7\u7684'\u7a0e\u989d'\u6c47\u603b\u8bef\u5dee\u5927\u4e8e1.27", (String)"InvoiceBatchFileImportPlugin_117", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"tax");
                addFlag = Boolean.FALSE;
            }
            Boolean redFlag = null;
            try {
                redFlag = this.dealOriginalByRed(issuetype, linkedMap.get(0), addMoney, taxMoney, saleInfo.getSaleTaxNo());
            }
            catch (MsgException e) {
                int rowIndex3 = Integer.parseInt(linkedMap.getFirst().get("rowIndex").toString());
                row2 = workbook.getSheetAt(0).getRow(rowIndex3);
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row2, (Integer)rowIndex3, errMap, fieldMap, (String)e.getErrorMsg(), (String)"billno");
                addFlag = Boolean.FALSE;
            }
            if (null != redFlag && !redFlag.booleanValue()) {
                int rowIndex4 = Integer.parseInt(linkedMap.getFirst().get("rowIndex").toString());
                Row row3 = workbook.getSheetAt(0).getRow(rowIndex4);
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row3, (Integer)rowIndex4, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8be5\u5355\u636e\u603b\u91d1\u989d\u5927\u4e8e\u5bf9\u5e94\u84dd\u7968\u53ef\u7ea2\u51b2\u91d1\u989d", (String)"InvoiceBatchFileImportPlugin_118", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"billno");
                addFlag = Boolean.FALSE;
            }
            if (linkedMap.size() > 8) {
                int rowIndex5 = Integer.parseInt(linkedMap.getFirst().get("rowIndex").toString());
                Row row4 = workbook.getSheetAt(0).getRow(rowIndex5);
                if (tobaccoFlag.booleanValue()) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row4, (Integer)rowIndex5, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5377\u70df\u5355\u636e\u4e0d\u80fd\u8d85\u8fc78\u884c\u660e\u7ec6", (String)"InvoiceBatchFileImportPlugin_119", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"billno");
                    addFlag = Boolean.FALSE;
                } else if (IssueType.RED_INVOICE.getTypeCode().equals(issuetype)) {
                    linkedMap.getFirst().put("inventorymark", 0);
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row4, (Integer)rowIndex5, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8d1f\u6570\u5355\u636e\u4e0d\u80fd\u8d85\u8fc78\u884c\u660e\u7ec6", (String)"InvoiceBatchFileImportPlugin_120", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"billno");
                    addFlag = Boolean.FALSE;
                } else {
                    linkedMap.getFirst().put("inventorymark", 1);
                }
            } else {
                linkedMap.getFirst().put("inventorymark", 0);
            }
            if (!addFlag.booleanValue() || !switchFlag.booleanValue()) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.map2DynamicObject(linkedMap.get(0), (DynamicObject)dynamicObject);
            DynamicObjectCollection dc = dynamicObject.getDynamicObjectCollection("items");
            String hsbz = dynamicObject.getString("hsbz");
            invoiceType = dynamicObject.getString("invoicetype");
            String isElePaper = dynamicObject.getString("iselepaper");
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
            for (Map map : linkedMap) {
                BigDecimal num;
                BigDecimal unitPrice;
                BigDecimal amount = new BigDecimal(map.get("amount").toString());
                BigDecimal tax = new BigDecimal(map.get("tax").toString());
                if ("1".equals(hsbz)) {
                    map.put("taxamount", amount);
                    BigDecimal bhsAmount = amount.subtract(tax);
                    map.put("amount", bhsAmount);
                    if (map.get("unitprice") instanceof BigDecimal && !MathUtils.isZero((BigDecimal)(unitPrice = (BigDecimal)map.get("unitprice")))) {
                        num = new BigDecimal(map.get("num").toString());
                        BigDecimal bhsdj = PriceHelper.calcPriceOrNum((BigDecimal)bhsAmount, (BigDecimal)num, (boolean)isAllEle);
                        map.put("taxunitprice", PriceHelper.getValue((BigDecimal)unitPrice, (String)"\u5355\u4ef7", (boolean)isAllEle));
                        map.put("unitprice", bhsdj);
                    }
                } else {
                    BigDecimal hsAmount = amount.add(tax);
                    map.put("taxamount", hsAmount);
                    if (map.get("unitprice") instanceof BigDecimal && !MathUtils.isZero((BigDecimal)(unitPrice = (BigDecimal)map.get("unitprice")))) {
                        num = new BigDecimal(map.get("num").toString());
                        BigDecimal hsdj = PriceHelper.calcPriceOrNum((BigDecimal)hsAmount, (BigDecimal)num, (boolean)isAllEle);
                        map.put("taxunitprice", hsdj);
                        map.put("unitprice", PriceHelper.getValue((BigDecimal)unitPrice, (String)"\u5355\u4ef7", (boolean)isAllEle));
                    }
                }
                DynamicObjectUtil.map2DynamicObject((Map)map, (DynamicObject)dc.addNew());
            }
            DynamicObject saleData = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo);
            if (saleData != null) {
                if (StringUtils.isBlank((CharSequence)dynamicObject.getString("salerbank"))) {
                    dynamicObject.set("salerbank", (Object)saleData.getString("openuserbank"));
                }
                if (StringUtils.isBlank((CharSequence)dynamicObject.getString("saleraddr"))) {
                    dynamicObject.set("saleraddr", (Object)saleData.getString("invoiceaddr"));
                }
            }
            if (null == process.getTaxOrg()) {
                Long taxOrgPk = IssueInvoiceService.getTaxOrgLongValue((String)saleInfo.getSaleTaxNo());
                process.setTaxOrg(taxOrgPk);
            }
            dynamicObject.set("taxorg", (Object)process.getTaxOrg());
            if (null == process.getBaseInvoiceTypePk(invoiceType)) {
                Long baseInvoiceType = IssueInvoiceService.getBaseInvoiceType((String)invoiceType);
                process.getBaseInvoiceTypeMap().put(invoiceType, baseInvoiceType);
            }
            dynamicObject.set("baseinvoicetype", process.getBaseInvoiceTypeMap().get(invoiceType));
            dynamicObject.set("orderno", (Object)UUID.randomUUID());
            dynamicObject.set("batchbelong", (Object)batchbelong);
            dynamicObject.set("billdate", (Object)new Date());
            dynamicObject.set("salertaxno", (Object)saleInfo.getSaleTaxNo());
            dynamicObject.set("salername", (Object)saleInfo.getSaleName());
            dynamicObject.set("createtime", (Object)today);
            dynamicObject.set("issuebillstatus", (Object)invoiceWaitStatus);
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    private Boolean checkFarmSaleItems(Map<String, Object> map, Row row, Map<String, String> errMap, Boolean addFlag, Integer rowIndex, Map<String, FileField> fieldMap) {
        Object specialType = map.get("specialtype");
        Object invoiceType = map.get("invoicetype");
        if ("E12".equals(specialType)) {
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                addFlag = false;
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u81ea\u4ea7\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968", (String)"InvoiceBatchFileImportPlugin_188", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"invoicetype");
            }
            String zzstsgl = (String)map.get("zzstsgl");
            String taxpremark = (String)map.get("taxpremark");
            String taxRate = (String)map.get("taxrate");
            BigDecimal taxRateDecimalValue = BigDecimal.TEN;
            try {
                taxRateDecimalValue = new BigDecimal(taxRate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!"1".equals(taxpremark)) {
                addFlag = false;
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u7684\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\uff1a\u4eab\u53d7", (String)"InvoiceBatchFileImportPlugin_189", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxpremark");
            }
            if (!"\u514d\u7a0e".equals(zzstsgl)) {
                addFlag = false;
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\u5fc5\u987b\u4e3a\uff1a\u514d\u7a0e", (String)"InvoiceBatchFileImportPlugin_190", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
            }
            if (taxRateDecimalValue.compareTo(BigDecimal.ZERO) != 0) {
                addFlag = false;
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u7684\u7a0e\u7387\u5fc5\u987b\u4e3a0", (String)"InvoiceBatchFileImportPlugin_191", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxrate");
            }
            return addFlag;
        }
        return addFlag;
    }

    private void setSpecialType(Map<String, Object> map) {
        if (String.valueOf(map.get("invoicetype")).contains("\u6570\u7535\u7968")) {
            String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeByExcelDescription((String)((String)map.get("specialtype")));
            map.put("specialtype", specialType);
        }
    }

    private Boolean checkAllEInvoice(Map<String, FileField> fieldMap, Map<String, String> errMap, Boolean addFlag, Map<String, Object> map, Integer rowIndex, Row row, Object taxRate, Object invoiceType) {
        if (InvoiceUtils.isSpecialInvoice((String)String.valueOf(invoiceType)) || InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            try {
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(taxRate));
                if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u4e13\u7968\u4e0d\u80fd\u5f00\u51770\u7a0e\u7387", (String)"InvoiceBatchFileImportPlugin_122", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxrate");
                    addFlag = Boolean.FALSE;
                }
            }
            catch (Exception bigDecimal) {
                // empty catch block
            }
            String buyerTaxNo = (String)map.get("buyertaxno");
            if (StringUtils.isBlank((CharSequence)buyerTaxNo)) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u6570\u7535\u4e13\u7968\u8d2d\u65b9\u7a0e\u53f7\u5fc5\u586b", (String)"InvoiceBatchFileImportPlugin_123", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxrate");
                addFlag = Boolean.FALSE;
            }
        }
        if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            String buyerAddr = map.get("buyeraddr") == null ? "" : (String)map.get("buyeraddr");
            String buyerphone = map.get("buyeraddrphone") == null ? "" : (String)map.get("buyeraddrphone");
            String comAddr = buyerAddr + buyerphone;
            if (GBKUtils.getGBKLength((String)comAddr) > 100) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u5730\u5740\u52a0\u8d2d\u65b9\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\u621650\u4e2a\u6c49\u5b57", (String)"InvoiceBatchFileImportPlugin_124", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxrate");
                addFlag = Boolean.FALSE;
            }
            map.put("buyeraddr", comAddr);
            String buyerBank = map.get("buyerbank") == null ? "" : (String)map.get("buyerbank");
            String buyeraccount = map.get("buyeraccount") == null ? "" : (String)map.get("buyeraccount");
            String comBank = buyerBank + buyeraccount;
            if (GBKUtils.getGBKLength((String)comBank) > 100) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u5f00\u6237\u884c\u52a0\u8d2d\u65b9\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\u621650\u4e2a\u6c49\u5b57", (String)"InvoiceBatchFileImportPlugin_125", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxrate");
                addFlag = Boolean.FALSE;
            }
            map.put("buyerbank", comBank);
        }
        if (StringUtils.isBlank((Object)map.get("specialtype"))) {
            map.put("specialtype", "00");
        }
        return addFlag;
    }

    private Boolean checkOperator(Map<String, Object> map, InvoiceBatchImportProcessVo process, Row row, Integer rowIndex, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        Object operatornumber = map.get("operatornumber");
        if (StringUtils.isBlank((Object)operatornumber)) {
            return Boolean.TRUE;
        }
        Map operatorMap = process.getOperatorMap();
        DynamicObject operateObj = (DynamicObject)operatorMap.get(String.valueOf(operatornumber));
        if (null == operateObj) {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u7ecf\u529e\u4eba", (String)"InvoiceBatchFileImportPlugin_126", (String)"imc-sim-formplugin", (Object[])new Object[0]), operatornumber), (String)"operatornumber");
            return Boolean.FALSE;
        }
        map.put("operator", operateObj.getLong("id"));
        return Boolean.TRUE;
    }

    private Boolean dealOriginalByRed(String issuetype, Map<String, Object> insertInvoice, BigDecimal totalAmount, BigDecimal totalTaxAmt, String saleTaxNo) throws MsgException {
        if (IssueType.RED_INVOICE.getTypeCode().equals(issuetype)) {
            String originalinvoicecode = insertInvoice.get("originalinvoicecode").toString();
            String originalinvoiceno = insertInvoice.get("originalinvoiceno").toString();
            if (originalinvoicecode.length() == 12 && "13".equals(originalinvoicecode.substring(10))) {
                throw new MsgException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u84dd\u7968\u4e3a\u4e13\u7968\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u7ea2\u5b57\u4fe1\u606f\u8868\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_127", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (originalinvoicecode.length() == 10 && ("1".equals(originalinvoicecode.substring(7, 8)) || "5".equals(originalinvoicecode.substring(7, 8)))) {
                throw new MsgException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u84dd\u7968\u4e3a\u4e13\u7968\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u7ea2\u5b57\u4fe1\u606f\u8868\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_127", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)insertInvoice.get("redreason"))) {
                throw new MsgException(ResManager.loadKDString((String)"\u51b2\u7ea2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_128", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("invoicecode", "=", (Object)originalinvoicecode);
            filter.and(new QFilter("invoiceno", "=", (Object)originalinvoiceno));
            filter.and(new QFilter("invoicestatus", "=", (Object)"0"));
            DynamicObject vatInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,remainredamount,canredtaxamount,salertaxno,invoicetype,taxedtype,deduction,issuetype,issuetime", (QFilter[])new QFilter[]{filter});
            if (null == vatInvoice) {
                if (StringUtils.isBlank((Object)insertInvoice.get("originalinvoicetype"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_129", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((Object)insertInvoice.get("originalissuetime"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_130", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                insertInvoice.put("taxedtype", TaxedTypeEnum.normal.getValue());
                insertInvoice.put("deduction", BigDecimal.ZERO);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u8d1f\u6570\u53d1\u7968\u5bfc\u5165:\u5728\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u84dd\u7968\u53d1\u7968\u4ee3\u7801:%s,\u53d1\u7968\u53f7\u7801:%s\u7684\u53d1\u7968", originalinvoicecode, originalinvoiceno));
                }
            } else {
                String hsbz;
                if (!saleTaxNo.equals(vatInvoice.getString("salertaxno"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u627e\u5230\u5bf9\u5e94\u84dd\u7968\u7684\u7a0e\u53f7\u4e0e\u5f53\u524d\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u540c, \u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_132", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (!"0".equalsIgnoreCase(vatInvoice.getString("issuetype"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u539f\u59cb\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u5728\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u53d1\u7968\u7c7b\u578b\u4e3a\u975e\u84dd\u7968, \u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_133", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (!InvoiceUtils.isNormalInvoice((String)vatInvoice.getString("invoicetype")) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(vatInvoice.getString("blueinvoicetype"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u666e\u7968\u6216\u5377\u7968", (String)"InvoiceBatchFileImportPlugin_134", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(vatInvoice.getString("invoicetype")) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(vatInvoice.getString("invoicetype"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u5377\u7968\u7684\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u5377\u7968", (String)"InvoiceBatchFileImportPlugin_135", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                BigDecimal remainredamount = vatInvoice.getBigDecimal("remainredamount");
                BigDecimal canredtaxamount = vatInvoice.getBigDecimal("canredtaxamount");
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u84dd\u7968\u53ef\u7ea2\u51b2\u91d1\u989d\uff1a" + remainredamount);
                    LOGGER.info("\u84dd\u7968\u53ef\u7ea2\u51b2\u7a0e\u989d\uff1a" + canredtaxamount);
                }
                if ("1".equals(hsbz = insertInvoice.get("hsbz").toString())) {
                    String taxrate = insertInvoice.get("taxrate").toString();
                    totalAmount = totalAmount.divide(BigDecimal.ONE.add(new BigDecimal(taxrate)), 2, 4);
                }
                if (remainredamount.add(totalAmount).compareTo(BigDecimal.ZERO) < 0) {
                    throw new MsgException(ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u627e\u5230\u5bf9\u5e94\u84dd\u7968\u7684\u53ef\u7ea2\u51b2\u91d1\u989d\u5927\u4e8e\u5bfc\u5165\u7684\u91d1\u989d, \u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_138", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (canredtaxamount.add(totalTaxAmt).compareTo(BigDecimal.ZERO) < 0) {
                    throw new MsgException(ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u627e\u5230\u5bf9\u5e94\u84dd\u7968\u7684\u53ef\u7ea2\u51b2\u7a0e\u989d\u5927\u4e8e\u5bfc\u5165\u7684\u7a0e\u989d, \u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"InvoiceBatchFileImportPlugin_139", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                insertInvoice.put("originalinvoicetype", vatInvoice.getString("invoicetype"));
                insertInvoice.put("originalissuetime", DateUtils.format((Date)vatInvoice.getDate("issuetime"), (String)"yyyy-MM-dd"));
                if (TaxedTypeEnum.deduction.getValue().equals(vatInvoice.getString("taxedtype"))) {
                    insertInvoice.put("taxedtype", TaxedTypeEnum.deduction.getValue());
                    insertInvoice.put("deduction", vatInvoice.getBigDecimal("deduction").negate());
                    if (remainredamount.add(totalAmount).compareTo(BigDecimal.ZERO) != 0) {
                        throw new MsgException(ResManager.loadKDString((String)"\u5e26\u5dee\u989d\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u90e8\u5206\u7ea2\u51b2\uff01", (String)"InvoiceBatchFileImportPlugin_140", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    insertInvoice.put("taxedtype", TaxedTypeEnum.normal.getValue());
                    insertInvoice.put("deduction", BigDecimal.ZERO);
                }
            }
        } else {
            insertInvoice.put("taxedtype", TaxedTypeEnum.normal.getValue());
        }
        return Boolean.TRUE;
    }

    private Map<String, Object> taxNumberCountAndCheck(Map<String, Object> map, Row row, Map<String, String> errMap, Boolean addFlag, Integer rowIndex, Map<String, FileField> fieldMap, String taxKinds) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        Map taxamountMap = InvoiceBatchFileImportUtil.countTaxMount((String)(taxKinds.equals("\u4e0d\u542b\u7a0e") ? "0" : "1"), (String)map.get("num").toString(), (String)map.get("taxrate").toString(), (String)map.get("unitprice").toString(), (String)map.get("amount").toString(), (String)map.get("rowtype").toString());
        if (taxamountMap.get("errCode") != null && taxamountMap.get("errCode").toString().equals("0000")) {
            if (StringUtils.isNotBlank((Object)map.get("tax"))) {
                BigDecimal countAmout;
                BigDecimal taxamount = new BigDecimal(map.get("tax").toString());
                if (taxamount.subtract(countAmout = new BigDecimal(taxamountMap.get("tax").toString())).abs().compareTo(BigDecimal.valueOf(0.06)) > 0) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d'\u7a0e\u989d'\u8bef\u5dee\u4e0d\u80fd\u5927\u4e8e0.06", (String)"InvoiceBatchFileImportPlugin_142", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"tax");
                    addFlag = Boolean.FALSE;
                }
            } else {
                map.put("tax", taxamountMap.get("tax"));
                result.put("countAmout", taxamountMap.get("tax"));
            }
            map.put("taxflag", taxKinds.equals(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e", (String)"InvoiceBatchFileImportPlugin_141", (String)"imc-sim-formplugin", (Object[])new Object[0])) ? "0" : "1");
        } else {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)taxamountMap.get("errMsg").toString(), (String)"tax");
            addFlag = Boolean.FALSE;
        }
        result.put("result", map);
        result.put("addFlag", addFlag);
        return result;
    }

    private Map<String, String> checkBillNumber(Map<String, Object> map, Map<String, Map<String, String>> TAX_NUMBER_MAP) {
        String goodsCode = (String)map.getOrDefault("goodscode", "");
        Map<String, String> goodsInfo = TAX_NUMBER_MAP.get(goodsCode);
        if (goodsInfo == null) {
            goodsInfo = this.findParamsByName((String)map.get("goodsname"), goodsCode);
        }
        return goodsInfo;
    }

    private Map<String, String> findParamsByBuyerName(String buyerName) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        if (StringUtils.isNotBlank((CharSequence)buyerName)) {
            QFilter fQFilter = new QFilter("name", "=", (Object)buyerName);
            String field = "id,taxno,companycode,email,openingbank,addr,mobilephone,buyertype";
            QFilter baseDataFilter = ImcBaseDataHelper.getInvTitleFilter((Object)RequestContext.get().getOrgId());
            DynamicObject dObject = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)field, (QFilter[])new QFilter[]{baseDataFilter.and(fQFilter)});
            if (dObject != null) {
                result.put("buyertaxno", dObject.getString("taxno"));
                result.put("buyerproperty", dObject.getString("buyertype"));
                result.put("buyerbank", dObject.getString("openingbank"));
                result.put("buyeraddr", dObject.getString("addr"));
                result.put("buyerphone", dObject.getString("mobilephone"));
                result.put("buyeremail", dObject.getString("email"));
            }
        }
        return result;
    }

    private Map<String, String> findParamsByName(String name, Object goodscode) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("success", DETAIL_STATE);
        QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)RequestContext.get().getOrgId()).and("name", "=", (Object)name);
        DynamicObject goodsInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)"id,taxcode,specifications,price,unit,taxrate,privilegeflag,privilegetype", (QFilter[])orgFilter.toArray());
        if (goodsInfo != null) {
            result.put("goodscode", goodsInfo.getDynamicObject("taxcode").getString("mergecode"));
            result.put("unit", goodsInfo.getString("unit"));
            result.put("specification", goodsInfo.getString("specifications"));
            result.put("unitprice", goodsInfo.getString("price"));
            result.put("taxrate", goodsInfo.getString("taxrate"));
            result.put("taxpremark", goodsInfo.getString("privilegeflag"));
            result.put("zzstsgl", goodsInfo.getString("privilegetype"));
            result.put("success", "1");
        } else if (StringUtils.isNotBlank((Object)goodscode)) {
            QFilter qFilter = new QFilter("mergecode", "=", goodscode);
            goodsInfo = BusinessDataServiceHelper.loadSingle((String)"er_taxclasscode", (String)"id,mergecode,taxrate", (QFilter[])new QFilter[]{qFilter});
            if (goodsInfo != null) {
                result.put("goodscode", goodsInfo.getString("mergecode"));
                result.put("taxrate", goodsInfo.getString("taxrate"));
                result.put("success", "1");
            }
        }
        return result;
    }

    private void dealExcelChoose(Map<String, Object> map) {
        String TAX_PREMARK;
        String taxincluded;
        String invoicetype = InvoiceType.getCodeByDesc((String)map.get("invoicetype").toString());
        String buyerProperty = map.get("buyerproperty").toString();
        String buyerepinfotype = "\u4f01\u4e1a".equals(buyerProperty) ? "0" : ("\u4e2a\u4eba".equals(buyerProperty) ? "1" : "2");
        String string = taxincluded = map.get("hsbz").toString().equals("\u4e0d\u542b\u7a0e") ? "0" : "1";
        String invoicenature = IssueType.BLUE_INVOICE.getTypeCode().equals(map.get("issuetype").toString()) ? (map.get("rowtype").toString().equals("\u6298\u6263\u884c") ? "1" : (map.get("rowtype").toString().equals("\u666e\u901a\u5546\u54c1\u884c") ? "0" : "2")) : "0";
        String string2 = TAX_PREMARK = map.get("taxpremark").toString().equals("\u4eab\u53d7") ? "1" : "0";
        if (StringUtils.isNotBlank((Object)map.get("originalinvoicetype"))) {
            String originalinvoicetype = InvoiceType.getCodeByDesc((String)map.get("originalinvoicetype").toString());
            map.put("originalinvoicetype", originalinvoicetype);
        }
        if (StringUtils.isNotBlank((Object)map.get("redreason"))) {
            String redReason = RedReasonEnum.getTypeCodeByDescreption((String)map.get("redreason").toString());
            map.put("redreason", redReason);
        }
        map.put("invoicetype", invoicetype);
        map.put("buyerproperty", buyerepinfotype);
        map.put("hsbz", taxincluded);
        map.put("rowtype", invoicenature);
        map.put("taxpremark", TAX_PREMARK);
    }

    private void checkBuyerName(Map<String, Object> map) {
        Map<String, String> buyerInfo = this.findParamsByBuyerName(map.get("buyername").toString());
        if (!buyerInfo.isEmpty()) {
            map.put("buyertaxno", StringUtils.isBlank((Object)map.get("buyertaxno")) ? buyerInfo.get("buyertaxno") : map.get("buyertaxno"));
            map.put("buyerproperty", StringUtils.isBlank((Object)map.get("buyerproperty")) ? buyerInfo.get("buyerproperty") : map.get("buyerproperty"));
            map.put("buyerbank", StringUtils.isBlank((Object)map.get("buyerbank")) ? buyerInfo.get("buyerbank") : map.get("buyerbank"));
            map.put("buyeraddr", StringUtils.isBlank((Object)map.get("buyeraddr")) ? buyerInfo.get("buyeraddr") : map.get("buyeraddr"));
            map.put("buyerphone", StringUtils.isBlank((Object)map.get("buyerphone")) ? buyerInfo.get("buyerphone") : map.get("buyerphone"));
            map.put("buyeremail", StringUtils.isBlank((Object)map.get("buyeremail")) ? buyerInfo.get("buyeremail") : map.get("buyeremail"));
        }
    }

    private Boolean TAX_PREMARKCheck(Map<String, Object> map, Row row, Map<String, String> errMap, Boolean addFlag, Integer rowIndex, Map<String, FileField> fieldMap) {
        if (map.get("taxpremark").equals("1")) {
            if (StringUtils.isBlank((Object)map.get("zzstsgl"))) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u4e3a'\u4eab\u53d7'\u65f6\u5fc5\u586b", (String)"InvoiceBatchFileImportPlugin_147", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                addFlag = Boolean.FALSE;
            } else {
                String privilegeType = map.get("zzstsgl").toString();
                String taxRate = map.get("taxrate").toString();
                if (!POLICY_CONTENTS.contains(map.get("zzstsgl"))) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5339\u914d\u4e0d\u6b63\u786e", (String)"InvoiceBatchFileImportPlugin_148", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                    addFlag = Boolean.FALSE;
                }
                if (("\u514d\u7a0e".equals(privilegeType) || "\u4e0d\u5f81\u7a0e".equals(privilegeType)) && !"0".equals(taxRate)) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u514d\u7a0e\u6216\u4e0d\u5f81\u7a0e\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceBatchFileImportPlugin_151", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                    addFlag = Boolean.FALSE;
                }
                if ("\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.05".equals(taxRate) && !"0.04".equals(taxRate) && !"0.03".equals(taxRate)) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceBatchFileImportPlugin_153", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                    addFlag = Boolean.FALSE;
                }
                if ("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81".equals(privilegeType) && !"0.015".equals(taxRate)) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u5f81,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceBatchFileImportPlugin_155", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                    addFlag = Boolean.FALSE;
                }
                if ("\u63095%\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.05".equals(taxRate)) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceBatchFileImportPlugin_157", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                    addFlag = Boolean.FALSE;
                }
                if ("\u63093%\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.03".equals(taxRate)) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceBatchFileImportPlugin_159", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
                    addFlag = Boolean.FALSE;
                }
            }
        } else if ((map.get("taxpremark") == null || map.get("taxpremark").equals("") || map.get("taxpremark").equals("0")) && StringUtils.isNotBlank((Object)map.get("zzstsgl"))) {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u4e3a'\u4e0d\u4eab\u53d7'\u65f6\u9700\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_160", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"zzstsgl");
            addFlag = Boolean.FALSE;
        }
        return addFlag;
    }

    private Map<String, Object> priceAndQuantityCheck(Map<String, Object> map, Row row, Map<String, String> errMap, Boolean addFlag, Integer rowIndex, Map<String, FileField> fieldMap, BigDecimal addMoney) {
        String discountamount;
        String amountmoney;
        boolean isAllEle;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        addMoney = addMoney.compareTo(new BigDecimal(DETAIL_STATE)) == 0 ? BigDecimal.ZERO : addMoney;
        String invoiceType = (String)map.get("invoicetype");
        String isElePaper = (String)map.get("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        if (StringUtils.isBlank((Object)map.get("num")) && StringUtils.isBlank((Object)map.get("unitprice"))) {
            if (StringUtils.isBlank((Object)map.get("amount"))) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6570\u91cf'\u548c'\u5355\u4ef7'\u540c\u65f6\u4e3a\u7a7a\u65f6\uff0c\u91d1\u989d\u5fc5\u586b", (String)"InvoiceBatchFileImportPlugin_161", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                addFlag = Boolean.FALSE;
            } else {
                addMoney = addMoney.add(new BigDecimal(map.get("amount").toString()));
            }
        } else if (StringUtils.isNotBlank((Object)map.get("num")) && StringUtils.isNotBlank((Object)map.get("unitprice"))) {
            BigDecimal number = new BigDecimal(map.get("num").toString());
            try {
                number = UnitPriceHelper.getNumValue((BigDecimal)number, (String)ResManager.loadKDString((String)"\u6570\u91cf", (String)"InvoiceBatchFileImportPlugin_162", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                map.put("num", number.toPlainString());
            }
            catch (KDBizException e) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)e.getMessage(), (String)"num");
                addFlag = Boolean.FALSE;
            }
            BigDecimal price = new BigDecimal(map.get("unitprice").toString());
            try {
                price = PriceHelper.getValue((BigDecimal)price, (String)ResManager.loadKDString((String)"\u5355\u4ef7", (String)"InvoiceBatchFileImportPlugin_121", (String)"imc-sim-formplugin", (Object[])new Object[0]), (boolean)isAllEle);
                map.put("unitprice", price.toPlainString());
            }
            catch (KDBizException e) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)e.getMessage(), (String)"unitprice");
                addFlag = Boolean.FALSE;
            }
            BigDecimal amountmoney2 = number.multiply(price).setScale(2, 4);
            if (StringUtils.isBlank((Object)map.get("amount"))) {
                map.put("amount", amountmoney2);
                addMoney = addMoney.add(amountmoney2);
            } else {
                BigDecimal oldMoney = new BigDecimal(map.get("amount").toString());
                if (amountmoney2.subtract(oldMoney).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d'\u6570\u91cf'\u548c'\u5355\u4ef7'\u7684\u4e58\u79ef\u4e0e'\u91d1\u989d'\u7684\u8bef\u5dee\u4e0d\u80fd\u5927\u4e8e0.01", (String)"InvoiceBatchFileImportPlugin_163", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                    addFlag = Boolean.FALSE;
                }
                addMoney = addMoney.add(oldMoney);
            }
        } else if (StringUtils.isNotBlank((Object)map.get("amount"))) {
            BigDecimal money = new BigDecimal(map.get("amount").toString());
            if (StringUtils.isNotBlank((Object)map.get("num"))) {
                try {
                    map.put("unitprice", PriceHelper.calcPriceOrNum((BigDecimal)money, (BigDecimal)new BigDecimal(map.get("num").toString()), (boolean)isAllEle));
                }
                catch (KDBizException e) {
                    addFlag = Boolean.FALSE;
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)e.getMessage(), (String)"unitprice");
                }
            } else {
                try {
                    map.put("num", UnitPriceHelper.calcNum((BigDecimal)money, (BigDecimal)new BigDecimal(map.get("unitprice").toString())));
                }
                catch (KDBizException e) {
                    addFlag = Boolean.FALSE;
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)e.getMessage(), (String)"num");
                }
            }
            addMoney = addMoney.add(money);
        } else {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6570\u91cf'\u548c'\u5355\u4ef7'\u9700\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u4e0d\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_164", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"num");
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6570\u91cf'\u548c'\u5355\u4ef7'\u9700\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u4e0d\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_164", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"unitprice");
            addFlag = Boolean.FALSE;
        }
        if (addFlag.booleanValue() && map.get("rowtype").toString().equals("2") && StringUtils.isNotBlank((Object)map.get("discountamount")) && new BigDecimal(amountmoney = map.get("amount").toString()).compareTo(new BigDecimal(discountamount = map.get("discountamount").toString())) < 0) {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6298\u6263\u91d1\u989d'\u4e0d\u80fd\u5927\u4e8e'\u91d1\u989d'", (String)"InvoiceBatchFileImportPlugin_165", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"discountamount");
            addFlag = Boolean.FALSE;
        }
        result.put("addFlag", addFlag);
        result.put("addMoney", addMoney);
        return result;
    }

    private Map<String, Object> parseDiscountRow(Map<String, Object> map, BigDecimal addMoney) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (StringUtils.isNotBlank((Object)map.get("discountamount"))) {
            BigDecimal strAmount = new BigDecimal(map.get("discountamount").toString()).abs();
            map.put("amount", strAmount.negate());
        } else if (StringUtils.isNotBlank((Object)map.get("discountrate"))) {
            BigDecimal strRate = new BigDecimal(map.get("discountrate").toString());
            BigDecimal disAmount = StringUtils.isNotBlank((Object)map.get("amount")) ? new BigDecimal(map.get("amount").toString()).multiply(strRate).setScale(2, 4).abs() : new BigDecimal(map.get("num").toString()).multiply(new BigDecimal(map.get("unitprice").toString())).multiply(strRate).setScale(2, 4).abs();
            map.put("amount", disAmount.negate());
        }
        map.put("specification", "");
        map.put("unit", "");
        map.put("num", "0");
        map.put("unitprice", "0");
        map.put("taxunitprice", "0");
        addMoney = addMoney.add(StringUtils.isNotBlank((Object)map.get("amount")) ? new BigDecimal(map.get("amount").toString()) : BigDecimal.ZERO);
        result.put("result", map);
        result.put("addMoney", addMoney);
        return result;
    }

    private Boolean baseFieldCheck(Map<String, Object> map, Row row, Map<String, String> errMap, Boolean addFlag, Integer rowIndex, Map<String, FileField> fieldMap, Boolean msgSendFlag) {
        boolean isAllEle;
        String invoiceType;
        String strTaxNum;
        String issuetype = map.get("issuetype").toString();
        if (InvoiceBatchFileImportUtil.isContainChinese((String)map.get("billno").toString()).booleanValue()) {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u53ea\u80fd\u662f\u5b57\u6bcd\u6216\u6570\u5b57", (String)"InvoiceBatchFileImportPlugin_166", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"billno");
            addFlag = Boolean.FALSE;
        }
        if (StringUtils.isNotBlank((Object)map.get("buyertaxno")) && InvoiceBatchFileImportUtil.isContainChinese((String)(strTaxNum = map.get("buyertaxno").toString())).booleanValue()) {
            InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7'\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u53ea\u80fd\u662f\u5b57\u6bcd\u6216\u6570\u5b57", (String)"InvoiceBatchFileImportPlugin_167", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyertaxno");
            addFlag = Boolean.FALSE;
        }
        if (map.get("invoicetype").toString().equals("028") || map.get("invoicetype").toString().equals("004")) {
            if (StringUtils.isBlank((Object)map.get("buyertaxno"))) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u53d1\u7968\u79cd\u7c7b'\u4e3a'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b\u65f6\uff0c'\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7'\u5fc5\u586b", (String)"InvoiceBatchFileImportPlugin_170", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyertaxno");
                addFlag = Boolean.FALSE;
            }
            if (StringUtils.isBlank((Object)map.get("buyerbank"))) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u53d1\u7968\u79cd\u7c7b'\u4e3a'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b\u65f6\uff0c'\u8d2d\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7'\u5fc5\u586b", (String)"InvoiceBatchFileImportPlugin_171", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyerbank");
                addFlag = Boolean.FALSE;
            }
            if (StringUtils.isBlank((Object)map.get("buyeraddr"))) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u53d1\u7968\u79cd\u7c7b'\u4e3a'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b\u65f6\uff0c'\u8d2d\u65b9\u5730\u5740\u7535\u8bdd'\u5fc5\u586b", (String)"InvoiceBatchFileImportPlugin_172", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyeraddr");
                addFlag = Boolean.FALSE;
            }
            if (map.get("buyerproperty").toString().equals("1")) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u8d2d\u65b9\u4f01\u4e1a\u7c7b\u578b'\u4e3a'\u4e2a\u4eba'\u65f6\uff0c'\u53d1\u7968\u79cd\u7c7b'\u4e0d\u5e94\u4e3a'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b", (String)"InvoiceBatchFileImportPlugin_173", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"invoicetype");
                addFlag = Boolean.FALSE;
            }
            if (StringUtils.isNotBlank((Object)map.get("taxrate")) && new BigDecimal(map.get("taxrate").toString()).compareTo(BigDecimal.ZERO) <= 0) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u53d1\u7968\u79cd\u7c7b'\u4e3a'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b\u65f6\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a0", (String)"InvoiceBatchFileImportPlugin_174", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"taxrate");
                addFlag = Boolean.FALSE;
            }
        }
        if (InvoiceUtils.isEtcInvoice((String)map.get("invoicetype").toString()) && IssueType.BLUE_INVOICE.getTypeCode().equals(issuetype)) {
            String cachePhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)RequestContext.get().getOrgId());
            if (CheckPhoneEnum.DEFAULT.getCode().equals(cachePhone) && IssueType.BLUE_INVOICE.getTypeCode().equals(issuetype) && StringUtils.isBlank((Object)map.get("buyerphone")) && StringUtils.isBlank((Object)map.get("buyeremail"))) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6536\u7968\u624b\u673a'\u548c'\u6536\u7968\u90ae\u7bb1'\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_175", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyerphone");
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6536\u7968\u624b\u673a'\u548c'\u6536\u7968\u90ae\u7bb1'\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"InvoiceBatchFileImportPlugin_175", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyeremail");
                addFlag = Boolean.FALSE;
            }
        }
        if (StringUtils.isNotBlank((Object)map.get("buyeremail"))) {
            String strEmail = map.get("buyeremail").toString();
            String[] strArr = strEmail.split(";");
            if (strArr.length > 10) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6536\u7968\u90ae\u7bb1'\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"InvoiceBatchFileImportPlugin_176", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyeremail");
                addFlag = Boolean.FALSE;
            } else {
                for (String str : strArr) {
                    if (StringUtils.isEmail((String)str)) continue;
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6536\u7968\u90ae\u7bb1'\u683c\u5f0f\u9519\u8bef", (String)"InvoiceBatchFileImportPlugin_177", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"buyeremail");
                    addFlag = Boolean.FALSE;
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((Object)map.get("num"))) {
            String strNum = map.get("num").toString();
            int i = strNum.indexOf(46);
            if (i > 0 && strNum.length() - i > 8) {
                strNum = new BigDecimal(strNum).setScale(8, 4).toString();
            }
            invoiceType = (String)map.get("invoicetype");
            String isElePaper = (String)map.get("iselepaper");
            boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
            if (strNum.replace("-", "").length() > 16) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6570\u91cf'\u603b\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e16\u4f4d", (String)"InvoiceBatchFileImportPlugin_178", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"num");
                addFlag = Boolean.FALSE;
            } else {
                try {
                    map.put("num", UnitPriceHelper.getNumValue((BigDecimal)new BigDecimal(map.get("num").toString()), (String)"\u6570\u91cf"));
                }
                catch (KDBizException e) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)e.getMessage(), (String)"num");
                    addFlag = Boolean.FALSE;
                }
            }
            if (IssueType.RED_INVOICE.getTypeCode().equals(issuetype) && new BigDecimal(map.get("num").toString()).compareTo(BigDecimal.ZERO) >= 0) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968'\u6570\u91cf'\u5fc5\u987b\u4e3a\u8d1f\u6570", (String)"InvoiceBatchFileImportPlugin_179", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"num");
                addFlag = Boolean.FALSE;
            }
        }
        if (StringUtils.isNotBlank((Object)map.get("unitprice"))) {
            String strPrice = map.get("unitprice").toString();
            int i = strPrice.indexOf(46);
            if (i > 0 && strPrice.length() - i > 8) {
                strPrice = new BigDecimal(strPrice).setScale(8, 4).toString();
            }
            if (strPrice.length() > 16) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u5355\u4ef7'\u603b\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e16\u4f4d", (String)"InvoiceBatchFileImportPlugin_180", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"unitprice");
                addFlag = Boolean.FALSE;
            } else {
                try {
                    invoiceType = (String)map.get("invoicetype");
                    String isElePaper = (String)map.get("iselepaper");
                    isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
                    map.put("unitprice", PriceHelper.getValue((BigDecimal)new BigDecimal(map.get("unitprice").toString()), (String)"\u5355\u4ef7", (boolean)isAllEle));
                }
                catch (KDBizException e) {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)e.getMessage(), (String)"unitprice");
                    addFlag = Boolean.FALSE;
                }
            }
        }
        if (StringUtils.isNotBlank((Object)map.get("amount"))) {
            String amountmoney = map.get("amount").toString();
            if (!this.bigDecimalRegexCheck(12, null, amountmoney).booleanValue()) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u91d1\u989d'(\u5355\u4ef7\u548c\u6570\u91cf\u7684\u4e58\u79ef)\u6574\u6570\u4f4d\u6700\u591a12\u4f4d", (String)"InvoiceBatchFileImportPlugin_181", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                addFlag = Boolean.FALSE;
            } else {
                map.put("amount", new BigDecimal(amountmoney).setScale(2, 4).stripTrailingZeros());
            }
            if (IssueType.RED_INVOICE.getTypeCode().equals(issuetype) && new BigDecimal(amountmoney).compareTo(BigDecimal.ZERO) >= 0) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968'\u91d1\u989d'\u5fc5\u987b\u4e3a\u8d1f\u6570", (String)"InvoiceBatchFileImportPlugin_182", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                addFlag = Boolean.FALSE;
            }
            Object rowType = map.get("rowtype");
            if (IssueType.BLUE_INVOICE.getTypeCode().equals(issuetype) && !"1".equals(rowType) && new BigDecimal(amountmoney).compareTo(BigDecimal.ZERO) <= 0) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u6b63\u6570\u53d1\u7968'\u91d1\u989d'\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"InvoiceBatchFileImportPlugin_183", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"amount");
                addFlag = Boolean.FALSE;
            }
        }
        if (StringUtils.isNotBlank((Object)map.get("tax"))) {
            String taxamount = map.get("tax").toString();
            if (!this.bigDecimalRegexCheck(12, null, taxamount).booleanValue()) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u7a0e\u989d'\u6574\u6570\u4f4d\u6700\u591a12\u4f4d", (String)"InvoiceBatchFileImportPlugin_184", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"tax");
                addFlag = Boolean.FALSE;
            } else {
                map.put("tax", new BigDecimal(taxamount).setScale(2, 4).stripTrailingZeros());
            }
            if (IssueType.RED_INVOICE.getTypeCode().equals(issuetype) && new BigDecimal(taxamount).compareTo(BigDecimal.ZERO) >= 0) {
                InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968'\u7a0e\u989d'\u5fc5\u987b\u4e3a\u8d1f\u6570", (String)"InvoiceBatchFileImportPlugin_185", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"tax");
                addFlag = Boolean.FALSE;
            }
        }
        if (StringUtils.isNotBlank((Object)map.get("discountamount"))) {
            String strDiscount = map.get("discountamount").toString().replace("-", "");
            if (!this.floatRegexCheck(12, 2, strDiscount).booleanValue()) {
                if (strDiscount.contains(".")) {
                    if (!this.floatRegexCheck(12, null, strDiscount).booleanValue()) {
                        InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6298\u6263\u91d1\u989d'\u6574\u6570\u4f4d\u6700\u591a12\u4f4d", (String)"InvoiceBatchFileImportPlugin_186", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"discountamount");
                        addFlag = Boolean.FALSE;
                    } else if (new BigDecimal(strDiscount).setScale(2, 4).toString().length() > 12) {
                        InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6298\u6263\u91d1\u989d'\u5c0f\u6570\u90e8\u5206\u5927\u4e8e\u7b49\u4e8e2\u4f4d\u65f6\uff0c\u603b\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e12\u4f4d", (String)"InvoiceBatchFileImportPlugin_187", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"discountamount");
                    } else {
                        map.put("discountamount", new BigDecimal(strDiscount).setScale(2, 4));
                    }
                } else {
                    InvoiceBatchFileImportUtil.setErrorMessage((Row)row, (Integer)rowIndex, errMap, fieldMap, (String)ResManager.loadKDString((String)"'\u6298\u6263\u91d1\u989d'\u6574\u6570\u4f4d\u6700\u591a12\u4f4d", (String)"InvoiceBatchFileImportPlugin_186", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"discountamount");
                    addFlag = Boolean.FALSE;
                }
            }
        }
        return addFlag;
    }

    private Boolean checkRegexEmail(String email) {
        Pattern patten = Pattern.compile("[a-zA-Z0-9_]+@[a-zA-Z0-9]+(\\.[a-zA-Z]+)");
        Matcher matcher = patten.matcher(email);
        return matcher.matches();
    }

    private Boolean floatRegexCheck(Integer i, Integer f, String param) {
        if ("0".equals(param)) {
            return Boolean.TRUE;
        }
        if (f == null) {
            String prefix = param.split("\\.")[0];
            return prefix.length() > i ? Boolean.FALSE : Boolean.TRUE;
        }
        String regex = "^([1-9][0-9]{0," + (i - 1) + "}(\\.[0-9]{1," + f + "})?)|(0\\.[0-9]{0," + f + "})$";
        Pattern patten = Pattern.compile(regex);
        Matcher matcher = patten.matcher(param);
        return matcher.matches();
    }

    private Boolean bigDecimalRegexCheck(Integer integerLen, Integer decimalLen, String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return Boolean.FALSE;
        }
        BigDecimal decimal = new BigDecimal(param).stripTrailingZeros();
        int precision = decimal.precision();
        int scale = decimal.scale();
        return !(null != decimalLen && scale > decimalLen || null != integerLen && precision - scale > integerLen);
    }
}

