/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.helper.issueinvoice.BuildInvoiceHelper;
import kd.imc.sim.common.utils.GetCurrentFilterDate;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportInvoiceDialogPlugin
extends AbstractFormPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log log = LogFactory.getLog(ExportInvoiceDialogPlugin.class);
    private static final int size = 1000;

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date startDate = null;
        Date endDate = null;
        if (customParams.get("keys") != null) {
            JSONArray jsonArray = (JSONArray)customParams.get("keys");
            this.getPageCache().put("keys", jsonArray.toString());
            this.getView().setEnable(Boolean.FALSE, new String[]{"daterange"});
            Map<String, Date> dateMap = this.calcInvoiceStartAndEndDate(jsonArray);
            startDate = dateMap.get("startDate");
            endDate = dateMap.get("endDate");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])jsonArray.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            BigDecimal totalJSHJ = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            int invoiceSize = dynamicObjects.length;
            int totalItemSize = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                int itemSize = dynamicObject.getDynamicObjectCollection("items").size();
                totalItemSize += itemSize;
                totalJSHJ = totalJSHJ.add(dynamicObject.getBigDecimal("totalamount"));
                totalTax = totalTax.add(dynamicObject.getBigDecimal("totaltax"));
            }
            this.getModel().setValue("text", (Object)String.format(ResManager.loadKDString((String)"\u603b\u8ba1\u5bfc\u51fa\u53d1\u7968%1$s\u5f20\uff0c\u4ef7\u7a0e\u5408\u8ba1%2$s\uff0c\u7a0e\u989d%3$s\uff0c\u660e\u7ec6%4$s\u6761", (String)"ExportInvoiceDialogPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceSize, totalJSHJ.stripTrailingZeros().toPlainString(), totalTax.stripTrailingZeros().toPlainString(), totalItemSize));
        } else {
            Map searchDate = GetCurrentFilterDate.dealBillListCurrentFilterDate(customParams.get("search_date"));
            if (searchDate != null) {
                startDate = (Date)searchDate.get("startDate");
                endDate = (Date)searchDate.get("endDate");
            }
        }
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("daterange");
        String keyStartDate = headFieldEdit.getStartDateFieldKey();
        String keyEndDate = headFieldEdit.getEndDateFieldKey();
        this.getModel().setValue(keyStartDate, (Object)startDate);
        this.getModel().setValue(keyEndDate, (Object)endDate);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
    }

    private Map<String, Date> calcInvoiceStartAndEndDate(JSONArray keys) {
        HashMap dateMap = Maps.newHashMapWithExpectedSize((int)4);
        try (DataSet ds = DB.queryDataSet((String)"getMinIssueTime", (DBRoute)new DBRoute("taxc"), (String)this.getMaxOrMinSql(false, keys), (Object[])keys.toArray());){
            if (ds != null) {
                for (kd.bos.algo.Row data : ds) {
                    dateMap.put("startDate", data.getDate("issuetime"));
                }
            }
        }
        ds = DB.queryDataSet((String)"getMaxIssueTime", (DBRoute)new DBRoute("taxc"), (String)this.getMaxOrMinSql(true, keys), (Object[])keys.toArray());
        var4_4 = null;
        try {
            if (ds != null) {
                for (kd.bos.algo.Row data : ds) {
                    dateMap.put("endDate", data.getDate("issuetime"));
                }
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        dateMap.computeIfAbsent("startDate", k -> DateUtils.getFirstDateOfMonth((Date)new Date()));
        dateMap.computeIfAbsent("endDate", k -> new Date());
        return dateMap;
    }

    private String getMaxOrMinSql(boolean isMax, JSONArray keys) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append(isMax ? "max(t.FISSUETIME) as issuetime" : "min(t.FISSUETIME) as issuetime");
        sql.append(" FROM t_sim_vatinvoice t ");
        sql.append(" WHERE t.fid in (");
        for (int i = 0; i < keys.size(); ++i) {
            sql.append('?');
            if (i == keys.size() - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("confirm".equals(source.getKey())) {
            QFilter qFilter;
            StringBuilder titleArrStringBuffer = new StringBuilder();
            titleArrStringBuffer.append("id,orgid.name,invoicecode,invoiceno,buyername,buyertaxno,buyeraddr,buyerbank,issuetype,invoicestatus,invoicetype,taxedtype,deduction,issuetime,totalamount,invoiceamount,totaltax,originalinvoicecode,originalinvoiceno,drawer,payee,reviewer,buyeremail,buyerphone,jqbh,terminalno,buyertelno,invoicecopy,remark,taxorg.name");
            boolean chooseItem = (Boolean)this.getModel().getValue("chooseitem");
            if (chooseItem) {
                String itemsParam = ",items.rowtype,items.goodsname,items.specification,items.unit,items.num,items.unitprice,items.amount,items.taxrate,items.tax,items.goodscode,items.taxpremark,items.zzstsgl";
                titleArrStringBuffer.append(itemsParam);
            }
            String keys = this.getPageCache().get("keys");
            DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("daterange");
            Date startDate = (Date)this.getModel().getValue(headFieldEdit.getStartDateFieldKey());
            Date endDate = (Date)this.getModel().getValue(headFieldEdit.getEndDateFieldKey());
            if (!StringUtils.isEmpty((String)keys)) {
                keys = keys.replace("[", "");
                keys = keys.replace("]", "");
                String[] split = keys.split(",");
                qFilter = new QFilter("id", "in", (Object)Stream.of(split).map(Long::valueOf).toArray());
            } else {
                if (startDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u5fc5\u586b\u3002", (String)"ExportInvoiceDialogPlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (startDate.compareTo(new Date()) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u65f6\u95f4\u5728\u672a\u6765\u65f6\u7a7a\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"ExportInvoiceDialogPlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                long sec = (endDate.getTime() - startDate.getTime()) / 1000L;
                long hour = sec / 60L / 60L;
                long days = hour / 24L;
                if (days > 365L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51faexcel\u9700\u9650\u5236\u5728\u4e00\u5e74\u4e4b\u5185\u3002", (String)"ExportInvoiceDialogPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                qFilter = InvoiceQFilterUtil.getIssueTimeRangeQFilter((Date)startDate, (Date)endDate);
                String exportFilters = this.getView().getFormShowParameter().getCustomParams().get("exportFilters").toString();
                List qfilterCacheStrList = SerializationUtils.fromJsonStringToList((String)exportFilters, String.class);
                for (String filterStr : qfilterCacheStrList) {
                    QFilter filter = QFilter.fromSerializedString((String)filterStr);
                    if (filter.getProperty().equals("issuetime")) continue;
                    qFilter.and(filter);
                }
                String orgIdFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("orgIdFilter");
                QFilter orgFilter = (QFilter)SerializationUtils.fromJsonString((String)orgIdFilterStr, QFilter.class);
                qFilter.and(orgFilter);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sim_vatinvoice", (String)"issuetime", (QFilter[])qFilter.toArray(), null);
            int invoiceLength = dataSet.count("issuetime", false);
            if (invoiceLength < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u65f6\u95f4\u8303\u56f4\u67e5\u65e0\u6570\u636e\u3002", (String)"ExportInvoiceDialogPlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                DownLoadCenterHelper.checkLimitDownload((int)invoiceLength, (String)"excel");
                if (chooseItem) {
                    DownLoadCenterHelper.checkExportItemsLimit((QFilter)qFilter);
                }
            }
            catch (KDBizException e) {
                this.getView().getParentView().showErrorNotification(e.getMessage());
                this.getView().close();
                return;
            }
            this.downloadExcelExport(titleArrStringBuffer, qFilter, invoiceLength);
        }
    }

    private void downloadExcelExport(StringBuilder titleArrStringBuffer, QFilter qFilter, Integer downloadSize) {
        log.info("ExportInvoiceDialogPlugin downloadExcelExport downloadSize:" + downloadSize);
        String fileName = DownLoadCenterHelper.generateFileName((String)ResManager.loadKDString((String)"\u5f00\u7968\u67e5\u8be2\u53d1\u7968\u5bfc\u51fa", (String)"ExportInvoiceDialogPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)".xlsx");
        if (downloadSize <= Integer.parseInt(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BDM_DOWNLOAD_LIMIT_EXCEL_NUM))) {
            SXSSFWorkbook wb = this.outPutExcelByPages(titleArrStringBuffer, downloadSize, qFilter);
            this.flushFileIO(wb, fileName);
        } else {
            Date applyTime = new Date();
            DynamicObject obj = DownLoadCenterHelper.saveDownLoadCenter((IFormView)this.getView().getParentView(), (String)fileName, (int)downloadSize, (Date)applyTime);
            ThreadPools.executeOnce((String)"downloadFileThread", () -> {
                SXSSFWorkbook wb = this.outPutExcelByPages(titleArrStringBuffer, downloadSize, qFilter);
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    wb.write((OutputStream)bos);
                    ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
                    DownLoadCenterHelper.uploadFile((DynamicObject)obj, (String)fileName, (InputStream)in);
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u751f\u6210\u6d41\u5931\u8d25\uff1a", (Throwable)e);
                    obj.set("handlestate", (Object)"3");
                    ImcSaveServiceHelper.update((DynamicObject)obj);
                }
            });
            DownLoadCenterHelper.showConfirmView((IFormView)this.getView().getParentView());
        }
        DownLoadCenterHelper.addDownloadItem((int)downloadSize, (String)"excel");
        this.getView().close();
    }

    private SXSSFWorkbook outPutExcelByPages(StringBuilder titleArrStringBuffer, Integer downloadSize, QFilter qFilter) {
        String[] titleArr = titleArrStringBuffer.toString().split(",");
        XSSFWorkbook wb = new XSSFWorkbook();
        SXSSFWorkbook workbook = new SXSSFWorkbook(wb, 1000);
        SXSSFSheet xssfSheet = workbook.createSheet();
        for (int i = 1; i < titleArrStringBuffer.length(); ++i) {
            xssfSheet.setColumnWidth(i, 8000);
        }
        int index = 0;
        Row xssfRow = xssfSheet.createRow(index);
        XSSFCellStyle textStyle = wb.createCellStyle();
        XSSFDataFormat format = wb.createDataFormat();
        textStyle.setDataFormat(format.getFormat("text"));
        String[] title = titleArr.length == ExportInvoiceDialogPlugin_0.length ? ExportInvoiceDialogPlugin_0 : ExportInvoiceDialogPlugin_1;
        for (int i = 0; i < title.length; ++i) {
            Cell xssfCell = xssfRow.createCell(i);
            xssfCell.setCellValue(title[i]);
        }
        ++index;
        for (int i = 0; i <= downloadSize / 1000; ++i) {
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "salertaxno", "issuesource", titleArrStringBuffer.toString()), (QFilter[])qFilter.toArray(), (String)"createtime asc", (int)i, (int)1000);
            if (objects.length == 0) continue;
            for (DynamicObject invoiceObject : objects) {
                DynamicObjectCollection items = titleArr.length > ExportInvoiceDialogPlugin_0.length ? invoiceObject.getDynamicObjectCollection("items") : null;
                Row row = xssfSheet.createRow(index);
                Cell xsf = row.createCell(0);
                xsf.setCellValue((double)index);
                for (int titleIndex = 1; titleIndex < titleArr.length; ++titleIndex) {
                    xsf = row.createCell(titleIndex);
                    xsf.setCellStyle((CellStyle)textStyle);
                    if (titleIndex > ExportInvoiceDialogPlugin_0.length - 1) {
                        if (items == null || items.size() <= 0) continue;
                        this.formatInvoiceItemStr((DynamicObject)items.get(0), titleArr[titleIndex], xsf);
                        continue;
                    }
                    this.formatInvoiceStr(invoiceObject, titleArr[titleIndex], xsf);
                }
                if (items != null && items.size() > 1) {
                    index = this.addMultiItem((Sheet)xssfSheet, index, titleArr, invoiceObject, items, textStyle);
                }
                ++index;
            }
        }
        return workbook;
    }

    private int addMultiItem(Sheet xssfSheet, int index, String[] titleArr, DynamicObject invoiceObject, DynamicObjectCollection items, XSSFCellStyle textStyle) {
        for (int itemIndex = 1; itemIndex < items.size(); ++itemIndex) {
            Row row = xssfSheet.createRow(++index);
            Cell xssfCell = row.createCell(0);
            xssfCell.setCellValue((double)index);
            for (int titleIndex = 1; titleIndex < titleArr.length; ++titleIndex) {
                xssfCell = row.createCell(titleIndex);
                xssfCell.setCellStyle((CellStyle)textStyle);
                if (titleIndex > ExportInvoiceDialogPlugin_0.length - 1) {
                    this.formatInvoiceItemStr((DynamicObject)items.get(itemIndex), titleArr[titleIndex], xssfCell);
                    continue;
                }
                this.formatInvoiceStr(invoiceObject, titleArr[titleIndex], xssfCell);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFileIO(SXSSFWorkbook wb, String fileName) {
        ByteArrayInputStream bais = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            wb.write((OutputStream)byteArrayOutputStream);
            bais = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)bais, 7200);
            PermissionHelper.checkTempFilePermission((String)urls, (String)"sim", (String)"sim_vatinvoice", (String)ImcPermItemEnum.SIM_BDM_DERIVE.getPermId());
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u53d1\u7968\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    log.error("\u5bfc\u51fa\u53d1\u7968 IO close \u5931\u8d25", (Throwable)e);
                }
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25");
                }
            }
        }
    }

    private void formatInvoiceItemStr(DynamicObject item, String s, Cell xsf) {
        String title = s.split("\\.")[1];
        Object o = item.get(title);
        String result = "";
        switch (title) {
            case "amount": 
            case "tax": {
                result = item.getBigDecimal(title).setScale(2, 4).toString();
                break;
            }
            case "num": 
            case "unitprice": {
                result = item.getBigDecimal(title).setScale(8, 4).stripTrailingZeros().toPlainString();
                if (!"0".equals(result)) break;
                result = "";
                break;
            }
            case "rowtype": {
                if ("0".equals(item.getString("rowtype"))) {
                    result = "\u666e\u901a\u5546\u54c1\u884c";
                    break;
                }
                if ("1".equals(item.getString("rowtype"))) {
                    result = "\u6298\u6263\u884c";
                    break;
                }
                if (!"2".equals(item.getString("rowtype"))) break;
                result = "\u666e\u901a\u5546\u54c1\u884c";
                break;
            }
            case "taxpremark": {
                if ("0".equals(item.getString("taxpremark"))) {
                    result = "\u4e0d\u4eab\u53d7";
                    break;
                }
                if (!"1".equals(item.getString("taxpremark"))) break;
                result = "\u4eab\u53d7";
                break;
            }
            default: {
                result = o.toString();
            }
        }
        xsf.setCellValue(result);
    }

    private void formatInvoiceStr(DynamicObject object, String title, Cell xsf) {
        String result = null;
        switch (title) {
            case "issuetime": {
                result = StringUtils.isNotNull((String)object.getString("issuetime")) ? object.getString("issuetime").split(" ")[0] : "";
                break;
            }
            case "totalamount": {
                result = MathUtils.formatToNumber((BigDecimal)((BigDecimal)object.get("totalamount")));
                break;
            }
            case "totaltax": {
                result = MathUtils.formatToNumber((BigDecimal)((BigDecimal)object.get("totaltax")));
                break;
            }
            case "invoiceamount": {
                result = MathUtils.formatToNumber((BigDecimal)((BigDecimal)object.get("invoiceamount")));
                break;
            }
            case "deduction": {
                result = MathUtils.formatToNumber((BigDecimal)((BigDecimal)object.get("deduction")));
                break;
            }
            case "buyertelno": {
                DynamicObject device;
                String jqbh = object.getString("jqbh");
                String deviceName = this.getPageCache().get(jqbh);
                if (StringUtils.isEmpty((String)deviceName) && (device = EquipmentUtil.getCommonEquipment((String)jqbh, (String)object.getString("salertaxno"), (String)object.getString("terminalno"))) != null) {
                    deviceName = device.getString("equipmentname");
                    this.getPageCache().put(jqbh, deviceName);
                }
                result = deviceName;
                break;
            }
            case "invoicetype": {
                result = InvoiceType.getInvoiceDesc((String)object.getString("invoicetype"));
                break;
            }
            case "invoicestatus": {
                if ("0".equals(object.getString("invoicestatus"))) {
                    result = "\u6b63\u5e38";
                    break;
                }
                if ("3".equals(object.getString("invoicestatus"))) {
                    result = "\u7ea2\u51b2";
                    break;
                }
                if ("6".equals(object.getString("invoicestatus"))) {
                    result = "\u4f5c\u5e9f";
                    break;
                }
                if (!"2".equals(object.getString("invoicestatus"))) break;
                result = ResManager.loadKDString((String)"\u90e8\u5206\u7ea2\u51b2", (String)"ExportInvoiceDialogPlugin_48", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                break;
            }
            case "issuesource": {
                if ("0".equals(object.getString("issuesource"))) {
                    result = "\u7a0e\u52a1ukey";
                    break;
                }
                if ("1".equals(object.getString("issuesource"))) {
                    result = "\u7a0e\u63a7\u76d8";
                    break;
                }
                if ("2".equals(object.getString("issuesource"))) {
                    result = "\u91d1\u7a0e\u76d8";
                    break;
                }
                if (!"3".equals(object.getString("issuesource"))) break;
                result = "\u7a0e\u63a7\u865a\u62dfukey";
                break;
            }
            case "invoicecopy": {
                String invoiceCopy = object.getString("invoicecopy");
                if (StringUtils.isBlank((String)invoiceCopy) || "-1".equals(invoiceCopy)) {
                    result = "\u65e0";
                    break;
                }
                result = invoiceCopy;
                break;
            }
            case "issuetype": {
                if ("0".equals(object.getString("issuetype"))) {
                    result = "\u84dd\u7968";
                    break;
                }
                if (!"1".equals(object.getString("issuetype"))) break;
                result = "\u7ea2\u7968";
                break;
            }
            case "taxedtype": {
                if ("0".equals(object.getString("taxedtype"))) {
                    result = "\u666e\u901a\u5f81\u7a0e";
                    break;
                }
                if ("1".equals(object.getString("taxedtype"))) {
                    result = "\u51cf\u6309\u8ba1\u5f81";
                    break;
                }
                if (!"2".equals(object.getString("taxedtype"))) break;
                result = "\u5dee\u989d\u5f81\u7a0e";
                break;
            }
            case "remark": {
                String remark;
                log.info(object.getString("invoiceno") + ":remark issuesource:" + object.getString("issuesource"));
                result = EquipmentType.isLyServer((String)object.getString("issuesource")) ? ((remark = object.getString("remark")).contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801") ? remark : BuildInvoiceHelper.buildRemark((DynamicObject)object)) : object.getString(title);
                log.info("remark:" + result);
                break;
            }
            default: {
                result = object.getString(title);
            }
        }
        xsf.setCellValue(result);
    }
}

