/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MetadataUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.allele.AllEleUpdateInvoiceStatusRequestDTO;
import kd.imc.sim.common.helper.allele.RpaInvoiceFileHelper;
import kd.imc.sim.common.service.ImcPushInvoiceToIsmcService;
import kd.imc.sim.common.service.InvoiceIsmcSyncToImcService;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import org.apache.commons.lang3.StringUtils;

public class InvoiceShowPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(InvoiceShowPlugin.class);

    public void afterCreateNewData(EventObject e) {
        DynamicObject invoiceDynamicObject = this.queryInvoiceDynamicObject();
        if (invoiceDynamicObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"InvoiceShowPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (Objects.equals(invoiceDynamicObject.get("ofdstatus"), "1")) {
            this.showInvoicePDFImage(invoiceDynamicObject);
            return;
        }
        this.jumpShowInvoiceView(invoiceDynamicObject);
        if (InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper"))) {
            return;
        }
        ImmutableSet buyerTypeSet = ImmutableSet.of((Object)"8");
        if (!"2".equals(invoiceDynamicObject.get("uploadismcstatus")) && !buyerTypeSet.contains((Object)invoiceDynamicObject.getString("buyertype"))) {
            ThreadPools.executeOnceIncludeRequestContext((String)"invoice_query_handleHyperLinkClick", () -> {
                if (StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("uploadismcstatus")) || "0".equals(invoiceDynamicObject.get("uploadismcstatus"))) {
                    logger.info("InvoiceQuery push invoice to ismc");
                    ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest((DynamicObject)invoiceDynamicObject, (boolean)true);
                } else {
                    logger.info("InvoiceQuery sync ismc invoice");
                    ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("orderno", (Object)invoiceDynamicObject.getString("orderno"));
                    jsonObjects.add(jsonObject);
                    InvoiceIsmcSyncToImcService.executeSyncIsmcInvoice(jsonObjects, null);
                }
            });
        }
    }

    private DynamicObject queryInvoiceDynamicObject() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long id = BigDecimalUtil.transDecimal(customParams.get("id")).longValue();
        if (id > 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)"sim_vatinvoice");
        }
        if (customParams.get("orderno") != null) {
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter("orderno", "=", (Object)customParams.get("orderno").toString()).toArray());
            if (idObject == null) {
                return null;
            }
            return BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"sim_vatinvoice");
        }
        Object invoiceNo = customParams.get("invoiceno");
        Object invoiceCodeObject = customParams.get("invoicecode");
        if (invoiceNo != null) {
            String invoiceCode;
            QFilter filter2;
            QFilter filter1 = new QFilter("invoiceno", "=", (Object)invoiceNo.toString());
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("invoicecode", "=", (Object)(invoiceCode = invoiceCodeObject == null ? "" : invoiceCodeObject.toString()))});
            if (idObject == null) {
                return null;
            }
            return BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"sim_vatinvoice");
        }
        return null;
    }

    public void showInvoicePDFImage(DynamicObject dynamicObject) {
        IFrame iframe = (IFrame)this.getView().getControl("iframeap");
        if (InvoiceUtils.isAllEInvoice((Object)dynamicObject.getString("invoicetype"))) {
            this.showAllEInvoice(iframe, dynamicObject);
            return;
        }
        Map paramMap = ImcConfigUtil.getValue((String)"bdm_ismc_config");
        if (paramMap.isEmpty()) {
            String pdfFileUrl = dynamicObject.getString("pdffileurl");
            if (StringUtils.isNotBlank((CharSequence)pdfFileUrl)) {
                iframe.setSrc(AwsFpyService.replaceUrl((String)pdfFileUrl));
            } else {
                this.getView().showTipNotification("pdf not generated");
            }
            return;
        }
        String lsh = dynamicObject.getString("orderno");
        String taxNo = dynamicObject.getString("salertaxno");
        if ("02".equals(dynamicObject.getString("specialtype"))) {
            taxNo = dynamicObject.getString("buyertaxno");
        }
        IsmcToken ismcToken = new IsmcToken();
        String url = "/index.html?userId=Guest&formId=dim_invoice_show&path=" + taxNo + "&id=" + lsh;
        iframe.setSrc(ismcToken.getRequestUrl(url));
    }

    private void showAllEInvoice(IFrame iframe, DynamicObject invoice) {
        DynamicObject invoiceFile;
        String pdfFileUrl = invoice.getString("pdffileurl");
        if (StringUtils.isBlank((CharSequence)pdfFileUrl)) {
            return;
        }
        if (!pdfFileUrl.startsWith("http")) {
            if (!this.showPdfRim(pdfFileUrl)) {
                iframe.setSrc(InvoiceQueryControl.getFileUrl((String)pdfFileUrl));
            }
            return;
        }
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoice.getString("invoiceno")).and("filetype", "=", (Object)FileType.PDF.getFileExtension());
        Date issueTime = invoice.getDate("issuetime");
        if (issueTime != null) {
            qFilter.and("issuetime", ">=", (Object)DateUtils.addDay((Date)issueTime, (int)-1)).and("issuetime", "<=", (Object)DateUtils.addDay((Date)issueTime, (int)1));
        }
        if ((invoiceFile = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_file"), (QFilter[])qFilter.toArray())) == null) {
            iframe.setSrc(AwsFpyService.replaceUrl((String)pdfFileUrl));
            return;
        }
        String localFileUrl = invoiceFile.getString("localfileurl");
        if (StringUtils.isNotBlank((CharSequence)localFileUrl)) {
            if (!this.showPdfRim(localFileUrl)) {
                iframe.setSrc(InvoiceQueryControl.getFileUrl((String)invoiceFile.getString("localfileurl")));
            }
            return;
        }
        if (!"rpa".equals(invoiceFile.getString("issuechannel"))) {
            iframe.setSrc(AwsFpyService.replaceUrl((String)pdfFileUrl));
            return;
        }
        AllEleUpdateInvoiceStatusRequestDTO data = new AllEleUpdateInvoiceStatusRequestDTO();
        data.setPdfUrl(invoice.getString("pdffileurl"));
        RpaInvoiceFileHelper.downloadFile((AllEleUpdateInvoiceStatusRequestDTO)data, (DynamicObject)invoice, Collections.singletonList(invoiceFile));
        if (StringUtils.isNotBlank((CharSequence)invoiceFile.getString("localfileurl"))) {
            ImcSaveServiceHelper.update((DynamicObject)invoiceFile);
            iframe.setSrc(InvoiceQueryControl.getFileUrl((String)invoiceFile.getString("localfileurl")));
            return;
        }
        iframe.setSrc(AwsFpyService.replaceUrl((String)pdfFileUrl));
    }

    private boolean showPdfRim(String url) {
        if (!StringUtils.isEmpty((CharSequence)url) && !url.startsWith("http") && MetadataUtil.exists((String)"rim_file_view").booleanValue()) {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, String> customParams = new HashMap<String, String>(8);
            customParams.put("fileType", "1");
            customParams.put("path", url);
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InContainer);
            param.getOpenStyle().setTargetKey("flexpanelap");
            param.setFormId("rim_file_view");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_file_view");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
            this.getView().setVisible(Boolean.FALSE, new String[]{"iframeap"});
            return true;
        }
        return false;
    }

    public void jumpShowInvoiceView(DynamicObject invoiceDynamicObject) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("id", invoiceDynamicObject.getPkValue());
        String invoiceType = invoiceDynamicObject.getString("invoicetype");
        String formId = InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceType) ? "sim_vatinvoice_show_roll" : "sim_vatinvoice_show";
        String specialType = invoiceDynamicObject.getString("specialtype");
        if ("06".equals(specialType) || "07".equals(specialType)) {
            formId = "sim_vatinvoice_show_txf";
            this.openDialog(ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u770b", (String)"InvoiceShowPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), map, formId, true);
            return;
        }
        formId = InvoiceUtils.isAllEInvoice((Object)invoiceType) ? "sim_vatinvoice_show_all" : formId;
        this.openDialog(ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u770b", (String)"InvoiceShowPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), map, formId, true);
    }

    public void openDialog(String titleName, Map<String, Object> customParams, String formId, boolean isShowTitle) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"iframeap"});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (!StringUtils.isEmpty((CharSequence)titleName)) {
            formShowParameter.setCaption(titleName);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap");
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        formShowParameter.setShowTitle(isShowTitle);
        this.getView().showForm(formShowParameter);
    }
}

