/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.imc.sim.formplugin.issuing.helper.DataSyncHelper;
import org.apache.commons.lang3.StringUtils;

public class InvoiceStatusSyncPlugin
extends AbstractFormPlugin {
    public static final String BILLLISTID = "billlistap";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taxNo = (String)formShowParameter.getCustomParam("taxNo");
        DataSyncHelper.setAccount((AbstractFormPlugin)this, (String)taxNo, (String)"issueaccount");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("downloadchannel".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            boolean isRpa = "2".equals(newValue);
            this.getView().setVisible(Boolean.valueOf(isRpa), new String[]{"issueaccount"});
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm_sync"});
        this.addClickListeners(new String[]{"cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("confirm_sync".equals(key)) {
            String downloadChannel = (String)this.getModel().getValue("downloadchannel");
            if ("2".equals(downloadChannel)) {
                String account = (String)this.getModel().getValue("issueaccount");
                if (StringUtils.isEmpty((CharSequence)account)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceStatusSyncPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.queryRedInfoPre(true);
            } else {
                this.queryRedInfoPre(false);
            }
            this.getView().close();
        }
    }

    private void queryRedInfoPre(boolean isRpa) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\uff0c\u8bf7\u7a0d\u5019", (String)"InvoiceStatusSyncPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taxNo = (String)formShowParameter.getCustomParam("taxNo");
        JSONArray invoicesArr = (JSONArray)formShowParameter.getCustomParam("invoices");
        int totalNum = invoicesArr.size();
        int successNum = 0;
        for (int i = 0; i < totalNum; ++i) {
            JSONObject resultJson = this.queryRedInfoPreRpa(invoicesArr.getJSONObject(i), taxNo, isRpa);
            int success = resultJson.getIntValue("success");
            successNum += success;
        }
        int failNum = totalNum - successNum;
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u675f\uff0c\u603b\u6570\u91cf%1$s\u6761\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761", (String)"InvoiceStatusSyncPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), totalNum, successNum, failNum));
        BillList billList = (BillList)this.getView().getParentView().getControl(BILLLISTID);
        billList.refresh();
        billList.clearSelection();
    }

    private JSONObject queryRedInfoPreRpa(JSONObject jsonObject, String taxNo, boolean isRpa) {
        String sellerTaxNo = jsonObject.getString("salertaxno");
        String buyerTaxNo = jsonObject.getString("buyertaxno");
        String applicant = taxNo.equalsIgnoreCase(sellerTaxNo) ? "1" : "2";
        String account = (String)this.getModel().getValue("issueaccount");
        String invoiceCode = jsonObject.getString("invoicecode");
        String invoiceNo = jsonObject.getString("invoiceno");
        String invoiceType = jsonObject.getString("invoicetype");
        String invoiceDate = jsonObject.getString("issuetime");
        Object invoiceId = jsonObject.get((Object)"id");
        if (isRpa) {
            return DataSyncHelper.queryRedInfoPreRpa((String)applicant, (String)sellerTaxNo, (String)buyerTaxNo, (String)account, (String)invoiceCode, (String)invoiceNo, (String)invoiceType, (String)invoiceDate, (Object)invoiceId);
        }
        return DataSyncHelper.queryRedInfoPreLeqi((String)applicant, (String)sellerTaxNo, (String)buyerTaxNo, (String)invoiceCode, (String)invoiceNo, (String)invoiceType, (String)invoiceDate, (Object)invoiceId);
    }
}

