/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.dataimport;

import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.issuing.helper.DataSyncHelper;
import org.apache.commons.lang3.StringUtils;

public class HistoryInvoiceDataImportPopPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(HistoryInvoiceDataImportPopPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Object timeUnit = this.getModel().getValue("timeunit");
        this.setInvoiceDate(timeUnit);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexaccount"});
    }

    public void registerListener(EventObject e) {
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("epinfo");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            Object invoiceType;
            MulBasedataDynamicObjectCollection epInfos;
            boolean isCheckAccountOk;
            String issueAccount = (String)this.getModel().getValue("issueaccount");
            if (StringUtils.isNotEmpty((CharSequence)issueAccount) && !(isCheckAccountOk = this.checkAccount(issueAccount))) {
                return;
            }
            String importMethod = (String)this.getModel().getValue("importmethod");
            String dataType = (String)this.getModel().getValue("datatype");
            if ("3".equals(dataType) && null != (epInfos = (MulBasedataDynamicObjectCollection)this.getModel().getValue("epinfo"))) {
                StringBuilder builder = new StringBuilder();
                StringBuilder accountBuilder = new StringBuilder();
                for (DynamicObject epInfo : epInfos) {
                    DynamicObject taxCity = epInfo.getDynamicObject("fbasedataId").getDynamicObject("tax_city");
                    String name = epInfo.getDynamicObject("fbasedataId").getString("name");
                    String taxNo = epInfo.getDynamicObject("fbasedataId").getString("number");
                    if (null == taxCity) {
                        builder.append('[').append(name).append(']');
                    }
                    if (!StringUtils.isBlank((CharSequence)(issueAccount = AllEleAuthHelper.getAccount((String)taxNo, (boolean)true, (boolean)true)))) continue;
                    accountBuilder.append('[').append(name).append(']');
                }
                if (builder.length() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4f01\u4e1a\u672a\u914d\u7f6e\u5730\u533a\u7f16\u7801\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u4fe1\u606f\u8fdb\u884c\u914d\u7f6e\u3002%s", (String)"HistoryInvoiceDataImportPopPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), builder.toString()));
                }
                if (accountBuilder.length() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4f01\u4e1a\u672a\u83b7\u53d6\u5230\u5f00\u7968\u6570\u7535\u8d26\u53f7\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u4fe1\u606f\u8fdb\u884c\u8bbe\u7f6e\u3002%s", (String)"HistoryInvoiceDataImportPopPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), accountBuilder.toString()));
                }
            }
            Object downloadChannel = this.getModel().getValue("downloadchannel");
            boolean isTaxDownload = "1".equals(importMethod);
            if ("1".equals(dataType) && isTaxDownload && !"2".equals(downloadChannel) && (String.valueOf(invoiceType = this.getModel().getValue("invoicetype")).contains("06xdp") || String.valueOf(invoiceType).contains("83xdp") || String.valueOf(invoiceType).contains("51xdp") || String.valueOf(invoiceType).contains("84xdp") || String.valueOf(invoiceType).contains("85xdp") || String.valueOf(invoiceType).contains("86xdp") || String.valueOf(invoiceType).contains("006") || String.valueOf(invoiceType).contains("036"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e50\u4f01\u901a\u9053\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u673a\u52a8\u8f66\u548c\u4e8c\u624b\u8f66\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            HashMap returnMap = new HashMap(2);
            if ("2".equals(importMethod)) {
                AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanel");
                List attachmentData = panel.getAttachmentData();
                returnMap.put("attachmentpanel", attachmentData);
            }
            returnMap.put("paramData", this.getModel().getDataEntity());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private List<String> getLastYearList(int yearsAgo) {
        DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
        LocalDate currentDate = LocalDate.now();
        LocalDate fiveYearsAgo = currentDate.minusYears(yearsAgo);
        return IntStream.rangeClosed(fiveYearsAgo.getYear(), currentDate.getYear()).mapToObj(year -> yearFormatter.format(LocalDate.of(year, 1, 1))).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private static List<String> getLastYearMonthList(int yearsAgo) {
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate currentDate = LocalDate.now();
        LocalDate startDate = currentDate.minusYears(yearsAgo).minusMonths(currentDate.getMonthValue() - 1).withDayOfMonth(1);
        return IntStream.range(0, yearsAgo * 12 + currentDate.getMonthValue()).mapToObj(i -> YearMonth.from(startDate.plusMonths(i)).format(monthFormatter)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private void setInvoiceDate(Object timeUnit) {
        List<String> dateStrList = timeUnit == null || StringUtils.isEmpty((CharSequence)((String)timeUnit)) || "1".equals(timeUnit) ? this.getLastYearList(4) : HistoryInvoiceDataImportPopPlugin.getLastYearMonthList(4);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dateStrList.size());
        for (String yearStr : dateStrList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(yearStr));
            comboItem.setValue(yearStr);
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("invoicedate");
        this.getModel().setValue("invoicedate", null);
        comboEdit.setComboItems(comboItems);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("epinfo".equals(name)) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            Set permEpSet = OrgHelper.getUserHasPermEpPk();
            list.add(new QFilter("id", "in", (Object)permEpSet.toArray(new Object[0])));
            beforeF7SelectEvent.setCustomQFilters(list);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("epinfo".equals(name)) {
            this.chooseEpinfo(changeSet[0]);
        }
        if ("importmethod".equals(name)) {
            this.changeImportMethod(changeSet[0]);
        }
        if ("timeunit".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            this.setInvoiceDate(newValue);
        }
        if ("downloadchannel".equals(name)) {
            this.chooseChannel(changeSet[0]);
        }
        if ("datatype".equals(name)) {
            this.changeDataType(changeSet[0]);
        }
        if ("issueaccount".equals(name)) {
            this.chooseAccount(changeSet[0]);
        } else {
            this.controlShowAccountFlex();
        }
    }

    private void controlShowAccountFlex() {
        MulBasedataDynamicObjectCollection epInfos;
        Object downloadChannel = this.getModel().getValue("downloadchannel");
        boolean showAccount = false;
        if ("2".equals(downloadChannel) && null != (epInfos = (MulBasedataDynamicObjectCollection)this.getModel().getValue("epinfo")) && epInfos.size() == 1) {
            String taxNo = ((DynamicObject)epInfos.get(0)).getDynamicObject("fbasedataId").getString("number");
            showAccount = DataSyncHelper.setAccount((AbstractFormPlugin)this, (String)taxNo, (String)"issueaccount");
        }
        if (!showAccount) {
            this.getModel().setValue("issueaccount", null);
            ComboEdit comboEdit = (ComboEdit)this.getControl("issueaccount");
            comboEdit.setComboItems(null);
        }
        this.getView().setVisible(Boolean.valueOf(showAccount), new String[]{"flexaccount"});
    }

    private void chooseAccount(ChangeData changeData) {
        boolean isOk;
        String oldValue = (String)changeData.getOldValue();
        String newValue = (String)changeData.getNewValue();
        if (StringUtils.isNotEmpty((CharSequence)newValue) && !(isOk = this.checkAccount(newValue))) {
            this.setOldValue("issueaccount", oldValue);
        }
    }

    private void changeDataType(ChangeData changeData) {
        MulComboEdit invoiceDateEdit = (MulComboEdit)this.getControl("invoicedate");
        MulComboEdit invoiceTypeEdit = (MulComboEdit)this.getControl("invoicetype");
        String importMethod = (String)this.getModel().getValue("importmethod");
        boolean isFile = "2".equals(importMethod);
        Object newValue = changeData.getNewValue();
        this.initInvoiceType((String)newValue);
        if (isFile && "1".equals(newValue)) {
            invoiceDateEdit.setMustInput(Boolean.FALSE.booleanValue());
            invoiceTypeEdit.setMustInput(Boolean.FALSE.booleanValue());
            this.getModel().setValue("issueaccount", null);
        } else if (!"3".equals(newValue)) {
            invoiceDateEdit.setMustInput(Boolean.TRUE.booleanValue());
            invoiceTypeEdit.setMustInput(Boolean.TRUE.booleanValue());
            this.getModel().setValue("issueaccount", null);
        }
    }

    private void chooseChannel(ChangeData changeData) {
    }

    private void changeImportMethod(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        MulComboEdit invoiceDateEdit = (MulComboEdit)this.getControl("invoicedate");
        MulComboEdit invoiceTypeEdit = (MulComboEdit)this.getControl("invoicetype");
        if ("2".equals(newValue)) {
            DynamicObjectCollection epInfos = (DynamicObjectCollection)this.getModel().getValue("epinfo");
            if (epInfos != null && epInfos.size() > 1) {
                this.getModel().setValue("epinfo", null);
            }
            invoiceDateEdit.setMustInput(Boolean.FALSE.booleanValue());
            invoiceTypeEdit.setMustInput(Boolean.FALSE.booleanValue());
        } else if (!"3".equals(newValue)) {
            invoiceDateEdit.setMustInput(Boolean.TRUE.booleanValue());
            invoiceTypeEdit.setMustInput(Boolean.TRUE.booleanValue());
        }
    }

    private void chooseEpinfo(ChangeData changeData) {
        String importMethod = (String)this.getModel().getValue("importmethod");
        DynamicObjectCollection newValueCollection = (DynamicObjectCollection)changeData.getNewValue();
        if (newValueCollection != null) {
            int size = newValueCollection.size();
            boolean isFile = "2".equals(importMethod);
            if (size > 1 && isFile) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u5f0f\u4e3a\u5bfc\u5165\u7535\u5b50\u7a0e\u5c40\u6587\u4ef6\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u9500\u65b9", (String)"HistoryInvoiceDataImportPopPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void initInvoiceType(String dataType) {
        boolean isDownloadInvoice;
        LinkedHashMap<String, String> invoiceTypeMap = new LinkedHashMap<String, String>(8);
        invoiceTypeMap.put(ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", (String)"HistoryInvoiceDataImportPopPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), "10xdp");
        invoiceTypeMap.put(ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", (String)"HistoryInvoiceDataImportPopPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), "08xdp");
        boolean isDownInoviceFile = "3".equals(dataType);
        if (!isDownInoviceFile) {
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u7535\u5b50\u666e\u901a\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), "026");
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u7535\u5b50\u4e13\u7528\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), "028");
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u7eb8\u8d28\u666e\u901a\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), "007");
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), "006");
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u7eb8\u8d28\u4e13\u7528\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), "004");
        }
        if (isDownloadInvoice = "1".equals(dataType)) {
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", (String)"HistoryInvoiceDataImportPopPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968(\u6570\u7535\u7eb8\u7968)", (String)"HistoryInvoiceDataImportPopPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode());
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968(\u6570\u7535\u7535\u7968)", (String)"HistoryInvoiceDataImportPopPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode());
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968(\u6570\u7535\u7eb8\u7968)", (String)"HistoryInvoiceDataImportPopPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode());
            invoiceTypeMap.put(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968(\u6570\u7535\u7535\u7968)", (String)"HistoryInvoiceDataImportPopPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getTypeCode());
        }
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"invoicetype", invoiceTypeMap);
    }

    private boolean checkAccount(String accountValue) {
        String dataType = (String)this.getModel().getValue("datatype");
        boolean isInvoiceData = "1".equals(dataType);
        boolean isSyncInvoiceFile = "3".equals(dataType);
        boolean isSyncInvoiceUse = "2".equals(dataType);
        if (accountValue.length() > 300) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u9009\u62e9\u8fc7\u591a\uff0c\u603b\u957f\u5ea6\u6700\u591a300\u4e2a\u5b57\u7b26\uff0c\u8bf7\u5220\u51cf", (String)"HistoryInvoiceDataImportPopPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return false;
        }
        String[] newValueArr = accountValue.split(",");
        if ((isInvoiceData || isSyncInvoiceFile) && newValueArr.length > 2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u6570\u636e\u6216\u53d1\u7968\u7248\u5f0f\u6587\u4ef6\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7", (String)"HistoryInvoiceDataImportPopPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (isSyncInvoiceUse && newValueArr.length > 11) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u7528\u9014\u72b6\u6001\u65f6\uff0c\u6700\u591a\u9009\u62e910\u4e2a\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7", (String)"HistoryInvoiceDataImportPopPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setOldValue(String key, String value) {
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)value);
        this.getModel().endInit();
    }
}

