/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MetadataUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.service.OutputFileService;
import kd.imc.sim.common.dto.PrintInvoiceDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.BeanUtil;
import kd.imc.sim.formplugin.issuing.CreateInvoicePlugin;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceBaseControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceCustomViewControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceWaitControl;
import kd.imc.sim.formplugin.issuing.helper.ViewBuildInvoiceHelper;
import kd.imc.sim.formplugin.vehicle.VehicleInvoiceFormPlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IssueInvoiceHelper {
    private static final Log LOGGER = LogFactory.getLog(IssueInvoiceHelper.class);

    public void singleIssueInvoice(AbstractFormPlugin plugin, IFormView view, String itemJsonArray) {
        String key = IssueInvoiceMqHelper.getIssueInvoiceLockKey((String)((String)view.getModel().getValue("salertaxno")), (String)((String)view.getModel().getValue("jqbh")));
        String invoiceType = (String)plugin.getView().getModel().getValue("invoicetype");
        boolean isElePaperInvoice = AllEleAuthHelper.isElePaper((Object)plugin.getView().getModel().getValue("iselepaper"));
        try (DLock lock = DLock.create((String)key);){
            boolean isGetLock = lock.tryLock(200L);
            if (!isGetLock) {
                String tip = ResManager.loadKDString((String)"\u8be5\u8bbe\u5907\u6b63\u5728\u5f00\u7968\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"IssueInvoiceHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                if (isElePaperInvoice || InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                    tip = ResManager.loadKDString((String)"\u8be5\u7a0e\u53f7\u6709\u5176\u4ed6\u5f00\u7968\u8bf7\u6c42\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"IssueInvoiceHelper_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                }
                throw new MsgException(tip);
            }
            if (!InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                CacheHelper.put((String)("choose_terminalno" + plugin.getView().getModel().getValue("orderno")), (String)RequestContext.get().getUserId(), (int)86400);
            }
            DynamicObject invoiceDynamicObject = null;
            DynamicObject invalidInvoiceDynamicObject = null;
            String batchFid = plugin.getPageCache().get("invoiceBatchFid");
            Long invalidPrimaryKey = (Long)view.getFormShowParameter().getCustomParam("invalidPrimaryKey");
            boolean needBuildNewInvoice = false;
            if (StringUtils.isNotEmpty((String)batchFid)) {
                DynamicObject waitInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(batchFid), (String)"sim_vatinvoice");
                invoiceDynamicObject = CreateInvoiceWaitControl.batchEditBuildInvoiceDynamicObject((AbstractFormPlugin)plugin, (IFormView)view, (DynamicObject)waitInvoiceDynamicObject, (int)1);
                invoiceDynamicObject.set("orderno", (Object)plugin.getPageCache().get("batchOrderNo"));
                invoiceDynamicObject.set("jqbh", view.getModel().getValue("jqbh"));
            } else if (invalidPrimaryKey != null) {
                invalidInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)invalidPrimaryKey, (String)"sim_vatinvoice");
                if (StringUtils.isNotEmpty((String)invalidInvoiceDynamicObject.getString("reorderno"))) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter("orderno", "=", (Object)invalidInvoiceDynamicObject.getString("reorderno")).toArray());
                    if (dynamicObject != null) {
                        DynamicObject waitInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"sim_vatinvoice");
                        invoiceDynamicObject = CreateInvoiceWaitControl.batchEditBuildInvoiceDynamicObject((AbstractFormPlugin)plugin, (IFormView)view, (DynamicObject)waitInvoiceDynamicObject, (int)0);
                    } else {
                        needBuildNewInvoice = true;
                    }
                } else {
                    needBuildNewInvoice = true;
                }
            } else {
                needBuildNewInvoice = true;
            }
            if (needBuildNewInvoice) {
                invoiceDynamicObject = this.buildNewInvoice(plugin, view, itemJsonArray);
            }
            if (null != invoiceDynamicObject && !InvoiceUtils.isRedInfoInvoice((String)invoiceDynamicObject.getString("issuetype"), (String)invoiceDynamicObject.getString("invoicetype"))) {
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(invoiceDynamicObject);
                InvoiceUtils.dealInvoicesListMark(new HashMap(), list);
            }
            if (invoiceDynamicObject == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u5f85\u5f00\u53d1\u7968\u5931\u8d25", (String)"IssueInvoiceHelper_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            String issueSource = (String)view.getModel().getValue("issuesource");
            if (issueSource != null) {
                invoiceDynamicObject.set("issuesource", (Object)issueSource);
            }
            if (!StringUtils.isEmpty((String)plugin.getPageCache().get("pageCacheNewEquipmentType"))) {
                invoiceDynamicObject.set("issuesource", (Object)plugin.getPageCache().get("pageCacheNewEquipmentType"));
            }
            if (StringUtils.isNotBlank((String)plugin.getPageCache().get("btnpreview"))) {
                this.invoicePreview(plugin, invoiceDynamicObject);
            } else if (StringUtils.isNotBlank((String)plugin.getPageCache().get("btnsave"))) {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\uff0c\u53d1\u7968\u6570\u636e\u5c06\u63d0\u4ea4\u81f3\u5f00\u7968\u8fc7\u7a0b\u76d1\u63a7\u9875\u9762\uff0c\u53ef\u8fdb\u5165\u5f00\u7968\u8fc7\u7a0b\u76d1\u63a7\u9875\u9762\u7ee7\u7eed\u5f00\u7968\u3002\u662f\u5426\u4fdd\u5b58?", (String)"IssueInvoiceHelper_18", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"btnsave");
                plugin.getPageCache().remove("btnsave");
            } else if (StringUtils.isNotBlank((String)plugin.getPageCache().get("confirm_save"))) {
                plugin.getPageCache().remove("confirm_save");
                this.alleInvoiceWarpData(plugin, view, invoiceType, isElePaperInvoice, invoiceDynamicObject);
                invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
                invoiceDynamicObject.set("billdate", (Object)new Date());
                invoiceDynamicObject.set("issuebillstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_wait", (String)""));
                ImcSaveServiceHelper.save((DynamicObject)invoiceDynamicObject);
                CreateInvoiceControl.flushPageData((AbstractFormPlugin)plugin);
                view.getModel().setValue("orderno", (Object)UUID.next());
            } else if (invalidPrimaryKey != null) {
                this.singleReIssueInvoice(plugin, invalidInvoiceDynamicObject, invoiceDynamicObject);
            } else {
                boolean isNeed;
                if (view.getFormShowParameter().getCustomParams().get("scan_pk") != null) {
                    DynamicObject scanDynamicObject = BusinessDataServiceHelper.loadSingle(view.getFormShowParameter().getCustomParams().get("scan_pk"), (String)"sim_scan_invoice");
                    invoiceDynamicObject.set("buyertype", (Object)"7");
                    invoiceDynamicObject.set("wxid", scanDynamicObject.get("wxid"));
                    long longId = DBServiceHelper.genGlobalLongId();
                    invoiceDynamicObject.set("id", (Object)longId);
                    scanDynamicObject.set("invoiceid", (Object)longId);
                    scanDynamicObject.set("status", (Object)"1");
                    ImcSaveServiceHelper.save((DynamicObject)scanDynamicObject);
                }
                if (isNeed = BotpHelper.isRedNeedShowArTip((DynamicObject)invoiceDynamicObject)) {
                    view.showTipNotification(BotpHelper.getRedFiTip(), Integer.valueOf(8000));
                }
                this.alleInvoiceWarpData(plugin, view, invoiceType, isElePaperInvoice, invoiceDynamicObject);
                MsgResponse msgResponse = IssueInvoiceService.doIssueInvoice((DynamicObject)invoiceDynamicObject);
                this.handleDoIssueInvoiceResponse(plugin, view, msgResponse, batchFid, invoiceDynamicObject);
            }
        }
        catch (MsgException e) {
            LOGGER.error("CreateInvoiceFailed_" + e.getErrorMsg(), (Throwable)e);
            view.showErrorNotification(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("CreateInvoiceFailed_" + e, (Throwable)e);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u5f02\u5e38 %s", (String)"IssueInvoiceHelper_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void alleInvoiceWarpData(AbstractFormPlugin plugin, IFormView view, String invoiceType, boolean isElePaperInvoice, DynamicObject invoiceDynamicObject) {
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || isElePaperInvoice) {
            String account = (String)plugin.getView().getModel().getValue("account");
            invoiceDynamicObject.set("account", (Object)StringUtils.trimToEmpty((String)account));
            String taxNo = (String)view.getModel().getValue("salertaxno");
            if (StringUtils.isNotBlank((String)account) && !EnterpriseHelper.isLqptChannel((String)taxNo)) {
                invoiceDynamicObject.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)((String)view.getModel().getValue("salertaxno")), (String)StringUtils.trimToEmpty((String)account)));
            }
        }
    }

    public void invoicePreview(AbstractFormPlugin plugin, DynamicObject invoiceDynamicObject) {
        DynamicObject epInfo = TaxUtils.getEpInfoByOrg((Long)invoiceDynamicObject.getDynamicObject("orgid").getLong("id"));
        String fileName = invoiceDynamicObject.get("orderno") + ".pdf";
        DynamicObject dataInvoice = AllEleInvoiceFileHelper.getAcquisitionData((DynamicObject)invoiceDynamicObject, (String)invoiceDynamicObject.getString("salertaxno"));
        FullDigitalEInvoice eInvoice = AllEleInvoiceFileHelper.createFullDigitalEInvoice((DynamicObject)dataInvoice);
        eInvoice.setTest(true);
        String zgswskfjdm = epInfo.getString("zgswskfjdm");
        if (StringUtils.isNotEmpty((String)zgswskfjdm)) {
            eInvoice.setTaxBureauCode(zgswskfjdm);
        }
        OutputFileService outputFileService = new OutputFileService();
        byte[] pdf = outputFileService.createPdf(eInvoice);
        String dir = FileUploadUtils.getInvoiceDir((String)"simeinv");
        String fullUrlName = dir + fileName;
        FileUploadUtils.delete((String)fullUrlName);
        String pdfUrl = FileUploadUtils.uploadBytes((String)fullUrlName, (String)fileName, (byte[])pdf);
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("pdfUrl", pdfUrl);
        if (MetadataUtil.exists((String)"rim_file_view").booleanValue()) {
            customParams.put("page", "rim");
            ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)"sim_single_inv_preview", (String)"");
        } else {
            ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)"sim_single_inv_previe_inh", (String)"");
        }
        plugin.getPageCache().remove("btnpreview");
        plugin.getView().setVisible(Boolean.TRUE, new String[]{"btnflush", "btnpreview"});
    }

    public DynamicObject buildNewInvoice(AbstractFormPlugin plugin, IFormView view, String itemJsonArray) {
        String cacheRedReason;
        String orderNo = (String)plugin.getView().getModel().getValue("orderno");
        if (StringUtils.isNotBlank((String)orderNo) && QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540c\u6837\u6d41\u6c34\u53f7\u7684\u53d1\u7968\uff0c\u8bf7\u524d\u5f80\u5f85\u5f00\u53d1\u7968\u5217\u8868\u8fdb\u884c\u5f00\u7968\u64cd\u4f5c", (String)"IssueInvoiceHelper_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        DynamicObject invoiceDynamicObject = new ViewBuildInvoiceHelper().buildInvoiceByView(plugin, view, itemJsonArray, "sim_vatinvoice");
        invoiceDynamicObject.set("orderno", view.getModel().getValue("orderno"));
        invoiceDynamicObject.set("operator", view.getModel().getValue("operatorname"));
        invoiceDynamicObject.set("invoicecode", (Object)"");
        invoiceDynamicObject.set("invoiceno", (Object)"");
        invoiceDynamicObject.set("issuetime", null);
        String originalInvoiceCode = invoiceDynamicObject.getString("originalinvoicecode");
        String originalInvoiceNo = invoiceDynamicObject.getString("originalinvoiceno");
        String redReason = invoiceDynamicObject.getString("redreason");
        if (StringUtils.isNotBlank((String)originalInvoiceCode) && StringUtils.isNotBlank((String)originalInvoiceNo) && StringUtils.isBlank((String)redReason) && StringUtils.isNotBlank((String)(cacheRedReason = CacheHelper.get((String)(originalInvoiceCode + originalInvoiceNo + "redreason"))))) {
            LOGGER.info(String.format("redReasonFromCache:%s", cacheRedReason));
            invoiceDynamicObject.set("redreason", (Object)cacheRedReason);
        }
        if (StringUtils.isEmpty((String)plugin.getPageCache().get("red_blue_invoice_buyer_type"))) {
            invoiceDynamicObject.set("buyertype", (Object)"0");
        } else {
            invoiceDynamicObject.set("buyertype", (Object)plugin.getPageCache().get("red_blue_invoice_buyer_type"));
        }
        invoiceDynamicObject.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        invoiceDynamicObject.set("issuewritebackstatus", (Object)"0");
        invoiceDynamicObject.set("abolishwritebackstatus", (Object)"2");
        if (!TaxedTypeEnum.all_e_reduced_tax.getValue().equals(view.getModel().getValue("taxedtype"))) {
            invoiceDynamicObject.set("reductiontaxtype", null);
        }
        return invoiceDynamicObject;
    }

    private void singleReIssueInvoice(AbstractFormPlugin plugin, DynamicObject invalidInvoice, DynamicObject newReIssueInvoice) {
        if (StringUtils.isEmpty((String)plugin.getPageCache().get("singleIssueReOrderNo"))) {
            invalidInvoice.set("reorderno", (Object)newReIssueInvoice.getString("orderno"));
            invalidInvoice.set("reissuestatus", (Object)"2");
            ImcSaveServiceHelper.save((DynamicObject)invalidInvoice);
        }
        newReIssueInvoice.set("buyertype", (Object)"5");
        MsgResponse msgResponse = IssueInvoiceService.doIssueInvoice((DynamicObject)newReIssueInvoice);
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            plugin.getView().returnDataToParent((Object)"singleReIssueSuccess");
            plugin.getView().close();
        } else {
            this.issueFailed(plugin, plugin.getView(), msgResponse, null, newReIssueInvoice);
        }
    }

    public static void handleInvoicePrinterConfirm(AbstractFormPlugin formPlugin, ClosedCallBackEvent event) {
        PrintInvoiceDTO printInvoiceDTO;
        PrintInvoiceDTO printInvoiceDTO2 = printInvoiceDTO = event.getReturnData() == null ? null : (PrintInvoiceDTO)event.getReturnData();
        if (printInvoiceDTO == null || StringUtils.isEmpty((String)printInvoiceDTO.getPrinter_name())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u68c0\u6d4b\u5230\u53ef\u7528\u7684\u6253\u5370\u673a(\u8bf7\u5148\u68c0\u67e5\u6253\u5370\u673a\u72b6\u6001\uff0c\u53ef\u4ee5\u5728\u5f00\u7968\u67e5\u8be2\u9875\u9762\u6253\u5370\u53d1\u7968)", (String)"IssueInvoiceHelper_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String devNo = ObjectUtils.defaultIfNull((Object)formPlugin.getView().getModel().getValue("jqbh"), (Object)"").toString();
        ComponentResponse componentResponse = PaperPrintHelper.printInvoice((PrintInvoiceDTO)printInvoiceDTO, (String)(StringUtils.isNotEmpty((String)printInvoiceDTO.getJqbh()) ? printInvoiceDTO.getJqbh() : devNo));
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)printInvoiceDTO.getFpdm());
        qFilter.and("invoiceno", "=", (Object)printInvoiceDTO.getFphm());
        if ("5012".equals(componentResponse.getErrcode())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u672a\u6253\u5370", (String)"IssueInvoiceHelper_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!componentResponse.isSucess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u5931\u8d25: %s", (String)"IssueInvoiceHelper_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), componentResponse.getDescription()));
        }
        String invoiceTableName = formPlugin instanceof VehicleInvoiceFormPlugin ? "sim_vatinvoice_vehicles" : "sim_vatinvoice";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)invoiceTableName, (String)"id,printflag", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            dynamicObject.set("printflag", (Object)"1");
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("invoicecode", printInvoiceDTO.getFpdm());
        customParams.put("invoiceno", printInvoiceDTO.getFphm());
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u6210\u529f", (String)"IssueInvoiceHelper_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_show_invoice_dialog", (String)"sim_show_invoice_dialog");
    }

    private void handleDoIssueInvoiceResponse(AbstractFormPlugin formPlugin, IFormView view, MsgResponse msgResponse, String batchFid, DynamicObject invoiceDynamicObject) {
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            if (StringUtils.isEmpty((String)batchFid) || "13".equals(invoiceDynamicObject.getString("buyertype"))) {
                this.issueSuccess(formPlugin, view, msgResponse, invoiceDynamicObject);
            } else {
                view.returnDataToParent((Object)ResManager.loadKDString((String)"\u5f85\u5f00\u53d1\u7968\u5f00\u7968\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u5f00\u7968\u67e5\u8be2\u67e5\u770b", (String)"IssueInvoiceHelper_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                view.close();
            }
        } else if (ErrorType.SUBMITED.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            ViewUtil.openConfirmOK((String)"LYOpenInvoiceCommitCallBack", (String)ResManager.loadKDString((String)"\u6570\u636e\u5df2\u63d0\u4ea4\u5f00\u7968\uff0c\u7a0d\u540e\u53ef\u5728\u9500\u9879\u53d1\u7968\u6c60\u2192\u53d1\u7968\u67e5\u8be2\u9875\u9762\u67e5\u770b\u53d1\u7968\u6570\u636e", (String)"IssueInvoiceHelper_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"IssueInvoiceHelper_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            view.getModel().setValue("orderno", (Object)UUID.next());
        } else {
            this.issueFailed(formPlugin, view, msgResponse, batchFid, invoiceDynamicObject);
        }
    }

    private void issueFailed(AbstractFormPlugin formPlugin, IFormView view, MsgResponse msgResponse, String batchFid, DynamicObject invoiceDynamicObject) {
        if (StringUtils.isEmpty((String)batchFid)) {
            invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.failed.getCode());
            invoiceDynamicObject.set("result", (Object)msgResponse.getErrorMsg());
            ImcSaveServiceHelper.save((DynamicObject)invoiceDynamicObject);
            formPlugin.getView().close();
            IssueInvoiceHelper.jumpWaitInvoiceListPage(formPlugin, String.format(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff1a %s\u60a8\u53ef\u4ee5\u8fdb\u5165\u5f85\u5f00\u53d1\u7968\u91cd\u65b0\u53d1\u8d77\u5f00\u7968", (String)"IssueInvoiceHelper_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgResponse.getErrorMsg()), null);
        } else {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff1a %s", (String)"IssueInvoiceHelper_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgResponse.getErrorMsg()));
        }
    }

    public static void jumpWaitInvoiceListPage(AbstractFormPlugin formPlugin, String showErrorMsg, String showSuccessMsg) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("showErrorMsg", showErrorMsg);
        customParams.put("showSuccessMsg", showSuccessMsg);
        ViewUtil.openListPageByMainPage((AbstractFormPlugin)formPlugin, null, customParams, (String)"sim_invoice_wait", (String)"sim_invoice_wait", (ShowType)ShowType.MainNewTabPage);
        formPlugin.getView().returnDataToParent((Object)"sim_invoice_wait");
    }

    private void issueSuccess(AbstractFormPlugin formPlugin, IFormView view, MsgResponse msgResponse, DynamicObject invoiceDynamicObject) {
        String originInvoice = formPlugin.getPageCache().get("originInvoice");
        if (StringUtils.isEmpty((String)originInvoice)) {
            this.issueInvoiceSuccess(formPlugin, msgResponse);
        } else {
            this.issueInvoiceSuccessRed(formPlugin, view, msgResponse);
        }
        view.getModel().setValue("orderno", (Object)UUID.next());
        view.addClientCallBack("setNextInvoiceCodeNo", Integer.valueOf(100));
        formPlugin.getView().setEnable(Boolean.TRUE, new String[]{"specialtype"});
        if (formPlugin.getPageCache().get("fromSingleIssue") != null && !StringUtils.isEmpty((String)RequestContext.get().getUserId())) {
            CacheHelper.put((String)CreateInvoiceBaseControl.getSingleIssueCacheInvoiceTypeKey(), (String)invoiceDynamicObject.getString("invoicetype"));
            view.getModel().setValue("invoicetype", (Object)invoiceDynamicObject.getString("invoicetype"));
        }
    }

    private void issueInvoiceSuccess(AbstractFormPlugin formPlugin, MsgResponse msgResponse) {
        JSONObject parseObject = JSONObject.parseObject((String)msgResponse.getRespData());
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("invoicecode", parseObject.get((Object)"invoicecode"));
        customParams.put("invoiceno", parseObject.get((Object)"invoiceno"));
        HashMap<String, String> showDataMap = new HashMap<String, String>(4);
        showDataMap.put("eventkey", "sethsbz");
        showDataMap.put("hsbz", "1");
        ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"customcontrolap");
        String invoiceType = formPlugin.getView().getModel().getValue("invoicetype").toString();
        Object isElePaper = formPlugin.getView().getModel().getValue("iselepaper");
        if (InvoiceUtils.getEtcInvoiceType().contains(invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_show_invoice_dialog", null);
        } else if (InvoiceUtils.getPaperInvoiceType().contains(invoiceType)) {
            if (!EquipmentHelper.isBlockChainOrHostModeDevice((String)parseObject.getString("issuesource"))) {
                customParams.put("invoicetype", invoiceType);
                customParams.put("jqbh", formPlugin.getView().getModel().getValue("jqbh"));
                customParams.put("terminalno", formPlugin.getView().getModel().getValue("terminalno"));
                ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_invoice_print_confirm", (String)"callback_sim_invoice_print_confirm");
            } else {
                ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_show_invoice_dialog", null);
            }
        }
        this.resetView(formPlugin);
    }

    private void resetView(AbstractFormPlugin formPlugin) {
        String invoiceType = (String)formPlugin.getView().getModel().getValue("invoicetype");
        formPlugin.getView().getModel().setValue("simpleaddress", null);
        formPlugin.getView().getModel().setValue("detailaddress", null);
        formPlugin.getView().getModel().setValue("crosscitysign", null);
        formPlugin.getView().getModel().setValue("areaunit", null);
        formPlugin.getView().getModel().setValue("startleasedate", null);
        formPlugin.getView().getModel().setValue("endleasedate", null);
        formPlugin.getView().getModel().setValue("buildingname", null);
        formPlugin.getView().getModel().setValue("landtaxno", null);
        formPlugin.getView().getModel().setValue("estateid", null);
        formPlugin.getView().getModel().setValue("approvedprice", null);
        formPlugin.getView().getModel().setValue("actualturnover", null);
        formPlugin.getView().getModel().setValue("estatecode", null);
        formPlugin.getPageCache().put("has_change_zsfs", "yes");
        formPlugin.getPageCache().put("has_change_issue_type", "yes");
        formPlugin.getPageCache().put("has_change_invoice_type", "yes");
        formPlugin.getView().setEnable(Boolean.TRUE, new String[]{"remark", "specialtype"});
        CreateInvoiceCustomViewControl.updateTitleToCustomView((AbstractFormPlugin)formPlugin, (String)"salernamediy", (String)"");
        Object isElePaper = formPlugin.getView().getModel().getValue("iselepaper");
        formPlugin.getView().getModel().deleteEntryData("extra");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            CreateInvoiceControl.flushPageData((AbstractFormPlugin)formPlugin);
        } else {
            CreateInvoiceControl.flushPageData((AbstractFormPlugin)formPlugin);
            CreateInvoiceControl.selectBlueInvoice((String)"026", (AbstractFormPlugin)formPlugin, (IFormView)formPlugin.getView());
        }
    }

    private void issueInvoiceSuccessRed(AbstractFormPlugin formPlugin, IFormView view, MsgResponse msgResponse) {
        if (formPlugin instanceof CreateInvoicePlugin) {
            JSONObject parseObject = JSONObject.parseObject((String)msgResponse.getRespData());
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("invoicecode", parseObject.get((Object)"invoicecode"));
            customParams.put("invoiceno", parseObject.get((Object)"invoiceno"));
            String invoiceType = formPlugin.getView().getModel().getValue("invoicetype").toString();
            if (InvoiceUtils.getEtcInvoiceType().contains(invoiceType)) {
                ViewUtil.openDialog((AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u53d1\u7968\u7ea2\u51b2\u6210\u529f", (String)"IssueInvoiceHelper_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_show_invoice_dialog", null);
            } else if (InvoiceUtils.getPaperInvoiceType().contains(invoiceType)) {
                if (!EquipmentHelper.isBlockChainOrHostModeDevice((String)parseObject.getString("issuesource"))) {
                    customParams.put("invoicetype", invoiceType);
                    customParams.put("jqbh", formPlugin.getView().getModel().getValue("jqbh"));
                    ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_invoice_print_confirm", (String)"callback_sim_invoice_print_confirm");
                } else {
                    ViewUtil.openDialog((AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u53d1\u7968\u7ea2\u51b2\u6210\u529f", (String)"IssueInvoiceHelper_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_show_invoice_dialog", null);
                }
            }
            formPlugin.getPageCache().put("has_change_zsfs", "yes");
            formPlugin.getPageCache().put("issuetype", "0");
            formPlugin.getPageCache().put("issue_type_old_value", "1");
            formPlugin.getPageCache().put("has_change_issue_type", "yes");
            CreateInvoiceControl.flushPageData((AbstractFormPlugin)formPlugin);
            CreateInvoiceControl.selectBlueInvoice((String)"026", (AbstractFormPlugin)formPlugin, (IFormView)formPlugin.getView());
        } else {
            view.returnDataToParent((Object)"success");
            view.close();
        }
    }

    public boolean preIssueInvoice(AbstractFormPlugin plugin) {
        String equipmentType;
        String equipmentNo;
        boolean flag = true;
        Object isElePaper = plugin.getView().getModel().getValue("iselepaper");
        if (InvoiceUtils.isAllEInvoice((Object)((String)plugin.getView().getModel().getValue("invoicetype"))) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            return true;
        }
        String string = equipmentNo = plugin.getView().getModel().getValue("jqbh") == null ? "" : plugin.getView().getModel().getValue("jqbh").toString();
        if (StringUtils.isEmpty((String)equipmentNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"IssueInvoiceHelper_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String invoiceType = plugin.getView().getModel().getValue("invoicetype").toString();
        if (EquipmentHelper.checkIsSupportSelectInvoiceRoll((String)invoiceType, (String)(equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)equipmentNo)))) {
            plugin.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u83b7\u53d6\u53d1\u7968\u5377...", (String)"IssueInvoiceHelper_17", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = EquipmentHelper.queryPaperInvoiceRollInfo((String)invoiceType, (String)equipmentNo);
            plugin.getView().hideLoading();
            if (paperInvoiceRollInfoDTO != null && paperInvoiceRollInfoDTO.getVolumn().size() > 1) {
                flag = false;
                ViewUtil.openDialog((AbstractFormPlugin)plugin, (Map)BeanUtil.objectToMap((Object)paperInvoiceRollInfoDTO), (String)"sim_invoice_volumn_info", (String)"callback_sim_invoice_volumn_info_and_issueinvoice");
            }
        }
        return flag;
    }
}

