/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.invoice.mobile;

import com.google.common.collect.ImmutableSet;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.issuing.invoice.InvoiceQrSendFormPlugin;

public class InvoiceQrSendMobileFormPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoiceQrSendFormPlugin.class);
    public static final ImmutableSet<String> BUTTON_KEY = new ImmutableSet.Builder().add((Object)"fileurl_btn").add((Object)"pdffileurl_btn").add((Object)"xmlfileurl_btn").build();

    public void registerListener(EventObject e) {
        for (String key : BUTTON_KEY) {
            this.addClickListeners(new String[]{key});
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject invoice = this.getInvoice();
        if (invoice == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u4ed8\u53d1\u7968\u4e0d\u5b58\u5728", (String)"InvoiceSendAndPrintMobileFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        ModelUtil.setModelValueFromDynamicObject((DynamicObject)invoice, (AbstractFormPlugin)this);
    }

    private DynamicObject getInvoice() {
        String orderNo = (String)this.getView().getFormShowParameter().getCustomParam("orderNo");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("qrCode\u4ea4\u4ed8\u7684\u6d41\u6c34\u53f7\u662f:{}", (Object)orderNo);
        }
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BUTTON_KEY.contains((Object)control.getKey())) {
            String fileKey = control.getKey().split("_")[0];
            this.downloadFile((String)this.getModel().getValue(fileKey));
        }
    }

    private void downloadFile(String fileUrl) {
        if (!fileUrl.startsWith("http")) {
            fileUrl = UrlService.getAttachmentDownloadUrl((String)fileUrl) + "&kd_cs_ticket=" + SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        }
        if ("1".equals(ImcConfigUtil.getValue((String)"qrCode", (String)"type"))) {
            this.getView().openUrl(fileUrl);
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("errCode", "0000");
        param.put("eventKey", "download");
        param.put("url", fileUrl);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, param, (String)"filedownload");
    }
}

