/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.invoice.op;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class InvoiceQrSendOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("invoicetype");
        e.getFieldKeys().add("invoiceno");
        e.getFieldKeys().add("fileurl");
        e.getFieldKeys().add("pdffileurl");
        e.getFieldKeys().add("xmlfileurl");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                    DynamicObject invoice = dataEntity.getDataEntity();
                    String invoiceNo = invoice.getString("invoiceno");
                    if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\uff0c\u53ea\u6709\u6570\u7535\u7968\u624d\u53ef\u4ee5\u4e8c\u7ef4\u7801\u4ea4\u4ed8", (String)"InvoiceQrSendOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo));
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)invoice.getString("fileurl"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\uff0cofd\u6587\u4ef6\u672a\u751f\u6210", (String)"InvoiceQrSendOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo));
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)invoice.getString("pdffileurl"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\uff0cpdf\u6587\u4ef6\u672a\u751f\u6210", (String)"InvoiceQrSendOp_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo));
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)invoice.getString("xmlfileurl"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\uff0cxml\u6587\u4ef6\u672a\u751f\u6210", (String)"InvoiceQrSendOp_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo));
                        continue;
                    }
                    DynamicObjectCollection invoiceFiles = QueryServiceHelper.query((String)"sim_vatinvoice_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_file"), (QFilter[])new QFilter("invoiceno", "=", (Object)invoiceNo).and("filetype", "!=", (Object)FileType.JPG.getFileExtension()).toArray());
                    if (invoiceFiles.size() == 0) continue;
                    for (DynamicObject invoiceFile : invoiceFiles) {
                        String fileType = invoiceFile.getString("filetype");
                        if ("local".equals(invoiceFile.getString("callbacktype"))) {
                            if ("1".equals(invoiceFile.getString("localfilestatus"))) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%1$s]\uff0c%2$s\u6587\u4ef6\u672a\u751f\u6210", (String)"InvoiceQrSendOp_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo, fileType));
                            continue;
                        }
                        if ("1".equals(invoiceFile.getString("remotefilestatus"))) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%1$s]\uff0c%2$s\u6587\u4ef6\u672a\u751f\u6210", (String)"InvoiceQrSendOp_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo, fileType));
                    }
                }
            }
        });
    }
}

